/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.base.evaluators.DateFactory;
import org.drools.common.DroolsObjectInputStream;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;
import org.mvel.MVEL;

public class MVELTest
extends TestCase {
    public void testHelloWorld() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_mvel.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream obj = new ObjectOutputStream(out);
        obj.writeObject(ruleBase);
        obj.close();
        byte[] buf = out.toByteArray();
        DroolsObjectInputStream in = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(buf));
        ruleBase = (RuleBase)in.readObject();
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        ArrayList list2 = new ArrayList();
        workingMemory.setGlobal("list2", list2);
        Cheese c = new Cheese("stilton", 10);
        workingMemory.insert((Object)c);
        workingMemory.fireAllRules();
        MVELTest.assertEquals((int)2, (int)list.size());
        MVELTest.assertEquals((Object)new Integer(30), list.get(0));
        MVELTest.assertEquals((Object)new Integer(22), list.get(1));
        MVELTest.assertEquals((Object)"hello world", list2.get(0));
        Date dt = DateFactory.parseDate((String)"10-Jul-1974");
        MVELTest.assertEquals((Object)dt, (Object)c.getUsedBy());
    }

    public Object compiledExecute(String ex) {
        Serializable compiled = MVEL.compileExpression((String)ex);
        return MVEL.executeExpression((Object)compiled, (Object)new Object(), new HashMap());
    }

    private RuleBase loadRuleBase(Reader reader) throws IOException, DroolsParserException, Exception {
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse(reader);
        if (parser.hasErrors()) {
            Assert.fail((String)"Error messages in parser, need to sort this our (or else collect error messages)");
        }
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(packageDescr);
        System.out.println(builder.getErrors());
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        return ruleBase;
    }

    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }
}

