/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.acme.insurance.Driver;
import org.acme.insurance.Policy;
import org.drools.Address;
import org.drools.Cell;
import org.drools.Cheese;
import org.drools.Cheesery;
import org.drools.Child;
import org.drools.FactHandle;
import org.drools.FirstClass;
import org.drools.FromTestClass;
import org.drools.Guess;
import org.drools.IndexedNumber;
import org.drools.InsertedObject;
import org.drools.ObjectFilter;
import org.drools.Order;
import org.drools.OrderItem;
import org.drools.Person;
import org.drools.PersonFinal;
import org.drools.PersonInterface;
import org.drools.PersonWithEquals;
import org.drools.Primitives;
import org.drools.QueryResult;
import org.drools.QueryResults;
import org.drools.RandomNumber;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.SecondClass;
import org.drools.Sensor;
import org.drools.SpecialString;
import org.drools.State;
import org.drools.StatefulSession;
import org.drools.StatelessSession;
import org.drools.Target;
import org.drools.TestParam;
import org.drools.WorkingMemory;
import org.drools.WorkingMemoryEventManager;
import org.drools.audit.WorkingMemoryFileLogger;
import org.drools.base.ClassObjectFilter;
import org.drools.common.AbstractWorkingMemory;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.ParserError;
import org.drools.compiler.RuleError;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaGroupPoppedEvent;
import org.drools.event.AgendaGroupPushedEvent;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.event.DefaultWorkingMemoryEventListener;
import org.drools.event.ObjectInsertedEvent;
import org.drools.event.ObjectRetractedEvent;
import org.drools.event.ObjectUpdatedEvent;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.facttemplates.Fact;
import org.drools.facttemplates.FactTemplate;
import org.drools.integrationtests.IteratorToList;
import org.drools.integrationtests.helloworld.Message;
import org.drools.lang.DrlDumper;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.InvalidRulePackage;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.spi.Activation;
import org.drools.spi.ConsequenceExceptionHandler;
import org.drools.spi.GlobalResolver;
import org.drools.xml.XmlDumper;

public class MiscTest
extends TestCase {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    public void testGlobals() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("globals_rule_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.setGlobal("string", (Object)"stilton");
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((Object)new Integer(5), list.get(0));
    }

    public void testGlobals2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_globalsAsConstraints.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        ArrayList<String> cheeseTypes = new ArrayList<String>();
        workingMemory.setGlobal("cheeseTypes", cheeseTypes);
        cheeseTypes.add("stilton");
        cheeseTypes.add("muzzarela");
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((Object)"memberOf", results.get(0));
        Cheese brie = new Cheese("brie", 5);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertEquals((Object)"not memberOf", results.get(1));
    }

    public void testCustomGlobalResolver() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_globalCustomResolver.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        final HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        String string = "stilton";
        map.put("list", list);
        map.put("string", string);
        workingMemory.setGlobalResolver(new GlobalResolver(){

            public Object resolveGlobal(String identifier) {
                return map.get(identifier);
            }

            public void setGlobal(String identifier, Object value) {
                map.put(identifier, value);
            }
        });
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)new Integer(5), list.get(0));
    }

    public void testCustomGlobalResolverWithWorkingMemoryObject() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_globalCustomResolver.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        final HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        String string = "stilton";
        map.put("list", list);
        map.put("string", string);
        workingMemory.setGlobalResolver(new GlobalResolver(){

            public Object resolveGlobal(String identifier) {
                return map.get(identifier);
            }

            public void setGlobal(String identifier, Object value) {
                map.put(identifier, value);
            }
        });
        Cheese bree = new Cheese();
        bree.setPrice(100);
        workingMemory.insert((Object)bree);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)new Integer(5), list.get(0));
        MiscTest.assertEquals((Object)new Integer(6), list.get(1));
    }

    public void testFieldBiningsAndEvalSharing() throws Exception {
        String drl = "test_FieldBindingsAndEvalSharing.drl";
        this.evalSharingTest("test_FieldBindingsAndEvalSharing.drl");
    }

    public void testFieldBiningsAndPredicateSharing() throws Exception {
        String drl = "test_FieldBindingsAndPredicateSharing.drl";
        this.evalSharingTest("test_FieldBindingsAndPredicateSharing.drl");
    }

    private void evalSharingTest(String drl) throws DroolsParserException, IOException, Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(drl)));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        TestParam tp1 = new TestParam();
        tp1.setValue2("boo");
        wm.insert((Object)tp1);
        wm.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
    }

    public void testFactBindings() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FactBindings.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        final ArrayList events = new ArrayList();
        DefaultWorkingMemoryEventListener listener = new DefaultWorkingMemoryEventListener(){

            public void objectUpdated(ObjectUpdatedEvent event) {
                events.add(event);
            }
        };
        workingMemory.addEventListener((WorkingMemoryEventListener)listener);
        Person bigCheese = new Person("big cheese");
        Cheese cheddar = new Cheese("cheddar", 15);
        bigCheese.setCheese(cheddar);
        FactHandle bigCheeseHandle = workingMemory.insert((Object)bigCheese);
        FactHandle cheddarHandle = workingMemory.insert((Object)cheddar);
        workingMemory.fireAllRules();
        ObjectUpdatedEvent event = (ObjectUpdatedEvent)events.get(0);
        MiscTest.assertSame((Object)cheddarHandle, (Object)event.getFactHandle());
        MiscTest.assertSame((Object)cheddar, (Object)event.getOldObject());
        MiscTest.assertSame((Object)cheddar, (Object)event.getObject());
        event = (ObjectUpdatedEvent)events.get(1);
        MiscTest.assertSame((Object)bigCheeseHandle, (Object)event.getFactHandle());
        MiscTest.assertSame((Object)bigCheese, (Object)event.getOldObject());
        MiscTest.assertSame((Object)bigCheese, (Object)event.getObject());
    }

    public void testNullHandling() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NullHandling.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese nullCheese = new Cheese(null, 2);
        workingMemory.insert((Object)nullCheese);
        Person notNullPerson = new Person("shoes butt back");
        notNullPerson.setBigDecimal(new BigDecimal("42.42"));
        workingMemory.insert((Object)notNullPerson);
        Person nullPerson = new Person("whee");
        nullPerson.setBigDecimal(null);
        workingMemory.insert((Object)nullPerson);
        workingMemory.fireAllRules();
        System.out.println(list.get(0));
        MiscTest.assertEquals((int)3, (int)list.size());
    }

    public void testEmptyPattern() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EmptyPattern.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((Object)new Integer(5), list.get(0));
    }

    private RuleBase loadRuleBase(Reader reader) throws IOException, DroolsParserException, Exception {
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse(reader);
        if (parser.hasErrors()) {
            System.err.println(parser.getErrors());
            Assert.fail((String)"Error messages in parser, need to sort this our (or else collect error messages)");
        }
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        return ruleBase;
    }

    public void testExplicitAnd() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ExplicitAnd.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.insert((Object)new Message("hola"));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)0, (int)list.size());
        workingMemory.insert((Object)new Cheese("brie", 33));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
    }

    public void testHelloWorld() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("HelloWorld.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Message message = new Message("hola");
        message.addToList("hello");
        message.setNumber(42);
        workingMemory.insert((Object)message);
        workingMemory.insert((Object)"boo");
        workingMemory.fireAllRules();
        MiscTest.assertTrue((boolean)message.isFired());
        MiscTest.assertEquals((Object)message, list.get(0));
    }

    public void testMVELSoundex() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("MVEL_soundex.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese c = new Cheese("fubar", 2);
        workingMemory.insert((Object)c);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)42, (int)c.getPrice());
    }

    public void testLiteral() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("literal_rule_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((Object)"stilton", list.get(0));
    }

    public void testLiteralWithBoolean() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("literal_with_boolean.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person bill = new Person("bill", null, 12);
        bill.setAlive(true);
        workingMemory.insert((Object)bill);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((Object)bill, list.get(0));
    }

    public void testFactTemplate() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FactTemplate.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        FactTemplate cheese = pkg.getFactTemplate("Cheese");
        Fact stilton = cheese.createFact(0L);
        stilton.setFieldValue("name", (Object)"stilton");
        stilton.setFieldValue("price", (Object)new Integer(100));
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)stilton, list.get(0));
        Fact fact = (Fact)list.get(0);
        MiscTest.assertSame((Object)stilton, (Object)fact);
        MiscTest.assertEquals((Object)new Integer(200), (Object)fact.getFieldValue("price"));
    }

    public void testPropertyChangeSupport() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_PropertyChange.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        State state = new State("initial");
        workingMemory.insert((Object)state, true);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        state.setFlag(true);
        MiscTest.assertEquals((int)1, (int)list.size());
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        state.setState("finished");
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)list.size());
    }

    public void testBigDecimal() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("big_decimal_and_comparable.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person bill = new Person("bill", null, 12);
        bill.setBigDecimal(new BigDecimal("42"));
        Person ben = new Person("ben", null, 13);
        ben.setBigDecimal(new BigDecimal("43"));
        workingMemory.insert((Object)bill);
        workingMemory.insert((Object)ben);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
    }

    public void testCell() throws Exception {
        Cell cell1 = new Cell(9);
        Cell cell = new Cell(0);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("evalmodify.drl")));
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(builder.getPackage());
        StatefulSession memory = ruleBase.newStatefulSession();
        memory.insert((Object)cell1);
        memory.insert((Object)cell);
        memory.fireAllRules();
        MiscTest.assertEquals((int)9, (int)cell.getValue());
    }

    public void testNesting() throws Exception {
        Person p = new Person();
        p.setName("Michael");
        Address add1 = new Address();
        add1.setStreet("High");
        Address add2 = new Address();
        add2.setStreet("Low");
        ArrayList<Address> l = new ArrayList<Address>();
        l.add(add1);
        l.add(add2);
        p.setAddresses(l);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("nested_fields.drl")));
        MiscTest.assertFalse((String)builder.getErrors().toString(), (boolean)builder.hasErrors());
        DrlParser parser = new DrlParser();
        PackageDescr desc = parser.parse((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("nested_fields.drl")));
        List packageAttrs = desc.getAttributes();
        MiscTest.assertEquals((int)1, (int)desc.getRules().size());
        MiscTest.assertEquals((int)1, (int)packageAttrs.size());
        RuleDescr rule = (RuleDescr)desc.getRules().get(0);
        List ruleAttrs = rule.getAttributes();
        MiscTest.assertEquals((int)1, (int)ruleAttrs.size());
        MiscTest.assertEquals((String)"mvel", (String)((AttributeDescr)ruleAttrs.get(0)).getValue());
        MiscTest.assertEquals((String)"dialect", (String)((AttributeDescr)ruleAttrs.get(0)).getName());
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(builder.getPackage());
        StatefulSession memory = ruleBase.newStatefulSession();
        memory.insert((Object)p);
        memory.fireAllRules();
    }

    public void testOr() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("or_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese cheddar = new Cheese("cheddar", 5);
        FactHandle h = workingMemory.insert((Object)cheddar);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((Object)"got cheese", list.get(0));
        MiscTest.assertEquals((int)1, (int)list.size());
        workingMemory.retract(h);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        workingMemory.insert((Object)new Cheese("stilton", 5));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
    }

    public void testQuery() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("simple_query_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese stilton = new Cheese("stinky", 5);
        workingMemory.insert((Object)stilton);
        QueryResults results = workingMemory.getQueryResults("simple query");
        MiscTest.assertEquals((int)1, (int)results.size());
    }

    public void testEval() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("eval_rule_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.setGlobal("five", (Object)new Integer(5));
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((Object)stilton, list.get(0));
    }

    public void testJaninoEval() throws Exception {
        PackageBuilderConfiguration config = new PackageBuilderConfiguration();
        JavaDialectConfiguration javaConf = (JavaDialectConfiguration)config.getDialectConfiguration("java");
        javaConf.setCompiler(1);
        PackageBuilder builder = new PackageBuilder(config);
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("eval_rule_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.setGlobal("five", (Object)new Integer(5));
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((Object)stilton, list.get(0));
    }

    public void testEvalMore() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("eval_rule_test_more.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person foo = new Person("foo");
        workingMemory.insert((Object)foo);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((Object)foo, list.get(0));
    }

    public void testReturnValue() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("returnvalue_rule_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.setGlobal("two", (Object)new Integer(2));
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person peter = new Person("peter", null, 12);
        workingMemory.insert((Object)peter);
        Person jane = new Person("jane", null, 10);
        workingMemory.insert((Object)jane);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((Object)jane, list.get(0));
        MiscTest.assertEquals((Object)peter, list.get(1));
    }

    public void testPredicate() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("predicate_rule_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.setGlobal("two", (Object)new Integer(2));
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person peter = new Person("peter", null, 12);
        workingMemory.insert((Object)peter);
        Person jane = new Person("jane", null, 10);
        workingMemory.insert((Object)jane);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((Object)jane, list.get(0));
        MiscTest.assertEquals((Object)peter, list.get(1));
    }

    public void testNullBehaviour() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("null_behaviour.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Person p1 = new Person("michael", "food", 40);
        Person p2 = new Person(null, "drink", 30);
        workingMemory.insert((Object)p1);
        workingMemory.insert((Object)p2);
        workingMemory.fireAllRules();
    }

    public void testNullConstraint() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("null_constraint.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList foo = new ArrayList();
        workingMemory.setGlobal("messages", foo);
        Person p1 = new Person(null, "food", 40);
        Primitives p2 = new Primitives();
        p2.setArrayAttribute(null);
        workingMemory.insert((Object)p1);
        workingMemory.insert((Object)p2);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)foo.size());
    }

    public void testImportFunctions() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ImportFunctions.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese cheese = new Cheese("stilton", 15);
        workingMemory.insert((Object)cheese);
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)4, (int)list.size());
        MiscTest.assertEquals((Object)"rule1", list.get(0));
        MiscTest.assertEquals((Object)"rule2", list.get(1));
        MiscTest.assertEquals((Object)"rule3", list.get(2));
        MiscTest.assertEquals((Object)"rule4", list.get(3));
    }

    public void testBasicFrom() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_From.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list1 = new ArrayList();
        workingMemory.setGlobal("list1", list1);
        ArrayList list2 = new ArrayList();
        workingMemory.setGlobal("list2", list2);
        ArrayList list3 = new ArrayList();
        workingMemory.setGlobal("list3", list3);
        Cheesery cheesery = new Cheesery();
        Cheese stilton = new Cheese("stilton", 12);
        Cheese cheddar = new Cheese("cheddar", 15);
        cheesery.addCheese(stilton);
        cheesery.addCheese(cheddar);
        workingMemory.setGlobal("cheesery", (Object)cheesery);
        workingMemory.insert((Object)cheesery);
        Person p = new Person("stilton");
        workingMemory.insert((Object)p);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list1.size());
        MiscTest.assertEquals((Object)cheddar, list1.get(0));
        MiscTest.assertEquals((Object)stilton, list1.get(1));
        MiscTest.assertEquals((int)2, (int)list2.size());
        MiscTest.assertEquals((Object)cheddar, list2.get(0));
        MiscTest.assertEquals((Object)stilton, list2.get(1));
        MiscTest.assertEquals((int)1, (int)list3.size());
        MiscTest.assertEquals((Object)stilton, list3.get(0));
    }

    public void testFromWithParams() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FromWithParams.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        Object globalObject = new Object();
        workingMemory.setGlobal("list", list);
        workingMemory.setGlobal("testObject", (Object)new FromTestClass());
        workingMemory.setGlobal("globalObject", globalObject);
        Person bob = new Person("bob");
        workingMemory.insert((Object)bob);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)6, (int)list.size());
        List array = (List)list.get(0);
        MiscTest.assertEquals((int)3, (int)array.size());
        Person p = (Person)array.get(0);
        MiscTest.assertSame((Object)p, (Object)bob);
        MiscTest.assertEquals((Object)new Integer(42), array.get(1));
        List nested = (List)array.get(2);
        MiscTest.assertEquals((Object)"x", nested.get(0));
        MiscTest.assertEquals((Object)"y", nested.get(1));
        Map map = (Map)list.get(1);
        MiscTest.assertEquals((int)2, (int)map.keySet().size());
        MiscTest.assertTrue((boolean)map.keySet().contains(bob));
        MiscTest.assertSame((Object)globalObject, map.get(bob));
        MiscTest.assertTrue((boolean)map.keySet().contains("key1"));
        Map nestedMap = (Map)map.get("key1");
        MiscTest.assertEquals((int)1, (int)nestedMap.keySet().size());
        MiscTest.assertTrue((boolean)nestedMap.keySet().contains("key2"));
        MiscTest.assertEquals((Object)"value2", nestedMap.get("key2"));
        MiscTest.assertEquals((Object)new Integer(42), list.get(2));
        MiscTest.assertEquals((Object)"literal", list.get(3));
        MiscTest.assertSame((Object)bob, list.get(4));
        MiscTest.assertSame((Object)globalObject, list.get(5));
    }

    public void testFromWithNewConstructor() throws Exception {
        DrlParser parser = new DrlParser();
        PackageDescr descr = parser.parse((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FromWithNewConstructor.drl")));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(descr);
        Package pkg = builder.getPackage();
        pkg.checkValidity();
    }

    public void testWithInvalidRule() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("invalid_rule.drl")));
        Package pkg = builder.getPackage();
        RuntimeException runtime = null;
        RuleBase ruleBase = this.getRuleBase();
        try {
            ruleBase.addPackage(pkg);
            MiscTest.fail((String)"Should have thrown an exception as the rule is NOT VALID.");
        }
        catch (RuntimeException e) {
            MiscTest.assertNotNull((Object)e.getMessage());
            runtime = e;
        }
        MiscTest.assertTrue((builder.getErrors().getErrors().length > 0 ? 1 : 0) != 0);
        String pretty = builder.getErrors().toString();
        MiscTest.assertFalse((boolean)pretty.equals(""));
        MiscTest.assertEquals((String)pretty, (String)runtime.getMessage());
    }

    public void testErrorLineNumbers() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("errors_in_rule.drl")));
        Package pkg = builder.getPackage();
        DroolsError err = builder.getErrors().getErrors()[0];
        RuleError ruleErr = (RuleError)err;
        MiscTest.assertNotNull((Object)ruleErr.getDescr());
        MiscTest.assertTrue((ruleErr.getLine() != -1 ? 1 : 0) != 0);
        DroolsError[] errs = builder.getErrors().getErrors();
        MiscTest.assertEquals((int)3, (int)builder.getErrors().getErrors().length);
        MiscTest.assertEquals((int)ruleErr.getLine(), (int)ruleErr.getDescr().getLine());
        MiscTest.assertEquals((int)11, (int)ruleErr.getLine());
        RuleError rhs = (RuleError)builder.getErrors().getErrors()[2];
        MiscTest.assertTrue((rhs.getLine() > 7 ? 1 : 0) != 0);
    }

    public void testErrorsParser() throws Exception {
        DrlParser parser = new DrlParser();
        MiscTest.assertEquals((int)0, (int)parser.getErrors().size());
        parser.parse((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("errors_parser_multiple.drl")));
        MiscTest.assertTrue((boolean)parser.hasErrors());
        MiscTest.assertTrue((parser.getErrors().size() > 0 ? 1 : 0) != 0);
        MiscTest.assertTrue((boolean)(parser.getErrors().get(0) instanceof ParserError));
        ParserError first = (ParserError)parser.getErrors().get(0);
        MiscTest.assertTrue((first.getMessage() != null ? 1 : 0) != 0);
        MiscTest.assertFalse((boolean)first.getMessage().equals(""));
    }

    public void testFunction() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FunctionInConsequence.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((Object)new Integer(5), list.get(0));
    }

    public void testAssertRetract() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("assert_retract.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person person = new Person("michael", "cheese");
        person.setStatus("start");
        workingMemory.insert((Object)person);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)5, (int)list.size());
        MiscTest.assertTrue((boolean)list.contains("first"));
        MiscTest.assertTrue((boolean)list.contains("second"));
        MiscTest.assertTrue((boolean)list.contains("third"));
        MiscTest.assertTrue((boolean)list.contains("fourth"));
        MiscTest.assertTrue((boolean)list.contains("fifth"));
    }

    public void testPredicateAsFirstPattern() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("predicate_as_first_pattern.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese mussarela = new Cheese("Mussarela", 35);
        workingMemory.insert((Object)mussarela);
        Cheese provolone = new Cheese("Provolone", 20);
        workingMemory.insert((Object)provolone);
        workingMemory.fireAllRules();
        Assert.assertEquals((String)"The rule is being incorrectly fired", (int)35, (int)mussarela.getPrice());
        Assert.assertEquals((String)"Rule is incorrectly being fired", (int)20, (int)provolone.getPrice());
    }

    public void testConsequenceException() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ConsequenceException.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese brie = new Cheese("brie", 12);
        workingMemory.insert((Object)brie);
        try {
            workingMemory.fireAllRules();
            MiscTest.fail((String)"Should throw an Exception from the Consequence");
        }
        catch (Exception e) {
            MiscTest.assertEquals((String)"this should throw an exception", (String)e.getCause().getMessage());
        }
    }

    public void testCustomConsequenceException() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ConsequenceException.drl")));
        Package pkg = builder.getPackage();
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        CustomConsequenceExceptionHandler handler = new CustomConsequenceExceptionHandler();
        conf.setConsequenceExceptionHandler((ConsequenceExceptionHandler)handler);
        RuleBase ruleBase = this.getRuleBase(conf);
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese brie = new Cheese("brie", 12);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        MiscTest.assertTrue((boolean)handler.isCalled());
    }

    public void testFunctionException() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FunctionException.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese brie = new Cheese("brie", 12);
        workingMemory.insert((Object)brie);
        try {
            workingMemory.fireAllRules();
            MiscTest.fail((String)"Should throw an Exception from the Function");
        }
        catch (Exception e) {
            MiscTest.assertEquals((String)"this should throw an exception", (String)e.getCause().getMessage());
        }
    }

    public void testEvalException() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EvalException.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese brie = new Cheese("brie", 12);
        try {
            workingMemory.insert((Object)brie);
            workingMemory.fireAllRules();
            MiscTest.fail((String)"Should throw an Exception from the Eval");
        }
        catch (Exception e) {
            MiscTest.assertEquals((String)"this should throw an exception", (String)e.getCause().getMessage());
        }
    }

    public void testPredicateException() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_PredicateException.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese brie = new Cheese("brie", 12);
        try {
            workingMemory.insert((Object)brie);
            workingMemory.fireAllRules();
            MiscTest.fail((String)"Should throw an Exception from the Predicate");
        }
        catch (Exception e) {
            MiscTest.assertEquals((String)"this should throw an exception", (String)e.getCause().getMessage());
        }
    }

    public void testReturnValueException() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ReturnValueException.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese brie = new Cheese("brie", 12);
        try {
            workingMemory.insert((Object)brie);
            workingMemory.fireAllRules();
            MiscTest.fail((String)"Should throw an Exception from the ReturnValue");
        }
        catch (Exception e) {
            MiscTest.assertTrue((boolean)e.getCause().getMessage().endsWith("this should throw an exception"));
        }
    }

    public void testMultiRestrictionFieldConstraint() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_MultiRestrictionFieldConstraint.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list1 = new ArrayList();
        workingMemory.setGlobal("list1", list1);
        ArrayList list2 = new ArrayList();
        workingMemory.setGlobal("list2", list2);
        ArrayList list3 = new ArrayList();
        workingMemory.setGlobal("list3", list3);
        ArrayList list4 = new ArrayList();
        workingMemory.setGlobal("list4", list4);
        Person youngChili1 = new Person("young chili1");
        youngChili1.setAge(12);
        youngChili1.setHair("blue");
        Person youngChili2 = new Person("young chili2");
        youngChili2.setAge(25);
        youngChili2.setHair("purple");
        Person chili1 = new Person("chili1");
        chili1.setAge(35);
        chili1.setHair("red");
        Person chili2 = new Person("chili2");
        chili2.setAge(38);
        chili2.setHair("indigigo");
        Person oldChili1 = new Person("old chili2");
        oldChili1.setAge(45);
        oldChili1.setHair("green");
        Person oldChili2 = new Person("old chili2");
        oldChili2.setAge(48);
        oldChili2.setHair("blue");
        workingMemory.insert((Object)youngChili1);
        workingMemory.insert((Object)youngChili2);
        workingMemory.insert((Object)chili1);
        workingMemory.insert((Object)chili2);
        workingMemory.insert((Object)oldChili1);
        workingMemory.insert((Object)oldChili2);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list1.size());
        MiscTest.assertTrue((boolean)list1.contains(chili1));
        MiscTest.assertEquals((int)2, (int)list2.size());
        MiscTest.assertTrue((boolean)list2.contains(chili1));
        MiscTest.assertTrue((boolean)list2.contains(chili2));
        MiscTest.assertEquals((int)2, (int)list3.size());
        MiscTest.assertTrue((boolean)list3.contains(youngChili1));
        MiscTest.assertTrue((boolean)list3.contains(youngChili2));
        MiscTest.assertEquals((int)2, (int)list4.size());
        MiscTest.assertTrue((boolean)list4.contains(youngChili1));
        MiscTest.assertTrue((boolean)list4.contains(chili1));
    }

    public void testDumpers() throws Exception {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dumpers.drl")));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(pkg);
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(builder.getPackage());
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)list.size());
        MiscTest.assertEquals((Object)"3 1", list.get(0));
        MiscTest.assertEquals((Object)"MAIN", list.get(1));
        MiscTest.assertEquals((Object)"1 1", list.get(2));
        DrlDumper drlDumper = new DrlDumper();
        String drlResult = drlDumper.dump(pkg);
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(drlResult));
        ruleBase = this.getRuleBase();
        ruleBase.addPackage(builder.getPackage());
        workingMemory = ruleBase.newStatefulSession();
        list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)list.size());
        MiscTest.assertEquals((Object)"3 1", list.get(0));
        MiscTest.assertEquals((Object)"MAIN", list.get(1));
        MiscTest.assertEquals((Object)"1 1", list.get(2));
        XmlDumper xmlDumper = new XmlDumper();
        String xmlResult = xmlDumper.dump(pkg);
        builder = new PackageBuilder();
        builder.addPackageFromXml((Reader)new StringReader(xmlResult));
        ruleBase = this.getRuleBase();
        ruleBase.addPackage(builder.getPackage());
        workingMemory = ruleBase.newStatefulSession();
        list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)list.size());
        MiscTest.assertEquals((Object)"3 1", list.get(0));
        MiscTest.assertEquals((Object)"MAIN", list.get(1));
        MiscTest.assertEquals((Object)"1 1", list.get(2));
    }

    public void testContainsCheese() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ContainsCheese.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 12);
        workingMemory.insert((Object)stilton);
        Cheese brie = new Cheese("brie", 10);
        workingMemory.insert((Object)brie);
        Cheesery cheesery = new Cheesery();
        cheesery.getCheeses().add(stilton);
        workingMemory.insert((Object)cheesery);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)stilton, list.get(0));
        MiscTest.assertEquals((Object)brie, list.get(1));
    }

    public void testStaticFieldReference() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_StaticField.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheesery cheesery1 = new Cheesery();
        cheesery1.setStatus(1);
        cheesery1.setMaturity(Cheesery.Maturity.OLD);
        workingMemory.insert((Object)cheesery1);
        Cheesery cheesery2 = new Cheesery();
        cheesery2.setStatus(0);
        cheesery2.setMaturity(Cheesery.Maturity.YOUNG);
        workingMemory.insert((Object)cheesery2);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)cheesery1, list.get(0));
        MiscTest.assertEquals((Object)cheesery2, list.get(1));
    }

    public void testDuplicateRuleNames() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DuplicateRuleName1.drl")));
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(builder.getPackage());
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DuplicateRuleName2.drl")));
        ruleBase.addPackage(builder.getPackage());
    }

    public void testNullValuesIndexing() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NullValuesIndexing.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg1 = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg1);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Person bob = new Person(null, null);
        bob.setStatus("P1");
        Person pete = new Person(null, null);
        bob.setStatus("P2");
        workingMemory.insert((Object)bob);
        workingMemory.insert((Object)pete);
        workingMemory.fireAllRules();
        Assert.assertEquals((String)"Indexing with null values is not working correctly.", (String)"OK", (String)bob.getStatus());
        Assert.assertEquals((String)"Indexing with null values is not working correctly.", (String)"OK", (String)pete.getStatus());
    }

    public void testSerializable() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Serializable.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg = builder.getPackage();
        MiscTest.assertEquals((int)0, (int)builder.getErrors().getErrors().length);
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        Map map = new HashMap<String, RuleBase>();
        map.put("x", ruleBase);
        byte[] ast = this.serializeOut(map);
        map = (Map)this.serializeIn(ast);
        ruleBase = (RuleBase)map.get("x");
        Rule[] rules = ruleBase.getPackages()[0].getRules();
        MiscTest.assertEquals((int)4, (int)rules.length);
        MiscTest.assertEquals((String)"match Person 1", (String)rules[0].getName());
        MiscTest.assertEquals((String)"match Person 2", (String)rules[1].getName());
        MiscTest.assertEquals((String)"match Person 3", (String)rules[2].getName());
        MiscTest.assertEquals((String)"match Integer", (String)rules[3].getName());
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        workingMemory.insert((Object)bob);
        byte[] wm = this.serializeOut(workingMemory);
        workingMemory = ruleBase.newStatefulSession((InputStream)new ByteArrayInputStream(wm));
        MiscTest.assertEquals((int)1, (int)IteratorToList.convert(workingMemory.iterateObjects()).size());
        MiscTest.assertEquals((Object)bob, IteratorToList.convert(workingMemory.iterateObjects()).get(0));
        MiscTest.assertEquals((int)2, (int)workingMemory.getAgenda().agendaSize());
        workingMemory.fireAllRules();
        List list = (List)workingMemory.getGlobal("list");
        MiscTest.assertEquals((int)3, (int)list.size());
        MiscTest.assertEquals((Object)new Integer(4), list.get(0));
        MiscTest.assertEquals((int)2, (int)IteratorToList.convert(workingMemory.iterateObjects()).size());
        MiscTest.assertTrue((boolean)IteratorToList.convert(workingMemory.iterateObjects()).contains(bob));
        MiscTest.assertTrue((boolean)IteratorToList.convert(workingMemory.iterateObjects()).contains(new Person("help")));
    }

    public void testEmptyRule() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EmptyRule.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.fireAllRules();
        MiscTest.assertTrue((boolean)list.contains("fired1"));
        MiscTest.assertTrue((boolean)list.contains("fired2"));
    }

    public void testjustEval() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NoPatterns.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.fireAllRules();
        MiscTest.assertTrue((boolean)list.contains("fired1"));
        MiscTest.assertTrue((boolean)list.contains("fired3"));
    }

    public void testOrWithBinding() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_OrWithBindings.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Person hola = new Person("hola");
        workingMemory.insert((Object)hola);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)0, (int)list.size());
        workingMemory.insert((Object)new State("x"));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertTrue((boolean)list.contains(hola));
    }

    protected Object serializeIn(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Object obj = in.readObject();
        in.close();
        return obj;
    }

    protected byte[] serializeOut(Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(obj);
        out.close();
        byte[] bytes = bos.toByteArray();
        return bytes;
    }

    public void testJoinNodeModifyObject() throws Exception {
        IndexedNumber n;
        int i;
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_JoinNodeModifyObject.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg1 = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg1);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList orderedFacts = new ArrayList();
        ArrayList errors = new ArrayList();
        workingMemory.setGlobal("orderedNumbers", orderedFacts);
        workingMemory.setGlobal("errors", errors);
        int MAX = 5;
        for (i = 1; i <= 5; ++i) {
            n = new IndexedNumber(i, 5 - i + 1);
            workingMemory.insert((Object)n);
        }
        workingMemory.fireAllRules();
        Assert.assertTrue((String)("Processing generated errors: " + ((Object)errors).toString()), (boolean)errors.isEmpty());
        for (i = 1; i <= 5; ++i) {
            n = (IndexedNumber)orderedFacts.get(i - 1);
            Assert.assertEquals((String)"Fact is out of order", (int)i, (int)n.getIndex());
        }
    }

    public void testQuery2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Query.drl")));
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(builder.getPackage());
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.fireAllRules();
        QueryResults results = workingMemory.getQueryResults("assertedobjquery");
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((Object)new InsertedObject("value1"), (Object)results.get(0).get(0));
    }

    public void testQueryWithParams() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_QueryWithParams.drl")));
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(builder.getPackage());
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.fireAllRules();
        QueryResults results = workingMemory.getQueryResults("assertedobjquery", (Object[])new String[]{"value1"});
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((Object)new InsertedObject("value1"), (Object)results.get(0).get(0));
        results = workingMemory.getQueryResults("assertedobjquery", (Object[])new String[]{"value3"});
        MiscTest.assertEquals((int)0, (int)results.size());
        results = workingMemory.getQueryResults("assertedobjquery2", (Object[])new String[]{null, "value2"});
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((Object)new InsertedObject("value2"), (Object)results.get(0).get(0));
        results = workingMemory.getQueryResults("assertedobjquery2", (Object[])new String[]{"value3", "value2"});
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((Object)new InsertedObject("value2"), (Object)results.get(0).get(0));
    }

    public void testTwoQuerries() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_TwoQuerries.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese stilton = new Cheese("stinky", 5);
        workingMemory.insert((Object)stilton);
        Person per1 = new Person("stinker", "smelly feet", 70);
        Person per2 = new Person("skunky", "smelly armpits", 40);
        workingMemory.insert((Object)per1);
        workingMemory.insert((Object)per2);
        QueryResults results = workingMemory.getQueryResults("find stinky cheeses");
        MiscTest.assertEquals((int)1, (int)results.size());
        results = workingMemory.getQueryResults("find pensioners");
        MiscTest.assertEquals((int)1, (int)results.size());
    }

    public void testInsurancePricingExample() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("insurance_pricing_example.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        Driver driver = new Driver();
        Policy policy = new Policy();
        wm.insert((Object)driver);
        wm.insert((Object)policy);
        wm.fireAllRules();
        MiscTest.assertEquals((int)120, (int)policy.getBasePrice());
    }

    public void testLLR() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_JoinNodeModifyTuple.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        Target tgt = new Target();
        tgt.setLabel("Santa-Anna");
        tgt.setLat(new Float(60.26544f));
        tgt.setLon(new Float(28.952137f));
        tgt.setCourse(new Float(145.0f));
        tgt.setSpeed(new Float(12.0f));
        tgt.setTime(new Float(1.8666667f));
        wm.insert((Object)tgt);
        tgt = new Target();
        tgt.setLabel("Santa-Maria");
        tgt.setLat(new Float(60.236874f));
        tgt.setLon(new Float(28.992579f));
        tgt.setCourse(new Float(325.0f));
        tgt.setSpeed(new Float(8.0f));
        tgt.setTime(new Float(1.8666667f));
        wm.insert((Object)tgt);
        wm.fireAllRules();
        tgt = new Target();
        tgt.setLabel("Santa-Anna");
        tgt.setLat(new Float(60.265343f));
        tgt.setLon(new Float(28.952267f));
        tgt.setCourse(new Float(145.0f));
        tgt.setSpeed(new Float(12.0f));
        tgt.setTime(new Float(1.9f));
        wm.insert((Object)tgt);
        tgt = new Target();
        tgt.setLabel("Santa-Maria");
        tgt.setLat(new Float(60.236935f));
        tgt.setLon(new Float(28.992493f));
        tgt.setCourse(new Float(325.0f));
        tgt.setSpeed(new Float(8.0f));
        tgt.setTime(new Float(1.9f));
        wm.insert((Object)tgt);
        wm.fireAllRules();
        tgt = new Target();
        tgt.setLabel("Santa-Anna");
        tgt.setLat(new Float(60.26525f));
        tgt.setLon(new Float(28.952396f));
        tgt.setCourse(new Float(145.0f));
        tgt.setSpeed(new Float(12.0f));
        tgt.setTime(new Float(1.9333333f));
        wm.insert((Object)tgt);
        tgt = new Target();
        tgt.setLabel("Santa-Maria");
        tgt.setLat(new Float(60.236996f));
        tgt.setLon(new Float(28.992405f));
        tgt.setCourse(new Float(325.0f));
        tgt.setSpeed(new Float(8.0f));
        tgt.setTime(new Float(1.9333333f));
        wm.insert((Object)tgt);
        wm.fireAllRules();
        tgt = new Target();
        tgt.setLabel("Santa-Anna");
        tgt.setLat(new Float(60.265163f));
        tgt.setLon(new Float(28.952526f));
        tgt.setCourse(new Float(145.0f));
        tgt.setSpeed(new Float(12.0f));
        tgt.setTime(new Float(1.9666667f));
        wm.insert((Object)tgt);
        tgt = new Target();
        tgt.setLabel("Santa-Maria");
        tgt.setLat(new Float(60.237057f));
        tgt.setLon(new Float(28.99232f));
        tgt.setCourse(new Float(325.0f));
        tgt.setSpeed(new Float(8.0f));
        tgt.setTime(new Float(1.9666667f));
        wm.insert((Object)tgt);
        wm.fireAllRules();
    }

    public void testDoubleQueryWithExists() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DoubleQueryWithExists.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Person p1 = new Person("p1", "stilton", 20);
        p1.setStatus("europe");
        FactHandle c1FactHandle = workingMemory.insert((Object)p1);
        Person p2 = new Person("p2", "stilton", 30);
        p2.setStatus("europe");
        FactHandle c2FactHandle = workingMemory.insert((Object)p2);
        Person p3 = new Person("p3", "stilton", 40);
        p3.setStatus("europe");
        FactHandle c3FactHandle = workingMemory.insert((Object)p3);
        workingMemory.fireAllRules();
        QueryResults queryResults = workingMemory.getQueryResults("2 persons with the same status");
        MiscTest.assertEquals((int)2, (int)queryResults.size());
        p3.setStatus("america");
        workingMemory.update(c3FactHandle, (Object)p3);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status");
        MiscTest.assertEquals((int)1, (int)queryResults.size());
        p2.setStatus("america");
        workingMemory.update(c2FactHandle, (Object)p2);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status");
        MiscTest.assertEquals((int)1, (int)queryResults.size());
        p1.setStatus("america");
        workingMemory.update(c1FactHandle, (Object)p1);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status");
        MiscTest.assertEquals((int)2, (int)queryResults.size());
        p2.setStatus("europe");
        workingMemory.update(c2FactHandle, (Object)p2);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status");
        MiscTest.assertEquals((int)1, (int)queryResults.size());
        p1.setStatus("europe");
        workingMemory.update(c1FactHandle, (Object)p1);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status");
        MiscTest.assertEquals((int)1, (int)queryResults.size());
        p3.setStatus("europe");
        workingMemory.update(c3FactHandle, (Object)p3);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status");
        MiscTest.assertEquals((int)2, (int)queryResults.size());
    }

    public void testFunctionWithPrimitives() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FunctionWithPrimitives.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((Object)new Integer(10), list.get(0));
    }

    public void testReturnValueAndGlobal() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ReturnValueAndGlobal.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList matchlist = new ArrayList();
        workingMemory.setGlobal("matchingList", matchlist);
        ArrayList nonmatchlist = new ArrayList();
        workingMemory.setGlobal("nonMatchingList", nonmatchlist);
        workingMemory.setGlobal("cheeseType", (Object)"stilton");
        Cheese stilton1 = new Cheese("stilton", 5);
        Cheese stilton2 = new Cheese("stilton", 7);
        Cheese brie = new Cheese("brie", 4);
        workingMemory.insert((Object)stilton1);
        workingMemory.insert((Object)stilton2);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)matchlist.size());
        MiscTest.assertEquals((int)1, (int)nonmatchlist.size());
    }

    public void testDeclaringAndUsingBindsInSamePattern() throws Exception {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        config.setRemoveIdentities(true);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DeclaringAndUsingBindsInSamePattern.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase(config);
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList sensors = new ArrayList();
        workingMemory.setGlobal("sensors", sensors);
        Sensor sensor1 = new Sensor(100, 150);
        workingMemory.insert((Object)sensor1);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)0, (int)sensors.size());
        Sensor sensor2 = new Sensor(200, 150);
        workingMemory.insert((Object)sensor2);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)sensors.size());
    }

    public void testMissingImports() {
        try {
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_missing_import.drl")));
            Package pkg = builder.getPackage();
            RuleBase ruleBase = this.getRuleBase();
            ruleBase.addPackage(pkg);
            Assert.fail((String)"Should have thrown an InvalidRulePackage");
        }
        catch (InvalidRulePackage e) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Should have thrown an InvalidRulePackage Exception instead of " + e.getMessage()));
        }
    }

    public void testNestedConditionalElements() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NestedConditionalElements.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        State state = new State("SP");
        workingMemory.insert((Object)state);
        Person bob = new Person("Bob");
        bob.setStatus(state.getState());
        bob.setLikes("stilton");
        workingMemory.insert((Object)bob);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)0, (int)list.size());
        workingMemory.insert((Object)new Cheese(bob.getLikes(), 10));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
    }

    public void testDeclarationUsage() throws Exception {
        try {
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DeclarationUsage.drl")));
            Package pkg = builder.getPackage();
            RuleBase ruleBase = this.getRuleBase();
            ruleBase.addPackage(pkg);
            MiscTest.fail((String)"Should have trown an exception");
        }
        catch (InvalidRulePackage e) {
        }
        catch (Exception e) {
            e.printStackTrace();
            MiscTest.fail((String)("Wrong exception raised: " + e.getMessage()));
        }
    }

    public void testUnbalancedTrees() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_UnbalancedTrees.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession wm = ruleBase.newStatefulSession();
        wm.insert((Object)new Cheese("a", 10));
        wm.insert((Object)new Cheese("b", 10));
        wm.insert((Object)new Cheese("c", 10));
        wm.insert((Object)new Cheese("d", 10));
        Cheese e = new Cheese("e", 10);
        wm.insert((Object)e);
        wm.fireAllRules();
        Assert.assertEquals((String)"Rule should have fired twice, seting the price to 30", (int)30, (int)e.getPrice());
    }

    public void testImportConflict() throws Exception {
        RuleBase ruleBase = this.getRuleBase();
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ImportConflict.drl")));
        Package pkg = builder.getPackage();
        ruleBase.addPackage(pkg);
    }

    public void testPrimitiveArray() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_primitiveArray.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList result = new ArrayList();
        workingMemory.setGlobal("result", result);
        Primitives p1 = new Primitives();
        p1.setPrimitiveArrayAttribute(new int[]{1, 2, 3});
        p1.setArrayAttribute(new String[]{"a", "b"});
        workingMemory.insert((Object)p1);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)result.size());
        MiscTest.assertEquals((int)3, (int)((Integer)result.get(0)));
        MiscTest.assertEquals((int)2, (int)((Integer)result.get(1)));
        MiscTest.assertEquals((int)3, (int)((Integer)result.get(2)));
    }

    public void testEmptyIdentifier() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_emptyIdentifier.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList result = new ArrayList();
        workingMemory.setGlobal("results", result);
        Person person = new Person("bob");
        Cheese cheese = new Cheese("brie", 10);
        workingMemory.insert((Object)person);
        workingMemory.insert((Object)cheese);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)4, (int)result.size());
    }

    public void testDuplicateVariableBinding() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_duplicateVariableBinding.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        HashMap result = new HashMap();
        workingMemory.setGlobal("results", result);
        Cheese stilton = new Cheese("stilton", 20);
        Cheese brie = new Cheese("brie", 10);
        workingMemory.insert((Object)stilton);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)5, (int)result.size());
        MiscTest.assertEquals((int)stilton.getPrice(), (int)((Integer)result.get(stilton.getType())));
        MiscTest.assertEquals((int)brie.getPrice(), (int)((Integer)result.get(brie.getType())));
        MiscTest.assertEquals((int)stilton.getPrice(), (int)((Integer)result.get(stilton)));
        MiscTest.assertEquals((int)brie.getPrice(), (int)((Integer)result.get(brie)));
        MiscTest.assertEquals((int)stilton.getPrice(), (int)((Integer)result.get("test3" + stilton.getType())));
        workingMemory.insert((Object)new Person("bob", brie.getType()));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)6, (int)result.size());
        MiscTest.assertEquals((int)brie.getPrice(), (int)((Integer)result.get("test3" + brie.getType())));
    }

    public void testDuplicateVariableBindingError() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_duplicateVariableBindingError.drl")));
        Package pkg = builder.getPackage();
        MiscTest.assertFalse((boolean)pkg.isValid());
        System.out.println(pkg.getErrorSummary());
        MiscTest.assertEquals((int)6, (int)pkg.getErrorSummary().split("\n").length);
    }

    public void testShadowProxyInHirarchies() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ShadowProxyInHirarchies.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.insert((Object)new Child("gp"));
        workingMemory.fireAllRules();
    }

    public void testSelfReference() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_SelfReference.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Order order = new Order(10, "Bob");
        OrderItem item1 = new OrderItem(order, 1);
        OrderItem item2 = new OrderItem(order, 2);
        OrderItem anotherItem1 = new OrderItem(null, 3);
        OrderItem anotherItem2 = new OrderItem(null, 4);
        workingMemory.insert((Object)order);
        workingMemory.insert((Object)item1);
        workingMemory.insert((Object)item2);
        workingMemory.insert((Object)anotherItem1);
        workingMemory.insert((Object)anotherItem2);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertTrue((boolean)results.contains(item1));
        MiscTest.assertTrue((boolean)results.contains(item2));
    }

    public void testNumberComparisons() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NumberComparisons.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        RandomNumber rn = new RandomNumber();
        rn.setValue(10);
        workingMemory.insert((Object)rn);
        Guess guess = new Guess();
        guess.setValue(new Integer(5));
        FactHandle handle = workingMemory.insert((Object)guess);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)"HIGHER", list.get(0));
        guess.setValue(new Integer(15));
        workingMemory.update(handle, (Object)guess);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)"LOWER", list.get(1));
        guess.setValue(new Integer(10));
        workingMemory.update(handle, (Object)guess);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)list.size());
        MiscTest.assertEquals((Object)"CORRECT", list.get(2));
    }

    public void testSkipModify() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_skipModify.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Cheese cheese = new Cheese("brie", 10);
        FactHandle handle = workingMemory.insert((Object)cheese);
        Person bob = new Person("bob", "stilton");
        workingMemory.insert((Object)bob);
        cheese.setType("stilton");
        workingMemory.update(handle, (Object)cheese);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
    }

    public void testEventModel() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EventModel.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession wm = ruleBase.newStatefulSession();
        final ArrayList agendaList = new ArrayList();
        AgendaEventListener agendaEventListener = new AgendaEventListener(){

            public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }

            public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }

            public void afterActivationFired(AfterActivationFiredEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }

            public void beforeActivationFired(BeforeActivationFiredEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }
        };
        final ArrayList wmList = new ArrayList();
        WorkingMemoryEventListener workingMemoryListener = new WorkingMemoryEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                wmList.add(event);
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                wmList.add(event);
            }

            public void objectRetracted(ObjectRetractedEvent event) {
                wmList.add(event);
            }
        };
        wm.addEventListener(workingMemoryListener);
        Cheese stilton = new Cheese("stilton", 15);
        Cheese cheddar = new Cheese("cheddar", 17);
        FactHandle stiltonHandle = wm.insert((Object)stilton);
        ObjectInsertedEvent oae = (ObjectInsertedEvent)wmList.get(0);
        MiscTest.assertSame((Object)stiltonHandle, (Object)oae.getFactHandle());
        wm.update(stiltonHandle, (Object)stilton);
        ObjectUpdatedEvent ome = (ObjectUpdatedEvent)wmList.get(1);
        MiscTest.assertSame((Object)stiltonHandle, (Object)ome.getFactHandle());
        wm.retract(stiltonHandle);
        ObjectRetractedEvent ore = (ObjectRetractedEvent)wmList.get(2);
        MiscTest.assertSame((Object)stiltonHandle, (Object)ore.getFactHandle());
        wm.insert((Object)cheddar);
    }

    public void testImplicitDeclarations() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_implicitDeclarations.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.setGlobal("factor", (Object)new Double(1.2));
        Cheese cheese = new Cheese("stilton", 10);
        workingMemory.insert((Object)cheese);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
    }

    public void testCastingInsideEvals() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_castsInsideEval.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.setGlobal("value", (Object)new Integer(20));
        workingMemory.fireAllRules();
    }

    public void testMemberOfAndNotMemberOf() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_memberOf.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 12);
        Cheese muzzarela = new Cheese("muzzarela", 10);
        Cheese brie = new Cheese("brie", 15);
        workingMemory.insert((Object)stilton);
        workingMemory.insert((Object)muzzarela);
        Cheesery cheesery = new Cheesery();
        cheesery.getCheeses().add(stilton.getType());
        cheesery.getCheeses().add(brie.getType());
        workingMemory.insert((Object)cheesery);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)stilton, list.get(0));
        MiscTest.assertEquals((Object)muzzarela, list.get(1));
    }

    public void testContainsInArray() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_contains_in_array.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Primitives p = new Primitives();
        p.setStringArray(new String[]{"test1", "test3"});
        workingMemory.insert((Object)p);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)"ok1", list.get(0));
        MiscTest.assertEquals((Object)"ok2", list.get(1));
    }

    public void testCollectNodeSharing() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_collectNodeSharing.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.insert((Object)new Cheese("stilton", 10));
        workingMemory.insert((Object)new Cheese("brie", 15));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((int)2, (int)((List)list.get(0)).size());
    }

    public void testNodeSharingNotExists() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_nodeSharingNotExists.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)"rule1", list.get(0));
        workingMemory.insert((Object)new Cheese("stilton", 10));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)"rule2", list.get(1));
    }

    public void testNullBinding() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_nullBindings.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.insert((Object)new Person("bob"));
        workingMemory.insert((Object)new Person(null));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)"OK", list.get(0));
    }

    public void testModifyRetractWithFunction() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RetractModifyWithFunction.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)ruleBase.newStatefulSession();
        Cheese stilton = new Cheese("stilton", 7);
        Cheese muzzarella = new Cheese("muzzarella", 9);
        int sum = stilton.getPrice() + muzzarella.getPrice();
        FactHandle stiltonHandle = workingMemory.insert((Object)stilton);
        FactHandle muzzarellaHandle = workingMemory.insert((Object)muzzarella);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)sum, (int)stilton.getPrice());
        MiscTest.assertEquals((int)1, (int)workingMemory.getFactHandleMap().size());
        MiscTest.assertNotNull((Object)workingMemory.getObject(stiltonHandle));
        MiscTest.assertNotNull((Object)workingMemory.getFactHandle((Object)stilton));
        MiscTest.assertNull((Object)workingMemory.getObject(muzzarellaHandle));
        MiscTest.assertNull((Object)workingMemory.getFactHandle((Object)muzzarella));
    }

    public void testConstraintConnectors() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ConstraintConnectors.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Person youngChili1 = new Person("young chili1");
        youngChili1.setAge(12);
        youngChili1.setHair("blue");
        Person youngChili2 = new Person("young chili2");
        youngChili2.setAge(25);
        youngChili2.setHair("purple");
        Person chili1 = new Person("chili1");
        chili1.setAge(35);
        chili1.setHair("red");
        Person chili2 = new Person("chili2");
        chili2.setAge(38);
        chili2.setHair("indigigo");
        Person oldChili1 = new Person("old chili2");
        oldChili1.setAge(45);
        oldChili1.setHair("green");
        Person oldChili2 = new Person("old chili2");
        oldChili2.setAge(48);
        oldChili2.setHair("blue");
        Person veryold = new Person("very old");
        veryold.setAge(99);
        veryold.setHair("gray");
        workingMemory.insert((Object)youngChili1);
        workingMemory.insert((Object)youngChili2);
        workingMemory.insert((Object)chili1);
        workingMemory.insert((Object)chili2);
        workingMemory.insert((Object)oldChili1);
        workingMemory.insert((Object)oldChili2);
        workingMemory.insert((Object)veryold);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)4, (int)results.size());
        MiscTest.assertEquals((Object)chili1, results.get(0));
        MiscTest.assertEquals((Object)oldChili1, results.get(1));
        MiscTest.assertEquals((Object)youngChili1, results.get(2));
        MiscTest.assertEquals((Object)veryold, results.get(3));
    }

    public void testMatchesNotMatchesCheese() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_MatchesNotMatches.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 12);
        Cheese stilton2 = new Cheese("stilton2", 12);
        Cheese brie = new Cheese("brie", 10);
        Cheese brie2 = new Cheese("brie2", 10);
        Cheese muzzarella = new Cheese("muzzarella", 10);
        Cheese muzzarella2 = new Cheese("muzzarella2", 10);
        workingMemory.insert((Object)stilton);
        workingMemory.insert((Object)stilton2);
        workingMemory.insert((Object)brie);
        workingMemory.insert((Object)brie2);
        workingMemory.insert((Object)muzzarella);
        workingMemory.insert((Object)muzzarella2);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertEquals((Object)stilton, list.get(0));
        MiscTest.assertEquals((Object)brie, list.get(1));
    }

    public void testAutomaticBindings() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AutoBindings.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Person bob = new Person("bob", "stilton");
        Cheese stilton = new Cheese("stilton", 12);
        workingMemory.insert((Object)bob);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)bob, list.get(0));
    }

    public void testAutomaticBindingsErrors() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AutoBindingsErrors.drl")));
        Package pkg = builder.getPackage();
        MiscTest.assertNotNull((Object)pkg.getErrorSummary());
    }

    public void testQualifiedFieldReference() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_QualifiedFieldReference.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Person bob = new Person("bob", "stilton");
        Cheese stilton = new Cheese("stilton", 12);
        workingMemory.insert((Object)bob);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((Object)bob, list.get(0));
    }

    public void testEvalRewrite() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EvalRewrite.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Order order1 = new Order(10, "Bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        order1.addItem(item11);
        order1.addItem(item12);
        Order order2 = new Order(11, "Bob");
        OrderItem item21 = new OrderItem(order2, 1);
        OrderItem item22 = new OrderItem(order2, 2);
        order2.addItem(item21);
        order2.addItem(item22);
        Order order3 = new Order(12, "Bob");
        OrderItem item31 = new OrderItem(order3, 1);
        OrderItem item32 = new OrderItem(order3, 2);
        order3.addItem(item31);
        order3.addItem(item32);
        Order order4 = new Order(13, "Bob");
        OrderItem item41 = new OrderItem(order4, 1);
        OrderItem item42 = new OrderItem(order4, 2);
        order4.addItem(item41);
        order4.addItem(item42);
        workingMemory.insert((Object)order1);
        workingMemory.insert((Object)item11);
        workingMemory.insert((Object)item12);
        workingMemory.insert((Object)order2);
        workingMemory.insert((Object)item21);
        workingMemory.insert((Object)item22);
        workingMemory.insert((Object)order3);
        workingMemory.insert((Object)item31);
        workingMemory.insert((Object)item32);
        workingMemory.insert((Object)order4);
        workingMemory.insert((Object)item41);
        workingMemory.insert((Object)item42);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)5, (int)list.size());
        MiscTest.assertTrue((boolean)list.contains(item11));
        MiscTest.assertTrue((boolean)list.contains(item12));
        MiscTest.assertTrue((boolean)list.contains(item22));
        MiscTest.assertTrue((boolean)list.contains(order3));
        MiscTest.assertTrue((boolean)list.contains(order4));
    }

    public void testMapAccess() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_MapAccess.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "Edson");
        map.put("surname", "Tirelli");
        map.put("age", "28");
        workingMemory.insert(map);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertTrue((boolean)list.contains(map));
    }

    public void testHalt() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_halt.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.insert((Object)new Integer(0));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)10, (int)results.size());
        for (int i = 0; i < 10; ++i) {
            MiscTest.assertEquals((Object)new Integer(i), results.get(i));
        }
    }

    public void testFireLimit() throws Exception {
        int i;
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_fireLimit.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.insert((Object)new Integer(0));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)20, (int)results.size());
        for (i = 0; i < 20; ++i) {
            MiscTest.assertEquals((Object)new Integer(i), results.get(i));
        }
        results.clear();
        workingMemory.insert((Object)new Integer(0));
        workingMemory.fireAllRules(10);
        MiscTest.assertEquals((int)10, (int)results.size());
        for (i = 0; i < 10; ++i) {
            MiscTest.assertEquals((Object)new Integer(i), results.get(i));
        }
        results.clear();
        workingMemory.insert((Object)new Integer(0));
        workingMemory.fireAllRules(-1);
        MiscTest.assertEquals((int)20, (int)results.size());
        for (i = 0; i < 20; ++i) {
            MiscTest.assertEquals((Object)new Integer(i), results.get(i));
        }
        results.clear();
    }

    public void testEqualitySupport() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_equalitySupport.drl")));
        Package pkg = builder.getPackage();
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setAssertBehaviour(RuleBaseConfiguration.AssertBehaviour.EQUALITY);
        RuleBase ruleBase = this.getRuleBase(conf);
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        PersonWithEquals person = new PersonWithEquals("bob", 30);
        workingMemory.insert((Object)person);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((Object)"mark", results.get(0));
    }

    public void testCharComparisons() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_charComparisons.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Primitives p1 = new Primitives();
        p1.setCharPrimitive('a');
        p1.setStringAttribute("b");
        Primitives p2 = new Primitives();
        p2.setCharPrimitive('b');
        p2.setStringAttribute("a");
        workingMemory.insert((Object)p1);
        workingMemory.insert((Object)p2);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)results.size());
        MiscTest.assertEquals((Object)"1", results.get(0));
        MiscTest.assertEquals((Object)"2", results.get(1));
        MiscTest.assertEquals((Object)"3", results.get(2));
    }

    public void testAlphaNodeSharing() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_alphaNodeSharing.drl")));
        Package pkg = builder.getPackage();
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setShareAlphaNodes(false);
        RuleBase ruleBase = this.getRuleBase(conf);
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Person p1 = new Person("bob", 5);
        workingMemory.insert((Object)p1);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertEquals((Object)"1", results.get(0));
        MiscTest.assertEquals((Object)"2", results.get(1));
    }

    public void testFunctionCallingFunctionWithEclipse() throws Exception {
        PackageBuilderConfiguration packageBuilderConfig = new PackageBuilderConfiguration();
        ((JavaDialectConfiguration)packageBuilderConfig.getDialectConfiguration("java")).setCompiler(0);
        PackageBuilder builder = new PackageBuilder(packageBuilderConfig);
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_functionCallingFunction.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((int)10, (int)((Integer)list.get(0)));
    }

    public void testFunctionCallingFunctionWithJanino() throws Exception {
        PackageBuilderConfiguration packageBuilderConfig = new PackageBuilderConfiguration();
        ((JavaDialectConfiguration)packageBuilderConfig.getDialectConfiguration("java")).setCompiler(1);
        PackageBuilder builder = new PackageBuilder(packageBuilderConfig);
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_functionCallingFunction.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertEquals((int)10, (int)((Integer)list.get(0)));
    }

    public void testSelfReference2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_SelfReference2.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.insert((Object)new Cheese());
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)0, (int)results.size());
    }

    public void testMergingDifferentPackages() throws Exception {
        try {
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RuleNameClashes1.drl")));
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RuleNameClashes2.drl")));
            MiscTest.fail((String)"Can't merge packages with different names ");
        }
        catch (PackageBuilder.PackageMergeException e) {
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            MiscTest.fail((String)("unexpected exception: " + e.getMessage()));
        }
    }

    public void testMergingDifferentPackages2() throws Exception {
        try {
            PackageBuilder builder1 = new PackageBuilder();
            builder1.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RuleNameClashes1.drl")));
            Package pkg1 = builder1.getPackage();
            MiscTest.assertEquals((int)1, (int)pkg1.getRules().length);
            PackageBuilder builder2 = new PackageBuilder();
            builder2.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RuleNameClashes2.drl")));
            Package pkg2 = builder2.getPackage();
            MiscTest.assertEquals((int)1, (int)pkg2.getRules().length);
            RuleBase ruleBase = this.getRuleBase();
            ruleBase.addPackage(pkg1);
            ruleBase.addPackage(pkg2);
            StatefulSession workingMemory = ruleBase.newStatefulSession();
            ArrayList results = new ArrayList();
            workingMemory.setGlobal("results", results);
            workingMemory.insert((Object)new Cheese("stilton", 10));
            workingMemory.insert((Object)new Cheese("brie", 5));
            workingMemory.fireAllRules();
            MiscTest.assertEquals((String)((Object)results).toString(), (int)2, (int)results.size());
            MiscTest.assertTrue((boolean)results.contains("p1.r1"));
            MiscTest.assertTrue((boolean)results.contains("p2.r1"));
        }
        catch (PackageBuilder.PackageMergeException e) {
            MiscTest.fail((String)("Should not raise exception when merging different packages into the same rulebase: " + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            MiscTest.fail((String)("unexpected exception: " + e.getMessage()));
        }
    }

    public void testRuleReplacement() throws Exception {
        try {
            PackageBuilder builder1 = new PackageBuilder();
            builder1.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RuleNameClashes1.drl")));
            builder1.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RuleNameClashes3.drl")));
            Package pkg1 = builder1.getPackage();
            MiscTest.assertEquals((int)1, (int)pkg1.getRules().length);
            RuleBase ruleBase = this.getRuleBase();
            ruleBase.addPackage(pkg1);
            StatefulSession workingMemory = ruleBase.newStatefulSession();
            ArrayList results = new ArrayList();
            workingMemory.setGlobal("results", results);
            workingMemory.insert((Object)new Cheese("stilton", 10));
            workingMemory.insert((Object)new Cheese("brie", 5));
            workingMemory.fireAllRules();
            MiscTest.assertEquals((String)((Object)results).toString(), (int)0, (int)results.size());
            workingMemory.insert((Object)new Cheese("muzzarella", 7));
            workingMemory.fireAllRules();
            MiscTest.assertEquals((String)((Object)results).toString(), (int)1, (int)results.size());
            MiscTest.assertTrue((boolean)results.contains("p1.r3"));
        }
        catch (PackageBuilder.PackageMergeException e) {
            MiscTest.fail((String)("Should not raise exception when merging different packages into the same rulebase: " + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            MiscTest.fail((String)("unexpected exception: " + e.getMessage()));
        }
    }

    public void testOutOfMemory() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_OutOfMemory.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.insert((Object)new Cheese("stilton", 1));
        workingMemory.fireAllRules(3000000);
    }

    public void testBindingsOnConnectiveExpressions() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_bindings.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.insert((Object)new Cheese("stilton", 15));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertEquals((Object)"stilton", results.get(0));
        MiscTest.assertEquals((Object)new Integer(15), results.get(1));
    }

    public void testMultipleFroms() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_multipleFroms.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(new Cheese("stilton", 15));
        cheesery.addCheese(new Cheese("brie", 10));
        workingMemory.setGlobal("cheesery", (Object)cheesery);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertEquals((int)2, (int)((List)results.get(0)).size());
        MiscTest.assertEquals((int)2, (int)((List)results.get(1)).size());
    }

    public void testNullHashing() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NullHashing.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.insert((Object)new Cheese("stilton", 15));
        workingMemory.insert((Object)new Cheese("", 10));
        workingMemory.insert((Object)new Cheese(null, 8));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)results.size());
    }

    public void testDefaultBetaConstrains() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DefaultBetaConstraint.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        FirstClass first = new FirstClass("1", "2", "3", "4", "5");
        FactHandle handle = workingMemory.insert((Object)first);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(0));
        workingMemory.insert((Object)new SecondClass());
        workingMemory.update(handle, (Object)first);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(1));
        workingMemory.update(handle, (Object)first);
        workingMemory.insert((Object)new SecondClass(null, "2", "3", "4", "5"));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)3, (int)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(2));
        workingMemory.update(handle, (Object)first);
        workingMemory.insert((Object)new SecondClass("1", null, "3", "4", "5"));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)4, (int)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(3));
        workingMemory.update(handle, (Object)first);
        workingMemory.insert((Object)new SecondClass("1", "2", null, "4", "5"));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)5, (int)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(4));
        workingMemory.update(handle, (Object)first);
        workingMemory.insert((Object)new SecondClass("1", "2", "3", null, "5"));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)6, (int)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(5));
        workingMemory.update(handle, (Object)first);
        workingMemory.insert((Object)new SecondClass("1", "2", "3", "4", null));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)7, (int)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(6));
        workingMemory.insert((Object)new SecondClass("1", "2", "3", "4", "5"));
        workingMemory.update(handle, (Object)first);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)8, (int)results.size());
        MiscTest.assertEquals((Object)"EQUALS", results.get(7));
    }

    public void testBooleanWrapper() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_BooleanWrapper.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Primitives p1 = new Primitives();
        workingMemory.insert((Object)p1);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)0, (int)results.size());
        Primitives p2 = new Primitives();
        p2.setBooleanWrapper(Boolean.FALSE);
        workingMemory.insert((Object)p2);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)0, (int)results.size());
        Primitives p3 = new Primitives();
        p3.setBooleanWrapper(Boolean.TRUE);
        workingMemory.insert((Object)p3);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
    }

    public void testCrossProductRemovingIdentityEquals() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(MiscTest.class.getResourceAsStream("test_CrossProductRemovingIdentityEquals.drl")));
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setShadowProxy(true);
        RuleBase rb = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        rb.addPackage(builder.getPackage());
        StatefulSession session = rb.newStatefulSession();
        ArrayList list1 = new ArrayList();
        ArrayList list2 = new ArrayList();
        session.setGlobal("list1", list1);
        session.setGlobal("list2", list2);
        SpecialString first42 = new SpecialString("42");
        SpecialString second43 = new SpecialString("42");
        SpecialString world = new SpecialString("World");
        session.insert((Object)world);
        session.insert((Object)first42);
        session.insert((Object)second43);
        session.fireAllRules();
        MiscTest.assertEquals((int)6, (int)list1.size());
        MiscTest.assertEquals((int)6, (int)list2.size());
        MiscTest.assertEquals((Object)second43, list1.get(0));
        MiscTest.assertEquals((Object)first42, list1.get(1));
        MiscTest.assertEquals((Object)world, list1.get(2));
        MiscTest.assertEquals((Object)second43, list1.get(3));
        MiscTest.assertEquals((Object)first42, list1.get(4));
        MiscTest.assertEquals((Object)world, list1.get(5));
        MiscTest.assertEquals((Object)first42, list2.get(0));
        MiscTest.assertEquals((Object)second43, list2.get(1));
        MiscTest.assertEquals((Object)second43, list2.get(2));
        MiscTest.assertEquals((Object)world, list2.get(3));
        MiscTest.assertEquals((Object)world, list2.get(4));
        MiscTest.assertEquals((Object)first42, list2.get(5));
    }

    public void testIterateObjects() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_IterateObjects.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.insert((Object)new Cheese("stilton", 10));
        workingMemory.fireAllRules();
        Iterator events = workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(PersonInterface.class));
        MiscTest.assertTrue((boolean)events.hasNext());
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals(results.get(0), events.next());
    }

    public void testNotInStatelessSession() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NotInStatelessSession.drl")));
        Package pkg = builder.getPackage();
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setSequential(true);
        RuleBase ruleBase = this.getRuleBase(conf);
        ruleBase.addPackage(pkg);
        StatelessSession session = ruleBase.newStatelessSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.execute((Object)"not integer");
        MiscTest.assertEquals((Object)"not integer", list.get(0));
    }

    public void testDynamicallyAddInitialFactRule() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        String rule = "package org.drools.test\n global java.util.List list\n rule xxx\n when\n i:Integer()\nthen\n list.add(i);\nend";
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.insert((Object)new Integer(5));
        session.fireAllRules();
        MiscTest.assertEquals((Object)new Integer(5), list.get(0));
        builder = new PackageBuilder();
        rule = "package org.drools.test\n global java.util.List list\n rule xxx\n when\nthen\n list.add(\"x\");\nend";
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        pkg = builder.getPackage();
        ruleBase.addPackage(pkg);
        MiscTest.assertEquals((Object)"x", list.get(1));
    }

    public void testEvalRewriteWithSpecialOperators() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EvalRewriteWithSpecialOperators.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Order order1 = new Order(10, "Bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        order1.addItem(item11);
        order1.addItem(item12);
        Order order2 = new Order(11, "Bob");
        OrderItem item21 = new OrderItem(order2, 1);
        OrderItem item22 = new OrderItem(order2, 2);
        order2.addItem(item21);
        order2.addItem(item22);
        Order order3 = new Order(12, "Bob");
        OrderItem item31 = new OrderItem(order3, 1);
        OrderItem item32 = new OrderItem(order3, 2);
        OrderItem item33 = new OrderItem(order3, 3);
        order3.addItem(item31);
        order3.addItem(item32);
        order3.addItem(item33);
        Order order4 = new Order(13, "Bob");
        OrderItem item41 = new OrderItem(order4, 1);
        OrderItem item42 = new OrderItem(order4, 2);
        order4.addItem(item41);
        order4.addItem(item42);
        Order order5 = new Order(14, "Mark");
        OrderItem item51 = new OrderItem(order5, 1);
        OrderItem item52 = new OrderItem(order5, 2);
        order5.addItem(item51);
        order5.addItem(item52);
        workingMemory.insert((Object)order1);
        workingMemory.insert((Object)item11);
        workingMemory.insert((Object)item12);
        workingMemory.insert((Object)order2);
        workingMemory.insert((Object)item21);
        workingMemory.insert((Object)item22);
        workingMemory.insert((Object)order3);
        workingMemory.insert((Object)item31);
        workingMemory.insert((Object)item32);
        workingMemory.insert((Object)item33);
        workingMemory.insert((Object)order4);
        workingMemory.insert((Object)item41);
        workingMemory.insert((Object)item42);
        workingMemory.insert((Object)order5);
        workingMemory.insert((Object)item51);
        workingMemory.insert((Object)item52);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)9, (int)list.size());
        int index = 0;
        MiscTest.assertEquals((Object)item11, list.get(index++));
        MiscTest.assertEquals((Object)item12, list.get(index++));
        MiscTest.assertEquals((Object)item21, list.get(index++));
        MiscTest.assertEquals((Object)item22, list.get(index++));
        MiscTest.assertEquals((Object)item31, list.get(index++));
        MiscTest.assertEquals((Object)item33, list.get(index++));
        MiscTest.assertEquals((Object)item41, list.get(index++));
        MiscTest.assertEquals((Object)order5, list.get(index++));
        MiscTest.assertEquals((Object)order5, list.get(index++));
    }

    public void testImportColision() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageBuilder builder2 = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("nested1.drl")));
        builder2.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("nested2.drl")));
        Package pkg = builder.getPackage();
        Package pkg2 = builder2.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase.addPackage(pkg2);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.insert((Object)new FirstClass());
        workingMemory.insert((Object)new SecondClass());
        workingMemory.insert((Object)new FirstClass.AlternativeKey());
        workingMemory.insert((Object)new SecondClass.AlternativeKey());
        workingMemory.fireAllRules();
    }

    public void testAutovivificationOfVariableRestrictions() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AutoVivificationVR.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory.insert((Object)new Cheese("stilton", 10, 8));
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
    }

    public void testShadowProxyOnCollections() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ShadowProxyOnCollections.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Cheesery cheesery = new Cheesery();
        workingMemory.insert((Object)cheesery);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)results.size());
        MiscTest.assertEquals((int)1, (int)cheesery.getCheeses().size());
        MiscTest.assertEquals(results.get(0), cheesery.getCheeses().get(0));
    }

    public void testQueryWithCollect() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Query.drl")));
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(builder.getPackage());
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.fireAllRules();
        QueryResults results = workingMemory.getQueryResults("collect objects");
        MiscTest.assertEquals((int)1, (int)results.size());
        QueryResult result = results.get(0);
        List list = (List)result.get("$list");
        MiscTest.assertEquals((int)2, (int)list.size());
    }

    public void testNestedAccessors() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_NestedAccessors.drl")));
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(builder.getPackage());
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Order order1 = new Order(11, "Bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        order1.addItem(item11);
        order1.addItem(item12);
        workingMemory.insert((Object)order1);
        workingMemory.insert((Object)item11);
        workingMemory.insert((Object)item12);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)0, (int)list.size());
        Order order2 = new Order(12, "Mark");
        Order.OrderStatus status = new Order.OrderStatus();
        status.setActive(true);
        order2.setStatus(status);
        OrderItem item21 = new OrderItem(order2, 1);
        OrderItem item22 = new OrderItem(order2, 2);
        order1.addItem(item21);
        order1.addItem(item22);
        workingMemory.insert((Object)order2);
        workingMemory.insert((Object)item21);
        workingMemory.insert((Object)item22);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertSame((Object)item21, list.get(0));
        MiscTest.assertSame((Object)item22, list.get(1));
    }

    public void testWorkingMemoryLoggerWithUnbalancedBranches() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Logger.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession wm = ruleBase.newStatefulSession();
        try {
            WorkingMemoryFileLogger logger = new WorkingMemoryFileLogger((WorkingMemoryEventManager)wm);
            logger.setFileName("testLogger");
            wm.fireAllRules();
            wm.insert((Object)new Cheese("a", 10));
            wm.insert((Object)new Cheese("b", 11));
            wm.fireAllRules();
        }
        catch (Exception e) {
            e.printStackTrace();
            MiscTest.fail((String)"No exception should be raised ");
        }
    }

    public void testFromNestedAccessors() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FromNestedAccessors.drl")));
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(builder.getPackage());
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Order order1 = new Order(11, "Bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        order1.addItem(item11);
        order1.addItem(item12);
        workingMemory.insert((Object)order1);
        workingMemory.insert((Object)item11);
        workingMemory.insert((Object)item12);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
        MiscTest.assertSame((Object)order1.getStatus(), list.get(0));
    }

    public void testSubNetworks() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_SubNetworks.drl")));
        RuleBase ruleBase = this.getRuleBase();
        try {
            ruleBase.addPackage(builder.getPackage());
        }
        catch (Exception e) {
            e.printStackTrace();
            MiscTest.fail((String)"Should not raise any exception!");
        }
    }

    public void testFinalClass() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FinalClass.drl")));
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(builder.getPackage());
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        PersonFinal bob = new PersonFinal();
        bob.setName("bob");
        bob.setStatus(null);
        workingMemory.insert((Object)bob);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)1, (int)list.size());
    }

    public void testEvalRewriteMatches() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EvalRewriteMatches.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Order order1 = new Order(14, "Mark");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        order1.addItem(item11);
        order1.addItem(item12);
        workingMemory.insert((Object)order1);
        workingMemory.insert((Object)item11);
        workingMemory.insert((Object)item12);
        workingMemory.fireAllRules();
        MiscTest.assertEquals((int)2, (int)list.size());
        MiscTest.assertTrue((boolean)list.contains(item11));
        MiscTest.assertTrue((boolean)list.contains(item12));
    }

    public static class CustomConsequenceExceptionHandler
    implements ConsequenceExceptionHandler {
        private boolean called;

        public void handleException(Activation activation, WorkingMemory workingMemory, Exception exception) {
            this.called = true;
        }

        public boolean isCalled() {
            return this.called;
        }
    }
}

