/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.builder.dialect.java.JavaDialectConfiguration;

public class PackageBuilderThreadSafetyTest
extends TestCase {
    private static final int _NUMBER_OF_THREADS = 100;
    private static final int _SLEEP_TIME_MS = 100;

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testDummy() {
    }

    public void testThreadSafetyEclipse() {
        this.execute(0);
    }

    public void testThreadSafetyJanino() {
        this.execute(1);
    }

    public void execute(int compiler) {
        int i;
        final PackageBuilderConfiguration packageBuilderConfig = new PackageBuilderConfiguration();
        ((JavaDialectConfiguration)packageBuilderConfig.getDialectConfiguration("java")).setCompiler(compiler);
        final ArrayList errors = new ArrayList();
        final ArrayList exceptions = new ArrayList();
        Thread[] threads = new Thread[100];
        for (i = 0; i < 100; ++i) {
            Thread testThread;
            final int ID = i;
            threads[i] = testThread = new Thread(){

                public void run() {
                    try {
                        this.setName("Thread[" + ID + "]");
                        PackageBuilder builder = null;
                        try {
                            builder = new PackageBuilder(packageBuilderConfig);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            throw new RuntimeException(t);
                        }
                        PackageDescr packageDescr = new PackageDescr("MyRulebase");
                        PackageBuilderThreadSafetyTest.addImports(packageDescr);
                        PackageBuilderThreadSafetyTest.addFunctions(packageDescr);
                        1.sleep(100L);
                        builder.addPackage(packageDescr);
                        1.sleep(100L);
                        builder.getPackage();
                        1.sleep(100L);
                        if (builder.hasErrors()) {
                            System.out.println("ERROR in thread: " + ID);
                            System.out.println(builder.getErrors().toString());
                            errors.add(builder.getErrors());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        exceptions.add(e);
                    }
                }
            };
            try {
                testThread.start();
                continue;
            }
            catch (Exception e) {
                PackageBuilderThreadSafetyTest.assertTrue((boolean)false);
            }
        }
        for (i = 0; i < 100; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                threads[i].interrupt();
            }
        }
        PackageBuilderThreadSafetyTest.assertTrue((String)("Exceptions during package compilation (number=" + exceptions.size() + ")"), (boolean)exceptions.isEmpty());
        PackageBuilderThreadSafetyTest.assertTrue((String)("PackageBuilderErrors during package compilation (number=" + errors.size() + ")"), (boolean)errors.isEmpty());
    }

    private static void addImports(PackageDescr packageDescr) {
        packageDescr.addImport(new ImportDescr("java.util.List"));
        packageDescr.addImport(new ImportDescr("java.util.ArrayList"));
        packageDescr.addImport(new ImportDescr("java.util.LinkedList"));
        packageDescr.addImport(new ImportDescr("java.util.Set"));
        packageDescr.addImport(new ImportDescr("java.util.HashSet"));
        packageDescr.addImport(new ImportDescr("java.util.SortedSet"));
        packageDescr.addImport(new ImportDescr("java.util.TreeSet"));
    }

    private static void addFunctions(PackageDescr packageDescr) {
        FunctionDescr functionDescr = new FunctionDescr("foo", "void");
        functionDescr.addParameter("String", "arg1");
        String body = "Set myHashSet = new HashSet();myHashSet.add(arg1);List myArrayList = new ArrayList();myArrayList.add(arg1);List myLinkedList = new LinkedList();myLinkedList.add(arg1);Set myTreeSet = new TreeSet();myTreeSet.add(arg1);";
        functionDescr.setText(body);
        packageDescr.addFunction(functionDescr);
    }
}

