/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.FactHandle;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.PackageBuilder;
import org.drools.concurrent.Future;
import org.drools.rule.Package;

public class StatefulSessionTest
extends TestCase {
    final List list = new ArrayList();

    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    public void testSingleObjectAssert() throws Exception {
        StatefulSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        Future futureAssert = session.asyncInsert((Object)stilton);
        Future futureFireAllRules = session.asyncFireAllRules();
        int i = 0;
        while (!futureFireAllRules.isDone()) {
            Thread.sleep(100L);
            if (i++ <= 5) continue;
            StatefulSessionTest.fail((String)"Future should have finished by now");
        }
        StatefulSessionTest.assertTrue((boolean)(futureAssert.getObject() instanceof FactHandle));
        StatefulSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testArrayObjectAssert() throws Exception {
        StatefulSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        Future futureAssert = session.asyncInsert(new Object[]{stilton});
        Future futureFireAllRules = session.asyncFireAllRules();
        int i = 0;
        while (!futureFireAllRules.isDone()) {
            Thread.sleep(100L);
            if (i++ <= 5) continue;
            StatefulSessionTest.fail((String)"Future should have finished by now");
        }
        StatefulSessionTest.assertTrue((boolean)(futureAssert.getObject() instanceof List));
        StatefulSessionTest.assertTrue((boolean)(((List)futureAssert.getObject()).get(0) instanceof FactHandle));
        StatefulSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testCollectionObjectAssert() throws Exception {
        StatefulSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        ArrayList<Cheese> collection = new ArrayList<Cheese>();
        collection.add(stilton);
        Future futureAssert = session.asyncInsert(collection);
        Future futureFireAllRules = session.asyncFireAllRules();
        int i = 0;
        while (!futureFireAllRules.isDone()) {
            Thread.sleep(100L);
            if (i++ <= 5) continue;
            StatefulSessionTest.fail((String)"Future should have finished by now");
        }
        StatefulSessionTest.assertTrue((boolean)(futureAssert.getObject() instanceof List));
        StatefulSessionTest.assertTrue((boolean)(((List)futureAssert.getObject()).get(0) instanceof FactHandle));
        StatefulSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testHasExceptionSingleAssert() throws Exception {
        StatefulSession session = this.getExceptionSession();
        Cheese brie = new Cheese("brie", 12);
        Future futureAssert = session.asyncInsert((Object)brie);
        Future futureFireAllRules = session.asyncFireAllRules();
        int i = 0;
        while (!futureFireAllRules.isDone()) {
            Thread.sleep(100L);
            if (i++ <= 5) continue;
            StatefulSessionTest.fail((String)"Future should have finished by now");
        }
        StatefulSessionTest.assertTrue((boolean)(futureAssert.getObject() instanceof FactHandle));
        StatefulSessionTest.assertTrue((boolean)futureFireAllRules.exceptionThrown());
        StatefulSessionTest.assertTrue((boolean)(futureFireAllRules.getException() instanceof Exception));
    }

    public void testHasExceptionArrayAssert() throws Exception {
        StatefulSession session = this.getExceptionSession();
        Cheese brie = new Cheese("brie", 12);
        Future futureAssert = session.asyncInsert(new Object[]{brie});
        Future futureFireAllRules = session.asyncFireAllRules();
        int i = 0;
        while (!futureFireAllRules.isDone()) {
            Thread.sleep(100L);
            if (i++ <= 5) continue;
            StatefulSessionTest.fail((String)"Future should have finished by now");
        }
        StatefulSessionTest.assertTrue((boolean)(futureAssert.getObject() instanceof List));
        StatefulSessionTest.assertTrue((boolean)(((List)futureAssert.getObject()).get(0) instanceof FactHandle));
        StatefulSessionTest.assertTrue((boolean)(futureFireAllRules.getException() instanceof Exception));
    }

    public void testHasExceptionCollectionAssert() throws Exception {
        StatefulSession session = this.getExceptionSession();
        Cheese brie = new Cheese("brie", 12);
        ArrayList<Cheese> collection = new ArrayList<Cheese>();
        collection.add(brie);
        Future futureAssert = session.asyncInsert(collection);
        Future futureFireAllRules = session.asyncFireAllRules();
        int i = 0;
        while (!futureFireAllRules.isDone()) {
            Thread.sleep(100L);
            if (i++ <= 5) continue;
            StatefulSessionTest.fail((String)"Future should have finished by now");
        }
        StatefulSessionTest.assertTrue((boolean)(futureAssert.getObject() instanceof List));
        StatefulSessionTest.assertTrue((boolean)(((List)futureAssert.getObject()).get(0) instanceof FactHandle));
        StatefulSessionTest.assertTrue((boolean)(futureFireAllRules.getException() instanceof Exception));
    }

    public void testSequentialException() {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        config.setSequential(true);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)config);
        try {
            ruleBase.newStatefulSession();
            StatefulSessionTest.fail((String)"cannot have a stateful session with sequential set to true");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private StatefulSession getExceptionSession() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ConsequenceException.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        return ruleBase.newStatefulSession();
    }

    private StatefulSession getSession() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("literal_rule_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("list", (Object)this.list);
        return session;
    }
}

