/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.Cheesery;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.CopyIdentifiersGlobalExporter;
import org.drools.base.MapGlobalResolver;
import org.drools.base.ReferenceOriginalGlobalExporter;
import org.drools.compiler.PackageBuilder;
import org.drools.rule.Package;
import org.drools.spi.GlobalExporter;
import org.drools.spi.GlobalResolver;

public class StatelessSessionTest
extends TestCase {
    final List list = new ArrayList();
    final Cheesery cheesery = new Cheesery();
    final GlobalResolver globalResolver = new MapGlobalResolver();

    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    public void testSingleObjectAssert() throws Exception {
        StatelessSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        session.execute((Object)stilton);
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testArrayObjectAssert() throws Exception {
        StatelessSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        session.execute(new Object[]{stilton});
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testCollectionObjectAssert() throws Exception {
        StatelessSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        ArrayList<Cheese> collection = new ArrayList<Cheese>();
        collection.add(stilton);
        session.execute(collection);
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testSingleObjectAssertWithResults() throws Exception {
        StatelessSession session = this.getSession();
        session.setGlobalExporter((GlobalExporter)new CopyIdentifiersGlobalExporter(new String[]{"list"}));
        Cheese stilton = new Cheese("stilton", 5);
        StatelessSessionResult result = session.executeWithResults((Object)stilton);
        StatelessSessionTest.assertSame((Object)stilton, result.iterateObjects().next());
        StatelessSessionTest.assertEquals((Object)"stilton", ((List)result.getGlobal("list")).get(0));
        StatelessSessionTest.assertNull((Object)result.getGlobal("cheesery"));
    }

    public void testArrayObjectAssertWithResults() throws Exception {
        StatelessSession session = this.getSession();
        session.setGlobalExporter((GlobalExporter)new CopyIdentifiersGlobalExporter(new String[]{"list"}));
        Cheese stilton = new Cheese("stilton", 5);
        StatelessSessionResult result = session.executeWithResults(new Object[]{stilton});
        StatelessSessionTest.assertSame((Object)stilton, result.iterateObjects().next());
        StatelessSessionTest.assertEquals((Object)"stilton", ((List)result.getGlobal("list")).get(0));
        StatelessSessionTest.assertNull((Object)result.getGlobal("cheesery"));
    }

    public void testCollectionObjectAssertWithResults() throws Exception {
        StatelessSession session = this.getSession();
        session.setGlobalExporter((GlobalExporter)new CopyIdentifiersGlobalExporter(new String[]{"list"}));
        Cheese stilton = new Cheese("stilton", 5);
        ArrayList<Cheese> collection = new ArrayList<Cheese>();
        collection.add(stilton);
        StatelessSessionResult result = session.executeWithResults(collection);
        StatelessSessionTest.assertSame((Object)stilton, result.iterateObjects().next());
        StatelessSessionTest.assertEquals((Object)"stilton", ((List)result.getGlobal("list")).get(0));
        StatelessSessionTest.assertNull((Object)result.getGlobal("cheesery"));
    }

    public void testAsynSingleOjbectcAssert() throws Exception {
        StatelessSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        session.asyncExecute((Object)stilton);
        Thread.sleep(100L);
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testAsynArrayOjbectcAssert() throws Exception {
        StatelessSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        session.asyncExecute(new Object[]{stilton});
        Thread.sleep(100L);
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testAsynCollectionOjbectcAssert() throws Exception {
        StatelessSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        ArrayList<Cheese> collection = new ArrayList<Cheese>();
        collection.add(stilton);
        session.execute(collection);
        Thread.sleep(100L);
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testCopyIdentifierGlobalExporterOneValue() throws Exception {
        StatelessSession session = this.getSession();
        session.setGlobalExporter((GlobalExporter)new CopyIdentifiersGlobalExporter(new String[]{"list"}));
        StatelessSessionResult result = session.executeWithResults((Object)null);
        StatelessSessionTest.assertSame((Object)this.list, (Object)result.getGlobal("list"));
        StatelessSessionTest.assertNull((Object)result.getGlobal("cheesery"));
        StatelessSessionTest.assertNotSame((Object)this.globalResolver, (Object)result.getGlobalResolver());
    }

    public void testCopyIdentifierGlobalExporterTwoValues() throws Exception {
        StatelessSession session = this.getSession();
        session.setGlobalExporter((GlobalExporter)new CopyIdentifiersGlobalExporter(new String[]{"list", "cheesery"}));
        StatelessSessionResult result = session.executeWithResults((Object)null);
        StatelessSessionTest.assertSame((Object)this.list, (Object)result.getGlobal("list"));
        StatelessSessionTest.assertSame((Object)this.cheesery, (Object)result.getGlobal("cheesery"));
        StatelessSessionTest.assertNotSame((Object)this.globalResolver, (Object)result.getGlobalResolver());
    }

    public void testCopyIdentifierGlobalExporterAllValues() throws Exception {
        StatelessSession session = this.getSession();
        session.setGlobalExporter((GlobalExporter)new CopyIdentifiersGlobalExporter());
        StatelessSessionResult result = session.executeWithResults((Object)null);
        StatelessSessionTest.assertSame((Object)this.list, (Object)result.getGlobal("list"));
        StatelessSessionTest.assertSame((Object)this.cheesery, (Object)result.getGlobal("cheesery"));
        StatelessSessionTest.assertNotSame((Object)this.globalResolver, (Object)result.getGlobalResolver());
    }

    public void testReferenceOriginalGlobalExporter() throws Exception {
        StatelessSession session = this.getSession();
        session.setGlobalExporter((GlobalExporter)new ReferenceOriginalGlobalExporter());
        StatelessSessionResult result = session.executeWithResults((Object)null);
        StatelessSessionTest.assertSame((Object)this.list, (Object)result.getGlobal("list"));
        StatelessSessionTest.assertSame((Object)this.cheesery, (Object)result.getGlobal("cheesery"));
        StatelessSessionTest.assertSame((Object)this.globalResolver, (Object)result.getGlobalResolver());
    }

    private StatelessSession getSession() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("literal_rule_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatelessSession session = ruleBase.newStatelessSession();
        session.setGlobalResolver(this.globalResolver);
        session.setGlobal("list", (Object)this.list);
        session.setGlobal("cheesery", (Object)this.cheesery);
        return session;
    }
}

