/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests.sequential;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Properties;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatelessSession;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.rule.Package;

public class SequentialTest
extends TestCase {
    public void testBasicOperation() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("simpleSequential.drl")));
        Package pkg = builder.getPackage();
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setSequential(true);
        RuleBase ruleBase = this.getRuleBase(conf);
        ruleBase.addPackage(pkg);
        StatelessSession session = ruleBase.newStatelessSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person p1 = new Person("p1", "stilton");
        Person p2 = new Person("p2", "cheddar");
        Person p3 = new Person("p3", "stilton");
        Cheese stilton = new Cheese("stilton", 15);
        Cheese cheddar = new Cheese("cheddar", 15);
        session.execute(new Object[]{p1, stilton, p2, cheddar, p3});
        SequentialTest.assertEquals((int)3, (int)list.size());
    }

    public void XXtestProfileSequential() throws Exception {
        this.runTestProfileManyRulesAndFacts(true, "Sequential mode", 0, "sequentialProfile.drl");
        this.runTestProfileManyRulesAndFacts(true, "Sequential mode", 0, "sequentialProfile.drl");
        System.gc();
        Thread.sleep(100L);
    }

    public void XXtestProfileRETE() throws Exception {
        this.runTestProfileManyRulesAndFacts(false, "Normal RETE mode", 0, "sequentialProfile.drl");
        this.runTestProfileManyRulesAndFacts(false, "Normal RETE mode", 0, "sequentialProfile.drl");
        System.gc();
        Thread.sleep(100L);
    }

    public void testNumberofIterationsSeq() throws Exception {
        this.runTestProfileManyRulesAndFacts(true, "SEQUENTIAL", 2000, "sequentialProfile.drl");
    }

    public void testNumberofIterationsRETE() throws Exception {
        this.runTestProfileManyRulesAndFacts(false, "RETE", 2000, "sequentialProfile.drl");
    }

    public void XXtestPerfJDT() throws Exception {
        this.runTestProfileManyRulesAndFacts(true, "JDT", 2000, "sequentialProfile.drl");
    }

    public void XXtestPerfMVEL() throws Exception {
        this.runTestProfileManyRulesAndFacts(true, "MVEL", 2000, "sequentialProfileMVEL.drl");
    }

    private void runTestProfileManyRulesAndFacts(boolean sequentialMode, String message, int timetoMeasureIterations, String file) throws DroolsParserException, IOException, Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(file)));
        Package pkg = builder.getPackage();
        Properties properties = new Properties();
        properties.setProperty("drools.shadowProxyExcludes", "org.drools.*");
        RuleBaseConfiguration conf = new RuleBaseConfiguration(properties);
        conf.setSequential(sequentialMode);
        RuleBase ruleBase = this.getRuleBase(conf);
        ruleBase.addPackage(pkg);
        StatelessSession session = ruleBase.newStatelessSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Object[] data = new Object[50000];
        for (int i = 0; i < data.length; ++i) {
            if (i % 2 == 0) {
                Person p = new Person("p" + i, "stilton");
                data[i] = p;
                continue;
            }
            data[i] = new Cheese("cheddar", i);
        }
        if (timetoMeasureIterations == 0) {
            long start = System.currentTimeMillis();
            session.execute(data);
            System.out.println("Time for " + message + ":" + (System.currentTimeMillis() - start));
            SequentialTest.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        } else {
            long start = System.currentTimeMillis();
            long end = start + (long)timetoMeasureIterations;
            int count = 0;
            while (System.currentTimeMillis() < end) {
                StatelessSession sess2 = ruleBase.newStatelessSession();
                ArrayList list2 = new ArrayList();
                sess2.setGlobal("list", list2);
                sess2.execute(data);
                ++count;
            }
            System.out.println("Iterations in for " + message + " : " + count);
        }
    }

    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }
}

