/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import junit.framework.TestCase;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.lang.DRLLexer;
import org.drools.lang.DRLParser;
import org.drools.lang.MVELDumper;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.PatternDescr;

public class MVELDumperTest
extends TestCase {
    private MVELDumper dumper;

    protected void setUp() throws Exception {
        super.setUp();
        this.dumper = new MVELDumper();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void xxxtestDump() throws Exception {
        String input = "Cheese( price > 10 && < 20 || == $val || == 30 )";
        String expected = "( ( price > 10 && price < 20 ) || price == $val || price == 30 )";
        DRLParser parser = this.parse(input);
        PatternDescr pattern = (PatternDescr)parser.fact(null);
        FieldConstraintDescr fieldDescr = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        String result = this.dumper.dump(fieldDescr);
        MVELDumperTest.assertEquals((String)expected, (String)result);
    }

    public void testDumpMatches() throws Exception {
        String input = "Cheese( type.toString matches \"something\\swith\\tsingle escapes\" )";
        String expected = "type.toString ~= \"something\\\\swith\\\\tsingle escapes\"";
        DRLParser parser = this.parse(input);
        PatternDescr pattern = (PatternDescr)parser.fact(null);
        FieldConstraintDescr fieldDescr = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        String result = this.dumper.dump(fieldDescr);
        MVELDumperTest.assertEquals((String)expected, (String)result);
    }

    public void testDumpMatches2() throws Exception {
        String input = "Cheese( type.toString matches 'something\\swith\\tsingle escapes' )";
        String expected = "type.toString ~= \"something\\\\swith\\\\tsingle escapes\"";
        DRLParser parser = this.parse(input);
        PatternDescr pattern = (PatternDescr)parser.fact(null);
        FieldConstraintDescr fieldDescr = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        String result = this.dumper.dump(fieldDescr);
        MVELDumperTest.assertEquals((String)expected, (String)result);
    }

    private DRLParser parse(String text) throws Exception {
        return this.newParser(this.newTokenStream((Lexer)this.newLexer(this.newCharStream(text))));
    }

    private CharStream newCharStream(String text) {
        return new ANTLRStringStream(text);
    }

    private DRLLexer newLexer(CharStream charStream) {
        return new DRLLexer(charStream);
    }

    private TokenStream newTokenStream(Lexer lexer) {
        return new CommonTokenStream((TokenSource)lexer);
    }

    private DRLParser newParser(TokenStream tokenStream) {
        DRLParser p = new DRLParser(tokenStream);
        return p;
    }
}

