/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.compiler.DrlParser;
import org.drools.lang.DRLLexer;
import org.drools.lang.DRLParser;
import org.drools.lang.descr.AccessorDescr;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FactTemplateDescr;
import org.drools.lang.descr.FieldAccessDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.FieldTemplateDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QualifiedIdentifierRestrictionDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.VariableRestrictionDescr;
import org.drools.lang.dsl.DefaultExpander;

public class RuleParserTest
extends TestCase {
    private DRLParser parser;

    protected void setUp() throws Exception {
        super.setUp();
        this.parser = null;
    }

    protected void tearDown() throws Exception {
        this.parser = null;
        super.tearDown();
    }

    public void testPackage_OneSegment() throws Exception {
        String packageName = this.parse("package foo").package_statement();
        RuleParserTest.assertEquals((String)"foo", (String)packageName);
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testPackage_MultipleSegments() throws Exception {
        String packageName = this.parse("package foo.bar.baz;").package_statement();
        RuleParserTest.assertEquals((String)"foo.bar.baz", (String)packageName);
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testEmptyPackage() throws Exception {
        String source = "package foo.bar.baz";
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse((Reader)new StringReader("package foo.bar.baz"));
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
        RuleParserTest.assertEquals((String)"foo.bar.baz", (String)pkg.getName());
    }

    public void testCompilationUnit() throws Exception {
        String source = "package foo; import com.foo.Bar; import com.foo.Baz;";
        this.parse("package foo; import com.foo.Bar; import com.foo.Baz;").compilation_unit();
        RuleParserTest.assertEquals((String)"foo", (String)this.parser.getPackageDescr().getName());
        RuleParserTest.assertEquals((int)2, (int)this.parser.getPackageDescr().getImports().size());
        ImportDescr impdescr = (ImportDescr)this.parser.getPackageDescr().getImports().get(0);
        RuleParserTest.assertEquals((String)"com.foo.Bar", (String)impdescr.getTarget());
        RuleParserTest.assertEquals((int)"package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()), (int)impdescr.getStartCharacter());
        RuleParserTest.assertEquals((int)("package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length() - 1), (int)impdescr.getEndCharacter());
        impdescr = (ImportDescr)this.parser.getPackageDescr().getImports().get(1);
        RuleParserTest.assertEquals((String)"com.foo.Baz", (String)impdescr.getTarget());
        RuleParserTest.assertEquals((int)"package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()), (int)impdescr.getStartCharacter());
        RuleParserTest.assertEquals((int)("package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length() - 1), (int)impdescr.getEndCharacter());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testEmptyRule() throws Exception {
        RuleDescr rule = this.parseResource("empty_rule.drl").rule();
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"empty", (String)rule.getName());
        RuleParserTest.assertNull((Object)rule.getLhs());
        RuleParserTest.assertNotNull((Object)rule.getConsequence());
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
    }

    public void testKeywordCollisions() throws Exception {
        DRLParser parser = this.parseResource("eol_funny_business.drl");
        parser.compilation_unit();
        PackageDescr pkg = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleParserTest.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
    }

    public void testPartialAST() throws Exception {
        this.parseResource("pattern_partial.drl");
        this.parser.compilation_unit();
        RuleParserTest.assertTrue((boolean)this.parser.hasErrors());
        PackageDescr pkg = this.parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertNotNull((Object)pattern);
        RuleParserTest.assertEquals((String)"Bar", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((String)"foo3", (String)pattern.getIdentifier());
    }

    public void testTemplates() throws Exception {
        DRLParser parser = this.parseResource("test_Templates.drl");
        parser.compilation_unit();
        PackageDescr pkg = parser.getPackageDescr();
        if (parser.hasErrors()) {
            System.err.println("FACT TEMPLATES FAILED: " + parser.getErrorMessages());
        }
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleParserTest.assertEquals((int)2, (int)pkg.getFactTemplates().size());
        FactTemplateDescr fact1 = (FactTemplateDescr)pkg.getFactTemplates().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)fact1.getName());
        RuleParserTest.assertEquals((int)2, (int)fact1.getFields().size());
        RuleParserTest.assertEquals((String)"name", (String)((FieldTemplateDescr)fact1.getFields().get(0)).getName());
        RuleParserTest.assertEquals((String)"String", (String)((FieldTemplateDescr)fact1.getFields().get(0)).getClassType());
        RuleParserTest.assertEquals((String)"age", (String)((FieldTemplateDescr)fact1.getFields().get(1)).getName());
        RuleParserTest.assertEquals((String)"Integer", (String)((FieldTemplateDescr)fact1.getFields().get(1)).getClassType());
        fact1 = null;
        FactTemplateDescr fact2 = (FactTemplateDescr)pkg.getFactTemplates().get(1);
        RuleParserTest.assertEquals((String)"Wine", (String)fact2.getName());
        RuleParserTest.assertEquals((int)3, (int)fact2.getFields().size());
        RuleParserTest.assertEquals((String)"name", (String)((FieldTemplateDescr)fact2.getFields().get(0)).getName());
        RuleParserTest.assertEquals((String)"String", (String)((FieldTemplateDescr)fact2.getFields().get(0)).getClassType());
        RuleParserTest.assertEquals((String)"year", (String)((FieldTemplateDescr)fact2.getFields().get(1)).getName());
        RuleParserTest.assertEquals((String)"String", (String)((FieldTemplateDescr)fact2.getFields().get(1)).getClassType());
        RuleParserTest.assertEquals((String)"accolades", (String)((FieldTemplateDescr)fact2.getFields().get(2)).getName());
        RuleParserTest.assertEquals((String)"String[]", (String)((FieldTemplateDescr)fact2.getFields().get(2)).getClassType());
    }

    public void testTernaryExpression() throws Exception {
        DRLParser parser = this.parseResource("ternary_expression.drl");
        parser.compilation_unit();
        PackageDescr pkg = parser.getPackageDescr();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
        this.assertEqualsIgnoreWhitespace("if (speed > speedLimit ? true : false;) pullEmOver();", (String)rule.getConsequence());
    }

    public void FIXME_testLatinChars() throws Exception {
        DrlParser parser = new DrlParser();
        InputStreamReader drl = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("latin-sample.dslr"));
        InputStreamReader dsl = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("latin.dsl"));
        PackageDescr pkg = parser.parse((Reader)drl, (Reader)dsl);
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
        RuleParserTest.assertEquals((String)"br.com.auster.drools.sample", (String)pkg.getName());
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
    }

    public void testFunctionWithArrays() throws Exception {
        DRLParser parser = this.parseResource("function_arrays.drl");
        parser.compilation_unit();
        PackageDescr pkg = parser.getPackageDescr();
        if (parser.hasErrors()) {
            System.err.println(parser.getErrorMessages());
        }
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
        RuleParserTest.assertEquals((String)"foo", (String)pkg.getName());
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        this.assertEqualsIgnoreWhitespace("yourFunction(new String[3] {\"a\",\"b\",\"c\"});", (String)rule.getConsequence());
        FunctionDescr func = (FunctionDescr)pkg.getFunctions().get(0);
        RuleParserTest.assertEquals((String)"String[]", (String)func.getReturnType());
        RuleParserTest.assertEquals((Object)"args[]", func.getParameterNames().get(0));
        RuleParserTest.assertEquals((Object)"String", func.getParameterTypes().get(0));
    }

    public void testAlmostEmptyRule() throws Exception {
        RuleDescr rule = this.parseResource("almost_empty_rule.drl").rule();
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"almost_empty", (String)rule.getName());
        RuleParserTest.assertNotNull((Object)rule.getLhs());
        RuleParserTest.assertEquals((String)"", (String)((String)rule.getConsequence()).trim());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testQuotedStringNameRule() throws Exception {
        RuleDescr rule = this.parseResource("quoted_string_name_rule.drl").rule();
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"quoted string name", (String)rule.getName());
        RuleParserTest.assertNotNull((Object)rule.getLhs());
        RuleParserTest.assertEquals((String)"", (String)((String)rule.getConsequence()).trim());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testNoLoop() throws Exception {
        RuleDescr rule = this.parseResource("no-loop.drl").rule();
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"rule1", (String)rule.getName());
        AttributeDescr att = (AttributeDescr)rule.getAttributes().get(0);
        RuleParserTest.assertEquals((String)"false", (String)att.getValue());
        RuleParserTest.assertEquals((String)"no-loop", (String)att.getName());
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
    }

    public void testAutofocus() throws Exception {
        RuleDescr rule = this.parseResource("autofocus.drl").rule();
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"rule1", (String)rule.getName());
        AttributeDescr att = (AttributeDescr)rule.getAttributes().get(0);
        RuleParserTest.assertEquals((String)"true", (String)att.getValue());
        RuleParserTest.assertEquals((String)"auto-focus", (String)att.getName());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testRuleFlowGroup() throws Exception {
        RuleDescr rule = this.parseResource("ruleflowgroup.drl").rule();
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"rule1", (String)rule.getName());
        AttributeDescr att = (AttributeDescr)rule.getAttributes().get(0);
        RuleParserTest.assertEquals((String)"a group", (String)att.getValue());
        RuleParserTest.assertEquals((String)"ruleflow-group", (String)att.getName());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testConsequenceWithDeclaration() throws Exception {
        RuleDescr rule = this.parseResource("declaration-in-consequence.drl").rule();
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"myrule", (String)rule.getName());
        String expected = "int i = 0; i = 1; i / 1; i == 1; i(i); i = 'i'; i.i.i; i\\i; i<i; i>i; i=\"i\";  ++i;i++; --i; i--; i += i; i -= i; i *= i; i /= i;int i = 5;for(int j; j<i; ++j) {System.out.println(j);}Object o = new String(\"Hello\");String s = (String) o;";
        this.assertEqualsIgnoreWhitespace("int i = 0; i = 1; i / 1; i == 1; i(i); i = 'i'; i.i.i; i\\i; i<i; i>i; i=\"i\";  ++i;i++; --i; i--; i += i; i -= i; i *= i; i /= i;int i = 5;for(int j; j<i; ++j) {System.out.println(j);}Object o = new String(\"Hello\");String s = (String) o;", (String)rule.getConsequence());
        RuleParserTest.assertTrue((((String)rule.getConsequence()).indexOf("++") > 0 ? 1 : 0) != 0);
        RuleParserTest.assertTrue((((String)rule.getConsequence()).indexOf("--") > 0 ? 1 : 0) != 0);
        RuleParserTest.assertTrue((((String)rule.getConsequence()).indexOf("+=") > 0 ? 1 : 0) != 0);
        RuleParserTest.assertTrue((((String)rule.getConsequence()).indexOf("==") > 0 ? 1 : 0) != 0);
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testRuleParseLhs() throws Exception {
        String text = "Person(age < 42, location==\"atlanta\") \nor\nPerson(name==\"bob\") \n";
        AndDescr descrs = new AndDescr();
        ANTLRStringStream charStream = new ANTLRStringStream("Person(age < 42, location==\"atlanta\") \nor\nPerson(name==\"bob\") \n");
        DRLLexer lexer = new DRLLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        DRLParser parser = new DRLParser((TokenStream)tokenStream);
        parser.setLineOffset(descrs.getLine());
        parser.normal_lhs_block(descrs);
        if (parser.hasErrors()) {
            System.err.println(parser.getErrorMessages());
        }
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testLiteralBoolAndNegativeNumbersRule() throws Exception {
        DRLParser parser = this.parseResource("literal_bool_and_negative.drl");
        RuleDescr rule = parser.rule();
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertNotNull((Object)rule.getLhs());
        this.assertEqualsIgnoreWhitespace("cons();", (String)rule.getConsequence());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertEquals((int)3, (int)lhs.getDescrs().size());
        PatternDescr pattern = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        AndDescr fieldAnd = (AndDescr)pattern.getConstraint();
        FieldConstraintDescr fld = (FieldConstraintDescr)fieldAnd.getDescrs().get(0);
        LiteralRestrictionDescr lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"==", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"false", (String)lit.getText());
        RuleParserTest.assertEquals((String)"bar", (String)fld.getFieldName());
        pattern = (PatternDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        fieldAnd = (AndDescr)pattern.getConstraint();
        fld = (FieldConstraintDescr)fieldAnd.getDescrs().get(0);
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)">", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"-42", (String)lit.getText());
        RuleParserTest.assertEquals((String)"boo", (String)fld.getFieldName());
        pattern = (PatternDescr)lhs.getDescrs().get(2);
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        fieldAnd = (AndDescr)pattern.getConstraint();
        fld = (FieldConstraintDescr)fieldAnd.getDescrs().get(0);
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)">", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"-42.42", (String)lit.getText());
        RuleParserTest.assertEquals((String)"boo", (String)fld.getFieldName());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testChunkWithoutParens() throws Exception {
        String input = "( foo )";
        DRLParser.paren_chunk_return ret = this.parse(input).paren_chunk();
        String chunk = input.substring(((CommonToken)ret.start).getStartIndex(), ((CommonToken)ret.stop).getStopIndex() + 1);
        RuleParserTest.assertEquals((String)"( foo )", (String)chunk);
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testChunkWithParens() throws Exception {
        String input = "(fnord())";
        DRLParser.paren_chunk_return ret = this.parse(input).paren_chunk();
        String chunk = input.substring(((CommonToken)ret.start).getStartIndex(), ((CommonToken)ret.stop).getStopIndex() + 1);
        this.assertEqualsIgnoreWhitespace("(fnord())", chunk);
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testChunkWithParensAndQuotedString() throws Exception {
        String input = "( fnord( \"cheese\" ) )";
        DRLParser.paren_chunk_return ret = this.parse(input).paren_chunk();
        String chunk = input.substring(((CommonToken)ret.start).getStartIndex(), ((CommonToken)ret.stop).getStopIndex() + 1);
        this.assertEqualsIgnoreWhitespace("( fnord( \"cheese\" ) )", chunk);
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testChunkWithRandomCharac5ters() throws Exception {
        String input = "( %*9dkj)";
        DRLParser.paren_chunk_return ret = this.parse(input).paren_chunk();
        String chunk = input.substring(((CommonToken)ret.start).getStartIndex(), ((CommonToken)ret.stop).getStopIndex() + 1);
        this.assertEqualsIgnoreWhitespace("( %*9dkj)", chunk);
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testEmptyPattern() throws Exception {
        this.parseResource("test_EmptyPattern.drl");
        this.parser.compilation_unit();
        PackageDescr packageDescr = this.parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)packageDescr.getRules().size());
        RuleDescr ruleDescr = (RuleDescr)packageDescr.getRules().get(0);
        RuleParserTest.assertEquals((String)"simple rule", (String)ruleDescr.getName());
        RuleParserTest.assertNotNull((Object)ruleDescr.getLhs());
        RuleParserTest.assertEquals((int)1, (int)ruleDescr.getLhs().getDescrs().size());
        PatternDescr patternDescr = (PatternDescr)ruleDescr.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)0, (int)patternDescr.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"Cheese", (String)patternDescr.getObjectType());
    }

    public void testSimpleMethodCallWithFrom() throws Exception {
        RuleDescr rule = this.parseResource("test_SimpleMethodCallWithFrom.drl").rule();
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        AccessorDescr method = (AccessorDescr)from.getDataSource();
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertEquals((String)"something.doIt( foo,bar,42,\"hello\",{ a => \"b\", \"something\" => 42, \"a\" => foo, x => {x=>y}},\"end\", [a, \"b\", 42] )", (String)method.toString());
    }

    public void testSimpleFunctionCallWithFrom() throws Exception {
        RuleDescr rule = this.parseResource("test_SimpleFunctionCallWithFrom.drl").rule();
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        AccessorDescr func = (AccessorDescr)from.getDataSource();
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertEquals((String)"doIt( foo,bar,42,\"hello\",{ a => \"b\", \"something\" => 42, \"a\" => foo, x => {x=>y}},\"end\", [a, \"b\", 42] )", (String)func.toString());
    }

    public void testSimpleAccessorWithFrom() throws Exception {
        RuleDescr rule = this.parseResource("test_SimpleAccessorWithFrom.drl").rule();
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        AccessorDescr accessor = (AccessorDescr)from.getDataSource();
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNull((Object)((FieldAccessDescr)accessor.getInvokers().get(0)).getArgument());
        RuleParserTest.assertEquals((String)"something.doIt", (String)accessor.toString());
    }

    public void testSimpleAccessorAndArgWithFrom() throws Exception {
        RuleDescr rule = this.parseResource("test_SimpleAccessorArgWithFrom.drl").rule();
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        AccessorDescr accessor = (AccessorDescr)from.getDataSource();
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)((FieldAccessDescr)accessor.getInvokers().get(0)).getArgument());
        RuleParserTest.assertEquals((String)"something.doIt[\"key\"]", (String)accessor.toString());
    }

    public void testComplexChainedAcessor() throws Exception {
        RuleDescr rule = this.parseResource("test_ComplexChainedCallWithFrom.drl").rule();
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        AccessorDescr accessor = (AccessorDescr)from.getDataSource();
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertEquals((String)"doIt1( foo,bar,42,\"hello\",{ a => \"b\"}, [a, \"b\", 42] ).doIt2(bar, [a, \"b\", 42]).field[\"key\"]", (String)accessor.toString());
    }

    public void testSimpleRule() throws Exception {
        RuleDescr rule = this.parseResource("simple_rule.drl").rule();
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)7, (int)rule.getConsequenceLine());
        RuleParserTest.assertEquals((int)2, (int)rule.getConsequencePattern());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)3, (int)lhs.getDescrs().size());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"foo3", (String)first.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)first.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)first.getConstraint().getDescrs().size());
        AndDescr fieldAnd = (AndDescr)first.getConstraint();
        FieldConstraintDescr fld = (FieldConstraintDescr)fieldAnd.getDescrs().get(0);
        LiteralRestrictionDescr constraint = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertNotNull((Object)constraint);
        RuleParserTest.assertEquals((String)"a", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)constraint.getEvaluator());
        RuleParserTest.assertEquals((String)"3", (String)constraint.getText());
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"foo4", (String)second.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)second.getObjectType());
        fieldAnd = (AndDescr)second.getConstraint();
        RuleParserTest.assertEquals((int)2, (int)fieldAnd.getDescrs().size());
        FieldBindingDescr fieldBindingDescr = (FieldBindingDescr)fieldAnd.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"a", (String)fieldBindingDescr.getFieldName());
        RuleParserTest.assertEquals((String)"a4", (String)fieldBindingDescr.getIdentifier());
        fld = (FieldConstraintDescr)fieldAnd.getDescrs().get(1);
        constraint = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertNotNull((Object)constraint);
        RuleParserTest.assertEquals((String)"a", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)constraint.getEvaluator());
        RuleParserTest.assertEquals((String)"4", (String)constraint.getText());
        PatternDescr third = (PatternDescr)lhs.getDescrs().get(2);
        RuleParserTest.assertNull((Object)third.getIdentifier());
        RuleParserTest.assertEquals((String)"Baz", (String)third.getObjectType());
        this.assertEqualsIgnoreWhitespace("if ( a == b ) {   assert( foo3 );} else {  retract( foo4 );}  System.out.println( a4 );", (String)rule.getConsequence());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testRestrictionsMultiple() throws Exception {
        RuleDescr rule = this.parseResource("restrictions_test.drl").rule();
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        this.assertEqualsIgnoreWhitespace("consequence();", (String)rule.getConsequence());
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)pattern.getConstraint();
        FieldConstraintDescr fld = (FieldConstraintDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((int)0, (int)fld.getRestriction().getConnective());
        RuleParserTest.assertEquals((int)2, (int)fld.getRestrictions().size());
        RuleParserTest.assertEquals((String)"age", (String)fld.getFieldName());
        LiteralRestrictionDescr lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)">", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"30", (String)lit.getText());
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(1);
        RuleParserTest.assertEquals((String)"<", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"40", (String)lit.getText());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Vehicle", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)pattern.getConstraint().getDescrs().size());
        and = (AndDescr)pattern.getConstraint();
        fld = (FieldConstraintDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"type", (String)fld.getFieldName());
        RuleParserTest.assertEquals((int)1, (int)fld.getRestrictions().size());
        RestrictionConnectiveDescr or = (RestrictionConnectiveDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((int)1, (int)or.getConnective());
        RuleParserTest.assertEquals((int)2, (int)or.getRestrictions().size());
        lit = (LiteralRestrictionDescr)or.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"==", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"sedan", (String)lit.getText());
        lit = (LiteralRestrictionDescr)or.getRestrictions().get(1);
        RuleParserTest.assertEquals((String)"==", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"wagon", (String)lit.getText());
        fld = (FieldConstraintDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)fld.getRestrictions().size());
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"<", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"3", (String)lit.getText());
    }

    public void testLineNumberInAST() throws Exception {
        RuleDescr rule = this.parseResource("simple_rule.drl").rule();
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)7, (int)rule.getConsequenceLine());
        RuleParserTest.assertEquals((int)2, (int)rule.getConsequencePattern());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)3, (int)lhs.getDescrs().size());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"foo3", (String)first.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)first.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)first.getConstraint().getDescrs().size());
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"foo4", (String)second.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)second.getObjectType());
        PatternDescr third = (PatternDescr)lhs.getDescrs().get(2);
        RuleParserTest.assertEquals((String)"Baz", (String)third.getObjectType());
        RuleParserTest.assertEquals((int)4, (int)first.getLine());
        RuleParserTest.assertEquals((int)5, (int)second.getLine());
        RuleParserTest.assertEquals((int)6, (int)third.getLine());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testLineNumberIncludingCommentsInRHS() throws Exception {
        this.parseResource("test_CommentLineNumbersInConsequence.drl").compilation_unit();
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
        String rhs = (String)((RuleDescr)this.parser.getPackageDescr().getRules().get(0)).getConsequence();
        String expected = "  \t//woot\n  \tfirst\n  \t\n  \t//\n  \t\n  \t/* lala\n  \t\n  \t*/\n  \tsecond  \n";
        RuleParserTest.assertEquals((String)expected, (String)rhs);
    }

    public void testLhsSemicolonDelim() throws Exception {
        RuleDescr rule = this.parseResource("lhs_semicolon_delim.drl").rule();
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)3, (int)lhs.getDescrs().size());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"foo3", (String)first.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)first.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)first.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)first.getConstraint();
        FieldConstraintDescr fld = (FieldConstraintDescr)and.getDescrs().get(0);
        LiteralRestrictionDescr constraint = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertNotNull((Object)constraint);
        RuleParserTest.assertEquals((String)"a", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)constraint.getEvaluator());
        RuleParserTest.assertEquals((String)"3", (String)constraint.getText());
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"foo4", (String)second.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)second.getObjectType());
        and = (AndDescr)second.getConstraint();
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        FieldBindingDescr fieldBindingDescr = (FieldBindingDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"a", (String)fieldBindingDescr.getFieldName());
        RuleParserTest.assertEquals((String)"a4", (String)fieldBindingDescr.getIdentifier());
        fld = (FieldConstraintDescr)and.getDescrs().get(1);
        constraint = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertNotNull((Object)constraint);
        RuleParserTest.assertEquals((String)"a", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)constraint.getEvaluator());
        RuleParserTest.assertEquals((String)"4", (String)constraint.getText());
        PatternDescr third = (PatternDescr)lhs.getDescrs().get(2);
        RuleParserTest.assertNull((Object)third.getIdentifier());
        RuleParserTest.assertEquals((String)"Baz", (String)third.getObjectType());
        this.assertEqualsIgnoreWhitespace("if ( a == b ) {   assert( foo3 );} else {  retract( foo4 );}  System.out.println( a4 );", (String)rule.getConsequence());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testNotNode() throws Exception {
        RuleDescr rule = this.parseResource("rule_not.drl").rule();
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        NotDescr not = (NotDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)not.getDescrs().size());
        PatternDescr pattern = (PatternDescr)not.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)pattern.getConstraint();
        FieldConstraintDescr fld = (FieldConstraintDescr)and.getDescrs().get(0);
        LiteralRestrictionDescr lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"==", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"stilton", (String)lit.getText());
        RuleParserTest.assertEquals((String)"type", (String)fld.getFieldName());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testFunctionImport() throws Exception {
        DRLParser parser = this.parseResource("test_FunctionImport.drl");
        parser.compilation_unit();
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
        PackageDescr pkg = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)2, (int)pkg.getFunctionImports().size());
        RuleParserTest.assertEquals((String)"abd.def.x", (String)((FunctionImportDescr)pkg.getFunctionImports().get(0)).getTarget());
        RuleParserTest.assertFalse((((FunctionImportDescr)pkg.getFunctionImports().get(0)).getStartCharacter() == -1 ? 1 : 0) != 0);
        RuleParserTest.assertFalse((((FunctionImportDescr)pkg.getFunctionImports().get(0)).getEndCharacter() == -1 ? 1 : 0) != 0);
        RuleParserTest.assertEquals((String)"qed.wah.*", (String)((FunctionImportDescr)pkg.getFunctionImports().get(1)).getTarget());
        RuleParserTest.assertFalse((((FunctionImportDescr)pkg.getFunctionImports().get(1)).getStartCharacter() == -1 ? 1 : 0) != 0);
        RuleParserTest.assertFalse((((FunctionImportDescr)pkg.getFunctionImports().get(1)).getEndCharacter() == -1 ? 1 : 0) != 0);
    }

    public void testNotExistWithBrackets() throws Exception {
        DRLParser parser = this.parseResource("not_exist_with_brackets.drl");
        parser.compilation_unit();
        PackageDescr pkg = parser.getPackageDescr();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertEquals((int)2, (int)lhs.getDescrs().size());
        NotDescr not = (NotDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)not.getDescrs().size());
        PatternDescr pattern = (PatternDescr)not.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)pattern.getObjectType());
        ExistsDescr ex = (ExistsDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)ex.getDescrs().size());
        PatternDescr exPattern = (PatternDescr)ex.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Foo", (String)exPattern.getObjectType());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testNotBindindShouldBarf() throws Exception {
        DRLParser parser = this.parseResource("not_with_binding_error.drl");
        parser.compilation_unit();
        RuleParserTest.assertTrue((boolean)parser.hasErrors());
    }

    public void testSimpleQuery() throws Exception {
        QueryDescr query = this.parseResource("simple_query.drl").query();
        RuleParserTest.assertNotNull((Object)query);
        RuleParserTest.assertEquals((String)"simple_query", (String)query.getName());
        AndDescr lhs = query.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)3, (int)lhs.getDescrs().size());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"foo3", (String)first.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)first.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)first.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)first.getConstraint();
        FieldConstraintDescr fld = (FieldConstraintDescr)and.getDescrs().get(0);
        LiteralRestrictionDescr constraint = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertNotNull((Object)constraint);
        RuleParserTest.assertEquals((String)"a", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)constraint.getEvaluator());
        RuleParserTest.assertEquals((String)"3", (String)constraint.getText());
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"foo4", (String)second.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)second.getObjectType());
        and = (AndDescr)second.getConstraint();
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        FieldBindingDescr fieldBindingDescr = (FieldBindingDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"a", (String)fieldBindingDescr.getFieldName());
        RuleParserTest.assertEquals((String)"a4", (String)fieldBindingDescr.getIdentifier());
        fld = (FieldConstraintDescr)and.getDescrs().get(1);
        constraint = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertNotNull((Object)constraint);
        RuleParserTest.assertEquals((String)"a", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)constraint.getEvaluator());
        RuleParserTest.assertEquals((String)"4", (String)constraint.getText());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testQueryRuleMixed() throws Exception {
        DRLParser parser = this.parseResource("query_and_rule.drl");
        parser.compilation_unit();
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)4, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((String)"bar", (String)rule.getName());
        QueryDescr query = (QueryDescr)pack.getRules().get(1);
        RuleParserTest.assertEquals((String)"simple_query", (String)query.getName());
        rule = (RuleDescr)pack.getRules().get(2);
        RuleParserTest.assertEquals((String)"bar2", (String)rule.getName());
        query = (QueryDescr)pack.getRules().get(3);
        RuleParserTest.assertEquals((String)"simple_query2", (String)query.getName());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testMultipleRules() throws Exception {
        DRLParser parser = this.parseResource("multiple_rules.drl");
        parser.compilation_unit();
        PackageDescr pkg = parser.getPackageDescr();
        List rules = pkg.getRules();
        RuleParserTest.assertEquals((int)2, (int)rules.size());
        RuleDescr rule0 = (RuleDescr)rules.get(0);
        RuleParserTest.assertEquals((String)"Like Stilton", (String)rule0.getName());
        RuleDescr rule1 = (RuleDescr)rules.get(1);
        RuleParserTest.assertEquals((String)"Like Cheddar", (String)rule1.getName());
        AndDescr lhs = rule1.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        this.assertEqualsIgnoreWhitespace("System.out.println(\"I like \" + t);", (String)rule0.getConsequence());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)first.getObjectType());
        lhs = rule1.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        this.assertEqualsIgnoreWhitespace("System.out.println(\"I like \" + t);", (String)rule1.getConsequence());
        first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)first.getObjectType());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testExpanderErrorsAfterExpansion() throws Exception {
        String name = "expander_post_errors.dslr";
        DefaultExpander expander = new DefaultExpander();
        String expanded = expander.expand(this.getReader("expander_post_errors.dslr"));
        DRLParser parser = this.parse("expander_post_errors.dslr", expanded);
        parser.compilation_unit();
        RuleParserTest.assertTrue((boolean)parser.hasErrors());
        RecognitionException err = (RecognitionException)parser.getErrors().get(0);
        RuleParserTest.assertEquals((int)1, (int)parser.getErrors().size());
        RuleParserTest.assertEquals((int)5, (int)err.line);
    }

    public void testExpanderLineSpread() throws Exception {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(this.getReader("expander_spread_lines.dslr"), this.getReader("complex.dsl"));
        RuleParserTest.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        RuleParserTest.assertNotNull((Object)((String)rule.getConsequence()));
    }

    public void testExpanderMultipleConstraints() throws Exception {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(this.getReader("expander_multiple_constraints.dslr"), this.getReader("multiple_constraints.dsl"));
        RuleParserTest.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)pattern.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"age", (String)((FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0)).getFieldName());
        RuleParserTest.assertEquals((String)"location", (String)((FieldConstraintDescr)pattern.getConstraint().getDescrs().get(1)).getFieldName());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Bar", (String)pattern.getObjectType());
        RuleParserTest.assertNotNull((Object)((String)rule.getConsequence()));
    }

    public void testExpanderMultipleConstraintsFlush() throws Exception {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(this.getReader("expander_multiple_constraints_flush.dslr"), this.getReader("multiple_constraints.dsl"));
        RuleParserTest.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)pattern.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"age", (String)((FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0)).getFieldName());
        RuleParserTest.assertEquals((String)"location", (String)((FieldConstraintDescr)pattern.getConstraint().getDescrs().get(1)).getFieldName());
        RuleParserTest.assertNotNull((Object)((String)rule.getConsequence()));
    }

    public void testBasicBinding() throws Exception {
        DRLParser parser = this.parseResource("basic_binding.drl");
        parser.compilation_unit();
        PackageDescr pkg = parser.getPackageDescr();
        RuleDescr ruleDescr = (RuleDescr)pkg.getRules().get(0);
        AndDescr lhs = ruleDescr.getLhs();
        RuleParserTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        PatternDescr cheese = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)cheese.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        FieldBindingDescr fieldBinding = (FieldBindingDescr)cheese.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"type", (String)fieldBinding.getFieldName());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testBoundVariables() throws Exception {
        DRLParser parser = this.parseResource("bindings.drl");
        parser.compilation_unit();
        PackageDescr pkg = parser.getPackageDescr();
        RuleDescr ruleDescr = (RuleDescr)pkg.getRules().get(0);
        AndDescr lhs = ruleDescr.getLhs();
        RuleParserTest.assertEquals((int)2, (int)lhs.getDescrs().size());
        PatternDescr cheese = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)lhs.getDescrs().size());
        FieldBindingDescr fieldBinding = (FieldBindingDescr)cheese.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"type", (String)fieldBinding.getFieldName());
        FieldConstraintDescr fld = (FieldConstraintDescr)cheese.getConstraint().getDescrs().get(1);
        LiteralRestrictionDescr literalDescr = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"type", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)literalDescr.getEvaluator());
        RuleParserTest.assertEquals((String)"stilton", (String)literalDescr.getText());
        PatternDescr person = (PatternDescr)lhs.getDescrs().get(1);
        fieldBinding = (FieldBindingDescr)person.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"name", (String)fieldBinding.getFieldName());
        fld = (FieldConstraintDescr)person.getConstraint().getDescrs().get(1);
        literalDescr = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"name", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)literalDescr.getEvaluator());
        RuleParserTest.assertEquals((String)"bob", (String)literalDescr.getText());
        fld = (FieldConstraintDescr)person.getConstraint().getDescrs().get(2);
        VariableRestrictionDescr variableDescr = (VariableRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"likes", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)variableDescr.getEvaluator());
        RuleParserTest.assertEquals((String)"$type", (String)variableDescr.getIdentifier());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testOrNesting() throws Exception {
        DRLParser parser = this.parseResource("or_nesting.drl");
        parser.compilation_unit();
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertNotNull((Object)pack);
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        PatternDescr first = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)first.getObjectType());
        AndDescr and = (AndDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        PatternDescr left = (PatternDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)left.getObjectType());
        PatternDescr right = (PatternDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Cheese", (String)right.getObjectType());
    }

    public void testAndOrRules() throws Exception {
        DRLParser parser = this.parseResource("and_or_rule.drl");
        parser.compilation_unit();
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertNotNull((Object)pack);
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        AndDescr and = rule.getLhs();
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        AndDescr join = (AndDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)join.getDescrs().size());
        PatternDescr left = (PatternDescr)join.getDescrs().get(0);
        PatternDescr right = (PatternDescr)join.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Person", (String)left.getObjectType());
        RuleParserTest.assertEquals((String)"Cheese", (String)right.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)left.getConstraint().getDescrs().size());
        FieldConstraintDescr fld = (FieldConstraintDescr)left.getConstraint().getDescrs().get(0);
        LiteralRestrictionDescr literal = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"==", (String)literal.getEvaluator());
        RuleParserTest.assertEquals((String)"name", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"mark", (String)literal.getText());
        RuleParserTest.assertEquals((int)1, (int)right.getConstraint().getDescrs().size());
        fld = (FieldConstraintDescr)right.getConstraint().getDescrs().get(0);
        literal = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"==", (String)literal.getEvaluator());
        RuleParserTest.assertEquals((String)"type", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"stilton", (String)literal.getText());
        OrDescr or = (OrDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        left = (PatternDescr)or.getDescrs().get(0);
        right = (PatternDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Person", (String)left.getObjectType());
        RuleParserTest.assertEquals((String)"Cheese", (String)right.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)left.getConstraint().getDescrs().size());
        fld = (FieldConstraintDescr)left.getConstraint().getDescrs().get(0);
        literal = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"==", (String)literal.getEvaluator());
        RuleParserTest.assertEquals((String)"name", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"mark", (String)literal.getText());
        RuleParserTest.assertEquals((int)1, (int)right.getConstraint().getDescrs().size());
        fld = (FieldConstraintDescr)right.getConstraint().getDescrs().get(0);
        literal = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"==", (String)literal.getEvaluator());
        RuleParserTest.assertEquals((String)"type", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"stilton", (String)literal.getText());
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" );", (String)rule.getConsequence());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testOrWithBinding() throws Exception {
        DRLParser parser = this.parseResource("or_binding.drl");
        parser.compilation_unit();
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        PatternDescr leftPattern = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)leftPattern.getObjectType());
        RuleParserTest.assertEquals((String)"foo", (String)leftPattern.getIdentifier());
        PatternDescr rightPattern = (PatternDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Person", (String)rightPattern.getObjectType());
        RuleParserTest.assertEquals((String)"foo", (String)rightPattern.getIdentifier());
        PatternDescr cheeseDescr = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheeseDescr.getObjectType());
        RuleParserTest.assertEquals(null, (String)cheeseDescr.getIdentifier());
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" + bar );", (String)rule.getConsequence());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testOrBindingComplex() throws Exception {
        DRLParser parser = this.parseResource("or_binding_complex.drl");
        parser.compilation_unit();
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        PatternDescr firstFact = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)firstFact.getObjectType());
        RuleParserTest.assertEquals((String)"foo", (String)firstFact.getIdentifier());
        PatternDescr secondFact = (PatternDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Person", (String)secondFact.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)secondFact.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"foo", (String)secondFact.getIdentifier());
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" + bar );", (String)rule.getConsequence());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testOrBindingWithBrackets() throws Exception {
        DRLParser parser = this.parseResource("or_binding_with_brackets.drl");
        parser.compilation_unit();
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        PatternDescr firstFact = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)firstFact.getObjectType());
        RuleParserTest.assertEquals((String)"foo", (String)firstFact.getIdentifier());
        PatternDescr secondFact = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)secondFact.getObjectType());
        RuleParserTest.assertEquals((String)"foo", (String)secondFact.getIdentifier());
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" + bar );", (String)rule.getConsequence());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testBracketsPrecedence() throws Exception {
        DRLParser parser = this.parseResource("brackets_precedence.drl");
        parser.compilation_unit();
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        AndDescr rootAnd = (AndDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)rootAnd.getDescrs().size());
        OrDescr leftOr = (OrDescr)rootAnd.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)leftOr.getDescrs().size());
        NotDescr not = (NotDescr)leftOr.getDescrs().get(0);
        PatternDescr foo1 = (PatternDescr)not.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Foo", (String)foo1.getObjectType());
        PatternDescr foo2 = (PatternDescr)leftOr.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Foo", (String)foo2.getObjectType());
        OrDescr rightOr = (OrDescr)rootAnd.getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)rightOr.getDescrs().size());
        PatternDescr shoes = (PatternDescr)rightOr.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Shoes", (String)shoes.getObjectType());
        PatternDescr butt = (PatternDescr)rightOr.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Butt", (String)butt.getObjectType());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testEvalMultiple() throws Exception {
        DRLParser parser = this.parseResource("eval_multiple.drl");
        parser.compilation_unit();
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)4, (int)rule.getLhs().getDescrs().size());
        EvalDescr eval = (EvalDescr)rule.getLhs().getDescrs().get(0);
        this.assertEqualsIgnoreWhitespace("abc(\"foo\") + 5", (String)eval.getContent());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Foo", (String)pattern.getObjectType());
    }

    public void testWithEval() throws Exception {
        DRLParser parser = this.parseResource("with_eval.drl");
        parser.compilation_unit();
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)3, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Foo", (String)pattern.getObjectType());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Bar", (String)pattern.getObjectType());
        EvalDescr eval = (EvalDescr)rule.getLhs().getDescrs().get(2);
        this.assertEqualsIgnoreWhitespace("abc(\"foo\")", (String)eval.getContent());
        this.assertEqualsIgnoreWhitespace("Kapow", (String)rule.getConsequence());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testWithRetval() throws Exception {
        DRLParser parser = this.parseResource("with_retval.drl");
        parser.compilation_unit();
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)col.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"Foo", (String)col.getObjectType());
        FieldConstraintDescr fld = (FieldConstraintDescr)col.getConstraint().getDescrs().get(0);
        ReturnValueRestrictionDescr retval = (ReturnValueRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((Object)"a + b", (Object)retval.getContent());
        RuleParserTest.assertEquals((String)"name", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)retval.getEvaluator());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testWithPredicate() throws Exception {
        DRLParser parser = this.parseResource("with_predicate.drl");
        parser.compilation_unit();
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AndDescr and = (AndDescr)col.getConstraint();
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        FieldBindingDescr field = (FieldBindingDescr)and.getDescrs().get(0);
        PredicateDescr pred = (PredicateDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"age", (String)field.getFieldName());
        RuleParserTest.assertEquals((String)"$age2", (String)field.getIdentifier());
        this.assertEqualsIgnoreWhitespace("$age2 == $age1+2", (String)pred.getContent());
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
    }

    public void testNotWithConstraint() throws Exception {
        DRLParser parser = this.parseResource("not_with_constraint.drl");
        parser.compilation_unit();
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FieldBindingDescr fieldBinding = (FieldBindingDescr)pattern.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"$likes", (String)fieldBinding.getIdentifier());
        NotDescr not = (NotDescr)rule.getLhs().getDescrs().get(1);
        pattern = (PatternDescr)not.getDescrs().get(0);
        FieldConstraintDescr fld = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        VariableRestrictionDescr boundVariable = (VariableRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"type", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)boundVariable.getEvaluator());
        RuleParserTest.assertEquals((String)"$likes", (String)boundVariable.getIdentifier());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testGlobal() throws Exception {
        DRLParser parser = this.parseResource("globals.drl");
        parser.compilation_unit();
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        RuleParserTest.assertEquals((int)1, (int)pack.getImports().size());
        RuleParserTest.assertEquals((int)2, (int)pack.getGlobals().size());
        GlobalDescr foo = (GlobalDescr)pack.getGlobals().get(0);
        RuleParserTest.assertEquals((String)"java.lang.String", (String)foo.getType());
        RuleParserTest.assertEquals((String)"foo", (String)foo.getIdentifier());
        GlobalDescr bar = (GlobalDescr)pack.getGlobals().get(1);
        RuleParserTest.assertEquals((String)"java.lang.Integer", (String)bar.getType());
        RuleParserTest.assertEquals((String)"bar", (String)bar.getIdentifier());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testFunctions() throws Exception {
        DRLParser parser = this.parseResource("functions.drl");
        parser.compilation_unit();
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)2, (int)pack.getRules().size());
        List functions = pack.getFunctions();
        RuleParserTest.assertEquals((int)2, (int)functions.size());
        FunctionDescr func = (FunctionDescr)functions.get(0);
        RuleParserTest.assertEquals((String)"functionA", (String)func.getName());
        RuleParserTest.assertEquals((String)"String", (String)func.getReturnType());
        RuleParserTest.assertEquals((int)2, (int)func.getParameterNames().size());
        RuleParserTest.assertEquals((int)2, (int)func.getParameterTypes().size());
        RuleParserTest.assertEquals((int)4, (int)func.getLine());
        RuleParserTest.assertEquals((int)0, (int)func.getColumn());
        RuleParserTest.assertEquals((Object)"String", func.getParameterTypes().get(0));
        RuleParserTest.assertEquals((Object)"s", func.getParameterNames().get(0));
        RuleParserTest.assertEquals((Object)"Integer", func.getParameterTypes().get(1));
        RuleParserTest.assertEquals((Object)"i", func.getParameterNames().get(1));
        this.assertEqualsIgnoreWhitespace("foo();", func.getText());
        func = (FunctionDescr)functions.get(1);
        RuleParserTest.assertEquals((String)"functionB", (String)func.getName());
        this.assertEqualsIgnoreWhitespace("bar();", func.getText());
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
    }

    public void testComment() throws Exception {
        DRLParser parser = this.parseResource("comment.drl");
        parser.compilation_unit();
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertNotNull((Object)pack);
        RuleParserTest.assertEquals((String)"foo.bar", (String)pack.getName());
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
    }

    public void testAttributes() throws Exception {
        RuleDescr rule = this.parseResource("rule_attributes.drl").rule();
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        List attrs = rule.getAttributes();
        RuleParserTest.assertEquals((int)6, (int)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get(0);
        RuleParserTest.assertEquals((String)"salience", (String)at.getName());
        RuleParserTest.assertEquals((String)"42", (String)at.getValue());
        at = (AttributeDescr)attrs.get(1);
        RuleParserTest.assertEquals((String)"agenda-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"my_group", (String)at.getValue());
        at = (AttributeDescr)attrs.get(2);
        RuleParserTest.assertEquals((String)"no-loop", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
        at = (AttributeDescr)attrs.get(3);
        RuleParserTest.assertEquals((String)"duration", (String)at.getName());
        RuleParserTest.assertEquals((String)"42", (String)at.getValue());
        at = (AttributeDescr)attrs.get(4);
        RuleParserTest.assertEquals((String)"activation-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"my_activation_group", (String)at.getValue());
        at = (AttributeDescr)attrs.get(5);
        RuleParserTest.assertEquals((String)"lock-on-active", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testAttributes_alternateSyntax() throws Exception {
        RuleDescr rule = this.parseResource("rule_attributes_alt.drl").rule();
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        List attrs = rule.getAttributes();
        RuleParserTest.assertEquals((int)6, (int)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get(0);
        RuleParserTest.assertEquals((String)"salience", (String)at.getName());
        RuleParserTest.assertEquals((String)"42", (String)at.getValue());
        at = (AttributeDescr)attrs.get(1);
        RuleParserTest.assertEquals((String)"agenda-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"my_group", (String)at.getValue());
        at = (AttributeDescr)attrs.get(2);
        RuleParserTest.assertEquals((String)"no-loop", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
        at = (AttributeDescr)attrs.get(3);
        RuleParserTest.assertEquals((String)"lock-on-active", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
        at = (AttributeDescr)attrs.get(4);
        RuleParserTest.assertEquals((String)"duration", (String)at.getName());
        RuleParserTest.assertEquals((String)"42", (String)at.getValue());
        at = (AttributeDescr)attrs.get(5);
        RuleParserTest.assertEquals((String)"activation-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"my_activation_group", (String)at.getValue());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testEnumeration() throws Exception {
        RuleDescr rule = this.parseResource("enumeration.drl").rule();
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Foo", (String)col.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)col.getConstraint().getDescrs().size());
        FieldConstraintDescr fld = (FieldConstraintDescr)col.getConstraint().getDescrs().get(0);
        QualifiedIdentifierRestrictionDescr lit = (QualifiedIdentifierRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"bar", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"Foo.BAR", (String)lit.getText());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testInvalidSyntax_Catches() throws Exception {
        this.parseResource("invalid_syntax.drl").compilation_unit();
        RuleParserTest.assertTrue((boolean)this.parser.hasErrors());
    }

    public void testMultipleErrors() throws Exception {
        this.parseResource("multiple_errors.drl").compilation_unit();
        RuleParserTest.assertTrue((boolean)this.parser.hasErrors());
        RuleParserTest.assertEquals((int)2, (int)this.parser.getErrors().size());
    }

    public void testExtraLhsNewline() throws Exception {
        this.parseResource("extra_lhs_newline.drl").compilation_unit();
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testPackageGarbage() throws Exception {
        this.parseResource("package_garbage.drl").compilation_unit();
        RuleParserTest.assertTrue((boolean)this.parser.hasErrors());
    }

    public void testSoundsLike() throws Exception {
        this.parseResource("soundslike_operator.drl").compilation_unit();
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)this.parser.getPackageDescr().getRules().get(0);
        PatternDescr pat = (PatternDescr)rule.getLhs().getDescrs().get(0);
        pat.getConstraint();
    }

    public void testPackageAttributes() throws Exception {
        this.parseResource("package_attributes.drl").compilation_unit();
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
        PackageDescr pkg = this.parser.getPackageDescr();
        AttributeDescr at = (AttributeDescr)pkg.getAttributes().get(0);
        RuleParserTest.assertEquals((String)"agenda-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"x", (String)at.getValue());
        at = (AttributeDescr)pkg.getAttributes().get(1);
        RuleParserTest.assertEquals((String)"dialect", (String)at.getName());
        RuleParserTest.assertEquals((String)"java", (String)at.getValue());
        RuleParserTest.assertEquals((int)2, (int)pkg.getRules().size());
        RuleParserTest.assertEquals((int)2, (int)pkg.getImports().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"bar", (String)rule.getName());
        at = (AttributeDescr)rule.getAttributes().get(0);
        RuleParserTest.assertEquals((String)"agenda-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"x", (String)at.getValue());
        at = (AttributeDescr)rule.getAttributes().get(1);
        RuleParserTest.assertEquals((String)"dialect", (String)at.getName());
        RuleParserTest.assertEquals((String)"java", (String)at.getValue());
        rule = (RuleDescr)pkg.getRules().get(1);
        RuleParserTest.assertEquals((String)"baz", (String)rule.getName());
        at = (AttributeDescr)rule.getAttributes().get(0);
        RuleParserTest.assertEquals((String)"dialect", (String)at.getName());
        RuleParserTest.assertEquals((String)"mvel", (String)at.getValue());
        at = (AttributeDescr)rule.getAttributes().get(1);
        RuleParserTest.assertEquals((String)"agenda-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"x", (String)at.getValue());
    }

    public void testStatementOrdering1() throws Exception {
        this.parseResource("statement_ordering_1.drl");
        this.parser.compilation_unit();
        PackageDescr pkg = this.parser.getPackageDescr();
        RuleParserTest.assertEquals((int)2, (int)pkg.getRules().size());
        RuleParserTest.assertEquals((String)"foo", (String)((RuleDescr)pkg.getRules().get(0)).getName());
        RuleParserTest.assertEquals((String)"bar", (String)((RuleDescr)pkg.getRules().get(1)).getName());
        RuleParserTest.assertEquals((int)2, (int)pkg.getFunctions().size());
        RuleParserTest.assertEquals((String)"cheeseIt", (String)((FunctionDescr)pkg.getFunctions().get(0)).getName());
        RuleParserTest.assertEquals((String)"uncheeseIt", (String)((FunctionDescr)pkg.getFunctions().get(1)).getName());
        RuleParserTest.assertEquals((int)4, (int)pkg.getImports().size());
        RuleParserTest.assertEquals((String)"im.one", (String)((ImportDescr)pkg.getImports().get(0)).getTarget());
        RuleParserTest.assertEquals((String)"im.two", (String)((ImportDescr)pkg.getImports().get(1)).getTarget());
        RuleParserTest.assertEquals((String)"im.three", (String)((ImportDescr)pkg.getImports().get(2)).getTarget());
        RuleParserTest.assertEquals((String)"im.four", (String)((ImportDescr)pkg.getImports().get(3)).getTarget());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testRuleNamesStartingWithNumbers() throws Exception {
        this.parseResource("rule_names_number_prefix.drl").compilation_unit();
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        PackageDescr pkg = this.parser.getPackageDescr();
        RuleParserTest.assertEquals((int)2, (int)pkg.getRules().size());
        RuleParserTest.assertEquals((String)"1. Do Stuff!", (String)((RuleDescr)pkg.getRules().get(0)).getName());
        RuleParserTest.assertEquals((String)"2. Do More Stuff!", (String)((RuleDescr)pkg.getRules().get(1)).getName());
    }

    public void testEvalWithNewline() throws Exception {
        this.parseResource("eval_with_newline.drl").compilation_unit();
        if (this.parser.hasErrors()) {
            System.err.println(this.parser.getErrorMessages());
        }
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testEvalWithSemicolon() throws Exception {
        this.parseResource("eval_with_semicolon.drl").compilation_unit();
        RuleParserTest.assertTrue((boolean)this.parser.hasErrors());
        RuleParserTest.assertEquals((int)1, (int)this.parser.getErrorMessages().size());
        RuleParserTest.assertTrue((((String)this.parser.getErrorMessages().get(0)).indexOf("Trailing semi-colon not allowed") >= 0 ? 1 : 0) != 0);
    }

    public void testEndPosition() throws Exception {
        this.parseResource("test_EndPosition.drl").compilation_unit();
        RuleDescr rule = (RuleDescr)this.parser.getPackageDescr().getRules().get(0);
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)6, (int)col.getLine());
        RuleParserTest.assertEquals((int)8, (int)col.getEndLine());
    }

    public void testQualifiedClassname() throws Exception {
        this.parseResource("qualified_classname.drl").compilation_unit();
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
        PackageDescr pkg = this.parser.getPackageDescr();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr p = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"com.cheeseco.Cheese", (String)p.getObjectType());
    }

    public void testAccumulate() throws Exception {
        DRLParser parser = this.parseResource("accumulate.drl");
        parser.compilation_unit();
        if (parser.hasErrors()) {
            System.err.println(parser.getErrorMessages());
        }
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)outPattern.getSource();
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        RuleParserTest.assertNull((Object)accum.getReverseCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        RuleParserTest.assertFalse((boolean)accum.isExternalFunction());
        PatternDescr pattern = accum.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
    }

    public void testAccumulateWithBindings() throws Exception {
        DRLParser parser = this.parseResource("accumulate_with_bindings.drl");
        parser.compilation_unit();
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)outPattern.getSource();
        this.assertEqualsIgnoreWhitespace("$counter", outPattern.getIdentifier());
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        PatternDescr pattern = accum.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
    }

    public void testCollect() throws Exception {
        DRLParser parser = this.parseResource("collect.drl");
        parser.compilation_unit();
        if (parser.hasErrors()) {
            System.err.println(parser.getErrorMessages());
        }
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        CollectDescr collect = (CollectDescr)outPattern.getSource();
        PatternDescr pattern = collect.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
    }

    public void testPredicate() throws Exception {
        PatternDescr pattern = new PatternDescr();
        this.parse("$var : attr -> ( $var.equals(\"xyz\") )").constraints(pattern);
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
        List constraints = pattern.getConstraint().getDescrs();
        RuleParserTest.assertEquals((int)2, (int)constraints.size());
        FieldBindingDescr field = (FieldBindingDescr)constraints.get(0);
        PredicateDescr predicate = (PredicateDescr)constraints.get(1);
        RuleParserTest.assertEquals((String)"$var", (String)field.getIdentifier());
        RuleParserTest.assertEquals((String)"attr", (String)field.getFieldName());
        RuleParserTest.assertEquals((Object)" $var.equals(\"xyz\") ", (Object)predicate.getContent());
    }

    public void testPredicate2() throws Exception {
        PatternDescr pattern = new PatternDescr();
        this.parse("eval( $var.equals(\"xyz\") )").constraints(pattern);
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
        List constraints = pattern.getConstraint().getDescrs();
        RuleParserTest.assertEquals((int)1, (int)constraints.size());
        PredicateDescr predicate = (PredicateDescr)constraints.get(0);
        RuleParserTest.assertEquals((Object)" $var.equals(\"xyz\") ", (Object)predicate.getContent());
    }

    public void testEscapedStrings() throws Exception {
        RuleDescr rule = this.parseResource("escaped-string.drl").rule();
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"test_Quotes", (String)rule.getName());
        String expected = "String s = \"\\\"\\n\\t\\\\\";";
        this.assertEqualsIgnoreWhitespace("String s = \"\\\"\\n\\t\\\\\";", (String)rule.getConsequence());
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
    }

    public void testNestedCEs() throws Exception {
        RuleDescr rule = this.parseResource("nested_conditional_elements.drl").rule();
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        AndDescr root = rule.getLhs();
        NotDescr not1 = (NotDescr)root.getDescrs().get(0);
        AndDescr and1 = (AndDescr)not1.getDescrs().get(0);
        PatternDescr state = (PatternDescr)and1.getDescrs().get(0);
        NotDescr not2 = (NotDescr)and1.getDescrs().get(1);
        AndDescr and2 = (AndDescr)not2.getDescrs().get(0);
        PatternDescr person = (PatternDescr)and2.getDescrs().get(0);
        PatternDescr cheese = (PatternDescr)and2.getDescrs().get(1);
        PatternDescr person2 = (PatternDescr)root.getDescrs().get(1);
        OrDescr or = (OrDescr)root.getDescrs().get(2);
        PatternDescr cheese2 = (PatternDescr)or.getDescrs().get(0);
        PatternDescr cheese3 = (PatternDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)state.getObjectType(), (String)"State");
        RuleParserTest.assertEquals((String)person.getObjectType(), (String)"Person");
        RuleParserTest.assertEquals((String)cheese.getObjectType(), (String)"Cheese");
        RuleParserTest.assertEquals((String)person2.getObjectType(), (String)"Person");
        RuleParserTest.assertEquals((String)cheese2.getObjectType(), (String)"Cheese");
        RuleParserTest.assertEquals((String)cheese3.getObjectType(), (String)"Cheese");
    }

    public void testForall() throws Exception {
        DRLParser parser = this.parseResource("forall.drl");
        parser.compilation_unit();
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        ForallDescr forall = (ForallDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)forall.getDescrs().size());
        PatternDescr pattern = forall.getBasePattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        List remaining = forall.getRemainingPatterns();
        RuleParserTest.assertEquals((int)1, (int)remaining.size());
        PatternDescr cheese = (PatternDescr)remaining.get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese.getObjectType());
    }

    public void testMemberof() throws Exception {
        String text = "Country( $cities : city )\nPerson( city memberOf $cities )\n";
        AndDescr descrs = new AndDescr();
        ANTLRStringStream charStream = new ANTLRStringStream("Country( $cities : city )\nPerson( city memberOf $cities )\n");
        DRLLexer lexer = new DRLLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        DRLParser parser = new DRLParser((TokenStream)tokenStream);
        parser.setLineOffset(descrs.getLine());
        parser.normal_lhs_block(descrs);
        if (parser.hasErrors()) {
            System.err.println(parser.getErrorMessages());
        }
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
        RuleParserTest.assertEquals((int)2, (int)descrs.getDescrs().size());
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(1);
        FieldConstraintDescr fieldConstr = (FieldConstraintDescr)pat.getConstraint().getDescrs().get(0);
        VariableRestrictionDescr restr = (VariableRestrictionDescr)fieldConstr.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"memberOf", (String)restr.getEvaluator());
        RuleParserTest.assertEquals((String)"$cities", (String)restr.getIdentifier());
    }

    public void testNotMemberof() throws Exception {
        String text = "Country( $cities : city )\nPerson( city not memberOf $cities )\n";
        AndDescr descrs = new AndDescr();
        ANTLRStringStream charStream = new ANTLRStringStream("Country( $cities : city )\nPerson( city not memberOf $cities )\n");
        DRLLexer lexer = new DRLLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        DRLParser parser = new DRLParser((TokenStream)tokenStream);
        parser.setLineOffset(descrs.getLine());
        parser.normal_lhs_block(descrs);
        if (parser.hasErrors()) {
            System.err.println(parser.getErrorMessages());
        }
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
        RuleParserTest.assertEquals((int)2, (int)descrs.getDescrs().size());
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(1);
        FieldConstraintDescr fieldConstr = (FieldConstraintDescr)pat.getConstraint().getDescrs().get(0);
        VariableRestrictionDescr restr = (VariableRestrictionDescr)fieldConstr.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"not memberOf", (String)restr.getEvaluator());
        RuleParserTest.assertEquals((String)"$cities", (String)restr.getIdentifier());
    }

    public void testInOperator() throws Exception {
        RuleDescr rule = this.parseResource("in_operator_test.drl").rule();
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        this.assertEqualsIgnoreWhitespace("consequence();", (String)rule.getConsequence());
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        FieldConstraintDescr fld = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((int)0, (int)fld.getRestriction().getConnective());
        RuleParserTest.assertEquals((int)2, (int)fld.getRestrictions().size());
        RuleParserTest.assertEquals((String)"age", (String)fld.getFieldName());
        LiteralRestrictionDescr lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)">", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"30", (String)lit.getText());
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(1);
        RuleParserTest.assertEquals((String)"<", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"40", (String)lit.getText());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Vehicle", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)pattern.getConstraint().getDescrs().size());
        fld = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"type", (String)fld.getFieldName());
        RuleParserTest.assertEquals((int)1, (int)fld.getRestrictions().size());
        RestrictionConnectiveDescr or = (RestrictionConnectiveDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((int)1, (int)or.getConnective());
        RuleParserTest.assertEquals((int)2, (int)or.getRestrictions().size());
        lit = (LiteralRestrictionDescr)or.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"==", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"sedan", (String)lit.getText());
        lit = (LiteralRestrictionDescr)or.getRestrictions().get(1);
        RuleParserTest.assertEquals((String)"==", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"wagon", (String)lit.getText());
        fld = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)fld.getRestrictions().size());
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"<", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"3", (String)lit.getText());
    }

    public void testNotInOperator() throws Exception {
        RuleDescr rule = this.parseResource("notin_operator_test.drl").rule();
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        this.assertEqualsIgnoreWhitespace("consequence();", (String)rule.getConsequence());
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        FieldConstraintDescr fld = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)fld.getRestrictions().size());
        RuleParserTest.assertEquals((String)"age", (String)fld.getFieldName());
        LiteralRestrictionDescr lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)">", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"30", (String)lit.getText());
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(1);
        RuleParserTest.assertEquals((String)"<", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"40", (String)lit.getText());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Vehicle", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)pattern.getConstraint().getDescrs().size());
        fld = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)fld.getRestrictions().size());
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"type", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"!=", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"sedan", (String)lit.getText());
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(1);
        RuleParserTest.assertEquals((String)"!=", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"wagon", (String)lit.getText());
        fld = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)fld.getRestrictions().size());
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"<", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"3", (String)lit.getText());
    }

    public void testConstraintAndConnective() throws Exception {
        String text = "Person( age < 42 && location==\"atlanta\")";
        ANTLRStringStream charStream = new ANTLRStringStream("Person( age < 42 && location==\"atlanta\")");
        DRLLexer lexer = new DRLLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        DRLParser parser = new DRLParser((TokenStream)tokenStream);
        PatternDescr pattern = (PatternDescr)parser.fact(null);
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        RuleParserTest.assertEquals((int)2, (int)pattern.getDescrs().size());
        FieldConstraintDescr fcd = (FieldConstraintDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        fcd = (FieldConstraintDescr)pattern.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"location", (String)fcd.getFieldName());
    }

    public void testConstraintOrConnective() throws Exception {
        String text = "Person( age < 42 || location==\"atlanta\")";
        ANTLRStringStream charStream = new ANTLRStringStream("Person( age < 42 || location==\"atlanta\")");
        DRLLexer lexer = new DRLLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        DRLParser parser = new DRLParser((TokenStream)tokenStream);
        PatternDescr pattern = (PatternDescr)parser.fact(null);
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        OrDescr or = (OrDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        FieldConstraintDescr fcd = (FieldConstraintDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        fcd = (FieldConstraintDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"location", (String)fcd.getFieldName());
    }

    public void testConstraintConnectivesPrecedence() throws Exception {
        String text = "Person( age < 42 && location==\"atlanta\" || age > 20 && location==\"Seatle\" || location == \"Chicago\")";
        ANTLRStringStream charStream = new ANTLRStringStream("Person( age < 42 && location==\"atlanta\" || age > 20 && location==\"Seatle\" || location == \"Chicago\")");
        DRLLexer lexer = new DRLLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        DRLParser parser = new DRLParser((TokenStream)tokenStream);
        PatternDescr pattern = (PatternDescr)parser.fact(null);
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        OrDescr or = (OrDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((int)3, (int)or.getDescrs().size());
        AndDescr and = (AndDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        FieldConstraintDescr fcd = (FieldConstraintDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"<", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"42", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"location", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"atlanta", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        and = (AndDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        fcd = (FieldConstraintDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)">", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"20", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"location", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"Seatle", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)or.getDescrs().get(2);
        RuleParserTest.assertEquals((String)"location", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"Chicago", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
    }

    public void testConstraintConnectivesPrecedenceWithBracks() throws Exception {
        String text = "Person( age < 42 && ( location==\"atlanta\" || age > 20 && location==\"Seatle\") || location == \"Chicago\")";
        ANTLRStringStream charStream = new ANTLRStringStream("Person( age < 42 && ( location==\"atlanta\" || age > 20 && location==\"Seatle\") || location == \"Chicago\")");
        DRLLexer lexer = new DRLLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        DRLParser parser = new DRLParser((TokenStream)tokenStream);
        PatternDescr pattern = (PatternDescr)parser.fact(null);
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        OrDescr or1 = (OrDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or1.getDescrs().size());
        AndDescr and1 = (AndDescr)or1.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)and1.getDescrs().size());
        FieldConstraintDescr fcd = (FieldConstraintDescr)and1.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"<", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"42", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        OrDescr or2 = (OrDescr)and1.getDescrs().get(1);
        fcd = (FieldConstraintDescr)or2.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"location", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"atlanta", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        AndDescr and2 = (AndDescr)or2.getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)and2.getDescrs().size());
        fcd = (FieldConstraintDescr)and2.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)">", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"20", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)and2.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"location", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"Seatle", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)or1.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"location", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"Chicago", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
    }

    public void testConstraintConnectivesPrecedenceWithBracks2() throws Exception {
        String text = "Person( ( age == 70 && hair == \"black\" ) || ( age == 40 && hair == \"pink\" ) || ( age == 12 && ( hair == \"yellow\" || hair == \"blue\" ) ) )";
        ANTLRStringStream charStream = new ANTLRStringStream("Person( ( age == 70 && hair == \"black\" ) || ( age == 40 && hair == \"pink\" ) || ( age == 12 && ( hair == \"yellow\" || hair == \"blue\" ) ) )");
        DRLLexer lexer = new DRLLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        DRLParser parser = new DRLParser((TokenStream)tokenStream);
        PatternDescr pattern = (PatternDescr)parser.fact(null);
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        OrDescr or1 = (OrDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((int)3, (int)or1.getDescrs().size());
        AndDescr and1 = (AndDescr)or1.getDescrs().get(0);
        AndDescr and2 = (AndDescr)or1.getDescrs().get(1);
        AndDescr and3 = (AndDescr)or1.getDescrs().get(2);
        RuleParserTest.assertEquals((int)2, (int)and1.getDescrs().size());
        FieldConstraintDescr fcd = (FieldConstraintDescr)and1.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"70", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)and1.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"hair", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"black", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        RuleParserTest.assertEquals((int)2, (int)and2.getDescrs().size());
        fcd = (FieldConstraintDescr)and2.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"40", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)and2.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"hair", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"pink", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        RuleParserTest.assertEquals((int)2, (int)and3.getDescrs().size());
        fcd = (FieldConstraintDescr)and3.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"12", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        OrDescr or2 = (OrDescr)and3.getDescrs().get(1);
        fcd = (FieldConstraintDescr)or2.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"hair", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"yellow", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)or2.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"hair", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"blue", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
    }

    public void testRestrictionConnectives() throws Exception {
        String text = "Person( ( age ( > 60 && < 70 ) || ( > 50 && < 55 ) && hair == \"black\" ) || ( age == 40 && hair == \"pink\" ) || ( age == 12 && ( hair == \"yellow\" || hair == \"blue\" ) ))";
        ANTLRStringStream charStream = new ANTLRStringStream("Person( ( age ( > 60 && < 70 ) || ( > 50 && < 55 ) && hair == \"black\" ) || ( age == 40 && hair == \"pink\" ) || ( age == 12 && ( hair == \"yellow\" || hair == \"blue\" ) ))");
        DRLLexer lexer = new DRLLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        DRLParser parser = new DRLParser((TokenStream)tokenStream);
        PatternDescr pattern = (PatternDescr)parser.fact(null);
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        OrDescr orConstr = (OrDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((int)3, (int)orConstr.getDescrs().size());
        AndDescr andConstr1 = (AndDescr)orConstr.getDescrs().get(0);
        FieldConstraintDescr fcd = (FieldConstraintDescr)andConstr1.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RestrictionConnectiveDescr or = (RestrictionConnectiveDescr)fcd.getRestriction().getRestrictions().get(0);
        RestrictionConnectiveDescr and1 = (RestrictionConnectiveDescr)or.getRestrictions().get(0);
        RestrictionConnectiveDescr and2 = (RestrictionConnectiveDescr)or.getRestrictions().get(1);
        RuleParserTest.assertEquals((String)">", (String)((LiteralRestrictionDescr)and1.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"60", (String)((LiteralRestrictionDescr)and1.getRestrictions().get(0)).getText());
        RuleParserTest.assertEquals((String)"<", (String)((LiteralRestrictionDescr)and1.getRestrictions().get(1)).getEvaluator());
        RuleParserTest.assertEquals((String)"70", (String)((LiteralRestrictionDescr)and1.getRestrictions().get(1)).getText());
        RuleParserTest.assertEquals((String)">", (String)((LiteralRestrictionDescr)and2.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"50", (String)((LiteralRestrictionDescr)and2.getRestrictions().get(0)).getText());
        RuleParserTest.assertEquals((String)"<", (String)((LiteralRestrictionDescr)and2.getRestrictions().get(1)).getEvaluator());
        RuleParserTest.assertEquals((String)"55", (String)((LiteralRestrictionDescr)and2.getRestrictions().get(1)).getText());
        fcd = (FieldConstraintDescr)andConstr1.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"hair", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"black", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        AndDescr andConstr2 = (AndDescr)orConstr.getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)andConstr2.getDescrs().size());
        fcd = (FieldConstraintDescr)andConstr2.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"40", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)andConstr2.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"hair", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"pink", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        AndDescr andConstr3 = (AndDescr)orConstr.getDescrs().get(2);
        RuleParserTest.assertEquals((int)2, (int)andConstr3.getDescrs().size());
        fcd = (FieldConstraintDescr)andConstr3.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"12", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        OrDescr orConstr2 = (OrDescr)andConstr3.getDescrs().get(1);
        fcd = (FieldConstraintDescr)orConstr2.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"hair", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"yellow", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)orConstr2.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"hair", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"blue", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
    }

    public void testNotContains() throws Exception {
        String text = "City( $city : city )\nCountry( cities not contains $city )\n";
        AndDescr descrs = new AndDescr();
        ANTLRStringStream charStream = new ANTLRStringStream("City( $city : city )\nCountry( cities not contains $city )\n");
        DRLLexer lexer = new DRLLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        DRLParser parser = new DRLParser((TokenStream)tokenStream);
        parser.setLineOffset(descrs.getLine());
        parser.normal_lhs_block(descrs);
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        RuleParserTest.assertEquals((int)2, (int)descrs.getDescrs().size());
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(1);
        FieldConstraintDescr fieldConstr = (FieldConstraintDescr)pat.getConstraint().getDescrs().get(0);
        VariableRestrictionDescr restr = (VariableRestrictionDescr)fieldConstr.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"not contains", (String)restr.getEvaluator());
        RuleParserTest.assertEquals((String)"$city", (String)restr.getIdentifier());
    }

    public void testNotMatches() throws Exception {
        String text = "Message( text not matches '[abc]*' )\n";
        AndDescr descrs = new AndDescr();
        ANTLRStringStream charStream = new ANTLRStringStream("Message( text not matches '[abc]*' )\n");
        DRLLexer lexer = new DRLLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        DRLParser parser = new DRLParser((TokenStream)tokenStream);
        parser.setLineOffset(descrs.getLine());
        parser.normal_lhs_block(descrs);
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        RuleParserTest.assertEquals((int)1, (int)descrs.getDescrs().size());
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(0);
        FieldConstraintDescr fieldConstr = (FieldConstraintDescr)pat.getConstraint().getDescrs().get(0);
        LiteralRestrictionDescr restr = (LiteralRestrictionDescr)fieldConstr.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"not matches", (String)restr.getEvaluator());
        RuleParserTest.assertEquals((String)"[abc]*", (String)restr.getText());
    }

    public void testSemicolon() throws Exception {
        this.parseResource("semicolon.drl");
        this.parser.compilation_unit();
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
        PackageDescr pkg = this.parser.getPackageDescr();
        RuleParserTest.assertEquals((String)"org.drools", (String)pkg.getName());
        RuleParserTest.assertEquals((int)1, (int)pkg.getGlobals().size());
        RuleParserTest.assertEquals((int)3, (int)pkg.getRules().size());
        RuleDescr rule1 = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)2, (int)rule1.getLhs().getDescrs().size());
        RuleDescr query1 = (RuleDescr)pkg.getRules().get(1);
        RuleParserTest.assertEquals((int)3, (int)query1.getLhs().getDescrs().size());
        RuleDescr rule2 = (RuleDescr)pkg.getRules().get(2);
        RuleParserTest.assertEquals((int)2, (int)rule2.getLhs().getDescrs().size());
    }

    public void testEval() throws Exception {
        this.parseResource("eval_parsing.drl");
        this.parser.compilation_unit();
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
        PackageDescr pkg = this.parser.getPackageDescr();
        RuleParserTest.assertEquals((String)"org.drools", (String)pkg.getName());
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule1 = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule1.getLhs().getDescrs().size());
    }

    public void testAccumulateReverse() throws Exception {
        DRLParser parser = this.parseResource("accumulateReverse.drl");
        parser.compilation_unit();
        if (parser.hasErrors()) {
            System.err.println(parser.getErrorMessages());
        }
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        this.assertEqualsIgnoreWhitespace("x--;", accum.getReverseCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        RuleParserTest.assertFalse((boolean)accum.isExternalFunction());
        PatternDescr pattern = accum.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
    }

    public void testAccumulateExternalFunction() throws Exception {
        DRLParser parser = this.parseResource("accumulateExternalFunction.drl");
        parser.compilation_unit();
        if (parser.hasErrors()) {
            System.err.println(parser.getErrorMessages());
        }
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        this.assertEqualsIgnoreWhitespace("$age", accum.getExpression());
        this.assertEqualsIgnoreWhitespace("average", accum.getFunctionIdentifier());
        RuleParserTest.assertTrue((boolean)accum.isExternalFunction());
        PatternDescr pattern = accum.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
    }

    public void testCollectWithNestedFrom() throws Exception {
        DRLParser parser = this.parseResource("collect_with_nested_from.drl");
        parser.compilation_unit();
        if (parser.hasErrors()) {
            System.err.println(parser.getErrorMessages());
        }
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        CollectDescr collect = (CollectDescr)out.getSource();
        PatternDescr person = collect.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)person.getObjectType());
        CollectDescr collect2 = (CollectDescr)person.getSource();
        PatternDescr people = collect2.getInputPattern();
        RuleParserTest.assertEquals((String)"People", (String)people.getObjectType());
    }

    public void testAccumulateWithNestedFrom() throws Exception {
        DRLParser parser = this.parseResource("accumulate_with_nested_from.drl");
        parser.compilation_unit();
        if (parser.hasErrors()) {
            System.err.println(parser.getErrorMessages());
        }
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accumulate = (AccumulateDescr)out.getSource();
        PatternDescr person = accumulate.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)person.getObjectType());
        CollectDescr collect2 = (CollectDescr)person.getSource();
        PatternDescr people = collect2.getInputPattern();
        RuleParserTest.assertEquals((String)"People", (String)people.getObjectType());
    }

    public void testAccessorPaths() throws Exception {
        String text = "org   .   drools/*comment*/\t  .Message( text not matches $c#comment\n. property )\n";
        AndDescr descrs = new AndDescr();
        ANTLRStringStream charStream = new ANTLRStringStream("org   .   drools/*comment*/\t  .Message( text not matches $c#comment\n. property )\n");
        DRLLexer lexer = new DRLLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        DRLParser parser = new DRLParser((TokenStream)tokenStream);
        parser.setLineOffset(descrs.getLine());
        parser.normal_lhs_block(descrs);
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        RuleParserTest.assertEquals((int)1, (int)descrs.getDescrs().size());
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"org.drools.Message", (String)pat.getObjectType());
        FieldConstraintDescr fieldConstr = (FieldConstraintDescr)pat.getConstraint().getDescrs().get(0);
        QualifiedIdentifierRestrictionDescr restr = (QualifiedIdentifierRestrictionDescr)fieldConstr.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"not matches", (String)restr.getEvaluator());
        RuleParserTest.assertEquals((String)"$c.property", (String)restr.getText());
    }

    public void testOrCE() throws Exception {
        DRLParser parser = this.parseResource("or_ce.drl");
        parser.compilation_unit();
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr person = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)person.getObjectType());
        RuleParserTest.assertEquals((String)"$p", (String)person.getIdentifier());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        PatternDescr cheese1 = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese1.getObjectType());
        RuleParserTest.assertEquals((String)"$c", (String)cheese1.getIdentifier());
        PatternDescr cheese2 = (PatternDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese2.getObjectType());
        RuleParserTest.assertNull((Object)cheese2.getIdentifier());
    }

    public void testRuleParseLhs2() throws Exception {
        String text = "Message( Message.HELLO )\n";
        AndDescr descrs = new AndDescr();
        ANTLRStringStream charStream = new ANTLRStringStream("Message( Message.HELLO )\n");
        DRLLexer lexer = new DRLLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        DRLParser parser = new DRLParser((TokenStream)tokenStream);
        parser.setLineOffset(descrs.getLine());
        parser.normal_lhs_block(descrs);
        RuleParserTest.assertTrue((boolean)parser.hasErrors());
    }

    public void testRuleParseLhs3() throws Exception {
        String text = "(or\nnot Person()\n(and Cheese()\nMeat()\nWine()))";
        AndDescr descrs = new AndDescr();
        ANTLRStringStream charStream = new ANTLRStringStream("(or\nnot Person()\n(and Cheese()\nMeat()\nWine()))");
        DRLLexer lexer = new DRLLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        DRLParser parser = new DRLParser((TokenStream)tokenStream);
        parser.setLineOffset(descrs.getLine());
        parser.normal_lhs_block(descrs);
        if (parser.hasErrors()) {
            System.err.println(parser.getErrorMessages());
        }
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
        RuleParserTest.assertEquals((int)1, (int)descrs.getDescrs().size());
        OrDescr or = (OrDescr)descrs.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        NotDescr not = (NotDescr)or.getDescrs().get(0);
        AndDescr and = (AndDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)not.getDescrs().size());
        PatternDescr person = (PatternDescr)not.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)person.getObjectType());
        RuleParserTest.assertEquals((int)3, (int)and.getDescrs().size());
        PatternDescr cheese = (PatternDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese.getObjectType());
        PatternDescr meat = (PatternDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Meat", (String)meat.getObjectType());
        PatternDescr wine = (PatternDescr)and.getDescrs().get(2);
        RuleParserTest.assertEquals((String)"Wine", (String)wine.getObjectType());
    }

    public void testAccumulateMultiPattern() throws Exception {
        DRLParser parser = this.parseResource("accumulate_multi_pattern.drl");
        parser.compilation_unit();
        RuleParserTest.assertFalse((String)parser.getErrorMessages().toString(), (boolean)parser.hasErrors());
        PackageDescr pack = parser.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)outPattern.getSource();
        this.assertEqualsIgnoreWhitespace("$counter", outPattern.getIdentifier());
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        AndDescr and = (AndDescr)accum.getInput();
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        PatternDescr person = (PatternDescr)and.getDescrs().get(0);
        PatternDescr cheese = (PatternDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Person", (String)person.getObjectType());
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese.getObjectType());
    }

    public void testErrorMessageForMisplacedParenthesis() throws Exception {
        DRLParser parser = this.parseResource("misplaced_parenthesis.drl");
        parser.compilation_unit();
        RuleParserTest.assertTrue((String)"Parser should have raised errors", (boolean)parser.hasErrors());
        Iterator it = parser.getErrors().iterator();
        while (it.hasNext()) {
            Object error = it.next();
            if (error instanceof MismatchedTokenException) continue;
            RuleParserTest.fail((String)"Error should be an instance of MismatchedTokenException");
        }
    }

    private DRLParser parse(String text) throws Exception {
        this.parser = this.newParser(this.newTokenStream((Lexer)this.newLexer(this.newCharStream(text))));
        return this.parser;
    }

    private DRLParser parse(String source, String text) throws Exception {
        this.parser = this.newParser(this.newTokenStream((Lexer)this.newLexer(this.newCharStream(text))));
        this.parser.setSource(source);
        return this.parser;
    }

    private Reader getReader(String name) throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        return new InputStreamReader(in);
    }

    private DRLParser parseResource(String name) throws Exception {
        Reader reader = this.getReader(name);
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return this.parse(name, text.toString());
    }

    private CharStream newCharStream(String text) {
        return new ANTLRStringStream(text);
    }

    private DRLLexer newLexer(CharStream charStream) {
        return new DRLLexer(charStream);
    }

    private TokenStream newTokenStream(Lexer lexer) {
        return new CommonTokenStream((TokenSource)lexer);
    }

    private DRLParser newParser(TokenStream tokenStream) {
        DRLParser p = new DRLParser(tokenStream);
        return p;
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        RuleParserTest.assertEquals((String)cleanExpected, (String)cleanActual);
    }

    private void prettyPrintErrors() {
        List msgs = this.parser.getErrorMessages();
        Iterator iter = msgs.iterator();
        while (iter.hasNext()) {
            String err = (String)iter.next();
            System.out.println(err);
        }
    }
}

