/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.drools.lang.dsl.DSLMappingEntry;
import org.drools.lang.dsl.DSLMappingFile;

public class DSLMappingFileTest
extends TestCase {
    private DSLMappingFile file = null;
    private final String filename = "test_metainfo.dsl";

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testParseFile() {
        try {
            InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(this.filename));
            this.file = new DSLMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            DSLMappingFileTest.assertTrue((String)this.file.getErrors().toString(), (boolean)parsingResult);
            DSLMappingFileTest.assertTrue((boolean)this.file.getErrors().isEmpty());
            DSLMappingFileTest.assertEquals((int)31, (int)this.file.getMapping().getEntries().size());
        }
        catch (IOException e) {
            e.printStackTrace();
            DSLMappingFileTest.fail((String)"Should not raise exception ");
        }
    }

    public void testParseFileWithBrackets() {
        String file = "[when][]ATTRIBUTE \"{attr}\" IS IN [{list}]=Attribute( {attr} in ({list}) )";
        try {
            StringReader reader = new StringReader(file);
            this.file = new DSLMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            DSLMappingFileTest.assertTrue((String)this.file.getErrors().toString(), (boolean)parsingResult);
            DSLMappingFileTest.assertTrue((boolean)this.file.getErrors().isEmpty());
            DSLMappingFileTest.assertEquals((int)1, (int)this.file.getMapping().getEntries().size());
            DSLMappingEntry entry = (DSLMappingEntry)this.file.getMapping().getEntries().get(0);
            DSLMappingFileTest.assertEquals((Object)DSLMappingEntry.CONDITION, (Object)entry.getSection());
            DSLMappingFileTest.assertEquals((Object)DSLMappingEntry.EMPTY_METADATA, (Object)entry.getMetaData());
            DSLMappingFileTest.assertEquals((String)"ATTRIBUTE \"{attr}\" IS IN [{list}]", (String)entry.getMappingKey());
            DSLMappingFileTest.assertEquals((String)"Attribute( {attr} in ({list}) )", (String)entry.getMappingValue());
        }
        catch (IOException e) {
            e.printStackTrace();
            DSLMappingFileTest.fail((String)"Should not raise exception ");
        }
    }

    public void testParseFileWithEscaptedBrackets() {
        String file = "[when][]ATTRIBUTE \"{attr}\" IS IN \\[{list}\\]=Attribute( {attr} in ({list}) )";
        try {
            StringReader reader = new StringReader(file);
            this.file = new DSLMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            DSLMappingFileTest.assertTrue((String)this.file.getErrors().toString(), (boolean)parsingResult);
            DSLMappingFileTest.assertTrue((boolean)this.file.getErrors().isEmpty());
            DSLMappingFileTest.assertEquals((int)1, (int)this.file.getMapping().getEntries().size());
            DSLMappingEntry entry = (DSLMappingEntry)this.file.getMapping().getEntries().get(0);
            DSLMappingFileTest.assertEquals((Object)DSLMappingEntry.CONDITION, (Object)entry.getSection());
            DSLMappingFileTest.assertEquals((Object)DSLMappingEntry.EMPTY_METADATA, (Object)entry.getMetaData());
            DSLMappingFileTest.assertEquals((String)"ATTRIBUTE \"{attr}\" IS IN \\[{list}\\]", (String)entry.getMappingKey());
            DSLMappingFileTest.assertEquals((String)"Attribute( {attr} in ({list}) )", (String)entry.getMappingValue());
        }
        catch (IOException e) {
            e.printStackTrace();
            DSLMappingFileTest.fail((String)"Should not raise exception ");
        }
    }

    public void testParseFileWithEscaptedEquals() {
        String file = "[when][]something:\\={value}=Attribute( something == \"{value}\" )";
        try {
            StringReader reader = new StringReader(file);
            this.file = new DSLMappingFile();
            boolean parsingResult = this.file.parseAndLoad((Reader)reader);
            ((Reader)reader).close();
            DSLMappingFileTest.assertTrue((String)this.file.getErrors().toString(), (boolean)parsingResult);
            DSLMappingFileTest.assertTrue((boolean)this.file.getErrors().isEmpty());
            DSLMappingFileTest.assertEquals((int)1, (int)this.file.getMapping().getEntries().size());
            DSLMappingEntry entry = (DSLMappingEntry)this.file.getMapping().getEntries().get(0);
            DSLMappingFileTest.assertEquals((Object)DSLMappingEntry.CONDITION, (Object)entry.getSection());
            DSLMappingFileTest.assertEquals((Object)DSLMappingEntry.EMPTY_METADATA, (Object)entry.getMetaData());
            DSLMappingFileTest.assertEquals((String)"something:={value}", (String)entry.getMappingKey());
            DSLMappingFileTest.assertEquals((String)"Attribute( something == \"{value}\" )", (String)entry.getMappingValue());
        }
        catch (IOException e) {
            e.printStackTrace();
            DSLMappingFileTest.fail((String)"Should not raise exception ");
        }
    }
}

