/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import junit.framework.TestCase;
import org.drools.lang.dsl.DSLMappingEntry;
import org.drools.lang.dsl.DefaultDSLMappingEntry;

public class DefaultDSLMappingEntryTest
extends TestCase {
    private DSLMappingEntry entry;

    protected void setUp() throws Exception {
        super.setUp();
        this.setupEntry();
    }

    private void setupEntry() {
        String inputKey = "String is \"{value}\"";
        String inputValue = "SomeFact(value==\"{value}\")";
        this.entry = new DefaultDSLMappingEntry(DSLMappingEntry.CONDITION, null, "String is \"{value}\"", "SomeFact(value==\"{value}\")");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPatternCalculation() {
        String inputKey = "The Customer name is {name} and surname is {surname} and it has US$ 50,00 on his {pocket}";
        String inputValue = "Customer( name == \"{name}\", surname == \"{surname}\", money > $money )";
        String expectedKeyP = "(\\W|^)The\\s+Customer\\s+name\\s+is\\s+(.*?)\\s+and\\s+surname\\s+is\\s+(.*?)\\s+and\\s+it\\s+has\\s+US\\$\\s+50,00\\s+on\\s+his\\s+(.*?)$";
        String expectedValP = "Customer( name == \"$2\", surname == \"$3\", money > \\$money )";
        DefaultDSLMappingEntry entry = new DefaultDSLMappingEntry(DSLMappingEntry.CONDITION, null, "The Customer name is {name} and surname is {surname} and it has US$ 50,00 on his {pocket}", "Customer( name == \"{name}\", surname == \"{surname}\", money > $money )");
        DefaultDSLMappingEntryTest.assertEquals((String)"The Customer name is {name} and surname is {surname} and it has US$ 50,00 on his {pocket}", (String)entry.getMappingKey());
        DefaultDSLMappingEntryTest.assertEquals((String)"(\\W|^)The\\s+Customer\\s+name\\s+is\\s+(.*?)\\s+and\\s+surname\\s+is\\s+(.*?)\\s+and\\s+it\\s+has\\s+US\\$\\s+50,00\\s+on\\s+his\\s+(.*?)$", (String)entry.getKeyPattern().pattern());
        DefaultDSLMappingEntryTest.assertEquals((String)"Customer( name == \"{name}\", surname == \"{surname}\", money > $money )", (String)entry.getMappingValue());
        DefaultDSLMappingEntryTest.assertEquals((String)"Customer( name == \"$2\", surname == \"$3\", money > \\$money )", (String)entry.getValuePattern());
    }

    public void testPatternCalculation2() {
        String inputKey = "-name is {name}";
        String inputValue = "name == \"{name}\"";
        String expectedKeyP = "(\\W|^)-\\s*name\\s+is\\s+(.*?)$";
        String expectedValP = "name == \"$2\"";
        DefaultDSLMappingEntry entry = new DefaultDSLMappingEntry(DSLMappingEntry.CONDITION, null, "-name is {name}", "name == \"{name}\"");
        DefaultDSLMappingEntryTest.assertEquals((String)"-name is {name}", (String)entry.getMappingKey());
        DefaultDSLMappingEntryTest.assertEquals((String)"(\\W|^)-\\s*name\\s+is\\s+(.*?)$", (String)entry.getKeyPattern().pattern());
        DefaultDSLMappingEntryTest.assertEquals((String)"name == \"{name}\"", (String)entry.getMappingValue());
        DefaultDSLMappingEntryTest.assertEquals((String)"name == \"$2\"", (String)entry.getValuePattern());
    }

    public void testPatternCalculation3() {
        String inputKey = "- name is {name}";
        String inputValue = "name == \"{name}\"";
        String expectedKeyP = "(\\W|^)-\\s*name\\s+is\\s+(.*?)$";
        String expectedValP = "name == \"$2\"";
        DefaultDSLMappingEntry entry = new DefaultDSLMappingEntry(DSLMappingEntry.CONDITION, null, "- name is {name}", "name == \"{name}\"");
        DefaultDSLMappingEntryTest.assertEquals((String)"- name is {name}", (String)entry.getMappingKey());
        DefaultDSLMappingEntryTest.assertEquals((String)entry.getKeyPattern().pattern(), (String)"(\\W|^)-\\s*name\\s+is\\s+(.*?)$", (String)entry.getKeyPattern().pattern());
        DefaultDSLMappingEntryTest.assertEquals((String)"name == \"{name}\"", (String)entry.getMappingValue());
        DefaultDSLMappingEntryTest.assertEquals((String)"name == \"$2\"", (String)entry.getValuePattern());
    }

    public void testExpandNoSpaces() {
        this.setupEntry();
        String result = this.entry.getKeyPattern().matcher("String is \"blah\"").replaceAll(this.entry.getValuePattern());
        DefaultDSLMappingEntryTest.assertEquals((String)"SomeFact(value==\"blah\")", (String)result);
    }

    public void testExpandWithLeadingSpace() {
        this.setupEntry();
        String result = this.entry.getKeyPattern().matcher("String is \" blah\"").replaceAll(this.entry.getValuePattern());
        DefaultDSLMappingEntryTest.assertEquals((String)"SomeFact(value==\" blah\")", (String)result);
    }

    public void testExpandWithMultipleLeadingSpaces() {
        this.setupEntry();
        String result = this.entry.getKeyPattern().matcher("String is \"   blah\"").replaceAll(this.entry.getValuePattern());
        DefaultDSLMappingEntryTest.assertEquals((String)"SomeFact(value==\"   blah\")", (String)result);
    }

    public void testExpandWithTrailingSpace() {
        this.setupEntry();
        String result = this.entry.getKeyPattern().matcher("String is \"blah \"").replaceAll(this.entry.getValuePattern());
        DefaultDSLMappingEntryTest.assertEquals((String)"SomeFact(value==\"blah \")", (String)result);
    }

    public void testExpandWithMultipleTrailingSpaces() {
        this.setupEntry();
        String result = this.entry.getKeyPattern().matcher("String is \"blah  \"").replaceAll(this.entry.getValuePattern());
        DefaultDSLMappingEntryTest.assertEquals((String)"SomeFact(value==\"blah  \")", (String)result);
    }

    public void testExpandWithInternalSpace() {
        this.setupEntry();
        String result = this.entry.getKeyPattern().matcher("String is \"bl ah\"").replaceAll(this.entry.getValuePattern());
        DefaultDSLMappingEntryTest.assertEquals((String)"SomeFact(value==\"bl ah\")", (String)result);
    }

    public void testExpandWithMultipleSpaces() {
        this.setupEntry();
        String result = this.entry.getKeyPattern().matcher("String is \"  bl  ah  \"").replaceAll(this.entry.getValuePattern());
        DefaultDSLMappingEntryTest.assertEquals((String)"SomeFact(value==\"  bl  ah  \")", (String)result);
    }

    public void testExpandWithDots() {
        String inputKey = "- {prop} is {val} ";
        String inputValue = "{prop} == {val}";
        this.entry = new DefaultDSLMappingEntry(DSLMappingEntry.CONDITION, null, "- {prop} is {val} ", "{prop} == {val}");
        String result = this.entry.getKeyPattern().matcher("- type is ClientServiceType.TypeGOLD").replaceAll(this.entry.getValuePattern());
        DefaultDSLMappingEntryTest.assertEquals((String)result, (String)"type == ClientServiceType.TypeGOLD", (String)result);
    }

    public void testExpandPartialWords() {
        String inputKey = "- {prop} is {val} ";
        String inputValue = "{prop} == {val}";
        this.entry = new DefaultDSLMappingEntry(DSLMappingEntry.CONDITION, null, "- {prop} is {val} ", "{prop} == {val}");
        String result = this.entry.getKeyPattern().matcher("- type is_not ClientServiceType.TypeGOLD").replaceAll(this.entry.getValuePattern());
        DefaultDSLMappingEntryTest.assertEquals((String)result, (String)"- type is_not ClientServiceType.TypeGOLD", (String)result);
    }

    public void testExpandPartialWords2() {
        String inputKey = "- {prop} is_not {val} ";
        String inputValue = "{prop} != {val}";
        this.entry = new DefaultDSLMappingEntry(DSLMappingEntry.CONDITION, null, "- {prop} is_not {val} ", "{prop} != {val}");
        String result = this.entry.getKeyPattern().matcher("- type is_not ClientServiceType.TypeGOLD").replaceAll(this.entry.getValuePattern());
        DefaultDSLMappingEntryTest.assertEquals((String)result, (String)"type != ClientServiceType.TypeGOLD", (String)result);
    }

    public void testExpandPartialWords3() {
        String inputKey = "- {prop} is not {val} ";
        String inputValue = "{prop} != {val}";
        this.entry = new DefaultDSLMappingEntry(DSLMappingEntry.CONDITION, null, "- {prop} is not {val} ", "{prop} != {val}");
        String result = this.entry.getKeyPattern().matcher("- type is not ClientServiceType.TypeGOLD").replaceAll(this.entry.getValuePattern());
        DefaultDSLMappingEntryTest.assertEquals((String)result, (String)"type != ClientServiceType.TypeGOLD", (String)result);
    }

    public void testExpandWithBrackets() {
        String inputKey = "attr {attr_name} is in \\[ {values} \\]";
        String inputValue = "{attr_name} in ( {values} )";
        this.entry = new DefaultDSLMappingEntry(DSLMappingEntry.CONDITION, null, "attr {attr_name} is in \\[ {values} \\]", "{attr_name} in ( {values} )");
        String result = this.entry.getKeyPattern().matcher("attr name is in [ 'Edson', 'Bob' ]").replaceAll(this.entry.getValuePattern());
        DefaultDSLMappingEntryTest.assertEquals((String)result, (String)"name in ( 'Edson', 'Bob' )", (String)result);
    }

    public void testExpandWithParethesis() {
        String inputKey = "((H|h)e|(S|s)he) \\(is\\) (a|an) $xx {attribute} (man|woman)";
        String inputValue = "Person( attribute == \"{attribute}\" )";
        this.entry = new DefaultDSLMappingEntry(DSLMappingEntry.CONDITION, null, "((H|h)e|(S|s)he) \\(is\\) (a|an) $xx {attribute} (man|woman)", "Person( attribute == \"{attribute}\" )");
        String result = this.entry.getKeyPattern().matcher("he (is) a $xx handsome man").replaceAll(this.entry.getValuePattern());
        DefaultDSLMappingEntryTest.assertEquals((String)result, (String)"Person( attribute == \"handsome\" )", (String)result);
    }
}

