/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.drools.lang.ExpanderException;
import org.drools.lang.dsl.DSLMappingFile;
import org.drools.lang.dsl.DefaultExpander;

public class DefaultExpanderTest
extends TestCase {
    private DSLMappingFile file = null;
    private DefaultExpander expander = null;

    protected void setUp() throws Exception {
        String filename = "test_metainfo.dsl";
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_metainfo.dsl"));
        this.file = new DSLMappingFile();
        this.file.parseAndLoad((Reader)reader);
        ((Reader)reader).close();
        this.expander = new DefaultExpander();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAddDSLMapping() {
        this.expander.addDSLMapping(this.file.getMapping());
    }

    public void testRegexp() throws Exception {
        this.expander.addDSLMapping(this.file.getMapping());
        InputStreamReader rules = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_expansion.dslr"));
        String result = this.expander.expand((Reader)rules);
    }

    public void testExpandParts() throws Exception {
        DSLMappingFile file = new DSLMappingFile();
        String dsl = "[when]foo=Foo()\n[then]bar {num}=baz({num});";
        file.parseAndLoad((Reader)new StringReader(dsl));
        DefaultExpanderTest.assertEquals((int)0, (int)file.getErrors().size());
        DefaultExpander ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
        System.err.println(ex.expand("rule 'x' \n when \n foo \n then \n end"));
    }

    public void testExpandFailure() throws Exception {
        DSLMappingFile file = new DSLMappingFile();
        String dsl = "[when]foo=Foo()\n[then]bar {num}=baz({num});";
        file.parseAndLoad((Reader)new StringReader(dsl));
        DefaultExpanderTest.assertEquals((int)0, (int)file.getErrors().size());
        DefaultExpander ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
        String source = "rule 'q'\nagenda-group 'x'\nwhen\n    foo  \nthen\n    bar 42\nend";
        String drl = ex.expand(source);
        DefaultExpanderTest.assertFalse((boolean)ex.hasErrors());
        ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
        source = "rule 'q' agenda-group 'x'\nwhen\n    foos \nthen\n    bar 42\n end";
        drl = ex.expand(source);
        DefaultExpanderTest.assertTrue((boolean)ex.hasErrors());
        DefaultExpanderTest.assertEquals((int)1, (int)ex.getErrors().size());
    }

    public void testExpandWithKeywordClashes() throws Exception {
        DSLMappingFile file = new DSLMappingFile();
        String dsl = "[when]Invoke rule executor=ruleExec: RuleExecutor()\n[then]Execute rule \"{id}\"=ruleExec.ExecuteSubRule( new Long({id}));";
        file.parseAndLoad((Reader)new StringReader(dsl));
        DefaultExpanderTest.assertEquals((int)0, (int)file.getErrors().size());
        DefaultExpander ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
        String source = "package something;\n\nrule \"1\"\nwhen\n    Invoke rule executor\nthen\n    Execute rule \"5\"\nend";
        String expected = "package something;\n\nrule \"1\"\nwhen\n   ruleExec: RuleExecutor()\nthen\n   ruleExec.ExecuteSubRule( new Long(5));\nend\n";
        String drl = ex.expand(source);
        DefaultExpanderTest.assertFalse((boolean)ex.hasErrors());
        DefaultExpanderTest.assertEquals((String)expected, (String)drl);
    }

    public void testLineNumberError() throws Exception {
        DSLMappingFile file = new DSLMappingFile();
        String dsl = "[when]foo=Foo()\n[then]bar {num}=baz({num});";
        file.parseAndLoad((Reader)new StringReader(dsl));
        DefaultExpander ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
        String source = "rule 'q'\nagenda-group 'x'\nwhen\n    __  \nthen\n    bar 42\n\tgoober\nend";
        ex.expand(source);
        DefaultExpanderTest.assertTrue((boolean)ex.hasErrors());
        DefaultExpanderTest.assertEquals((int)2, (int)ex.getErrors().size());
        ExpanderException err = (ExpanderException)ex.getErrors().get(0);
        DefaultExpanderTest.assertEquals((int)4, (int)err.getLine());
        err = (ExpanderException)ex.getErrors().get(1);
        DefaultExpanderTest.assertEquals((int)7, (int)err.getLine());
    }

    private boolean equalsIgnoreWhiteSpace(String expected, String actual) {
        String patternStr = expected.replaceAll("\\s+", "(\\\\s|\\\\n|\\\\r)*");
        Pattern pattern = Pattern.compile(patternStr, 32);
        Matcher m = pattern.matcher(actual);
        return m.matches();
    }
}

