/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.compiler.PackageBuilder;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.rule.Package;

public class ReteooBuilderTest
extends TestCase {
    private final boolean writeTree = false;

    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase();
    }

    public void testThreePatternsWithConstraints() throws Exception {
    }

    public void testOneAndTwoOrs() throws Exception {
    }

    public void testOneAndTwoOrsPerson() throws Exception {
    }

    private void writeRuleBase(RuleBase ruleBase, String fileName) throws IOException {
        XStream xstream = new XStream();
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("src/test/resources/org/drools/reteoo/" + fileName)));
        xstream.toXML((Object)ruleBase, (Writer)out);
    }

    private void checkRuleBase(String name) throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_" + name + ".drl")));
        Package pkg = builder.getPackage();
        ReteooRuleBase ruleBase = (ReteooRuleBase)this.getRuleBase();
        ruleBase.addPackage(pkg);
        ((Object)((Object)this)).getClass();
        XStream xstream = new XStream();
        RuleBase goodRuleBase = (RuleBase)xstream.fromXML(((Object)((Object)this)).getClass().getResourceAsStream(name));
        this.nodesEquals(((ReteooRuleBase)goodRuleBase).getRete(), ruleBase.getRete());
    }

    private void nodesEquals(Object object1, Object object2) {
        block3: {
            block2: {
                ReteooBuilderTest.assertEquals((String)(object1 + " is not of the same type as " + object2), object1.getClass(), object2.getClass());
                ReteooBuilderTest.assertEquals((String)(object1 + " is not equal to " + object2), (Object)object1, (Object)object2);
                if (!(object1 instanceof ObjectSource)) break block2;
                ObjectSource source1 = (ObjectSource)object1;
                ObjectSource source2 = (ObjectSource)object2;
                ObjectSink[] list1 = source1.sink.getSinks();
                ObjectSink[] list2 = source2.sink.getSinks();
                ReteooBuilderTest.assertEquals((String)(object1.getClass() + " nodes have different number of sinks"), (int)list1.length, (int)list2.length);
                int size = list1.length;
                for (int i = 0; i < size; ++i) {
                    this.nodesEquals(list1[i], list2[i]);
                }
                break block3;
            }
            if (!(object1 instanceof TupleSource)) break block3;
            TupleSource source1 = (TupleSource)object1;
            TupleSource source2 = (TupleSource)object2;
            TupleSink[] list1 = source1.sink.getSinks();
            TupleSink[] list2 = source2.sink.getSinks();
            ReteooBuilderTest.assertEquals((String)(object1.getClass() + " nodes have different number of sinks"), (int)list1.length, (int)list2.length);
            int size = list1.length;
            for (int i = 0; i < size; ++i) {
                this.nodesEquals(list1[i], list2[i]);
            }
        }
    }
}

