/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.HashMap;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.FactHandle;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.base.ClassFieldExtractor;
import org.drools.base.ClassFieldExtractorCache;
import org.drools.base.ClassObjectType;
import org.drools.common.InternalFactHandle;
import org.drools.compiler.Dialect;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.reteoo.ReteTuple;
import org.drools.rule.Declaration;
import org.drools.rule.EvalCondition;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.mvel.InstrumentedBuildContent;
import org.drools.rule.builder.dialect.mvel.InstrumentedDeclarationScopeResolver;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.rule.builder.dialect.mvel.MVELEvalBuilder;
import org.drools.spi.Extractor;
import org.drools.spi.ObjectType;
import org.drools.spi.Tuple;

public class MVELEvalBuilderTest
extends TestCase {
    private ClassFieldExtractorCache cache;

    public void setUp() {
        this.cache = ClassFieldExtractorCache.getInstance();
    }

    public void testSimpleExpression() {
        Package pkg = new Package("pkg1");
        RuleDescr ruleDescr = new RuleDescr("rule 1");
        PackageBuilder pkgBuilder = new PackageBuilder(pkg);
        PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
        MVELDialect mvelDialect = (MVELDialect)pkgBuilder.getDialectRegistry().getDialect("mvel");
        InstrumentedBuildContent context = new InstrumentedBuildContent(conf, pkg, ruleDescr, pkgBuilder.getDialectRegistry(), (Dialect)mvelDialect);
        InstrumentedDeclarationScopeResolver declarationResolver = new InstrumentedDeclarationScopeResolver();
        ClassFieldExtractor extractor = this.cache.getExtractor(Cheese.class, "price", ((Object)((Object)this)).getClass().getClassLoader());
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Integer.TYPE));
        Declaration declaration = new Declaration("a", (Extractor)extractor, pattern);
        HashMap<String, Declaration> map = new HashMap<String, Declaration>();
        map.put("a", declaration);
        declarationResolver.setDeclarations(map);
        context.setDeclarationResolver(declarationResolver);
        EvalDescr evalDescr = new EvalDescr();
        evalDescr.setContent((Object)"a == 10");
        MVELEvalBuilder builder = new MVELEvalBuilder();
        EvalCondition eval = (EvalCondition)builder.build((RuleBuildContext)context, (BaseDescr)evalDescr);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        StatefulSession wm = ruleBase.newStatefulSession();
        Cheese cheddar = new Cheese("cheddar", 10);
        InternalFactHandle f0 = (InternalFactHandle)wm.insert((Object)cheddar);
        ReteTuple tuple = new ReteTuple(f0);
        MVELEvalBuilderTest.assertTrue((boolean)eval.isAllowed((Tuple)tuple, (WorkingMemory)wm));
        cheddar.setPrice(9);
        wm.update((FactHandle)f0, (Object)cheddar);
        MVELEvalBuilderTest.assertFalse((boolean)eval.isAllowed((Tuple)tuple, (WorkingMemory)wm));
    }
}

