/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.FactHandle;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.base.ClassFieldExtractor;
import org.drools.base.ClassFieldExtractorCache;
import org.drools.base.ClassObjectType;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.compiler.Dialect;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.reteoo.ReteTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.mvel.InstrumentedBuildContent;
import org.drools.rule.builder.dialect.mvel.InstrumentedDeclarationScopeResolver;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.rule.builder.dialect.mvel.MVELPredicateBuilder;
import org.drools.spi.Extractor;
import org.drools.spi.ObjectType;

public class MVELPredicateBuilderTest
extends TestCase {
    private ClassFieldExtractorCache cache = ClassFieldExtractorCache.getInstance();

    public void setUp() {
    }

    public void testSimpleExpression() {
        ArrayList list;
        Package pkg = new Package("pkg1");
        RuleDescr ruleDescr = new RuleDescr("rule 1");
        PackageBuilder pkgBuilder = new PackageBuilder(pkg);
        PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
        MVELDialect mvelDialect = (MVELDialect)pkgBuilder.getDialectRegistry().getDialect("mvel");
        InstrumentedBuildContent context = new InstrumentedBuildContent(conf, pkg, ruleDescr, pkgBuilder.getDialectRegistry(), (Dialect)mvelDialect);
        InstrumentedDeclarationScopeResolver declarationResolver = new InstrumentedDeclarationScopeResolver();
        ClassFieldExtractor extractor = this.cache.getExtractor(Cheese.class, "price", ((Object)((Object)this)).getClass().getClassLoader());
        Pattern patternA = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Pattern patternB = new Pattern(1, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration a = new Declaration("a", (Extractor)extractor, patternA);
        Declaration b = new Declaration("b", (Extractor)extractor, patternB);
        HashMap<String, Declaration> map = new HashMap<String, Declaration>();
        map.put("a", a);
        map.put("b", b);
        declarationResolver.setDeclarations(map);
        context.setDeclarationResolver(declarationResolver);
        PredicateDescr predicateDescr = new PredicateDescr();
        predicateDescr.setContent((Object)"a == b");
        MVELPredicateBuilder builder = new MVELPredicateBuilder();
        List[] usedIdentifiers = new ArrayList[2];
        usedIdentifiers[1] = list = new ArrayList();
        Declaration[] previousDeclarations = new Declaration[]{a};
        Declaration[] localDeclarations = new Declaration[]{b};
        PredicateConstraint predicate = new PredicateConstraint(null, localDeclarations);
        builder.build((RuleBuildContext)context, usedIdentifiers, previousDeclarations, localDeclarations, predicate, predicateDescr);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        InternalWorkingMemory wm = (InternalWorkingMemory)ruleBase.newStatefulSession();
        Cheese stilton = new Cheese("stilton", 10);
        Cheese cheddar = new Cheese("cheddar", 10);
        InternalFactHandle f0 = (InternalFactHandle)wm.insert((Object)cheddar);
        ReteTuple tuple = new ReteTuple(f0);
        PredicateConstraint.PredicateContextEntry predicateContext = new PredicateConstraint.PredicateContextEntry();
        predicateContext.leftTuple = tuple;
        MVELPredicateBuilderTest.assertTrue((boolean)predicate.isAllowedCachedLeft((ContextEntry)predicateContext, (Object)stilton));
        cheddar.setPrice(9);
        wm.update((FactHandle)f0, (Object)cheddar);
        MVELPredicateBuilderTest.assertFalse((boolean)predicate.isAllowedCachedLeft((ContextEntry)predicateContext, (Object)stilton));
    }
}

