/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.base.ClassFieldExtractor;
import org.drools.base.ClassFieldExtractorCache;
import org.drools.base.ClassObjectType;
import org.drools.base.ValueType;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.compiler.Dialect;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.reteoo.ReteTuple;
import org.drools.rule.Declaration;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.ReturnValueRestriction;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.mvel.InstrumentedBuildContent;
import org.drools.rule.builder.dialect.mvel.InstrumentedDeclarationScopeResolver;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.rule.builder.dialect.mvel.MVELReturnValueBuilder;
import org.drools.spi.Extractor;
import org.drools.spi.FieldExtractor;
import org.drools.spi.ObjectType;
import org.drools.spi.Tuple;

public class MVELReturnValueBuilderTest
extends TestCase {
    private ClassFieldExtractorCache cache;

    public void setUp() {
        this.cache = ClassFieldExtractorCache.getInstance();
    }

    public void testSimpleExpression() {
        ArrayList list;
        Package pkg = new Package("pkg1");
        RuleDescr ruleDescr = new RuleDescr("rule 1");
        PackageBuilder pkgBuilder = new PackageBuilder(pkg);
        PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
        MVELDialect mvelDialect = (MVELDialect)pkgBuilder.getDialectRegistry().getDialect("mvel");
        InstrumentedBuildContent context = new InstrumentedBuildContent(conf, pkg, ruleDescr, pkgBuilder.getDialectRegistry(), (Dialect)mvelDialect);
        InstrumentedDeclarationScopeResolver declarationResolver = new InstrumentedDeclarationScopeResolver();
        ClassFieldExtractor extractor = this.cache.getExtractor(Cheese.class, "price", ((Object)((Object)this)).getClass().getClassLoader());
        Pattern patternA = new Pattern(0, (ObjectType)new ClassObjectType(Integer.TYPE));
        Pattern patternB = new Pattern(1, (ObjectType)new ClassObjectType(Integer.TYPE));
        Declaration a = new Declaration("a", (Extractor)extractor, patternA);
        Declaration b = new Declaration("b", (Extractor)extractor, patternB);
        HashMap<String, Declaration> map = new HashMap<String, Declaration>();
        map.put("a", a);
        map.put("b", b);
        declarationResolver.setDeclarations(map);
        context.setDeclarationResolver(declarationResolver);
        ReturnValueRestrictionDescr returnValueDescr = new ReturnValueRestrictionDescr("=");
        returnValueDescr.setContent("a + b");
        MVELReturnValueBuilder builder = new MVELReturnValueBuilder();
        List[] usedIdentifiers = new ArrayList[2];
        usedIdentifiers[1] = list = new ArrayList();
        Declaration[] previousDeclarations = new Declaration[]{a, b};
        Declaration[] localDeclarations = new Declaration[]{};
        String[] requiredGlobals = new String[]{};
        ReturnValueRestriction returnValue = new ReturnValueRestriction((FieldExtractor)extractor, previousDeclarations, localDeclarations, requiredGlobals, ValueType.PINTEGER_TYPE.getEvaluator(Operator.EQUAL));
        builder.build((RuleBuildContext)context, usedIdentifiers, previousDeclarations, localDeclarations, returnValue, returnValueDescr);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        InternalWorkingMemory wm = (InternalWorkingMemory)ruleBase.newStatefulSession();
        Cheese stilton = new Cheese("stilton", 10);
        Cheese cheddar = new Cheese("cheddar", 10);
        InternalFactHandle f0 = (InternalFactHandle)wm.insert((Object)cheddar);
        ReteTuple tuple = new ReteTuple(f0);
        InternalFactHandle f1 = (InternalFactHandle)wm.insert((Object)stilton);
        tuple = new ReteTuple(tuple, f1);
        Cheese brie = new Cheese("brie", 20);
        MVELReturnValueBuilderTest.assertTrue((boolean)returnValue.isAllowed((Extractor)extractor, (Object)brie, (Tuple)tuple, (WorkingMemory)wm));
        brie.setPrice(18);
        MVELReturnValueBuilderTest.assertFalse((boolean)returnValue.isAllowed((Extractor)extractor, (Object)brie, (Tuple)tuple, (WorkingMemory)wm));
    }
}

