/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.Cheese;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cheesery
implements Serializable {
    private static final long serialVersionUID = 510L;
    public static final int MAKING_CHEESE = 0;
    public static final int SELLING_CHEESE = 1;
    private List cheeses = new ArrayList();
    private int status;
    private int totalAmount;
    private Maturity maturity;

    public List<Object> getCheeses() {
        return this.cheeses;
    }

    public void setCheeses(List l) {
        this.cheeses = l;
    }

    public void addCheese(Cheese cheese) {
        this.cheeses.add(cheese);
        this.totalAmount += cheese.getPrice();
    }

    public void removeCheese(Cheese cheese) {
        this.cheeses.remove(cheese);
        this.recalculateTotalAmount();
    }

    public boolean hasSomeFlavour(String flavour) {
        return "zesty".equals(flavour);
    }

    private void recalculateTotalAmount() {
        this.totalAmount = 0;
        Iterator it = this.cheeses.iterator();
        while (it.hasNext()) {
            this.totalAmount += ((Cheese)it.next()).getPrice();
        }
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public Maturity getMaturity() {
        return this.maturity;
    }

    public void setMaturity(Maturity maturity) {
        this.maturity = maturity;
    }

    public int getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(int totalAmount) {
        this.totalAmount = totalAmount;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cheeses == null ? 0 : ((Object)this.cheeses).hashCode());
        result = 31 * result + (this.maturity == null ? 0 : this.maturity.hashCode());
        result = 31 * result + this.status;
        result = 31 * result + this.totalAmount;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Cheesery) {
            Cheesery that = (Cheesery)obj;
            return ((Object)this.cheeses).equals(that.cheeses) && this.status == that.status && this.totalAmount == that.totalAmount && this.maturity == that.maturity || this.maturity != null && this.maturity.equals(that.maturity);
        }
        return false;
    }

    public static class Maturity
    implements Externalizable {
        public static final Maturity YOUNG = new Maturity("young");
        public static final Maturity OLD = new Maturity("old");
        private String age;

        public Maturity() {
        }

        public Maturity(String age) {
            this.age = age;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.age == null ? 0 : this.age.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Maturity other = (Maturity)obj;
            return !(this.age == null ? other.age != null : !this.age.equals(other.age));
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.age = (String)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.age);
        }

        private Object readResolve() throws ObjectStreamException {
            if ("young".equals(this.age)) {
                return YOUNG;
            }
            return OLD;
        }

        public String toString() {
            return "[Maturity age='" + this.age + "']";
        }
    }
}

