/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.net.URL;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.agent.BaseKnowledgeAgentTest;
import org.drools.agent.KnowledgeAgent;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.rule.Rule;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.QueryResults;
import org.drools.runtime.rule.QueryResultsRow;
import org.junit.Assert;
import org.junit.Test;

public class QueryRemotionTest
extends BaseKnowledgeAgentTest {
    @Test
    public void testRemoveQueryChangeSet() throws Exception {
        this.fileManager.write("rules.drl", this.createCommonQuery("all the Strings", new String[]{"$strings : String()"}));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rules.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        Assert.assertEquals((long)1L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
        Assert.assertTrue((boolean)((Rule)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().iterator().next()).getName().equals("all the Strings"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)"Some String");
        QueryResults queryResults = ksession.getQueryResults("all the Strings", new Object[0]);
        Assert.assertTrue((queryResults.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((QueryResultsRow)queryResults.iterator().next()).get("$strings").equals("Some String"));
        this.fileManager.write("rules.drl", this.createCommonQuery("all the Strings 2", new String[]{"$strings : String()"}));
        this.scan(kagent);
        Assert.assertEquals((long)1L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
        Assert.assertTrue((boolean)((Rule)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().iterator().next()).getName().equals("all the Strings 2"));
        queryResults = ksession.getQueryResults("all the Strings 2", new Object[0]);
        Assert.assertTrue((queryResults.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((QueryResultsRow)queryResults.iterator().next()).get("$strings").equals("Some String"));
        ksession.dispose();
    }
}

