/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import org.drools.core.util.FileManager;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.ResourceChangeNotifierImpl;
import org.drools.io.impl.ResourceChangeScannerImpl;
import org.drools.io.impl.UrlResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ResourceHandler;

public class UrlResourceTest {
    private FileManager fileManager;
    private Server server;

    @Before
    public void setUp() throws Exception {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
        ((ResourceChangeScannerImpl)ResourceFactory.getResourceChangeScannerService()).reset();
        ResourceFactory.getResourceChangeNotifierService().start();
        ResourceFactory.getResourceChangeScannerService().start();
        this.server = new Server(0);
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase(this.fileManager.getRootDirectory().getPath());
        System.out.println("root : " + this.fileManager.getRootDirectory().getPath());
        this.server.setHandler((Handler)resourceHandler);
        this.server.start();
    }

    private int getPort() {
        return this.server.getConnectors()[0].getLocalPort();
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
        ResourceFactory.getResourceChangeNotifierService().stop();
        ResourceFactory.getResourceChangeScannerService().stop();
        ((ResourceChangeNotifierImpl)ResourceFactory.getResourceChangeNotifierService()).reset();
        ((ResourceChangeScannerImpl)ResourceFactory.getResourceChangeScannerService()).reset();
        this.server.stop();
    }

    @Test
    public void testWithCache() throws Exception {
        URL url = new URL("http://localhost:" + this.getPort() + "/rule1.drl");
        UrlResource ur = new UrlResource(url);
        File cacheDir = new File("target/test-tmp/cache");
        cacheDir.mkdirs();
        UrlResource.CACHE_DIR = cacheDir;
        File f1 = this.fileManager.newFile("rule1.drl");
        System.err.println("target file: " + f1.getAbsolutePath());
        BufferedWriter output = new BufferedWriter(new FileWriter(f1));
        output.write("Some data");
        ((Writer)output).close();
        long lm = ur.getLastModified();
        Assert.assertTrue((lm > 0L ? 1 : 0) != 0);
        InputStream ins = ur.getInputStream();
        Assert.assertNotNull((Object)ins);
        this.server.stop();
        Assert.assertNotNull((Object)ur.getInputStream());
        Assert.assertTrue((ur.getLastModified() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(ur.getInputStream() instanceof FileInputStream));
        Thread.sleep(1000L);
        f1.delete();
        output = new BufferedWriter(new FileWriter(f1));
        output.write("More data...");
        ((Writer)output).close();
        this.server.start();
        url = new URL("http://localhost:" + this.getPort() + "/rule1.drl");
        ur = new UrlResource(url);
        Assert.assertNotNull((Object)ur.getInputStream());
        Assert.assertFalse((boolean)(ur.getInputStream() instanceof FileInputStream));
        long lm_ = ur.getLastModified();
        System.err.println("lm_ : " + lm_ + " lm : " + lm);
        Assert.assertTrue((lm_ > lm ? 1 : 0) != 0);
        InputStream in_ = ur.getInputStream();
        BufferedReader rdr = new BufferedReader(new InputStreamReader(in_));
        String line = rdr.readLine();
        Assert.assertEquals((Object)"More data...", (Object)line);
        this.server.stop();
        Thread.sleep(1000L);
        f1.delete();
        output = new BufferedWriter(new FileWriter(f1));
        output.write("Finally..");
        ((Writer)output).close();
        ur = new UrlResource(url);
        in_ = ur.getInputStream();
        rdr = new BufferedReader(new InputStreamReader(in_));
        line = rdr.readLine();
        Assert.assertEquals((Object)"More data...", (Object)line);
        Thread.sleep(1000L);
        this.server.start();
        url = new URL("http://localhost:" + this.getPort() + "/rule1.drl");
        ur = new UrlResource(url);
        ur = new UrlResource(url);
        in_ = ur.getInputStream();
        rdr = new BufferedReader(new InputStreamReader(in_));
        line = rdr.readLine();
        Assert.assertEquals((Object)"Finally..", (Object)line);
    }

    @Test
    public void testWithoutCache() throws Exception {
        UrlResource ur = new UrlResource(new URL("http://localhost:" + this.getPort() + "/rule1.drl"));
        UrlResource.CACHE_DIR = null;
        File f1 = this.fileManager.newFile("rule1.drl");
        System.err.println("target file: " + f1.getAbsolutePath());
        BufferedWriter output = new BufferedWriter(new FileWriter(f1));
        output.write("Some data");
        ((Writer)output).close();
        long lm = ur.getLastModified();
        Assert.assertTrue((lm > 0L ? 1 : 0) != 0);
        InputStream ins = ur.getInputStream();
        Assert.assertNotNull((Object)ins);
        this.server.stop();
        Assert.assertEquals((long)0L, (long)ur.getLastModified());
    }
}

