/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.util.ArrayList;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.TerminalNodeIterator;
import org.drools.core.util.Iterator;
import org.drools.io.ResourceFactory;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.TerminalNode;
import org.junit.Assert;
import org.junit.Test;

public class TerminalNodeIteratorTest {
    @Test
    public void testTerminalNodeListener() {
        String str = "package org.drools.test \n\nrule rule1 when\nthen\nend\nrule rule2 when\nthen\nend\nrule rule3 when\n    Object()then\nend\nrule rule4 when\n    Object()then\nend\nrule rule5 when\n    Object() or\n    Object()\nthen\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        ArrayList<String> nodes = new ArrayList<String>();
        Iterator it = TerminalNodeIterator.iterator((KnowledgeBase)kbase);
        TerminalNode node = (TerminalNode)it.next();
        while (node != null) {
            nodes.add(((RuleTerminalNode)node).getRule().getName());
            node = (TerminalNode)it.next();
        }
        Assert.assertEquals((long)6L, (long)nodes.size());
        Assert.assertTrue((boolean)nodes.contains("rule1"));
        Assert.assertTrue((boolean)nodes.contains("rule2"));
        Assert.assertTrue((boolean)nodes.contains("rule3"));
        Assert.assertTrue((boolean)nodes.contains("rule4"));
        Assert.assertTrue((boolean)nodes.contains("rule5"));
        int first = nodes.indexOf("rule5");
        int second = nodes.lastIndexOf("rule5");
        Assert.assertTrue((first != second ? 1 : 0) != 0);
    }
}

