/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.base.TypeResolver;
import org.drools.compiler.AnalysisResult;
import org.drools.compiler.BoundIdentifiers;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DialectConfiguration;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.PackageRegistry;
import org.drools.io.Resource;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.ProcessDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.AccumulateBuilder;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.EnabledBuilder;
import org.drools.rule.builder.EntryPointBuilder;
import org.drools.rule.builder.FromBuilder;
import org.drools.rule.builder.GroupElementBuilder;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.PatternBuilder;
import org.drools.rule.builder.PredicateBuilder;
import org.drools.rule.builder.QueryBuilder;
import org.drools.rule.builder.ReturnValueBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleClassBuilder;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.SalienceBuilder;
import org.drools.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.util.ChainedProperties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PackageBuilderConfigurationTest {
    @Before
    public void setUp() throws Exception {
        System.getProperties().remove("drools.dialect.java.compiler");
        System.getProperties().remove("drools.dialect.default");
    }

    @After
    public void tearDown() throws Exception {
        System.getProperties().remove("drools.dialect.java.compiler");
        System.getProperties().remove("drools.dialect.default");
    }

    @Test
    public void testIgnoreDefaults() {
        ChainedProperties chainedProperties = new ChainedProperties("packagebuilder.conf", this.getClass().getClassLoader(), true);
        Assert.assertNotNull((Object)chainedProperties.getProperty("drools.dialect.java.compiler", null));
        chainedProperties = new ChainedProperties("packagebuilder.conf", this.getClass().getClassLoader(), false);
        Assert.assertNull((Object)chainedProperties.getProperty("drools.dialect.java.compiler", null));
        chainedProperties = new ChainedProperties("packagebuilder.conf", this.getClass().getClassLoader(), true);
        Assert.assertNotNull((Object)chainedProperties.getProperty("drools.dialect.java.compiler", null));
    }

    @Test
    public void testSystemProperties() {
        PackageBuilderConfiguration cfg = new PackageBuilderConfiguration();
        JavaDialectConfiguration javaConf = (JavaDialectConfiguration)cfg.getDialectConfiguration("java");
        Assert.assertEquals((long)0L, (long)javaConf.getCompiler());
        System.setProperty("drools.dialect.java.compiler", "JANINO");
        cfg = new PackageBuilderConfiguration();
        javaConf = (JavaDialectConfiguration)cfg.getDialectConfiguration("java");
        Assert.assertEquals((long)1L, (long)javaConf.getCompiler());
        PackageBuilderConfiguration cfg2 = new PackageBuilderConfiguration();
        JavaDialectConfiguration javaConf2 = (JavaDialectConfiguration)cfg2.getDialectConfiguration("java");
        Assert.assertEquals((long)javaConf.getCompiler(), (long)javaConf2.getCompiler());
        System.setProperty("drools.dialect.java.compiler", "ECLIPSE");
        cfg = new PackageBuilderConfiguration();
        javaConf = (JavaDialectConfiguration)cfg.getDialectConfiguration("java");
        Assert.assertEquals((long)0L, (long)javaConf.getCompiler());
        javaConf2.setCompiler(0);
        Assert.assertEquals((long)0L, (long)javaConf2.getCompiler());
        javaConf2.setCompiler(1);
        Assert.assertEquals((long)1L, (long)javaConf2.getCompiler());
        PackageBuilderConfiguration cfg3 = new PackageBuilderConfiguration();
        JavaDialectConfiguration javaConf3 = (JavaDialectConfiguration)cfg3.getDialectConfiguration("java");
        Assert.assertEquals((long)javaConf.getCompiler(), (long)javaConf3.getCompiler());
    }

    @Test
    public void testProgrammaticProperties() {
        PackageBuilderConfiguration cfg = new PackageBuilderConfiguration();
        Assert.assertTrue((boolean)cfg.getDefaultDialect().equals("java"));
        Properties properties = new Properties();
        properties.setProperty("drools.dialect.default", "mvel");
        PackageBuilderConfiguration cfg1 = new PackageBuilderConfiguration(properties);
        Assert.assertEquals((Object)"mvel", (Object)cfg1.getDefaultDialect());
        PackageBuilderConfiguration cfg2 = new PackageBuilderConfiguration(properties);
        Assert.assertEquals(cfg1.getDefaultDialect().getClass(), cfg2.getDefaultDialect().getClass());
    }

    @Test
    public void testProgramaticProperties2() {
        JavaDialectConfiguration javaConf = new JavaDialectConfiguration();
        javaConf.init(new PackageBuilderConfiguration());
        javaConf.setCompiler(0);
        PackageBuilderConfiguration cfg = new PackageBuilderConfiguration();
        cfg.setDialectConfiguration("java", (DialectConfiguration)javaConf);
        JavaDialectConfiguration javaConf2 = (JavaDialectConfiguration)cfg.getDialectConfiguration("java");
        Assert.assertSame((Object)javaConf, (Object)javaConf2);
        Assert.assertEquals((long)0L, (long)javaConf2.getCompiler());
        javaConf = new JavaDialectConfiguration();
        javaConf.init(new PackageBuilderConfiguration());
        javaConf.setCompiler(1);
        cfg = new PackageBuilderConfiguration();
        cfg.setDialectConfiguration("java", (DialectConfiguration)javaConf);
        javaConf2 = (JavaDialectConfiguration)cfg.getDialectConfiguration("java");
        Assert.assertSame((Object)javaConf, (Object)javaConf2);
        Assert.assertEquals((long)1L, (long)javaConf2.getCompiler());
    }

    @Test
    public void testMockDialect() {
        Package pkg = new Package("org.pkg1");
        PackageBuilderConfiguration cfg1 = new PackageBuilderConfiguration();
        MockDialectConfiguration mockConf = new MockDialectConfiguration();
        cfg1.addDialect("mock", (DialectConfiguration)mockConf);
        cfg1.setDefaultDialect("mock");
        PackageBuilder builder = new PackageBuilder(pkg, cfg1);
        PackageRegistry pkgRegistry = builder.getPackageRegistry(pkg.getName());
        DialectCompiletimeRegistry dialectRegistry = pkgRegistry.getDialectCompiletimeRegistry();
        MockDialect mockDialect2 = (MockDialect)dialectRegistry.getDialect(cfg1.getDefaultDialect());
        Assert.assertSame((Object)builder, (Object)mockDialect2.getPackageBuilder());
        Assert.assertSame((Object)pkg, (Object)mockDialect2.getPkg());
        Assert.assertNull((Object)mockDialect2.getRuleDescr());
        RuleDescr ruleDescr = new RuleDescr("test rule");
        ruleDescr.addAttribute(new AttributeDescr("dialect", "mock"));
        ruleDescr.setLhs(new AndDescr());
        EvalDescr evalDescr = new EvalDescr();
        ruleDescr.getLhs().addDescr((BaseDescr)evalDescr);
        PackageDescr pkgDescr = new PackageDescr("org.pkg1");
        pkgDescr.addImport(new ImportDescr("java.util.HashMap"));
        FunctionImportDescr functionImportDescr = new FunctionImportDescr();
        functionImportDescr.setTarget("java.lang.System.currentTimeMillis");
        pkgDescr.addFunctionImport(functionImportDescr);
        pkgDescr.addRule(ruleDescr);
        builder.addPackage(pkgDescr);
        Assert.assertSame((Object)ruleDescr, (Object)mockDialect2.getRuleDescr());
        Assert.assertTrue((boolean)mockDialect2.getImport().contains("java.util.HashMap"));
        Assert.assertTrue((boolean)mockDialect2.getStaticImport().contains("java.lang.System.currentTimeMillis"));
        Assert.assertEquals((Object)"eval was built", (Object)evalDescr.getContent());
        Assert.assertEquals((Object)"consequence was built", (Object)ruleDescr.getConsequence());
        Assert.assertTrue((boolean)mockDialect2.isCompileAll());
        Assert.assertNotNull((Object)pkg.getRule("test rule"));
        Assert.assertFalse((boolean)builder.hasErrors());
    }

    public static class MockConsequenceBuilder
    implements ConsequenceBuilder {
        public void build(RuleBuildContext context, String name) {
            context.getRuleDescr().setConsequence((Object)"consequence was built");
        }
    }

    public static class MockEvalBuilder
    implements RuleConditionBuilder {
        public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
            EvalDescr evalDescr = (EvalDescr)descr;
            evalDescr.setContent((Object)"eval was built");
            return null;
        }

        public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
            return null;
        }
    }

    public static class MockDialect
    implements Dialect {
        private PackageBuilder builder;
        private Package pkg;
        private RuleDescr ruleDescr;
        private Rule rule;
        private List imports = new ArrayList();
        private List staticImports = new ArrayList();
        private boolean compileAll = false;

        public MockDialect(PackageBuilder builder, PackageRegistry pkgRegistry, Package pkg) {
            this.builder = builder;
            this.pkg = pkg;
        }

        public void init(RuleDescr ruleDescr) {
            this.ruleDescr = ruleDescr;
        }

        public PackageBuilder getPackageBuilder() {
            return this.builder;
        }

        public Package getPkg() {
            return this.pkg;
        }

        public RuleDescr getRuleDescr() {
            return this.ruleDescr;
        }

        public void addFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
        }

        public void addImport(String importEntry) {
            this.imports.add(importEntry);
        }

        public List getImport() {
            return this.imports;
        }

        public void addStaticImport(String importEntry) {
            this.imports.add(importEntry);
        }

        public List getStaticImport() {
            return this.imports;
        }

        public void addRule(RuleBuildContext context) {
            this.rule = context.getRule();
        }

        public Rule getRule() {
            return this.rule;
        }

        public void compileAll() {
            this.compileAll = true;
        }

        public boolean isCompileAll() {
            return this.compileAll;
        }

        public AccumulateBuilder getAccumulateBuilder() {
            return null;
        }

        public RuleConditionBuilder getBuilder(Class clazz) {
            if (clazz == EvalDescr.class) {
                return this.getEvalBuilder();
            }
            if (clazz == AndDescr.class) {
                return new GroupElementBuilder();
            }
            throw new RuntimeException("clazz " + clazz + " is not yet configured ");
        }

        public Map getBuilders() {
            return null;
        }

        public ConsequenceBuilder getConsequenceBuilder() {
            return new MockConsequenceBuilder();
        }

        public RuleConditionBuilder getEvalBuilder() {
            return new MockEvalBuilder();
        }

        public String getExpressionDialectName() {
            return null;
        }

        public FromBuilder getFromBuilder() {
            return null;
        }

        public PatternBuilder getPatternBuilder() {
            return null;
        }

        public PredicateBuilder getPredicateBuilder() {
            return null;
        }

        public QueryBuilder getQueryBuilder() {
            return null;
        }

        public List getResults() {
            return null;
        }

        public ReturnValueBuilder getReturnValueBuilder() {
            return null;
        }

        public RuleClassBuilder getRuleClassBuilder() {
            return null;
        }

        public SalienceBuilder getSalienceBuilder() {
            return null;
        }

        public TypeResolver getTypeResolver() {
            return null;
        }

        public String getId() {
            return "mock";
        }

        public void init(ProcessDescr processDescr) {
        }

        public EntryPointBuilder getEntryPointBuilder() {
            return null;
        }

        public void postCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
        }

        public void preCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
        }

        public EnabledBuilder getEnabledBuilder() {
            return null;
        }

        public void addFunction(FunctionDescr functionDescr, TypeResolver typeResolver, Resource resource) {
        }

        public AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, BoundIdentifiers availableIdentifiers) {
            return null;
        }

        public AnalysisResult analyzeBlock(PackageBuildContext context, BaseDescr descr, String text, BoundIdentifiers availableIdentifiers) {
            return null;
        }

        public PackageRegistry getPackageRegistry() {
            return null;
        }
    }

    public static class MockDialectConfiguration
    implements DialectConfiguration {
        private PackageBuilderConfiguration conf;

        public Dialect newDialect(PackageBuilder pkgBuilder, PackageRegistry pkgRegistry, Package pkg) {
            return new MockDialect(pkgBuilder, pkgRegistry, pkg);
        }

        public PackageBuilderConfiguration getPackageBuilderConfiguration() {
            return this.conf;
        }

        public void init(PackageBuilderConfiguration configuration) {
            this.conf = configuration;
        }
    }
}

