/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.changeset;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.ChangeSet;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.DecisionTableConfiguration;
import org.drools.builder.DecisionTableInputType;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.UrlResource;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.xml.XmlChangeSetReader;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class ChangeSetTest {
    @Test
    public void testXmlParser() throws SAXException, IOException {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        XmlChangeSetReader xmlReader = new XmlChangeSetReader(conf.getSemanticModules());
        xmlReader.setClassLoader(ChangeSetTest.class.getClassLoader(), ChangeSetTest.class);
        String str = "";
        str = str + "<change-set ";
        str = str + "xmlns='http://drools.org/drools-5.0/change-set' ";
        str = str + "xmlns:xs='http://www.w3.org/2001/XMLSchema-instance' ";
        str = str + "xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        str = str + "    <add> ";
        str = str + "        <resource source='http://www.domain.com/test.drl' type='DRL' />";
        str = str + "        <resource source='http://www.domain.com/test.xls' type='DTABLE' >";
        str = str + "            <decisiontable-conf worksheet-name='sheet10' input-type='XLS' />";
        str = str + "        </resource>";
        str = str + "    </add> ";
        str = str + "</change-set>";
        StringReader reader = new StringReader(str);
        ChangeSet changeSet = xmlReader.read((Reader)reader);
        Assert.assertEquals((long)2L, (long)changeSet.getResourcesAdded().size());
        UrlResource resource = (UrlResource)((List)changeSet.getResourcesAdded()).get(0);
        Assert.assertNull((Object)resource.getConfiguration());
        Assert.assertEquals((Object)"http://www.domain.com/test.drl", (Object)resource.getURL().toString());
        Assert.assertEquals((Object)ResourceType.DRL, (Object)resource.getResourceType());
        resource = (UrlResource)((List)changeSet.getResourcesAdded()).get(1);
        Assert.assertEquals((Object)"http://www.domain.com/test.xls", (Object)resource.getURL().toString());
        Assert.assertEquals((Object)ResourceType.DTABLE, (Object)resource.getResourceType());
        DecisionTableConfiguration dtConf = (DecisionTableConfiguration)resource.getConfiguration();
        Assert.assertEquals((Object)DecisionTableInputType.XLS, (Object)dtConf.getInputType());
    }

    @Test
    public void testIntegregation() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"changeset1Test.xml", this.getClass()), ResourceType.CHANGE_SET);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList("rule1", "rule2")));
    }

    @Test
    public void testBasicAuthentication() throws SAXException, IOException {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        XmlChangeSetReader xmlReader = new XmlChangeSetReader(conf.getSemanticModules());
        xmlReader.setClassLoader(ChangeSetTest.class.getClassLoader(), ChangeSetTest.class);
        String str = "";
        str = str + "<change-set ";
        str = str + "xmlns='http://drools.org/drools-5.0/change-set' ";
        str = str + "xmlns:xs='http://www.w3.org/2001/XMLSchema-instance' ";
        str = str + "xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        str = str + "    <add> ";
        str = str + "        <resource source='http://localhost:8081/jboss-brms/org.drools.guvnor.Guvnor/package/defaultPackage/LATEST' type='PKG' basicAuthentication='enabled' username='admin' password='pwd'/>";
        str = str + "    </add> ";
        str = str + "</change-set>";
        StringReader reader = new StringReader(str);
        ChangeSet changeSet = xmlReader.read((Reader)reader);
        Assert.assertEquals((long)1L, (long)changeSet.getResourcesAdded().size());
        UrlResource resource = (UrlResource)((List)changeSet.getResourcesAdded()).get(0);
        Assert.assertNull((Object)resource.getConfiguration());
        Assert.assertEquals((Object)"http://localhost:8081/jboss-brms/org.drools.guvnor.Guvnor/package/defaultPackage/LATEST", (Object)resource.getURL().toString());
        Assert.assertEquals((Object)"enabled", (Object)resource.getBasicAuthentication());
        Assert.assertEquals((Object)"admin", (Object)resource.getUsername());
        Assert.assertEquals((Object)"pwd", (Object)resource.getPassword());
        Assert.assertEquals((Object)ResourceType.PKG, (Object)resource.getResourceType());
    }
}

