/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.definition.type.FactType;
import org.drools.factmodel.traits.Entity;
import org.drools.factmodel.traits.TraitFactory;
import org.drools.factmodel.traits.TraitProxy;
import org.drools.factmodel.traits.TraitRegistry;
import org.drools.factmodel.traits.TraitableBean;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TraitTest {
    private static long t0;

    @BeforeClass
    public static void init() {
        t0 = new Date().getTime();
    }

    @AfterClass
    public static void finish() {
        System.out.println("TIME : " + (new Date().getTime() - t0));
    }

    @Before
    public void reset() {
        TraitRegistry.reset();
        TraitFactory.reset();
    }

    @Test
    public void testTraitWrapper_GetAndSet() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        try {
            FactType impClass = kb.getFactType("org.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            Class trait = kb.getFactType("org.test", "Student").getFactClass();
            TraitProxy proxy = (TraitProxy)new TraitFactory(kb).getProxy(imp, trait);
            Map virtualFields = imp.getDynamicProperties();
            Map wrapper = proxy.getFields();
            wrapper.put("name", "john");
            wrapper.put("virtualField", "xyz");
            wrapper.entrySet();
            Assert.assertEquals((int)4, (int)wrapper.size());
            Assert.assertEquals((int)2, (int)virtualFields.size());
            Assert.assertEquals((Object)"john", wrapper.get("name"));
            Assert.assertEquals((Object)"xyz", wrapper.get("virtualField"));
            Assert.assertEquals((Object)"john", (Object)impClass.get((Object)imp, "name"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTraitShed() {
        String source = "org/drools/factmodel/traits/testTraitShed.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = kb.newStatefulKnowledgeSession();
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        Assert.assertTrue((boolean)info.isEmpty());
        ks.fireAllRules();
        Assert.assertTrue((boolean)info.contains("Student"));
        Assert.assertEquals((int)1, (int)info.size());
        ks.insert((Object)"hire");
        ks.fireAllRules();
        Collection c = ks.getObjects();
        Assert.assertTrue((boolean)info.contains("Worker"));
        Assert.assertEquals((int)2, (int)info.size());
        ks.insert((Object)"check");
        ks.fireAllRules();
        Assert.assertEquals((int)4, (int)info.size());
        Assert.assertTrue((boolean)info.contains("Conflict"));
        Assert.assertTrue((boolean)info.contains("Nothing"));
    }

    @Test
    public void testTraitDon() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = kb.newStatefulKnowledgeSession();
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        Collection wm = ks.getObjects();
        ks.insert((Object)"die");
        ks.fireAllRules();
        Assert.assertTrue((boolean)info.contains("DON"));
        Assert.assertTrue((boolean)info.contains("SHED"));
    }

    @Test
    public void testMixin() {
        String source = "org/drools/factmodel/traits/testTraitMixin.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = kb.newStatefulKnowledgeSession();
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        Assert.assertTrue((boolean)info.contains("27"));
    }

    @Test
    public void testTraitMethodsWithObjects() {
        String source = "org/drools/factmodel/traits/testTraitWrapping.drl";
        Character c = Character.valueOf('\u0000');
        System.out.println(">>>>" + c + "<<<<");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = kb.newStatefulKnowledgeSession();
        ArrayList errors = new ArrayList();
        ks.setGlobal("list", errors);
        ks.fireAllRules();
        if (!errors.isEmpty()) {
            System.err.println(((Object)errors).toString());
        }
        Assert.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void testTraitMethodsWithPrimitives() {
        String source = "org/drools/factmodel/traits/testTraitWrappingPrimitives.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = kb.newStatefulKnowledgeSession();
        ArrayList errors = new ArrayList();
        ks.setGlobal("list", errors);
        ks.fireAllRules();
        if (!errors.isEmpty()) {
            System.err.println(errors);
        }
        Assert.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void testTraitProxy() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        TraitFactory traitBuilder = new TraitFactory(kb);
        try {
            FactType impClass = kb.getFactType("org.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            impClass.set((Object)imp, "name", (Object)"aaa");
            Class trait = kb.getFactType("org.test", "Student").getFactClass();
            Class trait2 = kb.getFactType("org.test", "Role").getFactClass();
            Assert.assertNotNull((Object)trait);
            TraitProxy proxy = (TraitProxy)traitBuilder.getProxy(imp, trait);
            proxy.getFields().put("field", "xyz");
            Assert.assertNotNull((Object)proxy);
            TraitProxy proxy2 = (TraitProxy)traitBuilder.getProxy(imp, trait);
            Assert.assertSame((Object)proxy2, (Object)proxy);
            TraitProxy proxy3 = (TraitProxy)traitBuilder.getProxy(imp, trait2);
            Assert.assertNotNull((Object)proxy3);
            Assert.assertEquals((Object)"xyz", proxy3.getFields().get("field"));
            Assert.assertEquals((Object)"aaa", proxy3.getFields().get("name"));
            TraitableBean imp2 = (TraitableBean)impClass.newInstance();
            impClass.set((Object)imp2, "name", (Object)"aaa");
            TraitProxy proxy4 = (TraitProxy)traitBuilder.getProxy(imp2, trait);
            proxy4.getFields().put("field", "xyz");
            Assert.assertEquals((Object)proxy2, (Object)proxy4);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTraitWrapper_Size() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        TraitFactory traitBuilder = new TraitFactory(kb);
        try {
            FactType impClass = kb.getFactType("org.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            FactType traitClass = kb.getFactType("org.test", "Student");
            Class trait = traitClass.getFactClass();
            TraitProxy proxy = (TraitProxy)traitBuilder.getProxy(imp, trait);
            Map virtualFields = imp.getDynamicProperties();
            Map wrapper = proxy.getFields();
            Assert.assertEquals((int)3, (int)wrapper.size());
            Assert.assertEquals((int)1, (int)virtualFields.size());
            impClass.set((Object)imp, "name", (Object)"john");
            Assert.assertEquals((int)3, (int)wrapper.size());
            Assert.assertEquals((int)1, (int)virtualFields.size());
            proxy.getFields().put("school", "skol");
            Assert.assertEquals((int)3, (int)wrapper.size());
            Assert.assertEquals((int)1, (int)virtualFields.size());
            proxy.getFields().put("surname", "xxx");
            Assert.assertEquals((int)4, (int)wrapper.size());
            Assert.assertEquals((int)2, (int)virtualFields.size());
            Entity ind = new Entity();
            TraitProxy proxy2 = (TraitProxy)traitBuilder.getProxy((TraitableBean)ind, trait);
            Map virtualFields2 = ind.getDynamicProperties();
            Map wrapper2 = proxy2.getFields();
            Assert.assertEquals((int)3, (int)wrapper2.size());
            Assert.assertEquals((int)3, (int)virtualFields2.size());
            traitClass.set((Object)proxy2, "name", (Object)"john");
            Assert.assertEquals((int)3, (int)wrapper2.size());
            Assert.assertEquals((int)3, (int)virtualFields2.size());
            proxy2.getFields().put("school", "skol");
            Assert.assertEquals((int)3, (int)wrapper2.size());
            Assert.assertEquals((int)3, (int)virtualFields2.size());
            proxy2.getFields().put("surname", "xxx");
            Assert.assertEquals((int)4, (int)wrapper2.size());
            Assert.assertEquals((int)4, (int)virtualFields2.size());
            FactType traitClass2 = kb.getFactType("org.test", "Role");
            Class trait2 = traitClass2.getFactClass();
            Entity ind2 = new Entity();
            TraitProxy proxy99 = (TraitProxy)traitBuilder.getProxy((TraitableBean)ind2, trait2);
            proxy99.getFields().put("surname", "xxx");
            proxy99.getFields().put("name", "xyz");
            proxy99.getFields().put("school", "skol");
            Assert.assertEquals((int)3, (int)proxy99.getFields().size());
            TraitProxy proxy100 = (TraitProxy)traitBuilder.getProxy((TraitableBean)ind2, trait);
            Assert.assertEquals((int)4, (int)proxy100.getFields().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTraitWrapper_IsEmpty() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        TraitFactory traitBuilder = new TraitFactory(kb);
        try {
            FactType impClass = kb.getFactType("org.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            FactType studentClass = kb.getFactType("org.test", "Student");
            Class trait = studentClass.getFactClass();
            TraitProxy proxy = (TraitProxy)traitBuilder.getProxy(imp, trait);
            Map virtualFields = imp.getDynamicProperties();
            Map wrapper = proxy.getFields();
            Assert.assertFalse((boolean)wrapper.isEmpty());
            studentClass.set((Object)proxy, "name", (Object)"john");
            Assert.assertFalse((boolean)wrapper.isEmpty());
            studentClass.set((Object)proxy, "name", null);
            Assert.assertFalse((boolean)wrapper.isEmpty());
            studentClass.set((Object)proxy, "age", (Object)32);
            Assert.assertFalse((boolean)wrapper.isEmpty());
            studentClass.set((Object)proxy, "age", null);
            Assert.assertFalse((boolean)wrapper.isEmpty());
            Entity ind = new Entity();
            FactType RoleClass = kb.getFactType("org.test", "Role");
            Class trait2 = RoleClass.getFactClass();
            TraitProxy proxy2 = (TraitProxy)traitBuilder.getProxy((TraitableBean)ind, trait2);
            Map wrapper2 = proxy2.getFields();
            Assert.assertTrue((boolean)wrapper2.isEmpty());
            proxy2.getFields().put("name", "john");
            Assert.assertFalse((boolean)wrapper2.isEmpty());
            proxy2.getFields().put("name", null);
            Assert.assertFalse((boolean)wrapper2.isEmpty());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTraitWrapper_ContainsKey() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        TraitFactory traitBuilder = new TraitFactory(kb);
        try {
            FactType impClass = kb.getFactType("org.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            impClass.set((Object)imp, "name", (Object)"john");
            FactType traitClass = kb.getFactType("org.test", "Student");
            Class trait = traitClass.getFactClass();
            TraitProxy proxy = (TraitProxy)traitBuilder.getProxy(imp, trait);
            Map virtualFields = imp.getDynamicProperties();
            Map wrapper = proxy.getFields();
            Assert.assertTrue((boolean)wrapper.containsKey("name"));
            Assert.assertTrue((boolean)wrapper.containsKey("school"));
            Assert.assertTrue((boolean)wrapper.containsKey("age"));
            Assert.assertFalse((boolean)wrapper.containsKey("surname"));
            proxy.getFields().put("school", "skol");
            proxy.getFields().put("surname", "xxx");
            Assert.assertTrue((boolean)wrapper.containsKey("surname"));
            Entity ind = new Entity();
            TraitProxy proxy2 = (TraitProxy)traitBuilder.getProxy((TraitableBean)ind, trait);
            Map virtualFields2 = ind.getDynamicProperties();
            Map wrapper2 = proxy2.getFields();
            Assert.assertTrue((boolean)wrapper2.containsKey("name"));
            Assert.assertTrue((boolean)wrapper2.containsKey("school"));
            Assert.assertTrue((boolean)wrapper2.containsKey("age"));
            Assert.assertFalse((boolean)wrapper2.containsKey("surname"));
            traitClass.set((Object)proxy2, "name", (Object)"john");
            proxy2.getFields().put("school", "skol");
            proxy2.getFields().put("surname", "xxx");
            Assert.assertTrue((boolean)wrapper2.containsKey("surname"));
            FactType traitClass2 = kb.getFactType("org.test", "Role");
            Class trait2 = traitClass2.getFactClass();
            Entity ind2 = new Entity();
            TraitProxy proxy99 = (TraitProxy)traitBuilder.getProxy((TraitableBean)ind2, trait2);
            Map wrapper99 = proxy99.getFields();
            Assert.assertFalse((boolean)wrapper99.containsKey("name"));
            Assert.assertFalse((boolean)wrapper99.containsKey("school"));
            Assert.assertFalse((boolean)wrapper99.containsKey("age"));
            Assert.assertFalse((boolean)wrapper99.containsKey("surname"));
            proxy99.getFields().put("surname", "xxx");
            proxy99.getFields().put("name", "xyz");
            proxy99.getFields().put("school", "skol");
            Assert.assertTrue((boolean)wrapper99.containsKey("name"));
            Assert.assertTrue((boolean)wrapper99.containsKey("school"));
            Assert.assertFalse((boolean)wrapper99.containsKey("age"));
            Assert.assertTrue((boolean)wrapper99.containsKey("surname"));
            Assert.assertEquals((int)3, (int)proxy99.getFields().size());
            Entity ind0 = new Entity();
            TraitProxy proxy100 = (TraitProxy)traitBuilder.getProxy((TraitableBean)ind0, trait2);
            Map wrapper100 = proxy100.getFields();
            Assert.assertFalse((boolean)wrapper100.containsKey("name"));
            Assert.assertFalse((boolean)wrapper100.containsKey("school"));
            Assert.assertFalse((boolean)wrapper100.containsKey("age"));
            Assert.assertFalse((boolean)wrapper100.containsKey("surname"));
            TraitProxy proxy101 = (TraitProxy)traitBuilder.getProxy((TraitableBean)ind0, trait);
            Assert.assertTrue((boolean)wrapper100.containsKey("name"));
            Assert.assertTrue((boolean)wrapper100.containsKey("school"));
            Assert.assertTrue((boolean)wrapper100.containsKey("age"));
            Assert.assertFalse((boolean)wrapper100.containsKey("surname"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTraitWrapper_keySetAndValues() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        TraitFactory traitBuilder = new TraitFactory(kb);
        try {
            FactType impClass = kb.getFactType("org.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            FactType traitClass = kb.getFactType("org.test", "Student");
            Class trait = traitClass.getFactClass();
            TraitProxy proxy = (TraitProxy)traitBuilder.getProxy(imp, trait);
            impClass.set((Object)imp, "name", (Object)"john");
            proxy.getFields().put("surname", "xxx");
            proxy.getFields().put("name2", "john");
            proxy.getFields().put("nfield", null);
            HashSet<String> set = new HashSet<String>();
            set.add("name");
            set.add("surname");
            set.add("age");
            set.add("school");
            set.add("name2");
            set.add("nfield");
            Assert.assertEquals((int)6, (int)proxy.getFields().keySet().size());
            Assert.assertEquals(set, proxy.getFields().keySet());
            Collection col1 = proxy.getFields().values();
            List<Serializable> col2 = Arrays.asList("john", null, 0, "xxx", "john", null);
            Comparator comp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 == null && o2 != null) {
                        return 1;
                    }
                    if (o1 != null && o2 == null) {
                        return -1;
                    }
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    return o1.toString().compareTo(o2.toString());
                }
            };
            Collections.sort((List)col1, comp);
            Collections.sort(col2, comp);
            Assert.assertEquals(col1, col2);
            Assert.assertTrue((boolean)proxy.getFields().containsValue(null));
            Assert.assertTrue((boolean)proxy.getFields().containsValue("john"));
            Assert.assertTrue((boolean)proxy.getFields().containsValue(0));
            Assert.assertTrue((boolean)proxy.getFields().containsValue("xxx"));
            Assert.assertFalse((boolean)proxy.getFields().containsValue("randomString"));
            Assert.assertFalse((boolean)proxy.getFields().containsValue(-96));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTraitWrapper_ClearAndRemove() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        TraitFactory traitBuilder = new TraitFactory(kb);
        try {
            FactType impClass = kb.getFactType("org.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            impClass.set((Object)imp, "name", (Object)"john");
            FactType traitClass = kb.getFactType("org.test", "Student");
            Class trait = traitClass.getFactClass();
            TraitProxy proxy = (TraitProxy)traitBuilder.getProxy(imp, trait);
            proxy.getFields().put("surname", "xxx");
            proxy.getFields().put("name2", "john");
            proxy.getFields().put("nfield", null);
            HashSet<String> set = new HashSet<String>();
            set.add("name");
            set.add("surname");
            set.add("age");
            set.add("school");
            set.add("name2");
            set.add("nfield");
            Assert.assertEquals((int)6, (int)proxy.getFields().keySet().size());
            Assert.assertEquals(set, proxy.getFields().keySet());
            proxy.getFields().clear();
            Map fields = proxy.getFields();
            Assert.assertEquals((int)3, (int)fields.size());
            Assert.assertTrue((boolean)fields.containsKey("age"));
            Assert.assertTrue((boolean)fields.containsKey("school"));
            Assert.assertTrue((boolean)fields.containsKey("name"));
            Assert.assertEquals((Object)0, fields.get("age"));
            Assert.assertNull(fields.get("school"));
            Assert.assertNotNull(fields.get("name"));
            proxy.getFields().put("surname", "xxx");
            proxy.getFields().put("name2", "john");
            proxy.getFields().put("nfield", null);
            proxy.getFields().put("age", 24);
            Assert.assertEquals((Object)"john", proxy.getFields().get("name"));
            Assert.assertEquals((Object)"xxx", proxy.getFields().get("surname"));
            Assert.assertEquals((Object)"john", proxy.getFields().get("name2"));
            Assert.assertEquals(null, proxy.getFields().get("nfield"));
            Assert.assertEquals((Object)24, proxy.getFields().get("age"));
            Assert.assertEquals(null, proxy.getFields().get("school"));
            proxy.getFields().remove("surname");
            proxy.getFields().remove("name2");
            proxy.getFields().remove("age");
            proxy.getFields().remove("school");
            proxy.getFields().remove("nfield");
            Assert.assertEquals((int)3, (int)proxy.getFields().size());
            Assert.assertEquals((Object)0, proxy.getFields().get("age"));
            Assert.assertEquals(null, proxy.getFields().get("school"));
            Assert.assertEquals((Object)"john", proxy.getFields().get("name"));
            Assert.assertEquals(null, proxy.getFields().get("nfield"));
            Assert.assertFalse((boolean)proxy.getFields().containsKey("nfield"));
            Assert.assertEquals(null, proxy.getFields().get("name2"));
            Assert.assertFalse((boolean)proxy.getFields().containsKey("name2"));
            Assert.assertEquals(null, proxy.getFields().get("surname"));
            Assert.assertFalse((boolean)proxy.getFields().containsKey("surname"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIsA() {
        String source = "org/drools/factmodel/traits/testTraitIsA.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = kb.newStatefulKnowledgeSession();
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        int num = 10;
        System.out.println(info);
        Assert.assertEquals((int)num, (int)info.size());
        for (int j = 0; j < num; ++j) {
            Assert.assertTrue((boolean)info.contains("" + j));
        }
    }

    @Test
    public void testTraitOverrideType() {
        String source = "org/drools/factmodel/traits/testTraitOverride.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = kb.newStatefulKnowledgeSession();
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        Collection wm = ks.getObjects();
        Assert.assertTrue((boolean)info.contains("OK"));
    }

    @Test
    public void testTraitLegacy() {
        String source = "org/drools/factmodel/traits/testTraitLegacyTrait.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = kb.newStatefulKnowledgeSession();
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        System.err.println(" -------------- " + ks.getObjects().size() + " ---------------- ");
        for (Object o : ks.getObjects()) {
            System.err.println("\t\t" + o);
        }
        System.err.println(" --------------  ---------------- ");
        System.err.println(info);
        System.err.println(" --------------  ---------------- ");
        Assert.assertEquals((int)5, (int)info.size());
        Assert.assertTrue((boolean)info.contains("OK"));
        Assert.assertTrue((boolean)info.contains("OK2"));
        Assert.assertTrue((boolean)info.contains("OK3"));
        Assert.assertTrue((boolean)info.contains("OK4"));
        Assert.assertTrue((boolean)info.contains("OK5"));
    }

    @Test
    public void testTraitCollections() {
        String source = "org/drools/factmodel/traits/testTraitCollections.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = kb.newStatefulKnowledgeSession();
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        System.err.println(" -------------- " + ks.getObjects().size() + " ---------------- ");
        for (Object o : ks.getObjects()) {
            System.err.println("\t\t" + o);
        }
        System.err.println(" --------------  ---------------- ");
        System.err.println(info);
        System.err.println(" --------------  ---------------- ");
        Assert.assertEquals((int)1, (int)info.size());
        Assert.assertTrue((boolean)info.contains("OK"));
    }

    @Test
    public void testTraitCore() {
        String source = "org/drools/factmodel/traits/testTraitLegacyCore.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = kb.newStatefulKnowledgeSession();
        ArrayList info = new ArrayList();
        ks.setGlobal("list", info);
        ks.fireAllRules();
        System.err.println(" -------------- " + ks.getObjects().size() + " ---------------- ");
        for (Object o : ks.getObjects()) {
            System.err.println("\t\t" + o);
        }
        System.err.println(" --------------  ---------------- ");
        System.err.println(info);
        System.err.println(" --------------  ---------------- ");
        Assert.assertTrue((boolean)info.contains("OK"));
        Assert.assertTrue((boolean)info.contains("OK2"));
        Assert.assertEquals((int)2, (int)info.size());
    }
}

