/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.util.Date;
import junit.framework.Assert;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.definition.type.FactType;
import org.drools.factmodel.traits.Thing;
import org.drools.factmodel.traits.TraitFactory;
import org.drools.factmodel.traits.TraitProxy;
import org.drools.factmodel.traits.TraitRegistry;
import org.drools.factmodel.traits.TraitableBean;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TripleBasedTraitsTest {
    static long t0;

    @BeforeClass
    public static void init() {
        t0 = new Date().getTime();
    }

    @AfterClass
    public static void finish() {
        System.out.println("TIME : " + (new Date().getTime() - t0));
    }

    @Before
    public void reset() {
        TraitRegistry.reset();
        TraitFactory.reset();
    }

    @Test
    public void testRdfsTypes() {
        String source = "org/drools/factmodel/traits/testTraitDon.drl";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resource res = ResourceFactory.newClassPathResource((String)source);
        Assert.assertNotNull((Object)res);
        kbuilder.add(res, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        TraitFactory traitBuilder = new TraitFactory(kb);
        try {
            FactType impClass = kb.getFactType("org.test", "Imp");
            TraitableBean imp = (TraitableBean)impClass.newInstance();
            impClass.set((Object)imp, "name", (Object)"aaabcd");
            Class trait = kb.getFactType("org.test", "Student").getFactClass();
            Class trait2 = kb.getFactType("org.test", "Role").getFactClass();
            Assert.assertNotNull((Object)trait);
            TraitProxy proxy = (TraitProxy)traitBuilder.getProxy(imp, trait);
            Thing thing = traitBuilder.getProxy(imp, Thing.class);
            TraitableBean core = (TraitableBean)proxy.getObject();
            TraitProxy proxy2 = (TraitProxy)traitBuilder.getProxy(imp, trait);
            Thing thing2 = traitBuilder.getProxy(imp, Thing.class);
            Assert.assertSame((Object)proxy, (Object)proxy2);
            Assert.assertSame((Object)thing, (Object)thing2);
            Assert.assertEquals((int)2, (int)core.getTraits().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

