/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.util.ArrayList;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Primitives;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.junit.Assert;
import org.junit.Test;

public class ArrayContainsTest {
    @Test
    public void testContainsBooleanArray() throws Exception {
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "global java.util.List list;\n";
        str = str + "global Boolean bGlobal;\n";
        str = str + "global Object bArrayGlobal;\n";
        str = str + "rule \"contains in array\"\n";
        str = str + "     salience 10\n";
        str = str + "     when\n";
        str = str + "         Primitives( $b : booleanPrimitive == true, $array1 :  primitiveBooleanArray ) \n";
        str = str + "         Primitives( booleanPrimitive == false, $array2 : primitiveBooleanArray contains bGlobal,  primitiveBooleanArray contains $b, ";
        str = str + "                     booleanPrimitive memberOf $array2, booleanPrimitive memberOf $array1, booleanPrimitive memberOf bArrayGlobal )\n";
        str = str + "     then\n";
        str = str + "        list.add( \"ok1\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)("kbuilder has errors\n:" + kbuilder.getErrors()));
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("bGlobal", (Object)true);
        ksession.setGlobal("bArrayGlobal", (Object)new boolean[]{true, false});
        Primitives p1 = new Primitives();
        p1.setPrimitiveBooleanArray(new boolean[]{true, false});
        p1.setBooleanPrimitive(false);
        FactHandle p1h = ksession.insert((Object)p1);
        Primitives p2 = new Primitives();
        p2.setPrimitiveBooleanArray(new boolean[]{true, false});
        p2.setBooleanPrimitive(true);
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.retract(p1h);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testNotContainsBooleanArray() throws Exception {
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "global java.util.List list;\n";
        str = str + "global Boolean bGlobal;\n";
        str = str + "global Object bArrayGlobal;\n";
        str = str + "rule \"contains in array\"\n";
        str = str + "     salience 10\n";
        str = str + "     when\n";
        str = str + "         Primitives( $b : booleanPrimitive, intPrimitive == 10, $array1 :  primitiveBooleanArray ) \n";
        str = str + "         Primitives( booleanPrimitive == false, intPrimitive != 10, $array2 : primitiveBooleanArray not contains bGlobal,  primitiveBooleanArray not contains $b, ";
        str = str + "                     booleanPrimitive not memberOf $array2, booleanPrimitive not memberOf $array1, booleanPrimitive not memberOf bArrayGlobal )\n";
        str = str + "     then\n";
        str = str + "        list.add( \"ok1\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)("kbuilder has errors\n:" + kbuilder.getErrors()));
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("bGlobal", (Object)false);
        ksession.setGlobal("bArrayGlobal", (Object)new boolean[]{true, true});
        Primitives p1 = new Primitives();
        p1.setIntPrimitive(10);
        p1.setPrimitiveBooleanArray(new boolean[]{true, true});
        p1.setBooleanPrimitive(false);
        FactHandle p1h = ksession.insert((Object)p1);
        Primitives p2 = new Primitives();
        p2.setPrimitiveBooleanArray(new boolean[]{true, true});
        p2.setBooleanPrimitive(false);
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.retract(p1h);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testContainsByteArray() throws Exception {
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "global java.util.List list;\n";
        str = str + "global Byte bGlobal;\n";
        str = str + "global Object bArrayGlobal;\n";
        str = str + "rule \"contains in array\"\n";
        str = str + "     salience 10\n";
        str = str + "     when\n";
        str = str + "         Primitives( $b : bytePrimitive == 1, $array1 :  primitiveByteArray ) \n";
        str = str + "         Primitives( bytePrimitive != 1, $array2 : primitiveByteArray contains bGlobal,  primitiveByteArray contains $b, ";
        str = str + "                     bytePrimitive memberOf $array2, bytePrimitive memberOf $array1, bytePrimitive memberOf bArrayGlobal )\n";
        str = str + "     then\n";
        str = str + "        list.add( \"ok1\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)("kbuilder has errors\n:" + kbuilder.getErrors()));
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("bGlobal", (Object)1);
        ksession.setGlobal("bArrayGlobal", (Object)new byte[]{1, 2, 3});
        Primitives p1 = new Primitives();
        p1.setPrimitiveByteArray(new byte[]{1, 2, 3});
        p1.setBytePrimitive((byte)2);
        FactHandle p1h = ksession.insert((Object)p1);
        Primitives p2 = new Primitives();
        p2.setPrimitiveByteArray(new byte[]{1, 2, 3});
        p2.setBytePrimitive((byte)1);
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.retract(p1h);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testNotContainsByteArray() throws Exception {
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "global java.util.List list;\n";
        str = str + "global Byte bGlobal;\n";
        str = str + "global Object bArrayGlobal;\n";
        str = str + "rule \"contains in array\"\n";
        str = str + "     salience 10\n";
        str = str + "     when\n";
        str = str + "         Primitives( $b : bytePrimitive == 1, $array1 :  primitiveByteArray ) \n";
        str = str + "         Primitives( bytePrimitive != 1, $array2 : primitiveByteArray not contains bGlobal,  primitiveByteArray not contains $b, ";
        str = str + "                     bytePrimitive not memberOf $array2, bytePrimitive not memberOf $array1, bytePrimitive not memberOf bArrayGlobal )\n";
        str = str + "     then\n";
        str = str + "        list.add( \"ok1\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)("kbuilder has errors\n:" + kbuilder.getErrors()));
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("bGlobal", (Object)1);
        ksession.setGlobal("bArrayGlobal", (Object)new byte[]{4, 5, 6});
        Primitives p1 = new Primitives();
        p1.setPrimitiveByteArray(new byte[]{4, 5, 6});
        p1.setBytePrimitive((byte)2);
        FactHandle p1h = ksession.insert((Object)p1);
        Primitives p2 = new Primitives();
        p2.setPrimitiveByteArray(new byte[]{4, 5, 6});
        p2.setBytePrimitive((byte)1);
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.retract(p1h);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testContainsShortArray() throws Exception {
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "global java.util.List list;\n";
        str = str + "global Short sGlobal;\n";
        str = str + "global Object sArrayGlobal;\n";
        str = str + "rule \"contains in array\"\n";
        str = str + "     salience 10\n";
        str = str + "     when\n";
        str = str + "         Primitives( $s : shortPrimitive == 1, $array1 :  primitiveShortArray ) \n";
        str = str + "         Primitives( shortPrimitive != 1, $array2 : primitiveShortArray contains sGlobal,  primitiveShortArray contains $s, ";
        str = str + "                     shortPrimitive memberOf $array2, shortPrimitive memberOf $array1, shortPrimitive memberOf sArrayGlobal )\n";
        str = str + "     then\n";
        str = str + "        list.add( \"ok1\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)("kbuilder has errors\n:" + kbuilder.getErrors()));
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("sGlobal", (Object)1);
        ksession.setGlobal("sArrayGlobal", (Object)new short[]{1, 2, 3});
        Primitives p1 = new Primitives();
        p1.setPrimitiveShortArray(new short[]{1, 2, 3});
        p1.setShortPrimitive((short)2);
        FactHandle p1h = ksession.insert((Object)p1);
        Primitives p2 = new Primitives();
        p2.setPrimitiveShortArray(new short[]{1, 2, 3});
        p2.setShortPrimitive((short)1);
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.retract(p1h);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testNotContainsShortArray() throws Exception {
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "global java.util.List list;\n";
        str = str + "global Short sGlobal;\n";
        str = str + "global Object sArrayGlobal;\n";
        str = str + "rule \"contains in array\"\n";
        str = str + "     salience 10\n";
        str = str + "     when\n";
        str = str + "         Primitives( $s : shortPrimitive == 1, $array1 :  primitiveShortArray ) \n";
        str = str + "         Primitives( shortPrimitive != 1, $array2 : primitiveShortArray not contains sGlobal,  primitiveShortArray not contains $s, ";
        str = str + "                     shortPrimitive not memberOf $array2, shortPrimitive not memberOf $array1, shortPrimitive not memberOf sArrayGlobal )\n";
        str = str + "     then\n";
        str = str + "        list.add( \"ok1\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)("kbuilder has errors\n:" + kbuilder.getErrors()));
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("sGlobal", (Object)1);
        ksession.setGlobal("sArrayGlobal", (Object)new short[]{4, 5, 6});
        Primitives p1 = new Primitives();
        p1.setPrimitiveShortArray(new short[]{4, 5, 6});
        p1.setShortPrimitive((short)2);
        FactHandle p1h = ksession.insert((Object)p1);
        Primitives p2 = new Primitives();
        p2.setPrimitiveShortArray(new short[]{4, 5, 6});
        p2.setShortPrimitive((short)1);
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.retract(p1h);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testContainsCharArray() throws Exception {
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "global java.util.List list;\n";
        str = str + "global Character cGlobal;\n";
        str = str + "global Object cArrayGlobal;\n";
        str = str + "rule \"contains in array\"\n";
        str = str + "     salience 10\n";
        str = str + "     when\n";
        str = str + "         Primitives( $c : charPrimitive == 'c', $array1 :  primitiveCharArray ) \n";
        str = str + "         Primitives( charPrimitive != 'c', $array2 : primitiveCharArray contains cGlobal,  primitiveCharArray contains $c, ";
        str = str + "                     charPrimitive memberOf $array2, charPrimitive memberOf $array1, charPrimitive memberOf cArrayGlobal )\n";
        str = str + "     then\n";
        str = str + "        list.add( \"ok1\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)("kbuilder has errors\n:" + kbuilder.getErrors()));
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("cGlobal", (Object)Character.valueOf('c'));
        ksession.setGlobal("cArrayGlobal", (Object)new char[]{'a', 'b', 'c'});
        Primitives p1 = new Primitives();
        p1.setPrimitiveCharArray(new char[]{'a', 'b', 'c'});
        p1.setCharPrimitive('a');
        FactHandle p1h = ksession.insert((Object)p1);
        Primitives p2 = new Primitives();
        p2.setPrimitiveCharArray(new char[]{'a', 'b', 'c'});
        p2.setCharPrimitive('c');
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.retract(p1h);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testNotContainsCharArray() throws Exception {
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "global java.util.List list;\n";
        str = str + "global Character cGlobal;\n";
        str = str + "global Object cArrayGlobal;\n";
        str = str + "rule \"contains in array\"\n";
        str = str + "     salience 10\n";
        str = str + "     when\n";
        str = str + "         Primitives( $c : charPrimitive == 'c', $array1 :  primitiveCharArray ) \n";
        str = str + "         Primitives( charPrimitive != 'c', $array2 : primitiveCharArray not contains cGlobal,  primitiveCharArray not contains $c, ";
        str = str + "                     charPrimitive not memberOf $array2, charPrimitive not memberOf $array1, charPrimitive not memberOf cArrayGlobal )\n";
        str = str + "     then\n";
        str = str + "        list.add( \"ok1\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)("kbuilder has errors\n:" + kbuilder.getErrors()));
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("cGlobal", (Object)Character.valueOf('c'));
        ksession.setGlobal("cArrayGlobal", (Object)new char[]{'d', 'e', 'f'});
        Primitives p1 = new Primitives();
        p1.setPrimitiveCharArray(new char[]{'d', 'e', 'f'});
        p1.setCharPrimitive('a');
        FactHandle p1h = ksession.insert((Object)p1);
        Primitives p2 = new Primitives();
        p2.setPrimitiveCharArray(new char[]{'d', 'e', 'f'});
        p2.setCharPrimitive('c');
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.retract(p1h);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testContainsIntArray() throws Exception {
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "global java.util.List list;\n";
        str = str + "global Integer iGlobal;\n";
        str = str + "global Object iArrayGlobal;\n";
        str = str + "rule \"contains in array\"\n";
        str = str + "     salience 10\n";
        str = str + "     when\n";
        str = str + "         Primitives( $i : intPrimitive == 10, $array1 :  primitiveIntArray ) \n";
        str = str + "         Primitives( intPrimitive != 10, $array2 : primitiveIntArray contains iGlobal,  primitiveIntArray contains $i, ";
        str = str + "                     intPrimitive memberOf $array2, intPrimitive memberOf $array1, intPrimitive memberOf iArrayGlobal )\n";
        str = str + "     then\n";
        str = str + "        list.add( \"ok1\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)("kbuilder has errors\n:" + kbuilder.getErrors()));
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("iGlobal", (Object)10);
        ksession.setGlobal("iArrayGlobal", (Object)new int[]{5, 10, 20});
        Primitives p1 = new Primitives();
        p1.setPrimitiveIntArray(new int[]{5, 10, 20});
        p1.setIntPrimitive(5);
        FactHandle p1h = ksession.insert((Object)p1);
        Primitives p2 = new Primitives();
        p2.setPrimitiveIntArray(new int[]{5, 10, 20});
        p2.setIntPrimitive(10);
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.retract(p1h);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testNotContainsIntArray() throws Exception {
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "global java.util.List list;\n";
        str = str + "global Integer iGlobal;\n";
        str = str + "global Object iArrayGlobal;\n";
        str = str + "rule \"contains in array\"\n";
        str = str + "     salience 10\n";
        str = str + "     when\n";
        str = str + "         Primitives( $i : intPrimitive == 10, $array1 :  primitiveIntArray ) \n";
        str = str + "         Primitives( intPrimitive != 10, $array2 : primitiveIntArray not contains iGlobal,  primitiveIntArray not contains $i, ";
        str = str + "                     intPrimitive not memberOf $array2, intPrimitive not memberOf $array1, intPrimitive not memberOf iArrayGlobal )\n";
        str = str + "     then\n";
        str = str + "        list.add( \"ok1\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)("kbuilder has errors\n:" + kbuilder.getErrors()));
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("iGlobal", (Object)10);
        ksession.setGlobal("iArrayGlobal", (Object)new int[]{40, 50, 60});
        Primitives p1 = new Primitives();
        p1.setPrimitiveIntArray(new int[]{40, 50, 60});
        p1.setIntPrimitive(5);
        FactHandle p1h = ksession.insert((Object)p1);
        Primitives p2 = new Primitives();
        p2.setPrimitiveIntArray(new int[]{40, 50, 60});
        p2.setIntPrimitive(10);
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.retract(p1h);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testContainsLongArray() throws Exception {
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "global java.util.List list;\n";
        str = str + "global Long lGlobal;\n";
        str = str + "global Object lArrayGlobal;\n";
        str = str + "rule \"contains in array\"\n";
        str = str + "     salience 10\n";
        str = str + "     when\n";
        str = str + "         Primitives( $l : longPrimitive == 10, $array1 :  primitiveLongArray ) \n";
        str = str + "         Primitives( longPrimitive != 10, $array2 : primitiveLongArray contains lGlobal,  primitiveLongArray contains $l, ";
        str = str + "                     longPrimitive memberOf $array2, longPrimitive memberOf $array1, longPrimitive memberOf lArrayGlobal )\n";
        str = str + "     then\n";
        str = str + "        list.add( \"ok1\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)("kbuilder has errors\n:" + kbuilder.getErrors()));
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("lGlobal", (Object)10L);
        ksession.setGlobal("lArrayGlobal", (Object)new long[]{5L, 10L, 20L});
        Primitives p1 = new Primitives();
        p1.setPrimitiveLongArray(new long[]{5L, 10L, 20L});
        p1.setLongPrimitive(5L);
        FactHandle p1h = ksession.insert((Object)p1);
        Primitives p2 = new Primitives();
        p2.setLongPrimitive(10L);
        p2.setPrimitiveLongArray(new long[]{5L, 10L, 20L});
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.retract(p1h);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testNotContainsLongArray() throws Exception {
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "global java.util.List list;\n";
        str = str + "global Long lGlobal;\n";
        str = str + "global Object lArrayGlobal;\n";
        str = str + "rule \"contains in array\"\n";
        str = str + "     salience 10\n";
        str = str + "     when\n";
        str = str + "         Primitives( $l : longPrimitive == 10, $array1 :  primitiveLongArray ) \n";
        str = str + "         Primitives( longPrimitive != 10, $array2 : primitiveLongArray not contains lGlobal,  primitiveLongArray not contains $l, ";
        str = str + "                     longPrimitive not memberOf $array2, longPrimitive not memberOf $array1, longPrimitive not memberOf lArrayGlobal )\n";
        str = str + "     then\n";
        str = str + "        list.add( \"ok1\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)("kbuilder has errors\n:" + kbuilder.getErrors()));
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("lGlobal", (Object)10L);
        ksession.setGlobal("lArrayGlobal", (Object)new long[]{40L, 50L, 60L});
        Primitives p1 = new Primitives();
        p1.setPrimitiveLongArray(new long[]{40L, 50L, 60L});
        p1.setLongPrimitive(5L);
        FactHandle p1h = ksession.insert((Object)p1);
        Primitives p2 = new Primitives();
        p2.setLongPrimitive(10L);
        p2.setPrimitiveLongArray(new long[]{40L, 50L, 60L});
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.retract(p1h);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testContainsFloatArray() throws Exception {
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "global java.util.List list;\n";
        str = str + "global Float fGlobal;\n";
        str = str + "global Object fArrayGlobal;\n";
        str = str + "rule \"contains in array\"\n";
        str = str + "     salience 10\n";
        str = str + "     when\n";
        str = str + "         Primitives( $f : floatPrimitive == 10, $array1 :  primitiveFloatArray ) \n";
        str = str + "         Primitives( floatPrimitive != 10, $array2 : primitiveFloatArray contains fGlobal,  primitiveFloatArray contains $f, ";
        str = str + "                     floatPrimitive memberOf $array2, floatPrimitive memberOf $array1, floatPrimitive memberOf fArrayGlobal )\n";
        str = str + "     then\n";
        str = str + "        list.add( \"ok1\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)("kbuilder has errors\n:" + kbuilder.getErrors()));
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("fGlobal", (Object)Float.valueOf(10.0f));
        ksession.setGlobal("fArrayGlobal", (Object)new float[]{5.0f, 10.0f, 20.0f});
        Primitives p1 = new Primitives();
        p1.setFloatPrimitive(5.0f);
        p1.setPrimitiveFloatArray(new float[]{5.0f, 10.0f, 20.0f});
        FactHandle p1h = ksession.insert((Object)p1);
        Primitives p2 = new Primitives();
        p2.setFloatPrimitive(10.0f);
        p2.setPrimitiveFloatArray(new float[]{5.0f, 10.0f, 20.0f});
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.retract(p1h);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testNotContainsFloatArray() throws Exception {
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "global java.util.List list;\n";
        str = str + "global Float fGlobal;\n";
        str = str + "global Object fArrayGlobal;\n";
        str = str + "rule \"contains in array\"\n";
        str = str + "     salience 10\n";
        str = str + "     when\n";
        str = str + "         Primitives( $f : floatPrimitive == 10, $array1 :  primitiveFloatArray ) \n";
        str = str + "         Primitives( floatPrimitive != 10, $array2 : primitiveFloatArray not contains fGlobal,  primitiveFloatArray not contains $f, ";
        str = str + "                     floatPrimitive not memberOf $array2, floatPrimitive not memberOf $array1, floatPrimitive not memberOf fArrayGlobal )\n";
        str = str + "     then\n";
        str = str + "        list.add( \"ok1\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)("kbuilder has errors\n:" + kbuilder.getErrors()));
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("fGlobal", (Object)Float.valueOf(10.0f));
        ksession.setGlobal("fArrayGlobal", (Object)new float[]{40.0f, 50.0f, 60.0f});
        Primitives p1 = new Primitives();
        p1.setFloatPrimitive(5.0f);
        p1.setPrimitiveFloatArray(new float[]{40.0f, 50.0f, 60.0f});
        FactHandle p1h = ksession.insert((Object)p1);
        Primitives p2 = new Primitives();
        p2.setFloatPrimitive(10.0f);
        p2.setPrimitiveFloatArray(new float[]{40.0f, 50.0f, 60.0f});
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.retract(p1h);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testContainsDoubleArray() throws Exception {
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "global java.util.List list;\n";
        str = str + "global Double dGlobal;\n";
        str = str + "global Object dArrayGlobal;\n";
        str = str + "rule \"contains in array\"\n";
        str = str + "     salience 10\n";
        str = str + "     when\n";
        str = str + "         Primitives( $d : doublePrimitive == 10, $array1 :  primitiveDoubleArray ) \n";
        str = str + "         Primitives( doublePrimitive != 10, $array2 : primitiveDoubleArray contains dGlobal,  primitiveDoubleArray contains $d, ";
        str = str + "                     doublePrimitive memberOf $array2, doublePrimitive memberOf $array1, doublePrimitive memberOf dArrayGlobal )\n";
        str = str + "     then\n";
        str = str + "        list.add( \"ok1\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)("kbuilder has errors\n:" + kbuilder.getErrors()));
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("dGlobal", (Object)10.0);
        ksession.setGlobal("dArrayGlobal", (Object)new double[]{5.0, 10.0, 20.0});
        Primitives p1 = new Primitives();
        p1.setPrimitiveDoubleArray(new double[]{5.0, 10.0, 20.0});
        p1.setDoublePrimitive(5.0);
        FactHandle p1h = ksession.insert((Object)p1);
        Primitives p2 = new Primitives();
        p2.setDoublePrimitive(10.0);
        p2.setPrimitiveDoubleArray(new double[]{5.0, 10.0, 20.0});
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.retract(p1h);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testNotContainsDoubleArray() throws Exception {
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "global java.util.List list;\n";
        str = str + "global Double dGlobal;\n";
        str = str + "global Object dArrayGlobal;\n";
        str = str + "rule \"contains in array\"\n";
        str = str + "     salience 10\n";
        str = str + "     when\n";
        str = str + "         Primitives( $d : doublePrimitive == 10, $array1 :  primitiveDoubleArray ) \n";
        str = str + "         Primitives( doublePrimitive != 10, $array2 : primitiveDoubleArray not contains dGlobal,  primitiveDoubleArray not contains $d, ";
        str = str + "                     doublePrimitive not memberOf $array2, doublePrimitive not memberOf $array1, doublePrimitive not memberOf dArrayGlobal )\n";
        str = str + "     then\n";
        str = str + "        list.add( \"ok1\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)("kbuilder has errors\n:" + kbuilder.getErrors()));
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("dGlobal", (Object)10.0);
        ksession.setGlobal("dArrayGlobal", (Object)new double[]{40.0, 50.0, 60.0});
        Primitives p1 = new Primitives();
        p1.setPrimitiveDoubleArray(new double[]{40.0, 50.0, 60.0});
        p1.setDoublePrimitive(5.0);
        FactHandle p1h = ksession.insert((Object)p1);
        Primitives p2 = new Primitives();
        p2.setDoublePrimitive(10.0);
        p2.setPrimitiveDoubleArray(new double[]{40.0, 50.0, 60.0});
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.retract(p1h);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }
}

