/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.drools.ClockType;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.OrderEvent;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.Sensor;
import org.drools.SessionConfiguration;
import org.drools.StatefulSession;
import org.drools.StockTick;
import org.drools.WorkingMemory;
import org.drools.audit.WorkingMemoryFileLogger;
import org.drools.base.ClassObjectType;
import org.drools.base.evaluators.TimeIntervalParser;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.conf.AssertBehaviorOption;
import org.drools.conf.EventProcessingOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.event.rule.ActivationCreatedEvent;
import org.drools.event.rule.AfterActivationFiredEvent;
import org.drools.event.rule.AgendaEventListener;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.lang.descr.PackageDescr;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.EntryPoint;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.conf.ClockTypeOption;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.drools.runtime.rule.Activation;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.drools.time.SessionPseudoClock;
import org.drools.time.impl.DurationTimer;
import org.drools.time.impl.PseudoClockScheduler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;

public class CepEspTest {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    private RuleBase loadRuleBase(Reader reader) throws IOException, DroolsParserException, Exception {
        return this.loadRuleBase(reader, null);
    }

    private RuleBase loadRuleBase(Reader reader, RuleBaseConfiguration conf) throws IOException, DroolsParserException, Exception {
        PackageBuilder builder = new PackageBuilder();
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse(reader);
        if (parser.hasErrors()) {
            System.out.println(parser.getErrors());
            Assert.fail((String)parser.getErrors().toString());
        }
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase(conf);
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        return ruleBase;
    }

    private KnowledgeBase loadKnowledgeBase(Reader reader, KnowledgeBaseConfiguration conf) throws IOException, ClassNotFoundException {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)reader), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)conf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        return kbase;
    }

    private KnowledgeBase loadKnowledgeBase(String resource, KnowledgeBaseConfiguration conf, boolean serialize) throws IOException, ClassNotFoundException {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)resource, CepEspTest.class), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)conf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        if (serialize) {
            kbase = SerializationHelper.serializeObject(kbase);
        }
        return kbase;
    }

    @Test
    public void testComplexTimestamp() {
        String rule = "";
        rule = rule + "package " + Message.class.getPackage().getName() + "\n" + "declare " + Message.class.getCanonicalName() + "\n" + "   @role( event ) \n" + "   @timestamp( getProperties().get( 'timestamp' )-1 ) \n" + "   @duration( getProperties().get( 'duration' )+1 ) \n" + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(rule)), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Message msg = new Message();
        Properties props = new Properties();
        props.put("timestamp", new Integer(99));
        props.put("duration", new Integer(52));
        msg.setProperties(props);
        EventFactHandle efh = (EventFactHandle)ksession.insert((Object)msg);
        Assert.assertEquals((long)98L, (long)efh.getStartTimestamp());
        Assert.assertEquals((long)53L, (long)efh.getDuration());
    }

    @Test
    public void testEventAssertion() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("test_CEP_SimpleEventAssertion.drl")), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession(conf, null);
        SessionPseudoClock clock = (SessionPseudoClock)session.getSessionClock();
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, 10000L);
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, 10010L);
        StockTick tick3 = new StockTick(3L, "ACME", 10.0, 10100L);
        StockTick tick4 = new StockTick(4L, "DROO", 50.0, 11000L);
        InternalFactHandle handle1 = (InternalFactHandle)session.insert((Object)tick1);
        clock.advanceTime(10L, TimeUnit.SECONDS);
        InternalFactHandle handle2 = (InternalFactHandle)session.insert((Object)tick2);
        clock.advanceTime(30L, TimeUnit.SECONDS);
        InternalFactHandle handle3 = (InternalFactHandle)session.insert((Object)tick3);
        clock.advanceTime(20L, TimeUnit.SECONDS);
        InternalFactHandle handle4 = (InternalFactHandle)session.insert((Object)tick4);
        clock.advanceTime(10L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)handle1);
        Assert.assertNotNull((Object)handle2);
        Assert.assertNotNull((Object)handle3);
        Assert.assertNotNull((Object)handle4);
        Assert.assertTrue((boolean)handle1.isEvent());
        Assert.assertTrue((boolean)handle2.isEvent());
        Assert.assertTrue((boolean)handle3.isEvent());
        Assert.assertTrue((boolean)handle4.isEvent());
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)((List)session.getGlobal("results")).size());
    }

    @Test
    public void testPackageSerializationWithEvents() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("test_CEP_SimpleEventAssertion.drl")), ResourceType.DRL);
        Collection pkgs = kbuilder.getKnowledgePackages();
        Assert.assertEquals((long)2L, (long)pkgs.size());
        byte[] serializedPkg = DroolsStreamUtils.streamOut((Object)pkgs);
        pkgs = (Collection)DroolsStreamUtils.streamIn((byte[])serializedPkg);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession(conf, null);
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, 10000L);
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, 10010L);
        InternalFactHandle handle1 = (InternalFactHandle)session.insert((Object)tick1);
        InternalFactHandle handle2 = (InternalFactHandle)session.insert((Object)tick2);
        Assert.assertNotNull((Object)handle1);
        Assert.assertNotNull((Object)handle2);
        Assert.assertTrue((boolean)handle1.isEvent());
        Assert.assertTrue((boolean)handle2.isEvent());
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)tick2, results.get(0));
    }

    @Test
    public void testEventAssertionWithDuration() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CEP_SimpleEventAssertionWithDuration.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulSession wm = ruleBase.newStatefulSession(conf, null);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, 10000L, 5L);
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, 11000L, 10L);
        StockTick tick3 = new StockTick(3L, "ACME", 10.0, 12000L, 8L);
        StockTick tick4 = new StockTick(4L, "DROO", 50.0, 13000L, 7L);
        InternalFactHandle handle1 = (InternalFactHandle)wm.insert((Object)tick1);
        InternalFactHandle handle2 = (InternalFactHandle)wm.insert((Object)tick2);
        InternalFactHandle handle3 = (InternalFactHandle)wm.insert((Object)tick3);
        InternalFactHandle handle4 = (InternalFactHandle)wm.insert((Object)tick4);
        Assert.assertNotNull((Object)handle1);
        Assert.assertNotNull((Object)handle2);
        Assert.assertNotNull((Object)handle3);
        Assert.assertNotNull((Object)handle4);
        Assert.assertTrue((boolean)handle1.isEvent());
        Assert.assertTrue((boolean)handle2.isEvent());
        Assert.assertTrue((boolean)handle3.isEvent());
        Assert.assertTrue((boolean)handle4.isEvent());
        EventFactHandle eh1 = (EventFactHandle)handle1;
        EventFactHandle eh2 = (EventFactHandle)handle2;
        EventFactHandle eh3 = (EventFactHandle)handle3;
        EventFactHandle eh4 = (EventFactHandle)handle4;
        Assert.assertEquals((long)tick1.getTime(), (long)eh1.getStartTimestamp());
        Assert.assertEquals((long)tick2.getTime(), (long)eh2.getStartTimestamp());
        Assert.assertEquals((long)tick3.getTime(), (long)eh3.getStartTimestamp());
        Assert.assertEquals((long)tick4.getTime(), (long)eh4.getStartTimestamp());
        Assert.assertEquals((long)tick1.getDuration(), (long)eh1.getDuration());
        Assert.assertEquals((long)tick2.getDuration(), (long)eh2.getDuration());
        Assert.assertEquals((long)tick3.getDuration(), (long)eh3.getDuration());
        Assert.assertEquals((long)tick4.getDuration(), (long)eh4.getDuration());
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testEventAssertionWithDateTimestamp() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CEP_SimpleEventAssertionWithDateTimestamp.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulSession wm = ruleBase.newStatefulSession(conf, null);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, 10000L, 5L);
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, 11000L, 10L);
        StockTick tick3 = new StockTick(3L, "ACME", 10.0, 12000L, 8L);
        StockTick tick4 = new StockTick(4L, "DROO", 50.0, 13000L, 7L);
        InternalFactHandle handle1 = (InternalFactHandle)wm.insert((Object)tick1);
        InternalFactHandle handle2 = (InternalFactHandle)wm.insert((Object)tick2);
        InternalFactHandle handle3 = (InternalFactHandle)wm.insert((Object)tick3);
        InternalFactHandle handle4 = (InternalFactHandle)wm.insert((Object)tick4);
        Assert.assertNotNull((Object)handle1);
        Assert.assertNotNull((Object)handle2);
        Assert.assertNotNull((Object)handle3);
        Assert.assertNotNull((Object)handle4);
        Assert.assertTrue((boolean)handle1.isEvent());
        Assert.assertTrue((boolean)handle2.isEvent());
        Assert.assertTrue((boolean)handle3.isEvent());
        Assert.assertTrue((boolean)handle4.isEvent());
        EventFactHandle eh1 = (EventFactHandle)handle1;
        EventFactHandle eh2 = (EventFactHandle)handle2;
        EventFactHandle eh3 = (EventFactHandle)handle3;
        EventFactHandle eh4 = (EventFactHandle)handle4;
        Assert.assertEquals((long)tick1.getTime(), (long)eh1.getStartTimestamp());
        Assert.assertEquals((long)tick2.getTime(), (long)eh2.getStartTimestamp());
        Assert.assertEquals((long)tick3.getTime(), (long)eh3.getStartTimestamp());
        Assert.assertEquals((long)tick4.getTime(), (long)eh4.getStartTimestamp());
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testEventExpiration() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CEP_EventExpiration.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        InternalRuleBase internal = (InternalRuleBase)ruleBase;
        TimeIntervalParser parser = new TimeIntervalParser();
        Assert.assertEquals((long)parser.parse("1h30m")[0], (long)internal.getTypeDeclaration(StockTick.class).getExpirationOffset());
    }

    @Test
    public void testEventExpiration2() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CEP_EventExpiration2.drl"));
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setEventProcessingMode(EventProcessingOption.STREAM);
        RuleBase ruleBase = this.loadRuleBase(reader, conf);
        InternalRuleBase internal = (InternalRuleBase)ruleBase;
        TimeIntervalParser parser = new TimeIntervalParser();
        Map objectTypeNodes = internal.getRete().getObjectTypeNodes(EntryPoint.DEFAULT);
        ObjectTypeNode node = (ObjectTypeNode)objectTypeNodes.get(new ClassObjectType(StockTick.class));
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((long)(parser.parse("10m")[0] + 1L), (long)node.getExpirationOffset());
    }

    @Test
    public void testEventExpiration3() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CEP_EventExpiration3.drl"));
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setEventProcessingMode(EventProcessingOption.STREAM);
        RuleBase ruleBase = this.loadRuleBase(reader, conf);
        InternalRuleBase internal = (InternalRuleBase)ruleBase;
        TimeIntervalParser parser = new TimeIntervalParser();
        Map objectTypeNodes = internal.getRete().getObjectTypeNodes(EntryPoint.DEFAULT);
        ObjectTypeNode node = (ObjectTypeNode)objectTypeNodes.get(new ClassObjectType(StockTick.class));
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((long)(parser.parse("10m")[0] + 1L), (long)node.getExpirationOffset());
    }

    @Test
    public void testEventExpiration4() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CEP_EventExpiration4.drl"));
        KnowledgeBaseConfiguration conf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        conf.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = this.loadKnowledgeBase(reader, conf);
        KnowledgeSessionConfiguration sconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sconf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(sconf, null);
        WorkingMemoryEntryPoint eventStream = ksession.getWorkingMemoryEntryPoint("Event Stream");
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        EventFactHandle handle1 = (EventFactHandle)eventStream.insert((Object)new StockTick(1L, "ACME", 50.0, System.currentTimeMillis(), 3L));
        ksession.fireAllRules();
        clock.advanceTime(11L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertTrue((results.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)handle1.isExpired());
        Assert.assertFalse((boolean)ksession.getFactHandles().contains(handle1));
    }

    @Test
    public void testTimeRelationalOperators() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CEP_TimeRelationalOperators.drl"));
        RuleBaseConfiguration rbconf = new RuleBaseConfiguration();
        rbconf.setEventProcessingMode(EventProcessingOption.STREAM);
        RuleBase ruleBase = this.loadRuleBase(reader, rbconf);
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulSession wm = ruleBase.newStatefulSession(conf, null);
        PseudoClockScheduler clock = (PseudoClockScheduler)wm.getSessionClock();
        clock.setStartupTime(1000L);
        ArrayList results_coincides = new ArrayList();
        ArrayList results_before = new ArrayList();
        ArrayList results_after = new ArrayList();
        ArrayList results_meets = new ArrayList();
        ArrayList results_met_by = new ArrayList();
        ArrayList results_overlaps = new ArrayList();
        ArrayList results_overlapped_by = new ArrayList();
        ArrayList results_during = new ArrayList();
        ArrayList results_includes = new ArrayList();
        ArrayList results_starts = new ArrayList();
        ArrayList results_started_by = new ArrayList();
        ArrayList results_finishes = new ArrayList();
        ArrayList results_finished_by = new ArrayList();
        wm.setGlobal("results_coincides", results_coincides);
        wm.setGlobal("results_before", results_before);
        wm.setGlobal("results_after", results_after);
        wm.setGlobal("results_meets", results_meets);
        wm.setGlobal("results_met_by", results_met_by);
        wm.setGlobal("results_overlaps", results_overlaps);
        wm.setGlobal("results_overlapped_by", results_overlapped_by);
        wm.setGlobal("results_during", results_during);
        wm.setGlobal("results_includes", results_includes);
        wm.setGlobal("results_starts", results_starts);
        wm.setGlobal("results_started_by", results_started_by);
        wm.setGlobal("results_finishes", results_finishes);
        wm.setGlobal("results_finished_by", results_finished_by);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, System.currentTimeMillis(), 3L);
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, System.currentTimeMillis(), 3L);
        StockTick tick3 = new StockTick(3L, "ACME", 10.0, System.currentTimeMillis(), 3L);
        StockTick tick4 = new StockTick(4L, "DROO", 50.0, System.currentTimeMillis(), 5L);
        StockTick tick5 = new StockTick(5L, "ACME", 10.0, System.currentTimeMillis(), 5L);
        StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis(), 3L);
        StockTick tick7 = new StockTick(7L, "ACME", 10.0, System.currentTimeMillis(), 5L);
        StockTick tick8 = new StockTick(8L, "ACME", 10.0, System.currentTimeMillis(), 3L);
        InternalFactHandle handle1 = (InternalFactHandle)wm.insert((Object)tick1);
        clock.advanceTime(4L, TimeUnit.MILLISECONDS);
        InternalFactHandle handle2 = (InternalFactHandle)wm.insert((Object)tick2);
        clock.advanceTime(4L, TimeUnit.MILLISECONDS);
        InternalFactHandle handle3 = (InternalFactHandle)wm.insert((Object)tick3);
        clock.advanceTime(4L, TimeUnit.MILLISECONDS);
        InternalFactHandle handle4 = (InternalFactHandle)wm.insert((Object)tick4);
        InternalFactHandle handle5 = (InternalFactHandle)wm.insert((Object)tick5);
        clock.advanceTime(1L, TimeUnit.MILLISECONDS);
        InternalFactHandle handle6 = (InternalFactHandle)wm.insert((Object)tick6);
        InternalFactHandle handle7 = (InternalFactHandle)wm.insert((Object)tick7);
        clock.advanceTime(2L, TimeUnit.MILLISECONDS);
        InternalFactHandle handle8 = (InternalFactHandle)wm.insert((Object)tick8);
        Assert.assertNotNull((Object)handle1);
        Assert.assertNotNull((Object)handle2);
        Assert.assertNotNull((Object)handle3);
        Assert.assertNotNull((Object)handle4);
        Assert.assertNotNull((Object)handle5);
        Assert.assertNotNull((Object)handle6);
        Assert.assertNotNull((Object)handle7);
        Assert.assertNotNull((Object)handle8);
        Assert.assertTrue((boolean)handle1.isEvent());
        Assert.assertTrue((boolean)handle2.isEvent());
        Assert.assertTrue((boolean)handle3.isEvent());
        Assert.assertTrue((boolean)handle4.isEvent());
        Assert.assertTrue((boolean)handle6.isEvent());
        Assert.assertTrue((boolean)handle7.isEvent());
        Assert.assertTrue((boolean)handle8.isEvent());
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results_coincides.size());
        Assert.assertEquals((Object)tick5, results_coincides.get(0));
        Assert.assertEquals((long)1L, (long)results_before.size());
        Assert.assertEquals((Object)tick2, results_before.get(0));
        Assert.assertEquals((long)1L, (long)results_after.size());
        Assert.assertEquals((Object)tick3, results_after.get(0));
        Assert.assertEquals((long)1L, (long)results_meets.size());
        Assert.assertEquals((Object)tick3, results_meets.get(0));
        Assert.assertEquals((long)1L, (long)results_met_by.size());
        Assert.assertEquals((Object)tick2, results_met_by.get(0));
        Assert.assertEquals((long)1L, (long)results_met_by.size());
        Assert.assertEquals((Object)tick2, results_met_by.get(0));
        Assert.assertEquals((long)1L, (long)results_overlaps.size());
        Assert.assertEquals((Object)tick4, results_overlaps.get(0));
        Assert.assertEquals((long)1L, (long)results_overlapped_by.size());
        Assert.assertEquals((Object)tick8, results_overlapped_by.get(0));
        Assert.assertEquals((long)1L, (long)results_during.size());
        Assert.assertEquals((Object)tick6, results_during.get(0));
        Assert.assertEquals((long)1L, (long)results_includes.size());
        Assert.assertEquals((Object)tick4, results_includes.get(0));
        Assert.assertEquals((long)1L, (long)results_starts.size());
        Assert.assertEquals((Object)tick6, results_starts.get(0));
        Assert.assertEquals((long)1L, (long)results_started_by.size());
        Assert.assertEquals((Object)tick7, results_started_by.get(0));
        Assert.assertEquals((long)1L, (long)results_finishes.size());
        Assert.assertEquals((Object)tick8, results_finishes.get(0));
        Assert.assertEquals((long)1L, (long)results_finished_by.size());
        Assert.assertEquals((Object)tick7, results_finished_by.get(0));
    }

    @Test
    public void testBeforeOperator() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CEP_BeforeOperator.drl"));
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = this.loadKnowledgeBase(reader, kconf);
        KnowledgeSessionConfiguration sconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sconf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(sconf, null);
        PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
        clock.setStartupTime(1000L);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, System.currentTimeMillis(), 3L);
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, System.currentTimeMillis(), 3L);
        StockTick tick3 = new StockTick(3L, "ACME", 10.0, System.currentTimeMillis(), 3L);
        StockTick tick4 = new StockTick(4L, "DROO", 50.0, System.currentTimeMillis(), 5L);
        StockTick tick5 = new StockTick(5L, "ACME", 10.0, System.currentTimeMillis(), 5L);
        StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis(), 3L);
        StockTick tick7 = new StockTick(7L, "ACME", 10.0, System.currentTimeMillis(), 5L);
        StockTick tick8 = new StockTick(8L, "ACME", 10.0, System.currentTimeMillis(), 3L);
        ksession.insert((Object)tick1);
        clock.advanceTime(4L, TimeUnit.MILLISECONDS);
        ksession.insert((Object)tick2);
        clock.advanceTime(4L, TimeUnit.MILLISECONDS);
        ksession.insert((Object)tick3);
        clock.advanceTime(4L, TimeUnit.MILLISECONDS);
        ksession.insert((Object)tick4);
        ksession.insert((Object)tick5);
        clock.advanceTime(1L, TimeUnit.MILLISECONDS);
        ksession.insert((Object)tick6);
        ksession.insert((Object)tick7);
        clock.advanceTime(2L, TimeUnit.MILLISECONDS);
        ksession.insert((Object)tick8);
        ArgumentCaptor arg = ArgumentCaptor.forClass(ActivationCreatedEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).activationCreated((ActivationCreatedEvent)arg.capture());
        Assert.assertThat((Object)((ActivationCreatedEvent)arg.getValue()).getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"before"));
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterActivationFired((AfterActivationFiredEvent)Matchers.any(AfterActivationFiredEvent.class));
    }

    @Test
    public void testMetByOperator() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CEP_MetByOperator.drl"));
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = this.loadKnowledgeBase(reader, kconf);
        KnowledgeSessionConfiguration sconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sconf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(sconf, null);
        PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
        clock.setStartupTime(1000L);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, System.currentTimeMillis(), 3L);
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, System.currentTimeMillis(), 3L);
        StockTick tick3 = new StockTick(3L, "ACME", 10.0, System.currentTimeMillis(), 3L);
        StockTick tick4 = new StockTick(4L, "DROO", 50.0, System.currentTimeMillis(), 5L);
        StockTick tick5 = new StockTick(5L, "ACME", 10.0, System.currentTimeMillis(), 5L);
        StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis(), 3L);
        StockTick tick7 = new StockTick(7L, "ACME", 10.0, System.currentTimeMillis(), 5L);
        StockTick tick8 = new StockTick(8L, "ACME", 10.0, System.currentTimeMillis(), 3L);
        InternalFactHandle fh1 = (InternalFactHandle)ksession.insert((Object)tick1);
        clock.advanceTime(4L, TimeUnit.MILLISECONDS);
        InternalFactHandle fh2 = (InternalFactHandle)ksession.insert((Object)tick2);
        clock.advanceTime(4L, TimeUnit.MILLISECONDS);
        ksession.insert((Object)tick3);
        clock.advanceTime(4L, TimeUnit.MILLISECONDS);
        ksession.insert((Object)tick4);
        ksession.insert((Object)tick5);
        clock.advanceTime(1L, TimeUnit.MILLISECONDS);
        ksession.insert((Object)tick6);
        ksession.insert((Object)tick7);
        clock.advanceTime(2L, TimeUnit.MILLISECONDS);
        ksession.insert((Object)tick8);
        ArgumentCaptor arg = ArgumentCaptor.forClass(ActivationCreatedEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).activationCreated((ActivationCreatedEvent)arg.capture());
        Activation activation = ((ActivationCreatedEvent)arg.getValue()).getActivation();
        Assert.assertThat((Object)activation.getRule().getName(), (Matcher)CoreMatchers.is((Object)"metby"));
        ksession.fireAllRules();
        ArgumentCaptor aaf = ArgumentCaptor.forClass(AfterActivationFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterActivationFired((AfterActivationFiredEvent)aaf.capture());
        Assert.assertThat((Object)((InternalFactHandle)((AfterActivationFiredEvent)aaf.getValue()).getActivation().getFactHandles().toArray()[0]), (Matcher)CoreMatchers.is((Object)fh2));
    }

    @Test
    public void testAfterOnArbitraryDates() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CEP_AfterOperatorDates.drl"));
        RuleBaseConfiguration rbconf = new RuleBaseConfiguration();
        RuleBase ruleBase = this.loadRuleBase(reader, rbconf);
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulSession wm = ruleBase.newStatefulSession(conf, null);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, 100000L, 3L);
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, 104000L, 3L);
        InternalFactHandle handle1 = (InternalFactHandle)wm.insert((Object)tick1);
        InternalFactHandle handle2 = (InternalFactHandle)wm.insert((Object)tick2);
        Assert.assertNotNull((Object)handle1);
        Assert.assertNotNull((Object)handle2);
        Assert.assertTrue((boolean)handle1.isEvent());
        Assert.assertTrue((boolean)handle2.isEvent());
        wm.fireAllRules();
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((Object)tick1, results.get(0));
        Assert.assertEquals((Object)tick2, results.get(1));
        Assert.assertEquals((Object)tick1, results.get(2));
        Assert.assertEquals((Object)tick2, results.get(3));
    }

    @Test
    public void testBeforeOnArbitraryDates() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CEP_BeforeOperatorDates.drl"));
        RuleBaseConfiguration rbconf = new RuleBaseConfiguration();
        RuleBase ruleBase = this.loadRuleBase(reader, rbconf);
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulSession wm = ruleBase.newStatefulSession(conf, null);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, 104000L, 3L);
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, 100000L, 3L);
        InternalFactHandle handle1 = (InternalFactHandle)wm.insert((Object)tick1);
        InternalFactHandle handle2 = (InternalFactHandle)wm.insert((Object)tick2);
        Assert.assertNotNull((Object)handle1);
        Assert.assertNotNull((Object)handle2);
        Assert.assertTrue((boolean)handle1.isEvent());
        Assert.assertTrue((boolean)handle2.isEvent());
        wm.fireAllRules();
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((Object)tick1, results.get(0));
        Assert.assertEquals((Object)tick2, results.get(1));
        Assert.assertEquals((Object)tick1, results.get(2));
        Assert.assertEquals((Object)tick2, results.get(3));
    }

    @Test
    public void testCoincidesOnArbitraryDates() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CEP_CoincidesOperatorDates.drl"));
        RuleBaseConfiguration rbconf = new RuleBaseConfiguration();
        RuleBase ruleBase = this.loadRuleBase(reader, rbconf);
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulSession wm = ruleBase.newStatefulSession(conf, null);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, 100000L, 3L);
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, 100050L, 3L);
        InternalFactHandle handle1 = (InternalFactHandle)wm.insert((Object)tick1);
        InternalFactHandle handle2 = (InternalFactHandle)wm.insert((Object)tick2);
        Assert.assertNotNull((Object)handle1);
        Assert.assertNotNull((Object)handle2);
        Assert.assertTrue((boolean)handle1.isEvent());
        Assert.assertTrue((boolean)handle2.isEvent());
        wm.fireAllRules();
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((Object)tick1, results.get(0));
        Assert.assertEquals((Object)tick2, results.get(1));
        Assert.assertEquals((Object)tick1, results.get(2));
        Assert.assertEquals((Object)tick2, results.get(3));
    }

    @Test
    public void testSimpleTimeWindow() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CEP_SimpleTimeWindow.drl"));
        RuleBaseConfiguration rbconf = new RuleBaseConfiguration();
        rbconf.setEventProcessingMode(EventProcessingOption.STREAM);
        RuleBase ruleBase = this.loadRuleBase(reader, rbconf);
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulSession wm = ruleBase.newStatefulSession(conf, null);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        SessionPseudoClock clock = (SessionPseudoClock)wm.getSessionClock();
        clock.advanceTime(5L, TimeUnit.SECONDS);
        EventFactHandle handle1 = (EventFactHandle)wm.insert((Object)new OrderEvent("1", "customer A", 70.0));
        Assert.assertEquals((long)5000L, (long)handle1.getStartTimestamp());
        Assert.assertEquals((long)0L, (long)handle1.getDuration());
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)70L, (long)((Number)results.get(0)).intValue());
        clock.advanceTime(10L, TimeUnit.SECONDS);
        EventFactHandle handle2 = (EventFactHandle)wm.insert((Object)new OrderEvent("2", "customer A", 60.0));
        Assert.assertEquals((long)15000L, (long)handle2.getStartTimestamp());
        Assert.assertEquals((long)0L, (long)handle2.getDuration());
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)65L, (long)((Number)results.get(1)).intValue());
        clock.advanceTime(10L, TimeUnit.SECONDS);
        EventFactHandle handle3 = (EventFactHandle)wm.insert((Object)new OrderEvent("3", "customer A", 50.0));
        Assert.assertEquals((long)25000L, (long)handle3.getStartTimestamp());
        Assert.assertEquals((long)0L, (long)handle3.getDuration());
        wm.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((long)60L, (long)((Number)results.get(2)).intValue());
        clock.advanceTime(10L, TimeUnit.SECONDS);
        EventFactHandle handle4 = (EventFactHandle)wm.insert((Object)new OrderEvent("4", "customer A", 25.0));
        Assert.assertEquals((long)35000L, (long)handle4.getStartTimestamp());
        Assert.assertEquals((long)0L, (long)handle4.getDuration());
        wm.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
        clock.advanceTime(10L, TimeUnit.SECONDS);
        EventFactHandle handle5 = (EventFactHandle)wm.insert((Object)new OrderEvent("5", "customer A", 70.0));
        Assert.assertEquals((long)45000L, (long)handle5.getStartTimestamp());
        Assert.assertEquals((long)0L, (long)handle5.getDuration());
        wm.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
        clock.advanceTime(10L, TimeUnit.SECONDS);
        EventFactHandle handle6 = (EventFactHandle)wm.insert((Object)new OrderEvent("6", "customer A", 115.0));
        Assert.assertEquals((long)55000L, (long)handle6.getStartTimestamp());
        Assert.assertEquals((long)0L, (long)handle6.getDuration());
        wm.fireAllRules();
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((long)70L, (long)((Number)results.get(3)).intValue());
    }

    @Test
    public void testSimpleLengthWindow() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CEP_SimpleLengthWindow.drl"));
        RuleBaseConfiguration rbconf = new RuleBaseConfiguration();
        rbconf.setEventProcessingMode(EventProcessingOption.STREAM);
        RuleBase ruleBase = this.loadRuleBase(reader, rbconf);
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.REALTIME_CLOCK);
        StatefulSession wm = ruleBase.newStatefulSession(conf, null);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        EventFactHandle handle1 = (EventFactHandle)wm.insert((Object)new OrderEvent("1", "customer A", 70.0));
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)70L, (long)((Number)results.get(0)).intValue());
        EventFactHandle handle2 = (EventFactHandle)wm.insert((Object)new OrderEvent("2", "customer A", 60.0));
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)65L, (long)((Number)results.get(1)).intValue());
        EventFactHandle handle3 = (EventFactHandle)wm.insert((Object)new OrderEvent("3", "customer A", 50.0));
        wm.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((long)60L, (long)((Number)results.get(2)).intValue());
        EventFactHandle handle4 = (EventFactHandle)wm.insert((Object)new OrderEvent("4", "customer A", 25.0));
        wm.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
        EventFactHandle handle5 = (EventFactHandle)wm.insert((Object)new OrderEvent("5", "customer A", 70.0));
        wm.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
        EventFactHandle handle6 = (EventFactHandle)wm.insert((Object)new OrderEvent("6", "customer A", 115.0));
        wm.fireAllRules();
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((long)70L, (long)((Number)results.get(3)).intValue());
    }

    @Test
    public void testDelayingNot() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CEP_DelayingNot.drl"));
        RuleBaseConfiguration rbconf = new RuleBaseConfiguration();
        rbconf.setEventProcessingMode(EventProcessingOption.STREAM);
        RuleBase ruleBase = this.loadRuleBase(reader, rbconf);
        Rule rule = ruleBase.getPackage("org.drools").getRule("Delaying Not");
        Assert.assertEquals((long)10000L, (long)((DurationTimer)rule.getTimer()).getDuration());
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulSession wm = ruleBase.newStatefulSession(conf, null);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        SessionPseudoClock clock = (SessionPseudoClock)wm.getSessionClock();
        clock.advanceTime(10L, TimeUnit.SECONDS);
        StockTick st1O = new StockTick(1L, "DROO", 100.0, clock.getCurrentTime());
        EventFactHandle st1 = (EventFactHandle)wm.insert((Object)st1O);
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        clock.advanceTime(5L, TimeUnit.SECONDS);
        EventFactHandle st2 = (EventFactHandle)wm.insert((Object)new StockTick(1L, "DROO", 80.0, clock.getCurrentTime()));
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        wm.fireAllRules();
        clock.advanceTime(6L, TimeUnit.SECONDS);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)st1O, results.get(0));
    }

    @Test
    public void testIdleTime() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("test_CEP_SimpleEventAssertion.drl")), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession(conf, null);
        ReteooWorkingMemory iwm = ((StatefulKnowledgeSessionImpl)session).session;
        SessionPseudoClock clock = (SessionPseudoClock)session.getSessionClock();
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, 10000L);
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, 10010L);
        StockTick tick3 = new StockTick(3L, "ACME", 10.0, 10100L);
        StockTick tick4 = new StockTick(4L, "DROO", 50.0, 11000L);
        Assert.assertEquals((long)0L, (long)iwm.getIdleTime());
        InternalFactHandle handle1 = (InternalFactHandle)session.insert((Object)tick1);
        clock.advanceTime(10L, TimeUnit.SECONDS);
        Assert.assertEquals((long)10000L, (long)iwm.getIdleTime());
        InternalFactHandle handle2 = (InternalFactHandle)session.insert((Object)tick2);
        Assert.assertEquals((long)0L, (long)iwm.getIdleTime());
        clock.advanceTime(15L, TimeUnit.SECONDS);
        Assert.assertEquals((long)15000L, (long)iwm.getIdleTime());
        clock.advanceTime(15L, TimeUnit.SECONDS);
        Assert.assertEquals((long)30000L, (long)iwm.getIdleTime());
        InternalFactHandle handle3 = (InternalFactHandle)session.insert((Object)tick3);
        Assert.assertEquals((long)0L, (long)iwm.getIdleTime());
        clock.advanceTime(20L, TimeUnit.SECONDS);
        InternalFactHandle handle4 = (InternalFactHandle)session.insert((Object)tick4);
        clock.advanceTime(10L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)handle1);
        Assert.assertNotNull((Object)handle2);
        Assert.assertNotNull((Object)handle3);
        Assert.assertNotNull((Object)handle4);
        Assert.assertTrue((boolean)handle1.isEvent());
        Assert.assertTrue((boolean)handle2.isEvent());
        Assert.assertTrue((boolean)handle3.isEvent());
        Assert.assertTrue((boolean)handle4.isEvent());
        Assert.assertEquals((long)10000L, (long)iwm.getIdleTime());
        session.fireAllRules();
        Assert.assertEquals((long)0L, (long)iwm.getIdleTime());
        Assert.assertEquals((long)2L, (long)((List)session.getGlobal("results")).size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIdleTimeAndTimeToNextJob() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CEP_SimpleTimeWindow.drl"));
        RuleBaseConfiguration rbconf = new RuleBaseConfiguration();
        rbconf.setEventProcessingMode(EventProcessingOption.STREAM);
        RuleBase ruleBase = this.loadRuleBase(reader, rbconf);
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulSession wm = ruleBase.newStatefulSession(conf, null);
        WorkingMemoryFileLogger logger = new WorkingMemoryFileLogger((WorkingMemory)wm);
        File testTmpDir = new File("target/test-tmp/");
        testTmpDir.mkdirs();
        logger.setFileName("target/test-tmp/testIdleTimeAndTimeToNextJob-audit");
        try {
            ArrayList results = new ArrayList();
            wm.setGlobal("results", results);
            InternalWorkingMemory iwm = (InternalWorkingMemory)wm;
            SessionPseudoClock clock = (SessionPseudoClock)wm.getSessionClock();
            clock.advanceTime(5L, TimeUnit.SECONDS);
            Assert.assertEquals((long)-1L, (long)iwm.getTimeToNextJob());
            wm.insert((Object)new OrderEvent("1", "customer A", 70.0));
            Assert.assertEquals((long)0L, (long)iwm.getIdleTime());
            Assert.assertEquals((long)30000L, (long)iwm.getTimeToNextJob());
            wm.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)70L, (long)((Number)results.get(0)).intValue());
            clock.advanceTime(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)20000L, (long)iwm.getTimeToNextJob());
            wm.insert((Object)new OrderEvent("2", "customer A", 60.0));
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((long)65L, (long)((Number)results.get(1)).intValue());
            clock.advanceTime(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)10000L, (long)iwm.getTimeToNextJob());
            wm.insert((Object)new OrderEvent("3", "customer A", 50.0));
            wm.fireAllRules();
            Assert.assertEquals((long)3L, (long)results.size());
            Assert.assertEquals((long)60L, (long)((Number)results.get(2)).intValue());
            clock.advanceTime(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)iwm.getIdleTime());
            wm.insert((Object)new OrderEvent("4", "customer A", 25.0));
            wm.fireAllRules();
            Assert.assertEquals((long)3L, (long)results.size());
            clock.advanceTime(10L, TimeUnit.SECONDS);
            wm.insert((Object)new OrderEvent("5", "customer A", 70.0));
            Assert.assertEquals((long)0L, (long)iwm.getIdleTime());
            wm.fireAllRules();
            Assert.assertEquals((long)3L, (long)results.size());
        }
        finally {
            logger.writeToDisk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCollectWithWindows() throws Exception {
        KnowledgeBaseConfiguration kbconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbconf.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = this.loadKnowledgeBase("test_CEP_CollectWithWindows.drl", kbconf, true);
        KnowledgeSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(ksconf, null);
        WorkingMemoryFileLogger logger = new WorkingMemoryFileLogger((KnowledgeRuntimeEventManager)ksession);
        File testTmpDir = new File("target/test-tmp/");
        testTmpDir.mkdirs();
        logger.setFileName("target/test-tmp/testCollectWithWindows-audit");
        ArrayList timeResults = new ArrayList();
        ArrayList lengthResults = new ArrayList();
        ksession.setGlobal("timeResults", timeResults);
        ksession.setGlobal("lengthResults", lengthResults);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        try {
            clock.advanceTime(5L, TimeUnit.SECONDS);
            ksession.insert((Object)new OrderEvent("1", "customer A", 70.0));
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)timeResults.size());
            Assert.assertEquals((long)1L, (long)((Number)timeResults.get(0)).intValue());
            Assert.assertEquals((long)1L, (long)lengthResults.size());
            Assert.assertEquals((long)1L, (long)((Number)lengthResults.get(0)).intValue());
            clock.advanceTime(10L, TimeUnit.SECONDS);
            ksession.insert((Object)new OrderEvent("2", "customer A", 60.0));
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)timeResults.size());
            Assert.assertEquals((long)2L, (long)((Number)timeResults.get(1)).intValue());
            Assert.assertEquals((long)2L, (long)lengthResults.size());
            Assert.assertEquals((long)2L, (long)((Number)lengthResults.get(1)).intValue());
            clock.advanceTime(10L, TimeUnit.SECONDS);
            ksession.insert((Object)new OrderEvent("3", "customer A", 50.0));
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)timeResults.size());
            Assert.assertEquals((long)3L, (long)((Number)timeResults.get(2)).intValue());
            Assert.assertEquals((long)3L, (long)lengthResults.size());
            Assert.assertEquals((long)3L, (long)((Number)lengthResults.get(2)).intValue());
            clock.advanceTime(10L, TimeUnit.SECONDS);
            ksession.insert((Object)new OrderEvent("4", "customer A", 25.0));
            ksession.fireAllRules();
            Assert.assertEquals((long)4L, (long)timeResults.size());
            Assert.assertEquals((long)3L, (long)((Number)timeResults.get(3)).intValue());
            Assert.assertEquals((long)4L, (long)lengthResults.size());
            Assert.assertEquals((long)3L, (long)((Number)lengthResults.get(3)).intValue());
            clock.advanceTime(5L, TimeUnit.SECONDS);
            ksession.insert((Object)new OrderEvent("5", "customer A", 70.0));
            ksession.fireAllRules();
            Assert.assertEquals((long)5L, (long)timeResults.size());
            Assert.assertEquals((long)4L, (long)((Number)timeResults.get(4)).intValue());
            Assert.assertEquals((long)5L, (long)lengthResults.size());
            Assert.assertEquals((long)3L, (long)((Number)lengthResults.get(4)).intValue());
        }
        finally {
            logger.writeToDisk();
        }
    }

    @Test
    public void testPseudoSchedulerRemoveJobTest() {
        String str = "import org.drools.integrationtests.CepEspTest.A\n";
        str = str + "declare A\n";
        str = str + "    @role( event )\n";
        str = str + "end\n";
        str = str + "rule A\n";
        str = str + "when\n";
        str = str + "   $a : A()\n";
        str = str + "   not A(this after [1s,10s] $a)\n";
        str = str + "then\n";
        str = str + "end";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(str)), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeSessionConfiguration sessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        KnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)config);
        knowledgeBase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = knowledgeBase.newStatefulKnowledgeSession(sessionConfig, KnowledgeBaseFactory.newEnvironment());
        PseudoClockScheduler pseudoClock = (PseudoClockScheduler)ksession.getSessionClock();
        FactHandle h = ksession.insert((Object)new A());
        ksession.retract(h);
    }

    @Test
    public void testStreamModeNoSerialization() throws IOException, ClassNotFoundException {
        KnowledgeBaseConfiguration kbconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbconf.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase1 = this.loadKnowledgeBase("test_CEP_StreamMode.drl", kbconf, false);
        KnowledgeBase kbase2 = (KnowledgeBase)DroolsStreamUtils.streamIn((byte[])DroolsStreamUtils.streamOut((Object)kbase1), null);
        StatefulKnowledgeSession ksession1 = kbase1.newStatefulKnowledgeSession();
        AgendaEventListener ael1 = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession1.addEventListener(ael1);
        StatefulKnowledgeSession ksession2 = kbase2.newStatefulKnowledgeSession();
        AgendaEventListener ael2 = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession2.addEventListener(ael2);
        ksession1.insert((Object)new Sensor(10, 10));
        ksession1.fireAllRules();
        ArgumentCaptor aafe1 = ArgumentCaptor.forClass(AfterActivationFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael1, (VerificationMode)Mockito.times((int)1))).afterActivationFired((AfterActivationFiredEvent)aafe1.capture());
        List events1 = aafe1.getAllValues();
        Assert.assertThat((Object)((AfterActivationFiredEvent)events1.get(0)).getActivation().getDeclarationValue("$avg"), (Matcher)CoreMatchers.is((Object)10));
        ksession1.insert((Object)new Sensor(20, 20));
        ksession1.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael1, (VerificationMode)Mockito.times((int)2))).afterActivationFired((AfterActivationFiredEvent)aafe1.capture());
        Assert.assertThat((Object)((AfterActivationFiredEvent)events1.get(1)).getActivation().getDeclarationValue("$avg"), (Matcher)CoreMatchers.is((Object)15));
        ksession1.insert((Object)new Sensor(30, 30));
        ksession1.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael1, (VerificationMode)Mockito.times((int)3))).afterActivationFired((AfterActivationFiredEvent)aafe1.capture());
        Assert.assertThat((Object)((AfterActivationFiredEvent)events1.get(2)).getActivation().getDeclarationValue("$avg"), (Matcher)CoreMatchers.is((Object)25));
        ksession1.dispose();
        ArgumentCaptor aafe2 = ArgumentCaptor.forClass(AfterActivationFiredEvent.class);
        ksession2.insert((Object)new Sensor(10, 10));
        ksession2.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael2, (VerificationMode)Mockito.times((int)1))).afterActivationFired((AfterActivationFiredEvent)aafe2.capture());
        List events2 = aafe2.getAllValues();
        Assert.assertThat((Object)((AfterActivationFiredEvent)events2.get(0)).getActivation().getDeclarationValue("$avg"), (Matcher)CoreMatchers.is((Object)10));
        ksession2.insert((Object)new Sensor(20, 20));
        ksession2.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael2, (VerificationMode)Mockito.times((int)2))).afterActivationFired((AfterActivationFiredEvent)aafe2.capture());
        Assert.assertThat((Object)((AfterActivationFiredEvent)events2.get(1)).getActivation().getDeclarationValue("$avg"), (Matcher)CoreMatchers.is((Object)15));
        ksession2.insert((Object)new Sensor(30, 30));
        ksession2.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael2, (VerificationMode)Mockito.times((int)3))).afterActivationFired((AfterActivationFiredEvent)aafe2.capture());
        Assert.assertThat((Object)((AfterActivationFiredEvent)events2.get(2)).getActivation().getDeclarationValue("$avg"), (Matcher)CoreMatchers.is((Object)25));
        ksession2.dispose();
    }

    @Test
    public void testIdentityAssertBehaviorOnEntryPoints() throws IOException, ClassNotFoundException {
        StockTick st1 = new StockTick(1L, "RHT", 10.0, 10L);
        StockTick st2 = new StockTick(1L, "RHT", 10.0, 10L);
        StockTick st3 = new StockTick(2L, "RHT", 15.0, 20L);
        KnowledgeBaseConfiguration kbconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbconf.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        kbconf.setOption((KnowledgeBaseOption)AssertBehaviorOption.IDENTITY);
        KnowledgeBase kbase1 = this.loadKnowledgeBase("test_CEP_AssertBehaviorOnEntryPoints.drl", kbconf, true);
        StatefulKnowledgeSession ksession1 = kbase1.newStatefulKnowledgeSession();
        AgendaEventListener ael1 = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession1.addEventListener(ael1);
        WorkingMemoryEntryPoint ep1 = ksession1.getWorkingMemoryEntryPoint("stocktick stream");
        FactHandle fh1 = ep1.insert((Object)st1);
        FactHandle fh1_2 = ep1.insert((Object)st1);
        FactHandle fh2 = ep1.insert((Object)st2);
        FactHandle fh3 = ep1.insert((Object)st3);
        Assert.assertSame((Object)fh1, (Object)fh1_2);
        Assert.assertNotSame((Object)fh1, (Object)fh2);
        Assert.assertNotSame((Object)fh1, (Object)fh3);
        Assert.assertNotSame((Object)fh2, (Object)fh3);
        ksession1.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael1, (VerificationMode)Mockito.times((int)3))).afterActivationFired((AfterActivationFiredEvent)Matchers.any(AfterActivationFiredEvent.class));
        ksession1.dispose();
    }

    @Test
    public void testEqualityAssertBehaviorOnEntryPoints() throws IOException, ClassNotFoundException {
        StockTick st1 = new StockTick(1L, "RHT", 10.0, 10L);
        StockTick st2 = new StockTick(1L, "RHT", 10.0, 10L);
        StockTick st3 = new StockTick(2L, "RHT", 15.0, 20L);
        KnowledgeBaseConfiguration kbconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbconf.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        kbconf.setOption((KnowledgeBaseOption)AssertBehaviorOption.EQUALITY);
        KnowledgeBase kbase1 = this.loadKnowledgeBase("test_CEP_AssertBehaviorOnEntryPoints.drl", kbconf, true);
        StatefulKnowledgeSession ksession1 = kbase1.newStatefulKnowledgeSession();
        AgendaEventListener ael1 = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession1.addEventListener(ael1);
        WorkingMemoryEntryPoint ep1 = ksession1.getWorkingMemoryEntryPoint("stocktick stream");
        FactHandle fh1 = ep1.insert((Object)st1);
        FactHandle fh1_2 = ep1.insert((Object)st1);
        FactHandle fh2 = ep1.insert((Object)st2);
        FactHandle fh3 = ep1.insert((Object)st3);
        Assert.assertSame((Object)fh1, (Object)fh1_2);
        Assert.assertSame((Object)fh1, (Object)fh2);
        Assert.assertNotSame((Object)fh1, (Object)fh3);
        ksession1.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael1, (VerificationMode)Mockito.times((int)2))).afterActivationFired((AfterActivationFiredEvent)Matchers.any(AfterActivationFiredEvent.class));
        ksession1.dispose();
    }

    @Test
    public void testEventDeclarationForInterfaces() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_CEP_EventInterfaces.drl", null, true);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, 10000L);
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, 10010L);
        StockTick tick3 = new StockTick(3L, "ACME", 10.0, 10100L);
        StockTick tick4 = new StockTick(4L, "DROO", 50.0, 11000L);
        InternalFactHandle handle1 = (InternalFactHandle)session.insert((Object)tick1);
        InternalFactHandle handle2 = (InternalFactHandle)session.insert((Object)tick2);
        InternalFactHandle handle3 = (InternalFactHandle)session.insert((Object)tick3);
        InternalFactHandle handle4 = (InternalFactHandle)session.insert((Object)tick4);
        Assert.assertTrue((boolean)handle1.isEvent());
        Assert.assertTrue((boolean)handle2.isEvent());
        Assert.assertTrue((boolean)handle3.isEvent());
        Assert.assertTrue((boolean)handle4.isEvent());
    }

    @Test
    public void testTemporalOperators() throws Exception {
        RuleBaseConfiguration kbconf = new RuleBaseConfiguration();
        kbconf.setEventProcessingMode(EventProcessingOption.STREAM);
        KnowledgeBase kbase = this.loadKnowledgeBase("test_CEP_TemporalOperators.drl", (KnowledgeBaseConfiguration)kbconf, true);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new StockTick(1L, "A", 10.0, 1000L));
    }

    @Test
    public void testTemporalOperators2() throws Exception {
        RuleBaseConfiguration kbconf = new RuleBaseConfiguration();
        kbconf.setEventProcessingMode(EventProcessingOption.STREAM);
        KnowledgeBase kbase = this.loadKnowledgeBase("test_CEP_TemporalOperators2.drl", (KnowledgeBaseConfiguration)kbconf, true);
        KnowledgeSessionConfiguration sconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sconf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(sconf, null);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        WorkingMemoryEntryPoint ep = ksession.getWorkingMemoryEntryPoint("X");
        clock.advanceTime(1000L, TimeUnit.SECONDS);
        ep.insert((Object)new StockTick(1L, "A", 10.0, clock.getCurrentTime()));
        clock.advanceTime(8L, TimeUnit.SECONDS);
        ep.insert((Object)new StockTick(2L, "B", 10.0, clock.getCurrentTime()));
        clock.advanceTime(8L, TimeUnit.SECONDS);
        ep.insert((Object)new StockTick(3L, "B", 10.0, clock.getCurrentTime()));
        clock.advanceTime(8L, TimeUnit.SECONDS);
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)rules);
    }

    @Test
    public void testTemporalOperatorsInfinity() throws Exception {
        RuleBaseConfiguration kbconf = new RuleBaseConfiguration();
        kbconf.setEventProcessingMode(EventProcessingOption.STREAM);
        KnowledgeBase kbase = this.loadKnowledgeBase("test_CEP_TemporalOperators3.drl", (KnowledgeBaseConfiguration)kbconf, true);
        KnowledgeSessionConfiguration sconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sconf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(sconf, null);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        WorkingMemoryEntryPoint ep = ksession.getWorkingMemoryEntryPoint("X");
        clock.advanceTime(1000L, TimeUnit.SECONDS);
        ep.insert((Object)new StockTick(1L, "A", 10.0, clock.getCurrentTime()));
        clock.advanceTime(8L, TimeUnit.SECONDS);
        ep.insert((Object)new StockTick(2L, "B", 10.0, clock.getCurrentTime()));
        clock.advanceTime(8L, TimeUnit.SECONDS);
        ep.insert((Object)new StockTick(3L, "B", 10.0, clock.getCurrentTime()));
        clock.advanceTime(8L, TimeUnit.SECONDS);
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)rules);
    }

    @Test
    public void testMultipleSlidingWindows() throws IOException, ClassNotFoundException {
        String str = "declare A\n    @role( event )\n    id : int\nend\ndeclare B\n    @role( event )\n    id : int\nend\nrule launch\nwhen\nthen\n    insert( new A( 1 ) );\n    insert( new A( 2 ) );\n    insert( new B( 1 ) );\n    insert( new A( 3 ) );\n    insert( new B( 2 ) );\nend\nrule \"ab\"\nwhen\n    A( $a : id ) over window:length( 1 )\n    B( $b : id ) over window:length( 1 )\nthen\n    //System.out.println(\"AB: ( \"+$a+\", \"+$b+\" )\");\nend\nrule \"ba\"\nwhen\n    B( $b : id ) over window:length( 1 )\n    A( $a : id ) over window:length( 1 )\nthen\n    //System.out.println(\"BA: ( \"+$b+\", \"+$a+\" )\");\nend";
        KnowledgeBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = this.loadKnowledgeBase(new StringReader(str), config);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        ksession.fireAllRules();
        ArgumentCaptor captor = ArgumentCaptor.forClass(AfterActivationFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)7))).afterActivationFired((AfterActivationFiredEvent)captor.capture());
        List values = captor.getAllValues();
        Activation act = ((AfterActivationFiredEvent)values.get(0)).getActivation();
        Assert.assertThat((Object)act.getRule().getName(), (Matcher)CoreMatchers.is((Object)"launch"));
        act = ((AfterActivationFiredEvent)values.get(1)).getActivation();
        Assert.assertThat((Object)act.getRule().getName(), (Matcher)CoreMatchers.is((Object)"ba"));
        Assert.assertThat((Object)((Number)act.getDeclarationValue("$a")).intValue(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((Number)act.getDeclarationValue("$b")).intValue(), (Matcher)CoreMatchers.is((Object)2));
        act = ((AfterActivationFiredEvent)values.get(2)).getActivation();
        Assert.assertThat((Object)act.getRule().getName(), (Matcher)CoreMatchers.is((Object)"ab"));
        Assert.assertThat((Object)((Number)act.getDeclarationValue("$a")).intValue(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((Number)act.getDeclarationValue("$b")).intValue(), (Matcher)CoreMatchers.is((Object)2));
        act = ((AfterActivationFiredEvent)values.get(3)).getActivation();
        Assert.assertThat((Object)act.getRule().getName(), (Matcher)CoreMatchers.is((Object)"ba"));
        Assert.assertThat((Object)((Number)act.getDeclarationValue("$a")).intValue(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((Number)act.getDeclarationValue("$b")).intValue(), (Matcher)CoreMatchers.is((Object)1));
        act = ((AfterActivationFiredEvent)values.get(4)).getActivation();
        Assert.assertThat((Object)act.getRule().getName(), (Matcher)CoreMatchers.is((Object)"ab"));
        Assert.assertThat((Object)((Number)act.getDeclarationValue("$a")).intValue(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((Number)act.getDeclarationValue("$b")).intValue(), (Matcher)CoreMatchers.is((Object)1));
        act = ((AfterActivationFiredEvent)values.get(5)).getActivation();
        Assert.assertThat((Object)act.getRule().getName(), (Matcher)CoreMatchers.is((Object)"ba"));
        Assert.assertThat((Object)((Number)act.getDeclarationValue("$a")).intValue(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Number)act.getDeclarationValue("$b")).intValue(), (Matcher)CoreMatchers.is((Object)1));
        act = ((AfterActivationFiredEvent)values.get(6)).getActivation();
        Assert.assertThat((Object)act.getRule().getName(), (Matcher)CoreMatchers.is((Object)"ab"));
        Assert.assertThat((Object)((Number)act.getDeclarationValue("$a")).intValue(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Number)act.getDeclarationValue("$b")).intValue(), (Matcher)CoreMatchers.is((Object)1));
    }

    public static class Message {
        private Properties properties;

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }
    }

    public static class A
    implements Serializable {
    }
}

