/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.drools.Cheese;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.io.ResourceFactory;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Assert;
import org.junit.Test;

public class DateComparisonTest {
    @Test
    public void testDateComparisonThan() throws Exception {
        ArrayList results = new ArrayList();
        String str = "";
        str = str + "package org.drools;\n";
        str = str + "dialect \"mvel\"\n";
        str = str + "global java.util.List results;\n";
        str = str + "rule \"test date greater than\"\n";
        str = str + "     when\n";
        str = str + "         $c : Cheese(type == \"Yesterday\")\n";
        str = str + "         Cheese(type == \"Tomorrow\",  usedBy > ($c.usedBy))\n";
        str = str + "     then\n";
        str = str + "         results.add( \"test date greater than\" );\n";
        str = str + "end\n";
        str = str + "rule \"test date less than\"\n";
        str = str + "    when\n";
        str = str + "        $c : Cheese(type == \"Tomorrow\")\n";
        str = str + "        Cheese(type == \"Yesterday\", usedBy < ($c.usedBy));\n";
        str = str + "    then\n";
        str = str + "        results.add( \"test date less than\" );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("results", results);
        File testTmpDir = new File("target/test-tmp/");
        testTmpDir.mkdirs();
        KnowledgeRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newFileLogger((KnowledgeRuntimeEventManager)ksession, (String)"target/test-tmp/testDateComparisonThan");
        Cheese yesterday = new Cheese("Yesterday");
        yesterday.setUsedBy(this.yesterday());
        Cheese tomorrow = new Cheese("Tomorrow");
        tomorrow.setUsedBy(this.tomorrow());
        ksession.insert((Object)yesterday);
        ksession.insert((Object)tomorrow);
        ksession.fireAllRules();
        logger.close();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("test date greater than"));
        Assert.assertTrue((boolean)results.contains("test date less than"));
    }

    private Date yesterday() {
        GregorianCalendar c = new GregorianCalendar();
        c.set(5, c.get(5) - 1);
        return c.getTime();
    }

    private Date tomorrow() {
        GregorianCalendar c = new GregorianCalendar();
        c.set(5, c.get(5) + 1);
        return c.getTime();
    }
}

