/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import java.util.Comparator;
import org.drools.Cheese;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.integrationtests.DroolsEventList;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.LiveQuery;
import org.drools.runtime.rule.Row;
import org.drools.runtime.rule.ViewChangedEventListener;
import org.junit.Assert;
import org.junit.Test;

public class DroolsEventListTest {
    protected RuleBase getRuleBase() throws Exception {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        config.setMultithreadEvaluation(false);
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    @Test
    public void testOpenQuery() throws Exception {
        String str = "";
        str = str + "package org.drools.test  \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "query cheeses(String $type1, String $type2) \n";
        str = str + "    stilton : Cheese(type == $type1, $price : price) \n";
        str = str + "    cheddar : Cheese(type == $type2, price == stilton.price) \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Cheese stilton1 = new Cheese("stilton", 1);
        Cheese cheddar1 = new Cheese("cheddar", 1);
        Cheese stilton2 = new Cheese("stilton", 2);
        Cheese cheddar2 = new Cheese("cheddar", 2);
        Cheese stilton3 = new Cheese("stilton", 3);
        Cheese cheddar3 = new Cheese("cheddar", 3);
        FactHandle s1Fh = ksession.insert((Object)stilton1);
        FactHandle s2Fh = ksession.insert((Object)stilton2);
        FactHandle s3Fh = ksession.insert((Object)stilton3);
        FactHandle c1Fh = ksession.insert((Object)cheddar1);
        FactHandle c2Fh = ksession.insert((Object)cheddar2);
        FactHandle c3Fh = ksession.insert((Object)cheddar3);
        DroolsEventList list = new DroolsEventList();
        LiveQuery query = ksession.openLiveQuery("cheeses", new Object[]{"cheddar", "stilton"}, (ViewChangedEventListener)list);
        SortedList sorted = new SortedList((EventList)list, (Comparator)new Comparator<Row>(){

            @Override
            public int compare(Row r1, Row r2) {
                Cheese c1 = (Cheese)r1.get("stilton");
                Cheese c2 = (Cheese)r2.get("stilton");
                return c1.getPrice() - c2.getPrice();
            }
        });
        Assert.assertEquals((long)3L, (long)sorted.size());
        Assert.assertEquals((long)1L, (long)((Cheese)((Row)sorted.get(0)).get("stilton")).getPrice());
        Assert.assertEquals((long)2L, (long)((Cheese)((Row)sorted.get(1)).get("stilton")).getPrice());
        Assert.assertEquals((long)3L, (long)((Cheese)((Row)sorted.get(2)).get("stilton")).getPrice());
        stilton3.setPrice(4);
        ksession.update(s3Fh, (Object)stilton3);
        Assert.assertEquals((long)2L, (long)sorted.size());
        Assert.assertEquals((long)1L, (long)((Cheese)((Row)sorted.get(0)).get("stilton")).getPrice());
        Assert.assertEquals((long)2L, (long)((Cheese)((Row)sorted.get(1)).get("stilton")).getPrice());
        stilton3.setPrice(3);
        ksession.update(s3Fh, (Object)stilton3);
        Assert.assertEquals((long)3L, (long)sorted.size());
        Assert.assertEquals((long)1L, (long)((Cheese)((Row)sorted.get(0)).get("stilton")).getPrice());
        Assert.assertEquals((long)2L, (long)((Cheese)((Row)sorted.get(1)).get("stilton")).getPrice());
        Assert.assertEquals((long)3L, (long)((Cheese)((Row)sorted.get(2)).get("stilton")).getPrice());
        stilton2.setPrice(4);
        ksession.update(s2Fh, (Object)stilton2);
        Assert.assertEquals((long)2L, (long)sorted.size());
        Assert.assertEquals((long)1L, (long)((Cheese)((Row)sorted.get(0)).get("stilton")).getPrice());
        Assert.assertEquals((long)3L, (long)((Cheese)((Row)sorted.get(1)).get("stilton")).getPrice());
        cheddar2.setPrice(4);
        ksession.update(c2Fh, (Object)cheddar2);
        Assert.assertEquals((long)3L, (long)sorted.size());
        Assert.assertEquals((long)1L, (long)((Cheese)((Row)sorted.get(0)).get("stilton")).getPrice());
        Assert.assertEquals((long)3L, (long)((Cheese)((Row)sorted.get(1)).get("stilton")).getPrice());
        Assert.assertEquals((long)4L, (long)((Cheese)((Row)sorted.get(2)).get("stilton")).getPrice());
        ksession.retract(s1Fh);
        Assert.assertEquals((long)2L, (long)sorted.size());
        Assert.assertEquals((long)3L, (long)((Cheese)((Row)sorted.get(0)).get("stilton")).getPrice());
        Assert.assertEquals((long)4L, (long)((Cheese)((Row)sorted.get(1)).get("stilton")).getPrice());
        query.close();
        Assert.assertEquals((long)0L, (long)sorted.size());
    }
}

