/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.Cheese;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.lang.Expander;
import org.drools.lang.dsl.DefaultExpanderResolver;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DslTest {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    @Test
    public void testMultiLineTemplates() throws Exception {
        InputStreamReader source = new InputStreamReader(this.getClass().getResourceAsStream("rule_with_expander_multiline.dslr"));
        InputStreamReader dsl = new InputStreamReader(this.getClass().getResourceAsStream("test_dsl_multiline.dsl"));
        Expander ex = new DefaultExpanderResolver((Reader)dsl).get("*", null);
        String r = ex.expand((Reader)source);
        Assert.assertEquals((Object)"when Car(color==\"Red\") then doSomething();", (Object)r.trim());
    }

    @Test
    public void testWithExpanderDSL() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_expander.dsl", this.getClass()), ResourceType.DSL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"rule_with_expander_dsl.dslr", this.getClass()), ResourceType.DSLR);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        String err = kbuilder.getErrors().toString();
        Assert.assertEquals((Object)"", (Object)err);
        Assert.assertEquals((long)0L, (long)kbuilder.getErrors().size());
        Collection pkgs = kbuilder.getKnowledgePackages();
        Assert.assertEquals((long)1L, (long)pkgs.size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        session.insert((Object)new Person("Bob", "http://foo.bar"));
        session.insert((Object)new Cheese("stilton", 42));
        ArrayList messages = new ArrayList();
        session.setGlobal("messages", messages);
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)messages.size());
    }

    @Test
    public void testWithExpanderMore() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_expander.dsl", this.getClass()), ResourceType.DSL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"rule_with_expander_dsl_more.dslr", this.getClass()), ResourceType.DSLR);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        String err = kbuilder.getErrors().toString();
        Assert.assertEquals((Object)"", (Object)err);
        Assert.assertEquals((long)0L, (long)kbuilder.getErrors().size());
        Collection pkgs = kbuilder.getKnowledgePackages();
        Assert.assertEquals((long)1L, (long)pkgs.size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        session.insert((Object)new Person("rage"));
        session.insert((Object)new Cheese("cheddar", 15));
        ArrayList messages = new ArrayList();
        session.setGlobal("messages", messages);
        session.fireAllRules();
        Assert.assertEquals((long)0L, (long)messages.size());
        session.insert((Object)new Person("fire"));
        session.fireAllRules();
        Assert.assertEquals((long)0L, (long)messages.size());
        session.insert((Object)new Cheese("brie", 15));
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)messages.size());
    }

    @Test
    @Ignore
    public void testEmptyDSL() throws Exception {
        String DSL = "# This is an empty dsl file.";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_expander.dsl", this.getClass()), ResourceType.DSL);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader("# This is an empty dsl file.")), ResourceType.DSLR);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        String err = kbuilder.getErrors().toString();
        Assert.assertEquals((Object)"", (Object)err);
        Assert.assertEquals((long)0L, (long)kbuilder.getErrors().size());
        Collection pkgs = kbuilder.getKnowledgePackages();
        Assert.assertEquals((long)0L, (long)pkgs.size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        pkgs = SerializationHelper.serializeObject(pkgs);
        Assert.assertNull((Object)pkgs);
    }

    @Test
    public void testDSLWithIndividualConstraintMappings() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_dslWithIndividualConstraints.dsl", this.getClass()), ResourceType.DSL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_dslWithIndividualConstraints.dslr", this.getClass()), ResourceType.DSLR);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        String err = kbuilder.getErrors().toString();
        Assert.assertEquals((Object)"", (Object)err);
        Assert.assertEquals((long)0L, (long)kbuilder.getErrors().size());
        Collection pkgs = kbuilder.getKnowledgePackages();
        Assert.assertEquals((long)1L, (long)pkgs.size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        Cheese cheese = new Cheese("stilton", 42);
        session.insert((Object)cheese);
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)cheese, results.get(0));
    }
}

