/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.drools.Cheese;
import org.drools.FactA;
import org.drools.FactB;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.Order;
import org.drools.OrderItem;
import org.drools.Person;
import org.drools.Precondition;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.StockTick;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.InternalFactHandle;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.definition.KnowledgePackage;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.event.rule.ActivationCreatedEvent;
import org.drools.event.rule.AgendaEventListener;
import org.drools.impl.EnvironmentFactory;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.ObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.IdentityPlaceholderResolverStrategy;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.Package;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;

public class DynamicRulesTest {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    @Test
    public void testDynamicRuleAdditions() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg1 = SerializationHelper.serializeObject(builder.getPackage());
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg1);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.setGlobal("total", (Object)new Integer(0));
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person bob = new Person("bob", "stilton");
        bob.setStatus("Not evaluated");
        workingMemory.insert((Object)bob);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        Cheese cheddar = new Cheese("cheddar", 5);
        workingMemory.insert((Object)cheddar);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"stilton", list.get(0));
        reader = new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic2.drl"));
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg2 = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg2);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"stilton", list.get(0));
        Assert.assertTrue(("cheddar".equals(list.get(1)) || "cheddar".equals(list.get(2)) ? 1 : 0) != 0);
        Assert.assertTrue(("stilton".equals(list.get(1)) || "stilton".equals(list.get(2)) ? 1 : 0) != 0);
        list.clear();
        reader = new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic3.drl"));
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg3 = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg3);
        workingMemory.fireAllRules();
        Assert.assertEquals((String)"Rule from package 3 should have been fired", (Object)"match Person ok", (Object)bob.getStatus());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)bob, list.get(0));
        reader = new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic4.drl"));
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg4 = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg4);
        workingMemory.fireAllRules();
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        Assert.assertEquals((String)"Rule from package 4 should have been fired", (Object)"Who likes Stilton ok", (Object)bob.getStatus());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)bob, list.get(1));
    }

    @Test
    public void testDynamicRuleRemovals() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic3.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic4.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ReteooRuleBase reteooRuleBase = null;
        RuleBase ruleBase = this.getRuleBase();
        reteooRuleBase = (ReteooRuleBase)ruleBase;
        ruleBase.addPackage(pkg);
        PackageBuilder builder2 = new PackageBuilder();
        builder2.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic2.drl")));
        ruleBase.addPackage(SerializationHelper.serializeObject(builder2.getPackage()));
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person bob = new Person("bob", "stilton");
        bob.setStatus("Not evaluated");
        workingMemory.insert((Object)bob);
        Cheese stilton1 = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton1);
        Cheese stilton2 = new Cheese("stilton", 3);
        workingMemory.insert((Object)stilton2);
        Cheese stilton3 = new Cheese("stilton", 1);
        workingMemory.insert((Object)stilton3);
        Cheese cheddar = new Cheese("cheddar", 5);
        workingMemory.insert((Object)cheddar);
        Assert.assertEquals((long)15L, (long)workingMemory.getAgenda().getActivations().length);
        reteooRuleBase.removeRule("org.drools.test", "Who likes Stilton");
        Assert.assertEquals((long)12L, (long)workingMemory.getAgenda().getActivations().length);
        reteooRuleBase.removeRule("org.drools.test", "like cheese");
        Cheese muzzarela = new Cheese("muzzarela", 5);
        Assert.assertEquals((long)8L, (long)workingMemory.getAgenda().getActivations().length);
        workingMemory.insert((Object)muzzarela);
        Assert.assertEquals((long)9L, (long)workingMemory.getAgenda().getActivations().length);
        reteooRuleBase.removePackage("org.drools.test");
        reteooRuleBase = SerializationHelper.serializeObject(reteooRuleBase);
        Assert.assertEquals((long)0L, (long)workingMemory.getAgenda().getActivations().length);
    }

    @Test
    public void testDynamicRuleRemovalsUnusedWorkingMemory() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic2.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic3.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic4.drl")));
        Package pkg = builder.getPackage();
        ReteooRuleBase reteooRuleBase = null;
        RuleBase ruleBase = this.getRuleBase();
        reteooRuleBase = (ReteooRuleBase)ruleBase;
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        if (reteooRuleBase != null) {
            Assert.assertEquals((long)1L, (long)reteooRuleBase.getPackages().length);
            Assert.assertEquals((long)5L, (long)reteooRuleBase.getPackages()[0].getRules().length);
            reteooRuleBase.removeRule("org.drools.test", "Who likes Stilton");
            Assert.assertEquals((long)4L, (long)reteooRuleBase.getPackages()[0].getRules().length);
            reteooRuleBase.removeRule("org.drools.test", "like cheese");
            Assert.assertEquals((long)3L, (long)reteooRuleBase.getPackages()[0].getRules().length);
            reteooRuleBase.removePackage("org.drools.test");
            Assert.assertEquals((long)0L, (long)reteooRuleBase.getPackages().length);
        }
    }

    @Test
    public void testDynamicFunction() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicFunction1.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        Assert.assertEquals((Object)new Integer(5), list.get(0));
        ruleBase.removeFunction("org.drools.test", "addFive");
        Cheese cheddar = new Cheese("cheddar", 5);
        workingMemory.insert((Object)cheddar);
        try {
            workingMemory.fireAllRules();
            Assert.fail((String)"Function should have been removed and NoClassDefFoundError thrown from the Consequence");
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicFunction2.drl")));
        ruleBase.addPackage(SerializationHelper.serializeObject(builder.getPackage()));
        Cheese brie = new Cheese("brie", 5);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        Assert.assertEquals((Object)new Integer(6), list.get(1));
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicFunction3.drl")));
        ruleBase.addPackage(SerializationHelper.serializeObject(builder.getPackage()));
        Cheese feta = new Cheese("feta", 5);
        workingMemory.insert((Object)feta);
        workingMemory.fireAllRules();
        Assert.assertEquals((Object)new Integer(5), list.get(2));
    }

    @Test
    public void testRemovePackage() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_RemovePackage.drl")));
        RuleBase ruleBase = this.getRuleBase();
        String packageName = builder.getPackage().getName();
        ruleBase.addPackage(SerializationHelper.serializeObject(builder.getPackage()));
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        session.insert((Object)new Precondition("genericcode", "genericvalue"));
        session.fireAllRules();
        RuleBase ruleBaseWM = session.getRuleBase();
        ruleBaseWM.removePackage(packageName);
        PackageBuilder builder1 = new PackageBuilder();
        builder1.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_RemovePackage.drl")));
        ruleBaseWM.addPackage(SerializationHelper.serializeObject(builder1.getPackage()));
        ruleBaseWM = SerializationHelper.serializeObject(ruleBaseWM);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        ruleBaseWM.removePackage(packageName);
        ruleBaseWM.addPackage(SerializationHelper.serializeObject(builder1.getPackage()));
        ruleBaseWM.removePackage(packageName);
        ruleBaseWM.addPackage(SerializationHelper.serializeObject(builder1.getPackage()));
    }

    @Test
    public void testDynamicRules() throws Exception {
        RuleBase ruleBase = this.getRuleBase();
        StatefulSession session = ruleBase.newStatefulSession();
        Cheese a = new Cheese("stilton", 10);
        Cheese b = new Cheese("stilton", 15);
        Cheese c = new Cheese("stilton", 20);
        session.insert((Object)a);
        session.insert((Object)b);
        session.insert((Object)c);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicRules.drl")));
        Package pkg = builder.getPackage();
        ruleBase.addPackage(SerializationHelper.serializeObject(pkg));
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
    }

    @Test
    public void testDynamicRules2() throws Exception {
        RuleBase ruleBase = this.getRuleBase();
        StatefulSession session = ruleBase.newStatefulSession();
        FactA a = new FactA("hello", new Integer(1), new Float(3.14));
        FactB b = new FactB("hello", new Integer(2), new Float(6.28));
        session.insert((Object)a);
        session.insert((Object)b);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicRules2.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
    }

    @Test
    public void testRuleBaseAddRemove() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        ruleBase.removePackage(pkg.getName());
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1.drl")));
        pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        ruleBase.removePackage(pkg.getName());
    }

    @Test
    public void testClassLoaderSwitchsUsingConf() throws Exception {
        try {
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/")}, this.getClass().getClassLoader());
            Class<?> cheeseClass = loader1.loadClass("org.drools.Cheese");
            PackageBuilderConfiguration conf = new PackageBuilderConfiguration(new ClassLoader[]{loader1});
            PackageBuilder builder = new PackageBuilder(conf);
            builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1.drl")));
            RuleBaseConfiguration rbconf = new RuleBaseConfiguration(new ClassLoader[]{loader1});
            RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)rbconf);
            Package pkg = SerializationHelper.serializeObject(builder.getPackage());
            ruleBase.addPackage(pkg);
            StatefulSession wm = ruleBase.newStatefulSession();
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/")}, this.getClass().getClassLoader());
            cheeseClass = loader2.loadClass("org.drools.Cheese");
            conf = new PackageBuilderConfiguration(new ClassLoader[]{loader2});
            builder = new PackageBuilder(conf);
            builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1.drl")));
            rbconf = new RuleBaseConfiguration(new ClassLoader[]{loader2});
            ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)rbconf);
            pkg = SerializationHelper.serializeObject(builder.getPackage());
            ruleBase.addPackage(pkg);
            wm = ruleBase.newStatefulSession();
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            Assert.fail((String)"No ClassCastException should be raised.");
        }
    }

    @Test
    public void testClassLoaderSwitchsUsingContext() throws Exception {
        try {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/")}, this.getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(loader1);
            Class<?> cheeseClass = loader1.loadClass("org.drools.Cheese");
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1.drl")));
            RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            Package pkg = SerializationHelper.serializeObject(builder.getPackage());
            ruleBase.addPackage(pkg);
            StatefulSession wm = ruleBase.newStatefulSession();
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/")}, this.getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(loader2);
            cheeseClass = loader2.loadClass("org.drools.Cheese");
            builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1.drl")));
            ruleBase = RuleBaseFactory.newRuleBase();
            pkg = SerializationHelper.serializeObject(builder.getPackage());
            ruleBase.addPackage(pkg);
            wm = ruleBase.newStatefulSession();
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            Thread.currentThread().setContextClassLoader(original);
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            Assert.fail((String)"No ClassCastException should be raised.");
        }
    }

    @Test
    public void testCollectDynamicRules() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_CollectDynamicRules1.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.insert((Object)new Cheese("stilton", 10));
        workingMemory.insert((Object)new Cheese("brie", 10));
        workingMemory.insert((Object)new Cheese("stilton", 10));
        workingMemory.insert((Object)new Cheese("muzzarela", 10));
        PackageBuilder builder2 = new PackageBuilder();
        builder2.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_CollectDynamicRules2.drl")));
        Package pkg2 = builder2.getPackage();
        ruleBase.addPackage(pkg2);
        workingMemory.fireAllRules();
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((List)list.get(0)).size());
    }

    @Test
    public void testDynamicNotNode() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_CollectDynamicRules1.drl", this.getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Collection kpkgs = SerializationHelper.serializeObject(kbuilder.getKnowledgePackages());
        kbase.addKnowledgePackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("drools.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(null, env);
        List results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese a = new Cheese("stilton", 10);
        Cheese b = new Cheese("stilton", 15);
        Cheese c = new Cheese("stilton", 20);
        ksession.insert((Object)a);
        ksession.insert((Object)b);
        ksession.insert((Object)c);
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_DynamicNotNode.drl", this.getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kpkgs = SerializationHelper.serializeObject(kbuilder.getKnowledgePackages());
        kbase.addKnowledgePackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, false);
        results = (List)ksession.getGlobal("results");
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        kbase.removeKnowledgePackage("org.drools");
        ksession.retract(ksession.getFactHandle((Object)b));
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_DynamicNotNode.drl", this.getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kpkgs = SerializationHelper.serializeObject(kbuilder.getKnowledgePackages());
        kbase.addKnowledgePackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, false);
        results = (List)ksession.getGlobal("results");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testDynamicRulesAddRemove() {
        try {
            RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            PackageBuilder tomBuilder = new PackageBuilder();
            tomBuilder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicRulesTom.drl")));
            ruleBase.addPackage(tomBuilder.getPackage());
            StatefulSession session = ruleBase.newStatefulSession();
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            InternalFactHandle h1 = (InternalFactHandle)session.insert((Object)new Person("tom", 1));
            InternalFactHandle h2 = (InternalFactHandle)session.insert((Object)new Person("fred", 2));
            InternalFactHandle h3 = (InternalFactHandle)session.insert((Object)new Person("harry", 3));
            InternalFactHandle h4 = (InternalFactHandle)session.insert((Object)new Person("fred", 4));
            InternalFactHandle h5 = (InternalFactHandle)session.insert((Object)new Person("ed", 5));
            InternalFactHandle h6 = (InternalFactHandle)session.insert((Object)new Person("tom", 6));
            InternalFactHandle h7 = (InternalFactHandle)session.insert((Object)new Person("sreeni", 7));
            InternalFactHandle h8 = (InternalFactHandle)session.insert((Object)new Person("jill", 8));
            InternalFactHandle h9 = (InternalFactHandle)session.insert((Object)new Person("ed", 9));
            InternalFactHandle h10 = (InternalFactHandle)session.insert((Object)new Person("tom", 10));
            session.fireAllRules();
            Assert.assertEquals((long)3L, (long)results.size());
            Assert.assertTrue((boolean)results.contains(h1.getObject()));
            Assert.assertTrue((boolean)results.contains(h6.getObject()));
            Assert.assertTrue((boolean)results.contains(h10.getObject()));
            results.clear();
            PackageBuilder fredBuilder = new PackageBuilder();
            fredBuilder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicRulesFred.drl")));
            ruleBase.addPackage(fredBuilder.getPackage());
            session.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertTrue((boolean)results.contains(h2.getObject()));
            Assert.assertTrue((boolean)results.contains(h4.getObject()));
            results.clear();
            ruleBase.removePackage("tom");
            PackageBuilder edBuilder = new PackageBuilder();
            edBuilder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicRulesEd.drl")));
            ruleBase.addPackage(edBuilder.getPackage());
            session.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertTrue((boolean)results.contains(h5.getObject()));
            Assert.assertTrue((boolean)results.contains(h9.getObject()));
            results.clear();
            ((Person)h3.getObject()).setName("ed");
            session.update((FactHandle)h3, h3.getObject());
            session.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertTrue((boolean)results.contains(h3.getObject()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Should not raise any exception: " + e.getMessage()));
        }
    }

    @Test
    public void testDynamicRuleRemovalsSubNetwork() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork1.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ReteooRuleBase reteooRuleBase = null;
        RuleBase ruleBase = this.getRuleBase();
        reteooRuleBase = (ReteooRuleBase)ruleBase;
        ruleBase.addPackage(pkg);
        PackageBuilder builder2 = new PackageBuilder();
        builder2.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork2.drl")));
        ruleBase.addPackage(SerializationHelper.serializeObject(builder2.getPackage()));
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("results", list);
        Order order = new Order();
        OrderItem item1 = new OrderItem(order, 1, "Adventure Guide Brazil", 1, 24);
        order.addItem(item1);
        session.insert((Object)item1);
        OrderItem item2 = new OrderItem(order, 2, "Prehistoric Britain", 1, 15);
        order.addItem(item2);
        session.insert((Object)item2);
        OrderItem item3 = new OrderItem(order, 3, "Holiday Music", 2, 9);
        order.addItem(item3);
        session.insert((Object)item3);
        OrderItem item4 = new OrderItem(order, 4, "Very Best of Mick Jagger", 2, 11);
        order.addItem(item4);
        session.insert((Object)item4);
        session.insert((Object)order);
        Assert.assertEquals((long)11L, (long)session.getAgenda().getActivations().length);
        reteooRuleBase.removeRule("org.drools", "Apply Discount on all books");
        Assert.assertEquals((long)10L, (long)session.getAgenda().getActivations().length);
        reteooRuleBase.removeRule("org.drools", "like book");
        OrderItem item5 = new OrderItem(order, 5, "Sinatra : Vegas", 2, 5);
        Assert.assertEquals((long)8L, (long)session.getAgenda().getActivations().length);
        session.insert((Object)item5);
        Assert.assertEquals((long)10L, (long)session.getAgenda().getActivations().length);
        reteooRuleBase.removePackage("org.drools");
        Assert.assertEquals((long)0L, (long)session.getAgenda().getActivations().length);
    }

    @Test
    public void testDynamicRuleRemovalsUnusedWorkingMemorySubNetwork() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork1.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork2.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork.drl")));
        Package pkg = builder.getPackage();
        ReteooRuleBase reteooRuleBase = null;
        RuleBase ruleBase = this.getRuleBase();
        reteooRuleBase = (ReteooRuleBase)ruleBase;
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        if (reteooRuleBase != null) {
            Assert.assertEquals((long)1L, (long)reteooRuleBase.getPackages().length);
            Assert.assertEquals((long)4L, (long)reteooRuleBase.getPackages()[0].getRules().length);
            reteooRuleBase.removeRule("org.drools", "Apply Discount on all books");
            Assert.assertEquals((long)3L, (long)reteooRuleBase.getPackages()[0].getRules().length);
            reteooRuleBase.removeRule("org.drools", "like book");
            Assert.assertEquals((long)2L, (long)reteooRuleBase.getPackages()[0].getRules().length);
            reteooRuleBase.removePackage("org.drools");
            Assert.assertEquals((long)0L, (long)reteooRuleBase.getPackages().length);
        }
    }

    @Test
    public void testRemovePackageSubNetwork() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork.drl")));
        RuleBase ruleBase = this.getRuleBase();
        String packageName = builder.getPackage().getName();
        ruleBase.addPackage(SerializationHelper.serializeObject(builder.getPackage()));
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        List results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Order order = new Order();
        OrderItem item1 = new OrderItem(order, 1, "Adventure Guide Brazil", 1, 24);
        OrderItem item2 = new OrderItem(order, 2, "Prehistoric Britain", 1, 15);
        OrderItem item3 = new OrderItem(order, 3, "Holiday Music", 2, 9);
        OrderItem item4 = new OrderItem(order, 4, "Very Best of Mick Jagger", 2, 11);
        OrderItem item5 = new OrderItem(order, 5, "The Master and Margarita", 1, 29);
        order.addItem(item1);
        order.addItem(item2);
        order.addItem(item3);
        order.addItem(item4);
        order.addItem(item5);
        workingMemory.insert((Object)order);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((List)results.get(0)).size());
        results.clear();
        RuleBase ruleBaseWM = workingMemory.getRuleBase();
        ruleBaseWM.removePackage(packageName);
        PackageBuilder builder1 = new PackageBuilder();
        builder1.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork.drl")));
        ruleBaseWM.addPackage(SerializationHelper.serializeObject(builder1.getPackage()));
        workingMemory.fireAllRules();
        results = (List)workingMemory.getGlobal("results");
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((List)results.get(0)).size());
        results.clear();
        ruleBaseWM.removePackage(packageName);
        ruleBaseWM.addPackage(SerializationHelper.serializeObject(builder1.getPackage()));
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((List)results.get(0)).size());
        results.clear();
        ruleBaseWM.removePackage(packageName);
        ruleBaseWM.addPackage(SerializationHelper.serializeObject(builder1.getPackage()));
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((List)results.get(0)).size());
        results.clear();
    }

    @Test
    public void testRuleBaseAddRemoveSubNetworks() throws Exception {
        try {
            RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork.drl")));
            Package pkg = SerializationHelper.serializeObject(builder.getPackage());
            ruleBase.addPackage(pkg);
            ruleBase.removePackage(pkg.getName());
            builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork.drl")));
            pkg = SerializationHelper.serializeObject(builder.getPackage());
            ruleBase.addPackage(pkg);
            ruleBase.removePackage(pkg.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Should not raise any exception");
        }
    }

    @Test
    public void testDynamicRuleAdditionsWithEntryPoints() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_DynamicWithEntryPoint.drl"));
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)reader), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        WorkingMemoryEntryPoint ep = ksession.getWorkingMemoryEntryPoint("in-channel");
        ep.insert((Object)new StockTick(1L, "RHT", 20.0, 10000L));
        ep.insert((Object)new StockTick(2L, "RHT", 21.0, 15000L));
        ep.insert((Object)new StockTick(3L, "RHT", 22.0, 20000L));
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
    }

    @Test
    public void testIsolatedClassLoaderWithEnumsPkgBuilder() throws Exception {
        try {
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/testEnum.jar")}, this.getClass().getClassLoader());
            KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{loader1});
            KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
            builder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("test_EnumSerialization.drl")), ResourceType.DRL);
            Collection pkgs = builder.getKnowledgePackages();
            KnowledgePackage pkg = (KnowledgePackage)pkgs.iterator().next();
            byte[] out = DroolsStreamUtils.streamOut((Object)((KnowledgePackageImp)pkg).pkg);
            KnowledgeBaseConfiguration kbaseConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{loader1});
            KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kbaseConf);
            kbase.addKnowledgePackages(pkgs);
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/testEnum.jar")}, this.getClass().getClassLoader());
            KnowledgeBuilderConfiguration conf2 = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{loader2});
            KnowledgeBuilder builder2 = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf2);
            builder2.add(ResourceFactory.newByteArrayResource((byte[])out), ResourceType.PKG);
            Collection pkgs2 = builder2.getKnowledgePackages();
            KnowledgeBaseConfiguration kbaseConf2 = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{loader2});
            KnowledgeBase kbase2 = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kbaseConf2);
            kbase2.addKnowledgePackages(pkgs2);
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            Assert.fail((String)"No ClassCastException should be raised.");
        }
    }

    @Test
    public void testIsolatedClassLoaderWithEnumsContextClassloader() throws Exception {
        try {
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/testEnum.jar")}, this.getClass().getClassLoader());
            KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{loader1});
            KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
            builder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("test_EnumSerialization.drl")), ResourceType.DRL);
            Collection pkgs = builder.getKnowledgePackages();
            KnowledgePackage pkg = (KnowledgePackage)pkgs.iterator().next();
            byte[] out = DroolsStreamUtils.streamOut((Object)pkg);
            KnowledgeBaseConfiguration kbaseConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{loader1});
            KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kbaseConf);
            kbase.addKnowledgePackages(pkgs);
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/testEnum.jar")}, this.getClass().getClassLoader());
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(loader2);
            KnowledgePackage pkg2 = (KnowledgePackage)DroolsStreamUtils.streamIn((byte[])out);
            Set<KnowledgePackage> pkgs2 = Collections.singleton(pkg2);
            Thread.currentThread().setContextClassLoader(ccl);
            KnowledgeBaseConfiguration kbaseConf2 = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{loader2});
            KnowledgeBase kbase2 = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kbaseConf2);
            kbase2.addKnowledgePackages(pkgs2);
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            Assert.fail((String)"No ClassCastException should be raised.");
        }
    }

    @Test
    public void testDynamicRuleRemovalsSubNetworkAndNot() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("test_DynamicRulesWithNotSubnetwork.drl")), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        AgendaEventListener alistener = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(alistener);
        ksession.insert((Object)new Person("toni"));
        ((AgendaEventListener)Mockito.verify((Object)alistener, (VerificationMode)Mockito.never())).activationCreated((ActivationCreatedEvent)Mockito.any(ActivationCreatedEvent.class));
        ksession.insert((Object)new Person("bob"));
        ((AgendaEventListener)Mockito.verify((Object)alistener, (VerificationMode)Mockito.times((int)1))).activationCreated((ActivationCreatedEvent)Mockito.any(ActivationCreatedEvent.class));
        ksession.insert((Object)new Person("mark"));
        ((AgendaEventListener)Mockito.verify((Object)alistener, (VerificationMode)Mockito.times((int)1))).activationCreated((ActivationCreatedEvent)Mockito.any(ActivationCreatedEvent.class));
        kbase.removeKnowledgePackage("org.drools");
        Assert.assertEquals((long)0L, (long)kbase.getKnowledgePackages().size());
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("test_DynamicRulesWithNotSubnetwork.drl")), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        ((AgendaEventListener)Mockito.verify((Object)alistener, (VerificationMode)Mockito.times((int)2))).activationCreated((ActivationCreatedEvent)Mockito.any(ActivationCreatedEvent.class));
    }

    @Test
    public void testSharedLIANodeRemoval() throws IOException, DroolsParserException {
        String str = "global java.util.List list;\n";
        str = str + "rule \"test\"\n";
        str = str + "when\n";
        str = str + "  exists(eval(true))\n";
        str = str + "then\n";
        str = str + " list.add(\"fired\");\n";
        str = str + "end\n";
        PackageBuilder pkgBuilder = new PackageBuilder();
        pkgBuilder.addPackageFromDrl((Reader)new StringReader(str));
        Assert.assertTrue((String)"Should not have errors", (boolean)pkgBuilder.getErrors().isEmpty());
        ReteooRuleBase rb = new ReteooRuleBase("dummy");
        rb.addPackage(pkgBuilder.getPackage());
        ArrayList list = new ArrayList();
        StatefulSession session = rb.newStatefulSession();
        session.setGlobal("list", list);
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        list.clear();
        rb.removePackage(pkgBuilder.getPackage().getName());
        rb.addPackage(pkgBuilder.getPackage());
        session = rb.newStatefulSession();
        session.setGlobal("list", list);
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testJBRULES_2206() {
        KnowledgeBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        ((RuleBaseConfiguration)config).setRuleBaseUpdateHandler(null);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)config);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        session.addEventListener(ael);
        for (int i = 0; i < 5; ++i) {
            session.insert((Object)new Cheese());
        }
        this.addDrlToKBase(kbase, "test_JBRULES_2206_1.drl");
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).activationCreated((ActivationCreatedEvent)Mockito.any(ActivationCreatedEvent.class));
        int fireCount = session.fireAllRules();
        Assert.assertEquals((long)2L, (long)fireCount);
        this.addDrlToKBase(kbase, "test_JBRULES_2206_2.drl");
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)3))).activationCreated((ActivationCreatedEvent)Mockito.any(ActivationCreatedEvent.class));
        fireCount = session.fireAllRules();
        Assert.assertEquals((long)1L, (long)fireCount);
        session.dispose();
    }

    private void addDrlToKBase(KnowledgeBase kbase, String drlName) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)drlName, DynamicRulesTest.class), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
    }

    public class SubvertedClassLoader
    extends URLClassLoader {
        private static final long serialVersionUID = 510L;

        public SubvertedClassLoader(URL[] urls, ClassLoader parentClassLoader) {
            super(urls, parentClassLoader);
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, resolve);
                }
            }
            return c;
        }
    }
}

