/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.File;
import java.util.ArrayList;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Message;
import org.drools.base.mvel.MVELDebugHandler;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.io.ResourceFactory;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Assert;
import org.junit.Test;
import org.mvel2.MVELRuntime;
import org.mvel2.debug.Debugger;
import org.mvel2.debug.Frame;

public class HelloWorldTest {
    @Test
    public void testHelloWorld() throws Exception {
        KnowledgeBase kbase = this.readKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        File testTmpDir = new File("target/test-tmp/");
        testTmpDir.mkdirs();
        KnowledgeRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newFileLogger((KnowledgeRuntimeEventManager)ksession, (String)"target/test-tmp/testHelloWorld");
        Message message = new Message();
        message.setMessage("Hello World");
        message.setStatus(0);
        ksession.insert((Object)message);
        ksession.fireAllRules();
        logger.close();
    }

    @Test
    public void testHelloWorldDebug() throws Exception {
        final ArrayList knownVariables = new ArrayList();
        MVELRuntime.resetDebugger();
        MVELDebugHandler.setDebugMode((boolean)true);
        MVELRuntime.setThreadDebugger((Debugger)new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("onBreak");
                for (String var : frame.getFactory().getKnownVariables()) {
                    knownVariables.add(var);
                }
                return 0;
            }
        });
        String source = "org.drools.integrationtests.Rule_Hello_World";
        MVELRuntime.registerBreakpoint((String)source, (int)1);
        KnowledgeBase kbase = this.readKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        File testTmpDir = new File("target/test-tmp/");
        testTmpDir.mkdirs();
        KnowledgeRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newFileLogger((KnowledgeRuntimeEventManager)ksession, (String)"target/test-tmp/testHelloWorldDebug");
        Message message = new Message();
        message.setMessage("Hello World");
        message.setStatus(0);
        ksession.insert((Object)message);
        ksession.fireAllRules();
        logger.close();
        Assert.assertEquals((long)6L, (long)knownVariables.size());
        Assert.assertTrue((boolean)knownVariables.contains("drools"));
        Assert.assertTrue((boolean)knownVariables.contains("myMessage"));
        Assert.assertTrue((boolean)knownVariables.contains("rule"));
        Assert.assertTrue((boolean)knownVariables.contains("kcontext"));
        Assert.assertTrue((boolean)knownVariables.contains("this"));
        Assert.assertTrue((boolean)knownVariables.contains("m"));
        Assert.assertTrue((boolean)knownVariables.contains("myMessage"));
    }

    private KnowledgeBase readKnowledgeBase() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"Sample.drl", HelloWorldTest.class), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }
}

