/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.common.InternalFactHandle;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.SerializationHelper;
import org.drools.rule.Package;
import org.junit.Assert;
import org.junit.Test;

public class LRUnlinkingTest {
    @Test
    public void multipleJoinsUsingSameOTN() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_LRUnlinking.drl")));
        Package pkg = builder.getPackage();
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setLRUnlinkingEnabled(true);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession wmOne = ruleBase.newStatefulSession();
        StatefulSession wmTwo = ruleBase.newStatefulSession();
        ArrayList listOne = new ArrayList();
        ArrayList listTwo = new ArrayList();
        wmOne.setGlobal("results", listOne);
        wmTwo.setGlobal("results", listTwo);
        Person name = new Person();
        Person likes = new Person();
        Person age = new Person();
        Person hair = new Person();
        Person happy = new Person();
        Person match = new Person();
        name.setName("Ana");
        likes.setLikes("Chocolate");
        age.setAge(30);
        hair.setHair("brown");
        happy.setHappy(true);
        match.setName("Leo");
        match.setLikes("Chocolate");
        match.setAge(30);
        match.setHair("brown");
        match.setHappy(true);
        wmOne.insert((Object)name);
        wmOne.insert((Object)likes);
        wmOne.insert((Object)age);
        wmOne.fireAllRules();
        Assert.assertEquals((String)"Should not have fired", (long)0L, (long)listOne.size());
        wmTwo.insert((Object)name);
        wmTwo.insert((Object)likes);
        wmTwo.insert((Object)age);
        wmTwo.fireAllRules();
        Assert.assertEquals((String)"Should not have fired", (long)0L, (long)listTwo.size());
        wmOne.insert((Object)hair);
        wmOne.insert((Object)happy);
        InternalFactHandle matchHandle = (InternalFactHandle)wmOne.insert((Object)match);
        wmOne.fireAllRules();
        Assert.assertTrue((String)"Should have fired", (listOne.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should have inserted the match Person", (Object)matchHandle.getObject(), listOne.get(0));
        wmTwo.fireAllRules();
        Assert.assertEquals((String)"Should not have fired", (long)0L, (long)listTwo.size());
        wmTwo.insert((Object)hair);
        wmTwo.insert((Object)happy);
        wmTwo.insert((Object)match);
        wmTwo.fireAllRules();
        Assert.assertTrue((String)"Should have fired", (listTwo.size() > 0 ? 1 : 0) != 0);
    }
}

