/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.drools.Address;
import org.drools.Cell;
import org.drools.Cheese;
import org.drools.ClockType;
import org.drools.FactA;
import org.drools.FactB;
import org.drools.FactC;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.Message;
import org.drools.Person;
import org.drools.Primitives;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.base.ClassObjectType;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.BaseNode;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.conf.EventProcessingOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.impl.EnvironmentFactory;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.integrationtests.IteratorToList;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.marshalling.Marshaller;
import org.drools.marshalling.MarshallerFactory;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.ObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.IdentityPlaceholderResolverStrategy;
import org.drools.marshalling.impl.RuleBaseNodes;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MockTupleSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooStatefulSession;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.MapBackedClassLoader;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.drools.spi.Consequence;
import org.drools.spi.GlobalResolver;
import org.drools.spi.KnowledgeHelper;
import org.drools.time.impl.DurationTimer;
import org.drools.time.impl.PseudoClockScheduler;
import org.drools.time.impl.Timer;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class MarshallingTest {
    @Test
    public void testSerializable() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_Serializable.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        if (builder.hasErrors()) {
            Assert.fail((String)builder.getErrors().toString());
        }
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        Assert.assertEquals((long)0L, (long)builder.getErrors().getErrors().length);
        RuleBase ruleBase = this.getRuleBase(pkg);
        Map map = new HashMap<String, RuleBase>();
        map.put("x", ruleBase);
        map = SerializationHelper.serializeObject(map);
        ruleBase = (RuleBase)map.get("x");
        Rule[] rules = ruleBase.getPackages()[0].getRules();
        Assert.assertEquals((long)4L, (long)rules.length);
        Assert.assertEquals((Object)"match Person 1", (Object)rules[0].getName());
        Assert.assertEquals((Object)"match Person 2", (Object)rules[1].getName());
        Assert.assertEquals((Object)"match Person 3", (Object)rules[2].getName());
        Assert.assertEquals((Object)"match Integer", (Object)rules[3].getName());
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        Assert.assertEquals((long)1L, (long)IteratorToList.convert(session.iterateObjects()).size());
        Assert.assertEquals((Object)bob, IteratorToList.convert(session.iterateObjects()).get(0));
        Assert.assertEquals((long)2L, (long)session.getAgenda().agendaSize());
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)new Integer(4), list.get(0));
        list = IteratorToList.convert(session.iterateObjects());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(bob));
        Assert.assertTrue((boolean)list.contains(new Person("help")));
    }

    @Test
    public void testSerializeWorkingMemoryAndRuleBase1() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_Serializable.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        Assert.assertEquals((long)0L, (long)builder.getErrors().getErrors().length);
        RuleBase ruleBase = this.getRuleBase();
        StatefulSession session = ruleBase.newStatefulSession();
        Map map = new HashMap<String, RuleBase>();
        map.put("x", ruleBase);
        map = SerializationHelper.serializeObject(map);
        ruleBase = (RuleBase)map.get("x");
        ruleBase.addPackage(pkg);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        Rule[] rules = ruleBase.getPackages()[0].getRules();
        Assert.assertEquals((long)4L, (long)rules.length);
        Assert.assertEquals((Object)"match Person 1", (Object)rules[0].getName());
        Assert.assertEquals((Object)"match Person 2", (Object)rules[1].getName());
        Assert.assertEquals((Object)"match Person 3", (Object)rules[2].getName());
        Assert.assertEquals((Object)"match Integer", (Object)rules[3].getName());
        Assert.assertEquals((long)1L, (long)IteratorToList.convert(session.iterateObjects()).size());
        Assert.assertEquals((Object)bob, IteratorToList.convert(session.iterateObjects()).get(0));
        Assert.assertEquals((long)2L, (long)session.getAgenda().agendaSize());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)new Integer(4), list.get(0));
        Assert.assertEquals((long)2L, (long)IteratorToList.convert(session.iterateObjects()).size());
        Assert.assertTrue((boolean)IteratorToList.convert(session.iterateObjects()).contains(bob));
        Assert.assertTrue((boolean)IteratorToList.convert(session.iterateObjects()).contains(new Person("help")));
    }

    @Test
    public void testSerializeWorkingMemoryAndRuleBase2() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_Serializable.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        Assert.assertEquals((long)0L, (long)builder.getErrors().getErrors().length);
        RuleBase ruleBase = this.getRuleBase();
        Map map = new HashMap<String, RuleBase>();
        map.put("x", ruleBase);
        map = SerializationHelper.serializeObject(map);
        ruleBase = (RuleBase)map.get("x");
        StatefulSession session = ruleBase.newStatefulSession();
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        ruleBase.addPackage(pkg);
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        Rule[] rules = ruleBase.getPackages()[0].getRules();
        Assert.assertEquals((long)4L, (long)rules.length);
        Assert.assertEquals((Object)"match Person 1", (Object)rules[0].getName());
        Assert.assertEquals((Object)"match Person 2", (Object)rules[1].getName());
        Assert.assertEquals((Object)"match Person 3", (Object)rules[2].getName());
        Assert.assertEquals((Object)"match Integer", (Object)rules[3].getName());
        Assert.assertEquals((long)1L, (long)IteratorToList.convert(session.iterateObjects()).size());
        Assert.assertEquals((Object)bob, IteratorToList.convert(session.iterateObjects()).get(0));
        Assert.assertEquals((long)2L, (long)session.getAgenda().agendaSize());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)new Integer(4), list.get(0));
        Assert.assertEquals((long)2L, (long)IteratorToList.convert(session.iterateObjects()).size());
        Assert.assertTrue((boolean)IteratorToList.convert(session.iterateObjects()).contains(bob));
        Assert.assertTrue((boolean)IteratorToList.convert(session.iterateObjects()).contains(new Person("help")));
    }

    @Test
    public void testSerializeWorkingMemoryAndRuleBase3() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_Serializable.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        Assert.assertEquals((long)0L, (long)builder.getErrors().getErrors().length);
        RuleBase ruleBase = this.getRuleBase();
        StatefulSession session = ruleBase.newStatefulSession();
        ruleBase.addPackage(pkg);
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        Map map = new HashMap<String, RuleBase>();
        map.put("x", ruleBase);
        map = SerializationHelper.serializeObject(map);
        ruleBase = (RuleBase)map.get("x");
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        Rule[] rules = ruleBase.getPackages()[0].getRules();
        Assert.assertEquals((long)4L, (long)rules.length);
        Assert.assertEquals((Object)"match Person 1", (Object)rules[0].getName());
        Assert.assertEquals((Object)"match Person 2", (Object)rules[1].getName());
        Assert.assertEquals((Object)"match Person 3", (Object)rules[2].getName());
        Assert.assertEquals((Object)"match Integer", (Object)rules[3].getName());
        Assert.assertEquals((long)1L, (long)IteratorToList.convert(session.iterateObjects()).size());
        Assert.assertEquals((Object)bob, IteratorToList.convert(session.iterateObjects()).get(0));
        Assert.assertEquals((long)2L, (long)session.getAgenda().agendaSize());
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)new Integer(4), list.get(0));
        Assert.assertEquals((long)2L, (long)IteratorToList.convert(session.iterateObjects()).size());
        Assert.assertTrue((boolean)IteratorToList.convert(session.iterateObjects()).contains(bob));
        Assert.assertTrue((boolean)IteratorToList.convert(session.iterateObjects()).contains(new Person("help")));
    }

    @Test
    public void testSerializeAdd() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        List list = new ArrayList();
        session.setGlobal("list", list);
        InternalFactHandle stilton = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        Assert.assertEquals((long)list.size(), (long)1L);
        Assert.assertEquals((Object)"stilton", list.get(0));
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        list = (List)session.getGlobal("list");
        Assert.assertNotNull(list);
        Assert.assertEquals((long)list.size(), (long)1L);
        Assert.assertEquals((Object)"stilton", list.get(0));
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic3.drl")));
        pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        InternalFactHandle bob = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        Assert.assertEquals((long)list.size(), (long)3L);
        Assert.assertEquals((Object)bob.getObject(), list.get(1));
        Assert.assertEquals((Object)"stilton", list.get(2));
        session.dispose();
    }

    @Test
    public void testSerializationOfIndexedWM() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_Serializable2.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg = builder.getPackage();
        Assert.assertEquals((String)builder.getErrors().toString(), (long)0L, (long)builder.getErrors().getErrors().length);
        RuleBase ruleBase = this.getRuleBase(pkg);
        Map map = new HashMap<String, RuleBase>();
        map.put("x", ruleBase);
        map = SerializationHelper.serializeObject(map);
        ruleBase = (RuleBase)map.get("x");
        Rule[] rules = ruleBase.getPackages()[0].getRules();
        Assert.assertEquals((long)3L, (long)rules.length);
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("list", new ArrayList());
        Primitives p = new Primitives();
        p.setBytePrimitive((byte)1);
        p.setShortPrimitive((short)2);
        p.setIntPrimitive(3);
        session.insert((Object)p);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        Assert.assertEquals((long)1L, (long)IteratorToList.convert(session.iterateObjects()).size());
        Assert.assertEquals((Object)p, IteratorToList.convert(session.iterateObjects()).get(0));
        Assert.assertEquals((long)3L, (long)session.getAgenda().agendaSize());
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"1", list.get(0));
        Assert.assertEquals((Object)"2", list.get(1));
        Assert.assertEquals((Object)"3", list.get(2));
    }

    @Test
    public void testSerializeAdd2() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1_0.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        List results = new ArrayList();
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        session.insert((Object)new Cheese("brie", 10));
        InternalFactHandle bob = (InternalFactHandle)session.insert((Object)new Person("bob", 10));
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)stilton1.getObject(), results.get(0));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StatefulKnowledgeSessionImpl ksession = new StatefulKnowledgeSessionImpl((ReteooWorkingMemory)((ReteooStatefulSession)session));
        Marshaller marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)ksession.getKnowledgeBase());
        marshaller.marshall((OutputStream)baos, (StatefulKnowledgeSession)ksession);
        baos.close();
        GlobalResolver resolver = session.getGlobalResolver();
        byte[] serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)new KnowledgeBaseImpl(ruleBase));
        ksession = (StatefulKnowledgeSessionImpl)marshaller.unmarshall((InputStream)new ByteArrayInputStream(baos.toByteArray()), KnowledgeBaseFactory.newKnowledgeSessionConfiguration(), EnvironmentFactory.newEnvironment());
        session = (ReteooStatefulSession)ksession.session;
        session.setGlobalResolver(resolver);
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic3_0.drl")));
        pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle mark = (InternalFactHandle)session.insert((Object)new Person("mark", 20));
        session.fireAllRules();
        results = (List)session.getGlobal("results");
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((Object)stilton2.getObject(), results.get(1));
        Assert.assertEquals((Object)mark.getObject(), results.get(2));
        Assert.assertEquals((Object)bob.getObject(), results.get(3));
        serializedRulebase = null;
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
    }

    @Test
    public void testSerializeAdd_newRuleNotFiredForNewData() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1_0.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        List results = new ArrayList();
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie1 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        GlobalResolver resolver = session.getGlobalResolver();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StatefulKnowledgeSessionImpl ksession = new StatefulKnowledgeSessionImpl((ReteooWorkingMemory)((ReteooStatefulSession)session));
        Marshaller marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)ksession.getKnowledgeBase());
        marshaller.marshall((OutputStream)baos, (StatefulKnowledgeSession)ksession);
        baos.close();
        byte[] serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)stilton1.getObject(), results.get(0));
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)new KnowledgeBaseImpl(ruleBase));
        ksession = (StatefulKnowledgeSessionImpl)marshaller.unmarshall((InputStream)new ByteArrayInputStream(baos.toByteArray()), KnowledgeBaseFactory.newKnowledgeSessionConfiguration(), EnvironmentFactory.newEnvironment());
        session = (ReteooStatefulSession)ksession.session;
        session.setGlobalResolver(resolver);
        results = (List)session.getGlobal("results");
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1_1.drl")));
        pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle brie3 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 30));
        session.fireAllRules();
        Assert.assertEquals((long)5L, (long)results.size());
        Assert.assertEquals((Object)stilton2.getObject(), results.get(1));
        Assert.assertEquals((Object)brie3.getObject(), results.get(2));
        Assert.assertEquals((Object)brie2.getObject(), results.get(3));
        Assert.assertEquals((Object)brie1.getObject(), results.get(4));
        serializedRulebase = null;
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
    }

    @Test
    public void testSerializeAdd3() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1_0.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        List results = new ArrayList();
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie1 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        GlobalResolver resolver = session.getGlobalResolver();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StatefulKnowledgeSessionImpl ksession = new StatefulKnowledgeSessionImpl((ReteooWorkingMemory)((ReteooStatefulSession)session));
        Marshaller marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)ksession.getKnowledgeBase());
        marshaller.marshall((OutputStream)baos, (StatefulKnowledgeSession)ksession);
        baos.close();
        byte[] serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)stilton1.getObject(), results.get(0));
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)new KnowledgeBaseImpl(ruleBase));
        ksession = (StatefulKnowledgeSessionImpl)marshaller.unmarshall((InputStream)new ByteArrayInputStream(baos.toByteArray()), KnowledgeBaseFactory.newKnowledgeSessionConfiguration(), EnvironmentFactory.newEnvironment());
        session = (ReteooStatefulSession)ksession.session;
        session.setGlobalResolver(resolver);
        results = (List)session.getGlobal("results");
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic3_0.drl")));
        pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob1 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob2 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((Object)stilton2.getObject(), results.get(1));
        Assert.assertEquals((Object)bob2.getObject(), results.get(2));
        Assert.assertEquals((Object)bob1.getObject(), results.get(3));
        serializedRulebase = null;
        resolver = session.getGlobalResolver();
        baos = new ByteArrayOutputStream();
        ksession = new StatefulKnowledgeSessionImpl((ReteooWorkingMemory)((ReteooStatefulSession)session));
        marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)ksession.getKnowledgeBase());
        marshaller.marshall((OutputStream)baos, (StatefulKnowledgeSession)ksession);
        baos.close();
        serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)new KnowledgeBaseImpl(ruleBase));
        ksession = (StatefulKnowledgeSessionImpl)marshaller.unmarshall((InputStream)new ByteArrayInputStream(baos.toByteArray()), KnowledgeBaseFactory.newKnowledgeSessionConfiguration(), EnvironmentFactory.newEnvironment());
        session = (ReteooStatefulSession)ksession.session;
        session.setGlobalResolver(resolver);
        results = (List)session.getGlobal("results");
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1_2.drl")));
        pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        InternalFactHandle stilton3 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 40));
        InternalFactHandle brie3 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 40));
        InternalFactHandle bob3 = (InternalFactHandle)session.insert((Object)new Person("bob", 40));
        InternalFactHandle bob4 = (InternalFactHandle)session.insert((Object)new Person("bob", 40));
        InternalFactHandle addr1 = (InternalFactHandle)session.insert((Object)new Address("bangalore"));
        InternalFactHandle addr2 = (InternalFactHandle)session.insert((Object)new Address("India"));
        session.fireAllRules();
        Assert.assertEquals((long)9L, (long)results.size());
        Assert.assertEquals((Object)stilton3.getObject(), results.get(4));
        Assert.assertEquals((Object)bob4.getObject(), results.get(5));
        Assert.assertEquals((Object)bob3.getObject(), results.get(6));
        Assert.assertEquals((Object)addr2.getObject(), results.get(7));
        Assert.assertEquals((Object)addr1.getObject(), results.get(8));
        serializedRulebase = null;
        resolver = session.getGlobalResolver();
        baos = new ByteArrayOutputStream();
        ksession = new StatefulKnowledgeSessionImpl((ReteooWorkingMemory)((ReteooStatefulSession)session));
        marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)ksession.getKnowledgeBase());
        marshaller.marshall((OutputStream)baos, (StatefulKnowledgeSession)ksession);
        baos.close();
        serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)new KnowledgeBaseImpl(ruleBase));
        ksession = (StatefulKnowledgeSessionImpl)marshaller.unmarshall((InputStream)new ByteArrayInputStream(baos.toByteArray()), KnowledgeBaseFactory.newKnowledgeSessionConfiguration(), EnvironmentFactory.newEnvironment());
        session = (ReteooStatefulSession)ksession.session;
        session.setGlobalResolver(resolver);
        results = (List)session.getGlobal("results");
        InternalFactHandle stilton4 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 50));
        InternalFactHandle brie4 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 50));
        InternalFactHandle bob5 = (InternalFactHandle)session.insert((Object)new Person("bob", 50));
        InternalFactHandle bob6 = (InternalFactHandle)session.insert((Object)new Person("bob", 50));
        InternalFactHandle addr3 = (InternalFactHandle)session.insert((Object)new Address("Tripura"));
        InternalFactHandle addr4 = (InternalFactHandle)session.insert((Object)new Address("Agartala"));
        session.fireAllRules();
        Assert.assertEquals((long)14L, (long)results.size());
        Assert.assertEquals((Object)stilton4.getObject(), results.get(9));
        Assert.assertEquals((Object)bob6.getObject(), results.get(10));
        Assert.assertEquals((Object)bob5.getObject(), results.get(11));
        Assert.assertEquals((Object)addr4.getObject(), results.get(12));
        Assert.assertEquals((Object)addr3.getObject(), results.get(13));
        serializedRulebase = null;
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
    }

    @Test
    public void testSerializeAddRemove_NoClassDefFoundError() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1_0.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        ArrayList results = new ArrayList();
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie1 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        GlobalResolver resolver = session.getGlobalResolver();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StatefulKnowledgeSessionImpl ksession = new StatefulKnowledgeSessionImpl((ReteooWorkingMemory)((ReteooStatefulSession)session));
        Marshaller marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)ksession.getKnowledgeBase());
        marshaller.marshall((OutputStream)baos, (StatefulKnowledgeSession)ksession);
        baos.close();
        byte[] serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)stilton1.getObject(), results.get(0));
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)new KnowledgeBaseImpl(ruleBase));
        ksession = (StatefulKnowledgeSessionImpl)marshaller.unmarshall((InputStream)new ByteArrayInputStream(baos.toByteArray()), KnowledgeBaseFactory.newKnowledgeSessionConfiguration(), EnvironmentFactory.newEnvironment());
        session = (ReteooStatefulSession)ksession.session;
        results.clear();
        session.setGlobal("results", results);
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic3_0.drl")));
        pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob1 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob2 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((Object)stilton2.getObject(), results.get(0));
        Assert.assertEquals((Object)bob2.getObject(), results.get(1));
        Assert.assertEquals((Object)bob1.getObject(), results.get(2));
        serializedRulebase = null;
        baos = new ByteArrayOutputStream();
        ksession = new StatefulKnowledgeSessionImpl((ReteooWorkingMemory)((ReteooStatefulSession)session));
        marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)ksession.getKnowledgeBase());
        marshaller.marshall((OutputStream)baos, (StatefulKnowledgeSession)ksession);
        baos.close();
        serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)new KnowledgeBaseImpl(ruleBase));
        ksession = (StatefulKnowledgeSessionImpl)marshaller.unmarshall((InputStream)new ByteArrayInputStream(baos.toByteArray()), KnowledgeBaseFactory.newKnowledgeSessionConfiguration(), EnvironmentFactory.newEnvironment());
        session = (ReteooStatefulSession)ksession.session;
        results.clear();
        session.setGlobal("results", results);
        ruleBase.removeRule("org.drools.test", "like stilton");
        InternalFactHandle stilton3 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie3 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob3 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob4 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)bob4.getObject(), results.get(0));
        Assert.assertEquals((Object)bob3.getObject(), results.get(1));
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)new KnowledgeBaseImpl(ruleBase));
        ksession = (StatefulKnowledgeSessionImpl)marshaller.unmarshall((InputStream)new ByteArrayInputStream(baos.toByteArray()), KnowledgeBaseFactory.newKnowledgeSessionConfiguration(), EnvironmentFactory.newEnvironment());
        session = (ReteooStatefulSession)ksession.session;
        results.clear();
        session.setGlobal("results", results);
        ruleBase.removePackage("org.drools.test");
        InternalFactHandle stilton4 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie4 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob5 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob6 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)bob6.getObject(), results.get(0));
        Assert.assertEquals((Object)bob5.getObject(), results.get(1));
        Object serializedSession = null;
        serializedRulebase = null;
        baos = new ByteArrayOutputStream();
        ksession = new StatefulKnowledgeSessionImpl((ReteooWorkingMemory)((ReteooStatefulSession)session));
        marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)ksession.getKnowledgeBase());
        marshaller.marshall((OutputStream)baos, (StatefulKnowledgeSession)ksession);
        baos.close();
        serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
        ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)new KnowledgeBaseImpl(ruleBase));
        ksession = (StatefulKnowledgeSessionImpl)marshaller.unmarshall((InputStream)new ByteArrayInputStream(baos.toByteArray()), KnowledgeBaseFactory.newKnowledgeSessionConfiguration(), EnvironmentFactory.newEnvironment());
        session = (ReteooStatefulSession)ksession.session;
        results.clear();
        session.setGlobal("results", results);
        InternalFactHandle stilton5 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 30));
        InternalFactHandle brie5 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 30));
        InternalFactHandle bob7 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        InternalFactHandle bob8 = (InternalFactHandle)session.insert((Object)new Person("bob", 40));
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)bob8.getObject(), results.get(0));
        Assert.assertEquals((Object)bob7.getObject(), results.get(1));
        serializedSession = null;
        serializedRulebase = null;
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        session.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignedSerialization1() throws Exception {
        try {
            this.setPrivateKeyProperties();
            this.setPublicKeyProperties();
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1_0.drl")));
            Package pkg = SerializationHelper.serializeObject(builder.getPackage());
            RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            ruleBase.addPackage(pkg);
            byte[] serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
            RuleBase ruleBase2 = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
        }
        finally {
            this.unsetPrivateKeyProperties();
            this.unsetPublicKeyProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignedSerialization2() throws Exception {
        try {
            this.setPrivateKeyProperties();
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1_0.drl")));
            try {
                Package pkg = SerializationHelper.serializeObject(builder.getPackage());
                Assert.fail((String)"Deserialisation should have failed.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.unsetPrivateKeyProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignedSerialization3() throws Exception {
        try {
            this.setPrivateKeyProperties();
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1_0.drl")));
            RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            ruleBase.addPackage(builder.getPackage());
            byte[] serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
            try {
                ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
                Assert.fail((String)"Deserialisation should have failed.");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        finally {
            this.unsetPrivateKeyProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignedSerialization4() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Dynamic1_0.drl")));
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(builder.getPackage());
        byte[] serializedRulebase = DroolsStreamUtils.streamOut((Object)ruleBase);
        try {
            this.setPublicKeyProperties();
            ruleBase = (RuleBase)DroolsStreamUtils.streamIn((byte[])serializedRulebase);
            Assert.fail((String)"Should not deserialize an unsigned rulebase on an environment configured to work with signed rulebases.");
        }
        catch (Exception e) {
        }
        finally {
            this.unsetPublicKeyProperties();
        }
    }

    private void setPublicKeyProperties() {
        URL clientKeyStoreURL = this.getClass().getResource("droolsClient.keystore");
        System.setProperty("drools.serialization.sign", "true");
        System.setProperty("drools.serialization.public.keyStoreURL", clientKeyStoreURL.toExternalForm());
        System.setProperty("drools.serialization.public.keyStorePwd", "clientpwd");
    }

    private void unsetPublicKeyProperties() {
        System.setProperty("drools.serialization.sign", "");
        System.setProperty("drools.serialization.public.keyStoreURL", "");
        System.setProperty("drools.serialization.public.keyStorePwd", "");
    }

    private void setPrivateKeyProperties() {
        URL serverKeyStoreURL = this.getClass().getResource("droolsServer.keystore");
        System.setProperty("drools.serialization.sign", "true");
        System.setProperty("drools.serialization.private.keyStoreURL", serverKeyStoreURL.toExternalForm());
        System.setProperty("drools.serialization.private.keyStorePwd", "serverpwd");
        System.setProperty("drools.serialization.private.keyAlias", "droolsKey");
        System.setProperty("drools.serialization.private.keyPwd", "keypwd");
    }

    private void unsetPrivateKeyProperties() {
        System.setProperty("drools.serialization.sign", "");
        System.setProperty("drools.serialization.private.keyStoreURL", "");
        System.setProperty("drools.serialization.private.keyStorePwd", "");
        System.setProperty("drools.serialization.private.keyAlias", "");
        System.setProperty("drools.serialization.private.keyPwd", "");
    }

    @Test
    public void testSerializabilityWithJarFacts() throws Exception {
        MapBackedClassLoader loader = new MapBackedClassLoader(this.getClass().getClassLoader());
        JarInputStream jis = new JarInputStream(this.getClass().getResourceAsStream("/billasurf.jar"));
        JarEntry entry = null;
        byte[] buf = new byte[1024];
        int len = 0;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = jis.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
            loader.addResource(entry.getName(), out.toByteArray());
        }
        String drl = "package foo.bar \nimport com.billasurf.Board\nrule 'MyGoodRule' \n dialect 'mvel' \n when    Board() then \n System.err.println(42); \nend\n";
        PackageBuilder builder = new PackageBuilder(new PackageBuilderConfiguration(new ClassLoader[]{loader}));
        builder.addPackageFromDrl((Reader)new StringReader(drl));
        Assert.assertFalse((boolean)builder.hasErrors());
        Package p = builder.getPackage();
        byte[] ser = DroolsStreamUtils.streamOut((Object)p);
        Package p_ = (Package)DroolsStreamUtils.streamIn((byte[])ser, (ClassLoader)loader);
        Assert.assertNotNull((Object)p_);
    }

    @Test
    public void testEmptyRule() throws Exception {
        String rule = "package org.test;\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "when\n";
        rule = rule + "then\n";
        rule = rule + "    list.add( \"fired\" );\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        Assert.assertTrue((boolean)builder.getErrors().isEmpty());
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        Map nodes = RuleBaseNodes.getNodeMap((InternalRuleBase)((InternalRuleBase)ruleBase));
        Assert.assertEquals((long)2L, (long)nodes.size());
        Assert.assertEquals((Object)"InitialFactImpl", (Object)((ClassObjectType)((ObjectTypeNode)nodes.get(2)).getObjectType()).getClassType().getSimpleName());
        Assert.assertEquals((Object)"Rule 1", (Object)((RuleTerminalNode)nodes.get(4)).getRule().getName());
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        session = SerializationHelper.getSerialisedStatefulSession(session);
        Assert.assertEquals((long)1L, (long)((List)session.getGlobal("list")).size());
        Assert.assertEquals((Object)"fired", ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testDynamicEmptyRule() throws Exception {
        String rule1 = "package org.test;\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( \"fired1\" );\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.test;\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( \"fired2\" );\n";
        rule2 = rule2 + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule1));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        Map nodes = RuleBaseNodes.getNodeMap((InternalRuleBase)((InternalRuleBase)ruleBase));
        Assert.assertEquals((long)2L, (long)nodes.size());
        Assert.assertEquals((Object)"InitialFactImpl", (Object)((ClassObjectType)((ObjectTypeNode)nodes.get(2)).getObjectType()).getClassType().getSimpleName());
        Assert.assertEquals((Object)"Rule 1", (Object)((RuleTerminalNode)nodes.get(4)).getRule().getName());
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        StatefulSession session1 = SerializationHelper.getSerialisedStatefulSession(session);
        session1.fireAllRules();
        Assert.assertEquals((long)1L, (long)((List)session1.getGlobal("list")).size());
        StatefulSession session2 = SerializationHelper.getSerialisedStatefulSession(session1, true);
        session.dispose();
        session1.dispose();
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule2));
        pkg = builder.getPackage();
        ruleBase.addPackage(pkg);
        session2.fireAllRules();
        Assert.assertEquals((long)2L, (long)((List)session2.getGlobal("list")).size());
        Assert.assertEquals((Object)"fired1", ((List)session2.getGlobal("list")).get(0));
        Assert.assertEquals((Object)"fired2", ((List)session2.getGlobal("list")).get(1));
    }

    @Test
    public void testSinglePattern() throws Exception {
        String rule = "package org.test;\n";
        rule = rule + "import org.drools.Person\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "when\n";
        rule = rule + "    $p : Person( ) \n";
        rule = rule + "then\n";
        rule = rule + "    list.add( $p );\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        Map nodes = RuleBaseNodes.getNodeMap((InternalRuleBase)((InternalRuleBase)ruleBase));
        Assert.assertEquals((long)2L, (long)nodes.size());
        Assert.assertEquals((Object)"Person", (Object)((ClassObjectType)((ObjectTypeNode)nodes.get(2)).getObjectType()).getClassType().getSimpleName());
        Assert.assertEquals((Object)"Rule 1", (Object)((RuleTerminalNode)nodes.get(4)).getRule().getName());
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person p = new Person("bobba fet", 32);
        session.insert((Object)p);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)((List)session.getGlobal("list")).size());
        Assert.assertEquals((Object)p, ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testSingleRuleSingleJoinNodePattern() throws Exception {
        String rule = "package org.test;\n";
        rule = rule + "import org.drools.Person\n";
        rule = rule + "import org.drools.Cheese\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "when\n";
        rule = rule + "    $c : Cheese( ) \n";
        rule = rule + "    $p : Person( cheese == $c ) \n";
        rule = rule + "then\n";
        rule = rule + "    list.add( $p );\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        Map nodes = RuleBaseNodes.getNodeMap((InternalRuleBase)((InternalRuleBase)ruleBase));
        Assert.assertEquals((long)4L, (long)nodes.size());
        Assert.assertEquals((Object)"Cheese", (Object)((ClassObjectType)((ObjectTypeNode)nodes.get(2)).getObjectType()).getClassType().getSimpleName());
        Assert.assertEquals((Object)"Person", (Object)((ClassObjectType)((ObjectTypeNode)nodes.get(4)).getObjectType()).getClassType().getSimpleName());
        Assert.assertEquals((Object)"JoinNode", (Object)((BaseNode)nodes.get(5)).getClass().getSimpleName());
        Assert.assertEquals((Object)"Rule 1", (Object)((RuleTerminalNode)nodes.get(6)).getRule().getName());
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 25);
        Cheese brie = new Cheese("brie", 49);
        Person bobba = new Person("bobba fet", 32);
        bobba.setCheese(stilton);
        Person vadar = new Person("darth vadar", 32);
        session.insert((Object)stilton);
        session.insert((Object)bobba);
        session.insert((Object)vadar);
        session.insert((Object)brie);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)((List)session.getGlobal("list")).size());
        Assert.assertEquals((Object)bobba, ((List)session.getGlobal("list")).get(0));
        Person c3po = new Person("c3p0", 32);
        c3po.setCheese(stilton);
        session.insert((Object)c3po);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)((List)session.getGlobal("list")).size());
        Assert.assertEquals((Object)c3po, ((List)session.getGlobal("list")).get(1));
        Person r2d2 = new Person("r2d2", 32);
        r2d2.setCheese(brie);
        session.insert((Object)r2d2);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((long)3L, (long)((List)session.getGlobal("list")).size());
        Assert.assertEquals((Object)r2d2, ((List)session.getGlobal("list")).get(2));
    }

    @Test
    public void testMultiRuleMultiJoinNodePatternsWithHalt() throws Exception {
        String rule1 = "package org.test;\n";
        rule1 = rule1 + "import org.drools.Person\n";
        rule1 = rule1 + "import org.drools.Cheese\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    $c : Cheese( ) \n";
        rule1 = rule1 + "    $p : Person( cheese == $c ) \n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( $p );\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.test;\n";
        rule2 = rule2 + "import org.drools.Person\n";
        rule2 = rule2 + "import org.drools.Cheese\n";
        rule2 = rule2 + "import org.drools.Cell\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    $c : Cheese( ) \n";
        rule2 = rule2 + "    $p : Person( cheese == $c ) \n";
        rule2 = rule2 + "    Cell( value == $p.age ) \n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( $p );\n";
        rule2 = rule2 + "end";
        String rule3 = "package org.test;\n";
        rule3 = rule3 + "import org.drools.FactA\n";
        rule3 = rule3 + "import org.drools.FactB\n";
        rule3 = rule3 + "import org.drools.FactC\n";
        rule3 = rule3 + "import org.drools.Person\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule \"Rule 3\"\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "    $a : FactA( field2 > 10 ) \n";
        rule3 = rule3 + "    $b : FactB( f2 >= $a.field2 ) \n";
        rule3 = rule3 + "    $p : Person( name == \"darth vadar\" ) \n";
        rule3 = rule3 + "    $c : FactC( f2 >= $b.f2 ) \n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "    list.add( $c );\n";
        rule3 = rule3 + "    drools.halt();\n";
        rule3 = rule3 + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule1));
        builder.addPackageFromDrl((Reader)new StringReader(rule2));
        builder.addPackageFromDrl((Reader)new StringReader(rule3));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 25);
        Cheese brie = new Cheese("brie", 49);
        Person bobba = new Person("bobba fet", 30);
        bobba.setCheese(stilton);
        Person vadar = new Person("darth vadar", 38);
        Person c3po = new Person("c3p0", 17);
        c3po.setCheese(stilton);
        Person r2d2 = new Person("r2d2", 58);
        r2d2.setCheese(brie);
        session.insert((Object)stilton);
        session.insert((Object)bobba);
        session.insert((Object)vadar);
        session.insert((Object)brie);
        session.insert((Object)c3po);
        session.insert((Object)r2d2);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((long)3L, (long)((List)session.getGlobal("list")).size());
        Assert.assertEquals((Object)r2d2, ((List)session.getGlobal("list")).get(0));
        Assert.assertEquals((Object)c3po, ((List)session.getGlobal("list")).get(1));
        Assert.assertEquals((Object)bobba, ((List)session.getGlobal("list")).get(2));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.insert((Object)new Cell(30));
        session.insert((Object)new Cell(58));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((long)5L, (long)((List)session.getGlobal("list")).size());
        Assert.assertEquals((Object)bobba, ((List)session.getGlobal("list")).get(4));
        Assert.assertEquals((Object)r2d2, ((List)session.getGlobal("list")).get(3));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.insert((Object)new FactA(15));
        session.insert((Object)new FactB(20));
        session.insert((Object)new FactC(27));
        session.insert((Object)new FactC(52));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((long)6L, (long)((List)session.getGlobal("list")).size());
        Assert.assertEquals((Object)new FactC(52), ((List)session.getGlobal("list")).get(5));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((long)7L, (long)((List)session.getGlobal("list")).size());
        Assert.assertEquals((Object)new FactC(27), ((List)session.getGlobal("list")).get(6));
    }

    @Test
    public void testNot() throws Exception {
        String header = "package org.drools.test;\n";
        header = header + "import java.util.List;\n";
        header = header + "import org.drools.Person\n";
        header = header + "import org.drools.Cheese\n";
        header = header + "global java.util.List list;\n";
        String rule1 = "rule \"not rule test\"\n";
        rule1 = rule1 + "salience 10\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    Person()\n";
        rule1 = rule1 + "    not Cheese( price >= 5 )\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( new Integer( 5 ) );\n";
        rule1 = rule1 + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])(header + rule1).getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("drools.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(null, env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Person bobba = new Person("bobba fet", 50);
        ksession.insert((Object)bobba);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Person darth = new Person("darth vadar", 200);
        ksession.insert((Object)darth);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.retract(ksession.getFactHandle((Object)stilton));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Cheese brie = new Cheese("brie", 18);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)stilton));
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)bobba));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)brie));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)list.size());
    }

    @Test
    public void testExists() throws Exception {
        String header = "package org.drools.test;\n";
        header = header + "import java.util.List;\n";
        header = header + "import org.drools.Person\n";
        header = header + "import org.drools.Cheese\n";
        header = header + "global java.util.List list;\n";
        String rule1 = "rule \"not rule test\"\n";
        rule1 = rule1 + "salience 10\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    Person()\n";
        rule1 = rule1 + "    exists Cheese( price >= 5 )\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( new Integer( 5 ) );\n";
        rule1 = rule1 + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])(header + rule1).getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("drools.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(null, env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Person bobba = new Person("bobba fet", 50);
        ksession.insert((Object)bobba);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Person darth = new Person("darth vadar", 200);
        ksession.insert((Object)darth);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.retract(ksession.getFactHandle((Object)stilton));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Cheese brie = new Cheese("brie", 18);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)stilton));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)bobba));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)brie));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)stilton);
        ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)list.size());
    }

    @Test
    public void testTruthMaintenance() throws Exception {
        String header = "package org.drools.test;\n";
        header = header + "import java.util.List;\n";
        header = header + "import org.drools.Person\n";
        header = header + "import org.drools.Cheese\n";
        header = header + "global Cheese cheese;\n";
        header = header + "global Person person;\n";
        header = header + "global java.util.List list;\n";
        String rule1 = "rule \"not person then cheese\"\n";
        rule1 = rule1 + "when \n";
        rule1 = rule1 + "    not Person() \n";
        rule1 = rule1 + "then \n";
        rule1 = rule1 + "    if (list.size() < 3) { \n";
        rule1 = rule1 + "        list.add(new Integer(0)); \n";
        rule1 = rule1 + "        insertLogical( cheese ); \n    }\n";
        rule1 = rule1 + "    drools.halt();\nend\n";
        String rule2 = "rule \"if cheese then person\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    Cheese()\n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    if (list.size() < 3) {\n";
        rule2 = rule2 + "        list.add(new Integer(0));\n";
        rule2 = rule2 + "        insertLogical( person );\n";
        rule2 = rule2 + "    }\n    drools.halt();\n";
        rule2 = rule2 + "end\n";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(header + rule1));
        builder.addPackageFromDrl((Reader)new StringReader(header + rule2));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        Person person = new Person("person");
        Cheese cheese = new Cheese("cheese", 0);
        session.setGlobal("cheese", (Object)cheese);
        session.setGlobal("person", (Object)person);
        session.setGlobal("list", list);
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testActivationGroups() throws Exception {
        String rule1 = "package org.test;\n";
        rule1 = rule1 + "import org.drools.Cheese\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "    activation-group \"activation-group-1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    $c : Cheese( ) \n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( \"rule1\" );\n";
        rule1 = rule1 + "    drools.halt();\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.test;\n";
        rule2 = rule2 + "import org.drools.Cheese\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "    salience 10\n";
        rule2 = rule2 + "    activation-group \"activation-group-1\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    $c : Cheese( ) \n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( \"rule2\" );\n";
        rule2 = rule2 + "    drools.halt();\n";
        rule2 = rule2 + "end";
        String rule3 = "package org.test;\n";
        rule3 = rule3 + "import org.drools.Cheese\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule \"Rule 3\"\n";
        rule3 = rule3 + "    activation-group \"activation-group-1\"\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "    $c : Cheese( ) \n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "    list.add( \"rule3\" );\n";
        rule3 = rule3 + "    drools.halt();\n";
        rule3 = rule3 + "end";
        String rule4 = "package org.test;\n";
        rule4 = rule4 + "import org.drools.Cheese\n";
        rule4 = rule4 + "global java.util.List list\n";
        rule4 = rule4 + "rule \"Rule 4\"\n";
        rule4 = rule4 + "    activation-group \"activation-group-2\"\n";
        rule4 = rule4 + "when\n";
        rule4 = rule4 + "    $c : Cheese( ) \n";
        rule4 = rule4 + "then\n";
        rule4 = rule4 + "    list.add( \"rule4\" );\n";
        rule4 = rule4 + "    drools.halt();\n";
        rule4 = rule4 + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule1));
        builder.addPackageFromDrl((Reader)new StringReader(rule2));
        builder.addPackageFromDrl((Reader)new StringReader(rule3));
        builder.addPackageFromDrl((Reader)new StringReader(rule4));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        session = SerializationHelper.getSerialisedStatefulSession(session);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        session.insert((Object)brie);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"rule2", list.get(0));
        Assert.assertEquals((Object)"rule4", list.get(1));
    }

    @Test
    public void testAgendaGroups() throws Exception {
        String rule1 = "package org.test;\n";
        rule1 = rule1 + "import org.drools.Cheese\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "    agenda-group \"agenda-group-1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    $c : Cheese( ) \n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( \"rule1\" );\n";
        rule1 = rule1 + "    drools.halt();\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.test;\n";
        rule2 = rule2 + "import org.drools.Cheese\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "    salience 10\n";
        rule2 = rule2 + "    agenda-group \"agenda-group-1\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    $c : Cheese( ) \n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( \"rule2\" );\n";
        rule2 = rule2 + "    drools.halt();\n";
        rule2 = rule2 + "end";
        String rule3 = "package org.test;\n";
        rule3 = rule3 + "import org.drools.Cheese\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule \"Rule 3\"\n";
        rule3 = rule3 + "    salience 10\n";
        rule3 = rule3 + "    agenda-group \"agenda-group-2\"\n";
        rule3 = rule3 + "    activation-group \"activation-group-2\"\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "    $c : Cheese( ) \n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "    list.add( \"rule3\" );\n";
        rule3 = rule3 + "    drools.halt();\n";
        rule3 = rule3 + "end";
        String rule4 = "package org.test;\n";
        rule4 = rule4 + "import org.drools.Cheese\n";
        rule4 = rule4 + "global java.util.List list\n";
        rule4 = rule4 + "rule \"Rule 4\"\n";
        rule4 = rule4 + "    agenda-group \"agenda-group-2\"\n";
        rule4 = rule4 + "    activation-group \"activation-group-2\"\n";
        rule4 = rule4 + "when\n";
        rule4 = rule4 + "    $c : Cheese( ) \n";
        rule4 = rule4 + "then\n";
        rule4 = rule4 + "    list.add( \"rule4\" );\n";
        rule4 = rule4 + "    drools.halt();\n";
        rule4 = rule4 + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule1));
        builder.addPackageFromDrl((Reader)new StringReader(rule2));
        builder.addPackageFromDrl((Reader)new StringReader(rule3));
        builder.addPackageFromDrl((Reader)new StringReader(rule4));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        session = SerializationHelper.getSerialisedStatefulSession(session);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        session.insert((Object)brie);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.setFocus("agenda-group-1");
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((Object)"rule2", list.get(0));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.setFocus("agenda-group-2");
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((Object)"rule3", list.get(1));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((Object)"rule1", list.get(2));
    }

    @Test
    public void testRuleFlowGroups() throws Exception {
        String rule1 = "package org.test;\n";
        rule1 = rule1 + "import org.drools.Cheese\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "    ruleflow-group \"ruleflow-group-1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    $c : Cheese( ) \n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( \"rule1\" );\n";
        rule1 = rule1 + "    drools.halt();\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.test;\n";
        rule2 = rule2 + "import org.drools.Cheese\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "    salience 10\n";
        rule2 = rule2 + "    ruleflow-group \"ruleflow-group-1\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    $c : Cheese( ) \n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( \"rule2\" );\n";
        rule2 = rule2 + "    drools.halt();\n";
        rule2 = rule2 + "end";
        String rule3 = "package org.test;\n";
        rule3 = rule3 + "import org.drools.Cheese\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule \"Rule 3\"\n";
        rule3 = rule3 + "    salience 10\n";
        rule3 = rule3 + "    ruleflow-group \"ruleflow-group-2\"\n";
        rule3 = rule3 + "    activation-group \"activation-group-2\"\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "    $c : Cheese( ) \n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "    list.add( \"rule3\" );\n";
        rule3 = rule3 + "    drools.halt();\n";
        rule3 = rule3 + "end";
        String rule4 = "package org.test;\n";
        rule4 = rule4 + "import org.drools.Cheese\n";
        rule4 = rule4 + "global java.util.List list\n";
        rule4 = rule4 + "rule \"Rule 4\"\n";
        rule4 = rule4 + "    ruleflow-group \"ruleflow-group-2\"\n";
        rule4 = rule4 + "    activation-group \"activation-group-2\"\n";
        rule4 = rule4 + "when\n";
        rule4 = rule4 + "    $c : Cheese( ) \n";
        rule4 = rule4 + "then\n";
        rule4 = rule4 + "    list.add( \"rule4\" );\n";
        rule4 = rule4 + "    drools.halt();\n";
        rule4 = rule4 + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule1));
        builder.addPackageFromDrl((Reader)new StringReader(rule2));
        builder.addPackageFromDrl((Reader)new StringReader(rule3));
        builder.addPackageFromDrl((Reader)new StringReader(rule4));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        session = SerializationHelper.getSerialisedStatefulSession(session);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        session.insert((Object)brie);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.getAgenda().activateRuleFlowGroup("ruleflow-group-1");
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((Object)"rule2", list.get(0));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.getAgenda().activateRuleFlowGroup("ruleflow-group-2");
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((Object)"rule3", list.get(1));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.fireAllRules();
        Assert.assertEquals((Object)"rule1", list.get(2));
    }

    @Test
    public void testAccumulate() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("package org.drools\n\nimport org.drools.Message\nglobal java.util.List results\n\nrule MyRule\n  when\n    $n : Number( intValue >= 2 ) from accumulate ( m: Message( ), count( m ) )\n  then\n    results.add($n);\nend");
        builder.addPackageFromDrl((Reader)source);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        session.setGlobal("results", new ArrayList());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.insert((Object)new Message());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        List results = (List)session.getGlobal("results");
        session.insert((Object)new Message());
        session.insert((Object)new Message());
        session.fireAllRules();
        Assert.assertEquals((long)3L, (long)((Number)results.get(0)).intValue());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.insert((Object)new Message());
        session.insert((Object)new Message());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        Assert.assertEquals((long)1L, (long)session.getAgenda().getActivations().length);
        session.fireAllRules();
        Assert.assertEquals((long)5L, (long)((Number)results.get(1)).intValue());
    }

    @Test
    public void testAccumulate2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("package org.drools\n\nimport org.drools.Message\n\nrule MyRule\n  when\n    Number( intValue >= 5 ) from accumulate ( m: Message( ), count( m ) )\n  then\n    System.out.println(\"Found messages\");\nend");
        builder.addPackageFromDrl((Reader)source);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        session.fireAllRules();
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.insert((Object)new Message());
        session.insert((Object)new Message());
        session.insert((Object)new Message());
        session.insert((Object)new Message());
        session.insert((Object)new Message());
        Assert.assertEquals((long)1L, (long)session.getAgenda().getActivations().length);
    }

    @Test
    public void testAccumulateSessionSerialization() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("test_AccumulateSerialization.drl")), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese("stilton", 10));
        ksession.insert((Object)new Cheese("brie", 5));
        ksession.insert((Object)new Cheese("provolone", 150));
        ksession.insert((Object)new Cheese("brie", 20));
        ksession.insert((Object)new Person("Bob", "brie"));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)25L, (long)((Number)results.get(0)).intValue());
    }

    @Test
    @Ignore
    public void testDroolsObjectOutputInputStream() throws Exception {
        Person bob = new Person();
        KnowledgeBuilder knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        knowledgeBuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/integrationtests/test_Serializable.drl"), ResourceType.DRL);
        KnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addKnowledgePackages(knowledgeBuilder.getKnowledgePackages());
        StatefulKnowledgeSession session = knowledgeBase.newStatefulKnowledgeSession();
        session.insert((Object)bob);
        Assert.assertSame((String)"these two object references should be same", (Object)bob, session.getObjects().iterator().next());
        Marshaller marshaller = this.createSerializableMarshaller(knowledgeBase);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)baos);
        out.writeObject(bob);
        out.writeObject(knowledgeBase);
        marshaller.marshall((OutputStream)out, session);
        out.flush();
        out.close();
        DroolsObjectInputStream in = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        Person deserializedBob = (Person)in.readObject();
        knowledgeBase = (KnowledgeBase)in.readObject();
        marshaller = this.createSerializableMarshaller(knowledgeBase);
        session = marshaller.unmarshall((InputStream)in);
        Assert.assertSame((String)"these two object references should be same", (Object)deserializedBob, session.getObjects().iterator().next());
        in.close();
    }

    @Test
    public void testAccumulateSerialization() {
        try {
            KnowledgeBuilder knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            knowledgeBuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/integrationtests/test_SerializableAccumulate.drl"), ResourceType.DRL);
            if (knowledgeBuilder.hasErrors()) {
                Assert.fail((String)knowledgeBuilder.getErrors().toString());
            }
            KnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
            knowledgeBase.addKnowledgePackages(knowledgeBuilder.getKnowledgePackages());
            StatefulKnowledgeSession ksession = knowledgeBase.newStatefulKnowledgeSession();
            ksession.setGlobal("results", new ArrayList());
            Cheese t1 = new Cheese("brie", 10);
            Cheese t2 = new Cheese("brie", 15);
            Cheese t3 = new Cheese("stilton", 20);
            Cheese t4 = new Cheese("brie", 30);
            ksession.insert((Object)t1);
            ksession.insert((Object)t2);
            ksession.insert((Object)t3);
            ksession.insert((Object)t4);
            Marshaller marshaller = this.createSerializableMarshaller(knowledgeBase);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)baos);
            out.writeObject(knowledgeBase);
            marshaller.marshall((OutputStream)out, ksession);
            out.flush();
            out.close();
            DroolsObjectInputStream in = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            knowledgeBase = (KnowledgeBase)in.readObject();
            marshaller = this.createSerializableMarshaller(knowledgeBase);
            ksession = marshaller.unmarshall((InputStream)in);
            in.close();
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            Assert.assertNotNull(results);
            ksession.fireAllRules();
            ksession.dispose();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((long)3L, (long)((List)results.get(0)).size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testJBRULES_1946() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("Sample.drl")), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(kbase);
            oos.flush();
            oos.close();
            baos.flush();
            baos.close();
            byte[] serializedKb = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedKb);
            ObjectInputStream ois = new ObjectInputStream(bais);
            KnowledgeBase kb2 = (KnowledgeBase)ois.readObject();
        }
        catch (OptionalDataException ode) {
            ode.printStackTrace();
            Assert.fail((String)("EOF? " + ode.eof));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testJBRULES_1946_2() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("Sample.drl")), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DroolsObjectOutputStream oos = new DroolsObjectOutputStream((OutputStream)baos);
            oos.writeObject((Object)kbase);
            oos.flush();
            oos.close();
            baos.flush();
            baos.close();
            byte[] serializedKb = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedKb);
            DroolsObjectInputStream ois = new DroolsObjectInputStream((InputStream)bais);
            KnowledgeBase kb2 = (KnowledgeBase)ois.readObject();
        }
        catch (OptionalDataException ode) {
            ode.printStackTrace();
            Assert.fail((String)("EOF? " + ode.eof));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testJBRULES_1946_3() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("Sample.drl")), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DroolsObjectOutputStream oos = new DroolsObjectOutputStream((OutputStream)baos);
            oos.writeObject((Object)kbase);
            oos.flush();
            oos.close();
            baos.flush();
            baos.close();
            byte[] serializedKb = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedKb);
            ObjectInputStream ois = new ObjectInputStream(bais);
            KnowledgeBase kb2 = (KnowledgeBase)ois.readObject();
            Assert.fail((String)"Should have raised an IllegalArgumentException since the kbase was serialized with a Drools Stream but deserialized with a regular stream");
        }
        catch (IllegalArgumentException ode) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testJBRULES_2331() throws Exception {
        String source = "package test.drl\n";
        source = source + "rule dummy_rule\n";
        source = source + "when\n";
        source = source + "eval( false )\n";
        source = source + "then\n";
        source = source + "end\n";
        StringReader reader = new StringReader(source);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)reader), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Assert.assertNotNull((Object)ksession);
        ksession.dispose();
    }

    @Test
    public void testMarshallWithNot() throws Exception {
        String str = "import " + this.getClass().getCanonicalName() + ".*\n" + "rule one\n" + "when\n" + "   A()\n" + "   not(B())\n" + "then\n" + "System.out.println(\"a\");\n" + "end\n" + "\n" + "rule two\n" + "when\n" + "   A()\n" + "then\n" + "System.out.println(\"b\");\n" + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(str)), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            throw new RuntimeException(kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)config);
        knowledgeBase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = knowledgeBase.newStatefulKnowledgeSession();
        ksession.insert((Object)new A());
        MarshallerFactory.newMarshaller((KnowledgeBase)knowledgeBase).marshall((OutputStream)new ByteArrayOutputStream(), ksession);
    }

    @Test
    public void testMarshallEvents() throws Exception {
        String str = "import " + this.getClass().getCanonicalName() + ".*\n" + "declare A\n" + " @role( event )\n" + " @expires( 10m )\n" + "end\n" + "declare B\n" + " @role( event )\n" + " @expires( 10m )\n" + "end\n" + "rule one\n" + "when\n" + "   $a : A()\n" + "   B(this after $a)\n" + "then\n" + "insert(new C());" + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(str)), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            throw new RuntimeException(kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)config);
        knowledgeBase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = knowledgeBase.newStatefulKnowledgeSession();
        ksession.insert((Object)new A());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MarshallerFactory.newMarshaller((KnowledgeBase)knowledgeBase).marshall((OutputStream)out, ksession);
        ksession = MarshallerFactory.newMarshaller((KnowledgeBase)knowledgeBase).unmarshall((InputStream)new ByteArrayInputStream(out.toByteArray()));
        ksession.insert((Object)new B());
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)ksession.getObjects().size());
    }

    @Test
    public void testScheduledActivation() {
        KnowledgeBaseImpl knowledgeBase = (KnowledgeBaseImpl)KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgePackageImp impl = new KnowledgePackageImp();
        impl.pkg = new Package("test");
        BuildContext buildContext = new BuildContext((InternalRuleBase)knowledgeBase.getRuleBase(), ((ReteooRuleBase)knowledgeBase.getRuleBase()).getReteooBuilder().getIdGenerator());
        Rule rule = new Rule("test-rule");
        new RuleTerminalNode(1, (LeftTupleSource)new MockTupleSource(2), rule, rule.getLhs(), 0, buildContext);
        final ArrayList fired = new ArrayList();
        rule.setConsequence(new Consequence(){

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
                fired.add("a");
            }

            public String getName() {
                return "default";
            }
        });
        rule.setTimer((Timer)new DurationTimer(10000L));
        rule.setPackage("test");
        impl.pkg.addRule(rule);
        knowledgeBase.addKnowledgePackages(Collections.singleton(impl));
        SessionConfiguration config = new SessionConfiguration();
        config.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulKnowledgeSession ksession = knowledgeBase.newStatefulKnowledgeSession((KnowledgeSessionConfiguration)config, KnowledgeBaseFactory.newEnvironment());
        PseudoClockScheduler scheduler = (PseudoClockScheduler)ksession.getSessionClock();
        Marshaller marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)knowledgeBase);
        ksession.insert((Object)"cheese");
        Assert.assertTrue((boolean)fired.isEmpty());
        this.readWrite((KnowledgeBase)knowledgeBase, ksession, (KnowledgeSessionConfiguration)config);
        Assert.assertTrue((boolean)fired.isEmpty());
        scheduler.advanceTime(12L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)fired.isEmpty());
    }

    @Test
    public void testMarshallEntryPoints() throws Exception {
        String str = "package org.domain.test \nimport " + this.getClass().getCanonicalName() + ".*\n" + "global java.util.List list\n" + "declare A\n" + " @role( event )\n" + " @expires( 10m )\n" + "end\n" + "declare B\n" + "" + " @role( event )\n" + " @expires( 10m )\n" + "end\n" + "" + "declare C\n" + " @role( event )\n" + " @expires( 10m )\n" + "end\n" + "" + "rule a1\n" + "when\n" + "   $a : A() from entry-point 'a-ep'\n" + "then\n" + "list.add( $a );" + "end\n" + "" + "rule b1\n" + "when\n" + "   $b : B() from entry-point 'b-ep'\n" + "then\n" + "list.add( $b );" + "end\n" + "" + "rule c1\n" + "when\n" + "   $c : C() from entry-point 'c-ep'\n" + "then\n" + "list.add( $c );" + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(str)), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            throw new RuntimeException(kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)config);
        knowledgeBase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = knowledgeBase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        WorkingMemoryEntryPoint aep = ksession.getWorkingMemoryEntryPoint("a-ep");
        aep.insert((Object)new A());
        WorkingMemoryEntryPoint bep = ksession.getWorkingMemoryEntryPoint("b-ep");
        bep.insert((Object)new B());
        WorkingMemoryEntryPoint cep = ksession.getWorkingMemoryEntryPoint("c-ep");
        cep.insert((Object)new C());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MarshallerFactory.newMarshaller((KnowledgeBase)knowledgeBase).marshall((OutputStream)out, ksession);
        ksession = MarshallerFactory.newMarshaller((KnowledgeBase)knowledgeBase).unmarshall((InputStream)new ByteArrayInputStream(out.toByteArray()));
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    private void readWrite(KnowledgeBase knowledgeBase, StatefulKnowledgeSession ksession, KnowledgeSessionConfiguration config) {
        try {
            Marshaller marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)knowledgeBase);
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            marshaller.marshall((OutputStream)o, ksession);
            ksession = marshaller.unmarshall((InputStream)new ByteArrayInputStream(o.toByteArray()), config, KnowledgeBaseFactory.newEnvironment());
            ksession.fireAllRules();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Marshaller createSerializableMarshaller(KnowledgeBase knowledgeBase) {
        ObjectMarshallingStrategyAcceptor acceptor = MarshallerFactory.newClassFilterAcceptor((String[])new String[]{"*.*"});
        ObjectMarshallingStrategy strategy = MarshallerFactory.newSerializeMarshallingStrategy((ObjectMarshallingStrategyAcceptor)acceptor);
        Marshaller marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)knowledgeBase, (ObjectMarshallingStrategy[])new ObjectMarshallingStrategy[]{strategy});
        return marshaller;
    }

    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(Package pkg) throws Exception {
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        return SerializationHelper.serializeObject(ruleBase);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    public static class C
    implements Serializable {
    }

    public static class B
    implements Serializable {
    }

    public static class A
    implements Serializable {
    }
}

