/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests.eventgenerator;

import java.util.Random;
import org.drools.integrationtests.eventgenerator.Event;

class EventOccurrence {
    private static Random myRandom = new Random();
    private String eventSenderId;
    private Event event;
    private long evDeviation;
    private long evMinDur;
    private int itemCounter;
    private int maxItems;
    private long latestEnd;
    private boolean infinite;

    public EventOccurrence(String eventSenderId, Event ev, long evMinDur, long avgOccur, long earliestStart, long maxDuration, int maxItems) {
        this.eventSenderId = eventSenderId;
        this.evMinDur = evMinDur;
        this.evDeviation = 2L * (avgOccur - evMinDur);
        this.event = ev;
        this.event.setTimes(earliestStart);
        this.latestEnd = earliestStart + maxDuration;
        this.maxItems = maxItems;
        this.itemCounter = 0;
        this.infinite = maxDuration <= 0L;
        this.calculateNextEventOccurrence();
    }

    public boolean calculateNextEventOccurrence() {
        this.event.setTimes(this.event.getEndTime() + (long)myRandom.nextInt((int)this.evDeviation) + this.evMinDur);
        if (this.maxItems <= 0) {
            if (this.isInfinite()) {
                return true;
            }
            return this.event.getEndTime() < this.latestEnd;
        }
        ++this.itemCounter;
        if (this.itemCounter > this.maxItems) {
            return false;
        }
        if (this.isInfinite()) {
            return true;
        }
        return this.event.getEndTime() < this.latestEnd;
    }

    private boolean isInfinite() {
        return this.infinite;
    }

    public String getEventSenderId() {
        return this.eventSenderId;
    }

    public long getNextOccurrenceTime() {
        return this.event.getEndTime();
    }

    public Event getEvent() {
        return this.event;
    }
}

