/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests.eventgenerator;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.SerializationHelper;
import org.drools.integrationtests.eventgenerator.Event;
import org.drools.integrationtests.eventgenerator.PseudoSessionClock;
import org.drools.integrationtests.eventgenerator.SimpleEventGenerator;
import org.drools.integrationtests.eventgenerator.SimpleEventListener;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;
import org.junit.Assert;
import org.junit.Test;

public class SimpleEventGeneratorTest {
    private static final String TEST_RULE_FILE = "test_eventGenerator.drl";

    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    private RuleBase loadRuleBase(Reader reader) throws IOException, DroolsParserException, Exception {
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse(reader);
        if (parser.hasErrors()) {
            System.out.println(parser.getErrors());
            Assert.fail((String)"Error messages in parser, need to sort this our (or else collect error messages)");
        }
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        return SerializationHelper.serializeObject(ruleBase);
    }

    @Test
    public void testEventGenerationMaxItems() throws DroolsParserException, IOException, Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(TEST_RULE_FILE));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator((WorkingMemory)wm, new SimpleEventListener((WorkingMemory)wm));
        myGenerator.addEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), 0L, 10);
        myGenerator.generate();
        Assert.assertEquals((long)wm.getQueryResults("all inserted events", new Object[0]).size(), (long)10L);
    }

    @Test
    public void testEventGenerationMaxTime() throws DroolsParserException, IOException, Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(TEST_RULE_FILE));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator((WorkingMemory)wm, new SimpleEventListener((WorkingMemory)wm));
        myGenerator.addEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(1L), 0);
        myGenerator.generate();
        Assert.assertEquals((long)wm.getQueryResults("all inserted events", new Object[0]).size(), (long)wm.getQueryResults("all inserted events with generation time < 1 min", new Object[0]).size());
    }

    @Test
    public void testEventGenerationMaxTimeAndMaxItems() throws DroolsParserException, IOException, Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(TEST_RULE_FILE));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator((WorkingMemory)wm, new SimpleEventListener((WorkingMemory)wm));
        myGenerator.addEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(1L), 10);
        myGenerator.generate();
        Assert.assertEquals((long)wm.getQueryResults("all inserted events", new Object[0]).size(), (long)wm.getQueryResults("all inserted events with generation time < 1 min", new Object[0]).size());
        Assert.assertTrue((wm.getQueryResults("all inserted events with generation time < 1 min", new Object[0]).size() <= 10 ? 1 : 0) != 0);
    }

    @Test
    public void testEventGenerationDelayedMaxItems() throws DroolsParserException, IOException, Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(TEST_RULE_FILE));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator((WorkingMemory)wm, new SimpleEventListener((WorkingMemory)wm));
        myGenerator.addDelayedEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(2L), 0L, 10);
        myGenerator.generate();
        Assert.assertEquals((long)wm.getQueryResults("all inserted events", new Object[0]).size(), (long)10L);
    }

    @Test
    public void testEventGenerationDelayedMaxTime() throws DroolsParserException, IOException, Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(TEST_RULE_FILE));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator((WorkingMemory)wm, new SimpleEventListener((WorkingMemory)wm));
        myGenerator.addDelayedEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(2L), PseudoSessionClock.timeInMinutes(1L), 0);
        myGenerator.generate();
        Assert.assertEquals((long)wm.getQueryResults("all inserted events", new Object[0]).size(), (long)wm.getQueryResults("all inserted events with 2 min < generation time < 3 min", new Object[0]).size());
    }

    @Test
    public void testEventGenerationDelayedMaxTimeAndMaxItems() throws DroolsParserException, IOException, Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(TEST_RULE_FILE));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator((WorkingMemory)wm, new SimpleEventListener((WorkingMemory)wm));
        myGenerator.addDelayedEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(2L), PseudoSessionClock.timeInMinutes(1L), 10);
        myGenerator.generate();
        Assert.assertEquals((long)wm.getQueryResults("all inserted events", new Object[0]).size(), (long)wm.getQueryResults("all inserted events with 2 min < generation time < 3 min", new Object[0]).size());
        Assert.assertTrue((wm.getQueryResults("all inserted events with 2 min < generation time < 3 min", new Object[0]).size() <= 10 ? 1 : 0) != 0);
    }

    @Test
    public void testEventGenerationGlobalMaxTime() throws DroolsParserException, IOException, Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(TEST_RULE_FILE));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator((WorkingMemory)wm, new SimpleEventListener((WorkingMemory)wm), PseudoSessionClock.timeInMinutes(1L));
        myGenerator.addEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, null), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), PseudoSessionClock.timeInMinutes(3L), 0);
        myGenerator.generate();
        Assert.assertEquals((long)wm.getQueryResults("all inserted events", new Object[0]).size(), (long)wm.getQueryResults("all inserted events with generation time < 1 min", new Object[0]).size());
    }

    @Test
    public void testEventGenerationMultipleSources() throws DroolsParserException, IOException, Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(TEST_RULE_FILE));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator((WorkingMemory)wm, new SimpleEventListener((WorkingMemory)wm));
        myGenerator.addEventSource("Conveyor1", new Event(Event.EventType.CUSTOM, "resA"), PseudoSessionClock.timeInSeconds(4L), PseudoSessionClock.timeInSeconds(6L), 0L, 15);
        myGenerator.addEventSource("Conveyor2", new Event(Event.EventType.CUSTOM, "resB"), PseudoSessionClock.timeInSeconds(3L), PseudoSessionClock.timeInSeconds(5L), 0L, 20);
        myGenerator.generate();
        Assert.assertEquals((long)wm.getQueryResults("all inserted events with parent resource A", new Object[0]).size(), (long)15L);
        Assert.assertEquals((long)wm.getQueryResults("all inserted events with parent resource B", new Object[0]).size(), (long)20L);
    }
}

