/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests.eventgenerator.example;

public class SlidingWindow {
    public static final String[] SW_STATES = new String[]{"Default", "Collecting", "Evaluating", "Advancing"};
    public static final int DEFAULT = 0;
    public static final int COLLECT = 1;
    public static final int EVALUATE = 2;
    public static final int ADVANCE = 3;
    private static int idCounter = 0;
    private int id = idCounter++;
    private int state = 0;
    private boolean readyToEvaluate = false;
    private String parentId;
    private long windowStart;
    private long windowEnd;
    private long lastUpdate;
    private long windowLength;
    private long windowShift;
    int numberEvents;

    public SlidingWindow(long wStart, String parentId, long windowLength, long windowShift) {
        this.parentId = parentId;
        this.windowStart = wStart;
        this.windowEnd = this.windowStart + windowLength;
        this.lastUpdate = wStart;
        this.windowLength = windowLength;
        this.windowShift = windowShift;
        this.numberEvents = 0;
    }

    public String getId() {
        return "sw" + this.id;
    }

    public long getWindowStart() {
        return this.windowStart;
    }

    public void setWindowStart(long start) {
        this.windowStart = start;
    }

    public long getWindowEnd() {
        return this.windowEnd;
    }

    public void setWindowEnd(long end) {
        this.windowEnd = end;
    }

    public long getWindowLength() {
        return this.windowLength;
    }

    public void setWindowLength(int windowLength) {
        this.windowLength = windowLength;
    }

    public long getWindowShift() {
        return this.windowShift;
    }

    public void setShift(int windowShift) {
        this.windowShift = windowShift;
    }

    public int getNumberEvents() {
        return this.numberEvents;
    }

    public void setNumberEvents(int numberEvents) {
        this.numberEvents = numberEvents;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void advance() {
        this.windowStart += this.windowShift;
        this.windowEnd += this.windowShift;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public boolean isReadyToEvaluate() {
        return this.readyToEvaluate;
    }

    public void setReadyToEvaluate(boolean readyToEvaluate) {
        this.readyToEvaluate = readyToEvaluate;
    }
}

