/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests.sequential;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.drools.Cheese;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.Message;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatelessSession;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.conf.SequentialOption;
import org.drools.event.rule.ActivationCancelledEvent;
import org.drools.event.rule.ActivationCreatedEvent;
import org.drools.event.rule.AfterActivationFiredEvent;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.AgendaGroupPoppedEvent;
import org.drools.event.rule.AgendaGroupPushedEvent;
import org.drools.event.rule.BeforeActivationFiredEvent;
import org.drools.event.rule.ObjectInsertedEvent;
import org.drools.event.rule.ObjectRetractedEvent;
import org.drools.event.rule.ObjectUpdatedEvent;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.integrationtests.DynamicRulesTest;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.rule.Package;
import org.drools.runtime.StatelessKnowledgeSession;
import org.junit.Assert;
import org.junit.Test;

public class SequentialTest {
    @Test
    public void testBasicOperation() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"simpleSequential.drl", this.getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)SequentialOption.YES);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kconf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatelessKnowledgeSession ksession = kbase.newStatelessKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("p1", "stilton");
        Person p2 = new Person("p2", "cheddar");
        Person p3 = new Person("p3", "stilton");
        Cheese stilton = new Cheese("stilton", 15);
        Cheese cheddar = new Cheese("cheddar", 15);
        ksession.execute(Arrays.asList(p1, stilton, p2, cheddar, p3));
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testSalience() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"simpleSalience.drl", this.getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)SequentialOption.YES);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kconf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatelessKnowledgeSession ksession = kbase.newStatelessKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.execute((Object)new Person("pob"));
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"rule 3", list.get(0));
        Assert.assertEquals((Object)"rule 2", list.get(1));
        Assert.assertEquals((Object)"rule 1", list.get(2));
    }

    @Test
    public void testKnowledgeRuntimeAccess() throws Exception {
        String str = "";
        str = str + "package org.test\n";
        str = str + "import org.drools.Message\n";
        str = str + "rule \"Hello World\"\n";
        str = str + "when\n";
        str = str + "    Message( )\n";
        str = str + "then\n";
        str = str + "    System.out.println( drools.getKnowledgeRuntime() );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)SequentialOption.YES);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kconf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatelessKnowledgeSession ksession = kbase.newStatelessKnowledgeSession();
        ksession.execute((Object)new Message("help"));
    }

    @Test
    public void testEvents() throws Exception {
        String str = "";
        str = str + "package org.test\n";
        str = str + "import org.drools.Message\n";
        str = str + "rule \"Hello World\"\n";
        str = str + "when\n";
        str = str + "    Message( )\n";
        str = str + "then\n";
        str = str + "    System.out.println( drools.getKnowledgeRuntime() );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)SequentialOption.YES);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kconf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatelessKnowledgeSession ksession = kbase.newStatelessKnowledgeSession();
        final ArrayList list = new ArrayList();
        ksession.addEventListener(new AgendaEventListener(){

            public void activationCancelled(ActivationCancelledEvent event) {
                Assert.assertNotNull((Object)event.getKnowledgeRuntime());
                list.add(event);
            }

            public void activationCreated(ActivationCreatedEvent event) {
                Assert.assertNotNull((Object)event.getKnowledgeRuntime());
                list.add(event);
            }

            public void afterActivationFired(AfterActivationFiredEvent event) {
                Assert.assertNotNull((Object)event.getKnowledgeRuntime());
                list.add(event);
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
                Assert.assertNotNull((Object)event.getKnowledgeRuntime());
                list.add(event);
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event) {
                Assert.assertNotNull((Object)event.getKnowledgeRuntime());
                list.add(event);
            }

            public void beforeActivationFired(BeforeActivationFiredEvent event) {
                Assert.assertNotNull((Object)event.getKnowledgeRuntime());
                list.add(event);
            }
        });
        ksession.addEventListener(new WorkingMemoryEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                Assert.assertNotNull((Object)event.getKnowledgeRuntime());
                list.add(event);
            }

            public void objectRetracted(ObjectRetractedEvent event) {
                Assert.assertNotNull((Object)event.getKnowledgeRuntime());
                list.add(event);
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                Assert.assertNotNull((Object)event.getKnowledgeRuntime());
                list.add(event);
            }
        });
        ksession.execute((Object)new Message("help"));
        Assert.assertEquals((long)4L, (long)list.size());
    }

    @Test
    public void testSequentialWithRulebaseUpdate() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"simpleSalience.drl", this.getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)SequentialOption.YES);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kconf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatelessKnowledgeSession ksession = kbase.newStatelessKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.execute((Object)new Person("pob"));
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_Dynamic3.drl", DynamicRulesTest.class), ResourceType.DRL);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        ksession = kbase.newStatelessKnowledgeSession();
        ksession.setGlobal("list", list);
        Person person = new Person("bop");
        ksession.execute((Object)person);
        Assert.assertEquals((long)7L, (long)list.size());
        Assert.assertEquals((Object)"rule 3", list.get(0));
        Assert.assertEquals((Object)"rule 2", list.get(1));
        Assert.assertEquals((Object)"rule 1", list.get(2));
        Assert.assertEquals((Object)"rule 3", list.get(3));
        Assert.assertEquals((Object)"rule 2", list.get(4));
        Assert.assertEquals((Object)"rule 1", list.get(5));
        Assert.assertEquals((Object)person, list.get(6));
    }

    @Test
    public void testProfileSequential() throws Exception {
        this.runTestProfileManyRulesAndFacts(true, "Sequential mode", 0, "sequentialProfile.drl");
        this.runTestProfileManyRulesAndFacts(true, "Sequential mode", 0, "sequentialProfile.drl");
        System.gc();
        Thread.sleep(100L);
    }

    @Test
    public void testProfileRETE() throws Exception {
        this.runTestProfileManyRulesAndFacts(false, "Normal RETE mode", 0, "sequentialProfile.drl");
        this.runTestProfileManyRulesAndFacts(false, "Normal RETE mode", 0, "sequentialProfile.drl");
        System.gc();
        Thread.sleep(100L);
    }

    @Test
    public void testNumberofIterationsSeq() throws Exception {
        this.runTestProfileManyRulesAndFacts(true, "SEQUENTIAL", 2000, "sequentialProfile.drl");
    }

    @Test
    public void testNumberofIterationsRETE() throws Exception {
        this.runTestProfileManyRulesAndFacts(false, "RETE", 2000, "sequentialProfile.drl");
    }

    @Test
    public void testPerfJDT() throws Exception {
        this.runTestProfileManyRulesAndFacts(true, "JDT", 2000, "sequentialProfile.drl");
    }

    @Test
    public void testPerfMVEL() throws Exception {
        this.runTestProfileManyRulesAndFacts(true, "MVEL", 2000, "sequentialProfileMVEL.drl");
    }

    private void runTestProfileManyRulesAndFacts(boolean sequentialMode, String message, int timetoMeasureIterations, String file) throws DroolsParserException, IOException, Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream(file)));
        if (builder.hasErrors()) {
            Assert.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        Properties properties = new Properties();
        properties.setProperty("drools.shadowProxyExcludes", "org.drools.*");
        RuleBaseConfiguration conf = new RuleBaseConfiguration(properties);
        conf.setSequential(sequentialMode);
        RuleBase ruleBase = this.getRuleBase(conf);
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatelessSession session = ruleBase.newStatelessSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Object[] data = new Object[50000];
        for (int i = 0; i < data.length; ++i) {
            if (i % 2 == 0) {
                Person p = new Person("p" + i, "stilton");
                data[i] = p;
                continue;
            }
            data[i] = new Cheese("cheddar", i);
        }
        if (timetoMeasureIterations == 0) {
            long start = System.currentTimeMillis();
            session.execute(data);
            System.out.println("Time for " + message + ":" + (System.currentTimeMillis() - start));
            Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        } else {
            long start = System.currentTimeMillis();
            long end = start + (long)timetoMeasureIterations;
            int count = 0;
            while (System.currentTimeMillis() < end) {
                StatelessSession sess2 = ruleBase.newStatelessSession();
                ArrayList list2 = new ArrayList();
                sess2.setGlobal("list", list2);
                sess2.execute(data);
                ++count;
            }
            System.out.println("Iterations in for " + message + " : " + count);
        }
    }

    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }
}

