/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.asm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import org.drools.rule.builder.dialect.asm.ClassGenerator;
import org.drools.rule.builder.dialect.asm.InvokerContext;
import org.drools.rule.builder.dialect.asm.InvokerDataProvider;
import org.drools.rule.builder.dialect.asm.InvokerGenerator;
import org.drools.rule.builder.dialect.asm.InvokerStub;
import org.junit.Test;

public class InvokerGeneratorTest {
    @Test
    public void testGenerate() {
        HashMap<String, Object> invokerContext = new HashMap<String, Object>();
        invokerContext.put("package", "pkg");
        invokerContext.put("invokerClassName", "TestInvoker");
        invokerContext.put("ruleClassName", "TestRule");
        invokerContext.put("methodName", "testMethod");
        invokerContext.put("consequenceName", "TestConsequence");
        invokerContext.put("hashCode", 111);
        invokerContext.put("declarationTypes", new String[]{"java/lang/String", "java/lang/Integer"});
        invokerContext.put("globals", new String[]{"globalList"});
        invokerContext.put("globalTypes", new String[]{"java/util/List"});
        HashSet<String> imports = new HashSet<String>();
        imports.add("p1");
        imports.add("p2");
        ClassGenerator generator = InvokerGenerator.createStubGenerator((InvokerDataProvider)new InvokerContext(invokerContext), (ClassLoader)this.getClass().getClassLoader(), null, imports);
        generator.setInterfaces(new Class[]{InvokerStub.class});
        InvokerStub stub = (InvokerStub)generator.newInstance();
        Assert.assertEquals((String)"pkg", (String)stub.getPackageName());
        Assert.assertEquals((String)"TestRule", (String)stub.getRuleClassName());
        Assert.assertEquals((String)"testMethod", (String)stub.getMethodName());
        Assert.assertEquals((String)"TestInvokerGenerated", (String)stub.getGeneratedInvokerClassName());
        Assert.assertEquals((int)111, (int)stub.hashCode());
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"java/lang/String", "java/lang/Integer"}, stub.getDeclarationTypes()));
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"globalList"}, stub.getGlobals()));
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"java/util/List"}, stub.getGlobalTypes()));
        List<String> importList = Arrays.asList(stub.getPackageImports());
        Assert.assertTrue((boolean)importList.contains("p1"));
        Assert.assertTrue((boolean)importList.contains("p2"));
    }
}

