package org.drools.compiler.lang.api;

import org.drools.compiler.lang.descr.BaseDescr;

/**
 * A helper interface for all builders that can encapsulate patterns
 */
public interface PatternContainerDescrBuilder<P extends DescrBuilder< ? , ? >, T extends BaseDescr> {

    public PatternDescrBuilder<P> pattern( String type );

    public PatternDescrBuilder<P> pattern();
    
    /**
     * Returns the descriptor generated by this builder.
     * 
     * @return
     */
    public T getDescr();
}
