/*
 * Decompiled with CFR 0.152.
 */
package org.drools.quarkus.test;

import io.quarkus.test.junit.QuarkusTest;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.drools.quarkus.test.Person;
import org.drools.quarkus.test.ProbeCounter;
import org.drools.quarkus.test.ProbeEvent;
import org.drools.quarkus.test.Result;
import org.drools.quarkus.test.StockTick;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieRuntimeBuilder;
import org.kie.api.runtime.KieSession;
import org.kie.api.time.SessionPseudoClock;

@QuarkusTest
public class RuntimeIT {
    @Inject
    KieRuntimeBuilder runtimeBuilder;

    @Test
    public void testDrlEvaluation() {
        this.testSimpleDrl(this.runtimeBuilder.newKieSession(), "org.drools.drl");
    }

    @Test
    public void testDTableEvaluation() {
        this.testSimpleDrl(this.runtimeBuilder.newKieSession("canDrinkKSDTable"), "org.drools.dtable");
    }

    private void testSimpleDrl(KieSession ksession, String assetPackage) {
        List pkgNames = ksession.getKieBase().getKiePackages().stream().map(KiePackage::getName).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)pkgNames.size());
        Assertions.assertTrue((boolean)pkgNames.contains("org.drools.quarkus.test"));
        Assertions.assertTrue((boolean)pkgNames.contains(assetPackage));
        Result result = new Result();
        ksession.insert((Object)result);
        ksession.insert((Object)new Person("Mark", 17));
        ksession.fireAllRules();
        Assertions.assertEquals((Object)"Mark can NOT drink", (Object)result.toString());
    }

    @Test
    public void testCepEvaluation() {
        KieSession ksession = this.runtimeBuilder.newKieSession("cepKS");
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        ksession.insert((Object)new StockTick("DROO"));
        clock.advanceTime(6L, TimeUnit.SECONDS);
        ksession.insert((Object)new StockTick("ACME"));
        Assertions.assertEquals((int)1, (int)ksession.fireAllRules());
        clock.advanceTime(4L, TimeUnit.SECONDS);
        ksession.insert((Object)new StockTick("ACME"));
        Assertions.assertEquals((int)0, (int)ksession.fireAllRules());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L, unit=TimeUnit.SECONDS)
    public void testFireUntiHalt() {
        KieSession ksession = this.runtimeBuilder.newKieSession("probeKS");
        new Thread(() -> ((KieSession)ksession).fireUntilHalt()).start();
        ProbeCounter pc = new ProbeCounter();
        ksession.insert((Object)pc);
        for (int i = 0; i < 10; ++i) {
            ksession.insert((Object)new ProbeEvent(i));
        }
        ProbeCounter probeCounter = pc;
        synchronized (probeCounter) {
            if (pc.getTotal() < 10) {
                try {
                    pc.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Assertions.assertEquals((int)10, (int)pc.getTotal());
    }

    @Test
    public void testAllPkgsKBase() {
        KieBase kBase = this.runtimeBuilder.getKieBase("allKB");
        List pkgNames = kBase.getKiePackages().stream().map(KiePackage::getName).collect(Collectors.toList());
        Assertions.assertEquals((int)5, (int)pkgNames.size());
        Assertions.assertTrue((boolean)pkgNames.contains("org.drools.quarkus.test"));
        Assertions.assertTrue((boolean)pkgNames.contains("org.drools.drl"));
        Assertions.assertTrue((boolean)pkgNames.contains("org.drools.dtable"));
        Assertions.assertTrue((boolean)pkgNames.contains("org.drools.cep"));
        Assertions.assertTrue((boolean)pkgNames.contains("org.drools.probe"));
    }
}

