/*
 * Decompiled with CFR 0.152.
 */
package org.drools.quarkus.test;

import io.quarkus.test.junit.QuarkusTest;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.drools.quarkus.test.Person;
import org.drools.quarkus.test.Result;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieRuntimeBuilder;
import org.kie.api.runtime.KieSession;

@QuarkusTest
public class RuntimeTest {
    @Inject
    KieRuntimeBuilder runtimeBuilder;

    @Test
    public void testDrlEvaluation() {
        this.testSimpleDrl(this.runtimeBuilder.newKieSession(), "org.drools.drl");
    }

    @Test
    public void testDTableEvaluation() {
        this.testSimpleDrl(this.runtimeBuilder.newKieSession("canDrinkKSDTable"), "org.drools.dtable");
    }

    private void testSimpleDrl(KieSession ksession, String assetPackage) {
        List pkgNames = ksession.getKieBase().getKiePackages().stream().map(KiePackage::getName).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)pkgNames.size());
        Assertions.assertTrue((boolean)pkgNames.contains("org.drools.quarkus.test"));
        Assertions.assertTrue((boolean)pkgNames.contains(assetPackage));
        Result result = new Result();
        ksession.insert((Object)result);
        ksession.insert((Object)new Person("Mark", 17));
        ksession.fireAllRules();
        Assertions.assertEquals((Object)"Mark can NOT drink", (Object)result.toString());
    }
}

