/*
 * Decompiled with CFR 0.152.
 */
package org.drools.quarkus.quickstart.test;

import io.quarkus.test.junit.QuarkusTest;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.drools.quarkus.quickstart.test.HomeAlertsBean;
import org.drools.quarkus.quickstart.test.model.Alert;
import org.drools.quarkus.quickstart.test.model.CCTV;
import org.drools.quarkus.quickstart.test.model.Light;
import org.drools.quarkus.quickstart.test.model.Smartphone;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class BeanTest {
    @Inject
    HomeAlertsBean alerts;

    @Test
    public void testRuleOutside() {
        Collection computeAlerts = this.alerts.computeAlerts(List.of(new Light("living room", Boolean.valueOf(true)), new Light("bedroom", Boolean.valueOf(false)), new Light("bathroom", Boolean.valueOf(false))), Collections.emptyList(), Collections.emptyList());
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)computeAlerts).isNotEmpty()).contains((Object[])new Alert[]{new Alert("You might have forgot one light powered on: living room")});
    }

    @Test
    public void testRuleInside() {
        Collection computeAlerts = this.alerts.computeAlerts(List.of(new Light("living room", Boolean.valueOf(true)), new Light("bedroom", Boolean.valueOf(false)), new Light("bathroom", Boolean.valueOf(false))), List.of(new CCTV("security camera 1", Boolean.valueOf(false)), new CCTV("security camera 2", Boolean.valueOf(true))), List.of(new Smartphone("John Doe's phone")));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)computeAlerts).isNotEmpty()).contains((Object[])new Alert[]{new Alert("One CCTV is still operating: security camera 2")});
    }

    @Test
    public void testNoAlerts() {
        Collection computeAlerts = this.alerts.computeAlerts(List.of(new Light("living room", Boolean.valueOf(false)), new Light("bedroom", Boolean.valueOf(false)), new Light("bathroom", Boolean.valueOf(false))), List.of(new CCTV("security camera 1", Boolean.valueOf(true)), new CCTV("security camera 2", Boolean.valueOf(true))), Collections.emptyList());
        Assertions.assertThat((Collection)computeAlerts).isEmpty();
    }
}

