/*
 * Decompiled with CFR 0.152.
 */
package org.drools.quarkus.quickstart.test;

import io.quarkus.test.junit.QuarkusTest;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.drools.quarkus.quickstart.test.HomeRuleUnitData;
import org.drools.quarkus.quickstart.test.model.Alert;
import org.drools.quarkus.quickstart.test.model.CCTV;
import org.drools.quarkus.quickstart.test.model.Light;
import org.drools.quarkus.quickstart.test.model.Smartphone;
import org.drools.ruleunits.api.RuleUnit;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.rule.QueryResults;

@QuarkusTest
public class RuntimeIT {
    @Inject
    RuleUnit<HomeRuleUnitData> ruleUnit;

    @Test
    public void testRuleOutside() {
        HomeRuleUnitData homeUnitData = new HomeRuleUnitData();
        homeUnitData.getLights().add((Object)new Light("living room", Boolean.valueOf(true)));
        homeUnitData.getLights().add((Object)new Light("bedroom", Boolean.valueOf(false)));
        homeUnitData.getLights().add((Object)new Light("bathroom", Boolean.valueOf(false)));
        try (RuleUnitInstance unitInstance = this.ruleUnit.createInstance((RuleUnitData)homeUnitData);){
            QueryResults queryResults = unitInstance.executeQuery("AllAlerts", new Object[0]);
            ((IterableAssert)Assertions.assertThat((Iterable)queryResults).isNotEmpty()).anyMatch(kv -> kv.get("$a").equals(new Alert("You might have forgot one light powered on: living room")));
        }
    }

    @Test
    public void testRuleInside() {
        HomeRuleUnitData homeUnitData = new HomeRuleUnitData();
        homeUnitData.getLights().add((Object)new Light("living room", Boolean.valueOf(true)));
        homeUnitData.getLights().add((Object)new Light("bedroom", Boolean.valueOf(false)));
        homeUnitData.getLights().add((Object)new Light("bathroom", Boolean.valueOf(false)));
        homeUnitData.getCctvs().add((Object)new CCTV("security camera 1", Boolean.valueOf(false)));
        homeUnitData.getCctvs().add((Object)new CCTV("security camera 2", Boolean.valueOf(true)));
        homeUnitData.getSmartphones().add((Object)new Smartphone("John Doe's phone"));
        try (RuleUnitInstance unitInstance = this.ruleUnit.createInstance((RuleUnitData)homeUnitData);){
            QueryResults queryResults = unitInstance.executeQuery("AllAlerts", new Object[0]);
            ((IterableAssert)Assertions.assertThat((Iterable)queryResults).isNotEmpty()).anyMatch(kv -> kv.get("$a").equals(new Alert("One CCTV is still operating: security camera 2")));
        }
    }

    @Test
    public void testNoAlerts() {
        HomeRuleUnitData homeUnitData = new HomeRuleUnitData();
        homeUnitData.getLights().add((Object)new Light("living room", Boolean.valueOf(false)));
        homeUnitData.getLights().add((Object)new Light("bedroom", Boolean.valueOf(false)));
        homeUnitData.getLights().add((Object)new Light("bathroom", Boolean.valueOf(false)));
        homeUnitData.getCctvs().add((Object)new CCTV("security camera 1", Boolean.valueOf(true)));
        homeUnitData.getCctvs().add((Object)new CCTV("security camera 2", Boolean.valueOf(true)));
        try (RuleUnitInstance unitInstance = this.ruleUnit.createInstance((RuleUnitData)homeUnitData);){
            QueryResults queryResults = unitInstance.executeQuery("AllAlerts", new Object[0]);
            Assertions.assertThat((Iterable)queryResults).isEmpty();
        }
    }
}

