/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factconstraints.client.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.drools.factconstraints.client.ConstraintConfiguration;
import org.drools.factconstraints.client.config.SimpleConstraintConfigurationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintsContainer {
    private static final Map<String, ConstraintConfiguration> constraintConfigs = new HashMap<String, ConstraintConfiguration>();
    private Map<String, List<ConstraintConfiguration>> constraints = new HashMap<String, List<ConstraintConfiguration>>();

    public ConstraintsContainer(ConstraintConfiguration[] constraints) {
        this(Arrays.asList(constraints));
    }

    public ConstraintsContainer(Collection<ConstraintConfiguration> constraints) {
        if (constraints != null && !constraints.isEmpty()) {
            for (ConstraintConfiguration c : constraints) {
                this.addConstraint(c);
            }
        }
    }

    public ConstraintsContainer() {
    }

    public List<ConstraintConfiguration> removeConstraint(ConstraintConfiguration c) {
        List<ConstraintConfiguration> list = this.constraints.get(c.getFactType());
        if (list != null) {
            list.remove(c);
        }
        return list;
    }

    public void addConstraint(ConstraintConfiguration c) {
        List<ConstraintConfiguration> list = this.constraints.get(c.getFactType());
        if (list == null) {
            list = new LinkedList<ConstraintConfiguration>();
            this.constraints.put(c.getFactType(), list);
        }
        list.add(c);
    }

    public List<ConstraintConfiguration> getConstraints(String factType) {
        return Collections.unmodifiableList(this.constraints.get(factType));
    }

    public List<ConstraintConfiguration> getConstraints(String factType, String fieldName) {
        List<ConstraintConfiguration> list = this.constraints.get(factType);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<ConstraintConfiguration> res = new LinkedList<ConstraintConfiguration>();
        for (ConstraintConfiguration c : list) {
            if (!fieldName.equals(c.getFieldName())) continue;
            res.add(c);
        }
        return res;
    }

    public boolean hasConstraints(String FactType) {
        return this.constraints.containsKey(FactType);
    }

    public static Map<String, ConstraintConfiguration> getAllConfigurations() {
        return constraintConfigs;
    }

    public static ConstraintConfiguration getEmptyConfiguration(String constraintName) {
        return ConstraintsContainer.copyConfig(ConstraintsContainer.getAllConfigurations().get(constraintName));
    }

    private static ConstraintConfiguration copyConfig(ConstraintConfiguration constraintConfiguration) {
        return new SimpleConstraintConfigurationImpl(constraintConfiguration);
    }

    static {
        SimpleConstraintConfigurationImpl config = new SimpleConstraintConfigurationImpl();
        config.setConstraintName("NotNull");
        constraintConfigs.put(config.getConstraintName(), config);
        config = new SimpleConstraintConfigurationImpl();
        config.setConstraintName("IntegerConstraint");
        constraintConfigs.put(config.getConstraintName(), config);
        config = new SimpleConstraintConfigurationImpl();
        config.setConstraintName("RangeConstraint");
        config.setArgumentValue("Min.value", "0");
        config.setArgumentValue("Max.value", "0");
        constraintConfigs.put(config.getConstraintName(), config);
        config = new SimpleConstraintConfigurationImpl();
        config.setConstraintName("NotMatches");
        config.setArgumentValue("matches", "");
        constraintConfigs.put(config.getConstraintName(), config);
        config = new SimpleConstraintConfigurationImpl();
        config.setConstraintName("Matches");
        config.setArgumentValue("matches", "");
        constraintConfigs.put(config.getConstraintName(), config);
        config = new SimpleConstraintConfigurationImpl();
        config.setConstraintName("IvalidFieldConstraint");
        constraintConfigs.put(config.getConstraintName(), config);
    }
}

