/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factconstraints.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.evaluators.Operator;
import org.drools.factconstraints.client.ArgumentNotSetException;
import org.drools.factconstraints.client.ConstraintConfiguration;
import org.drools.factconstraints.client.ValidationResult;
import org.drools.factconstraints.server.Constraint;
import org.drools.verifier.report.components.Severity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultFieldConstraintImpl
implements Constraint {
    private static final long serialVersionUID = 501L;
    private long ruleNum = 0L;
    public static final List<Operator> supportedOperators = new ArrayList<Operator>();

    protected String getFieldRestrictionClassName() {
        return "LiteralRestriction";
    }

    private String concatRule(ConstraintConfiguration config, Map<String, Object> context) {
        StringBuilder rule = new StringBuilder();
        rule.append(this.getVerifierPackagePrefixTemplate(config, context));
        rule.append(this.getVerifierPackageTemplate(config, context));
        rule.append(this.getVerifierPackageSufixTemplate(config, context));
        rule.append(this.getVerifierImportsPrefixTemplate(config, context));
        rule.append(this.getVerifierImportsTemplate(config, context));
        rule.append(this.getVerifierImportsSufixTemplate(config, context));
        rule.append(this.getVerifierGlobalsPrefixTemplate(config, context));
        rule.append(this.getVerifierGlobalsTemplate(config, context));
        rule.append(this.getVerifierGlobalsSufixTemplate(config, context));
        rule.append(this.getVerifierRuleNamePrefixTemplate(config, context));
        rule.append(this.getVerifierRuleNameTemplate(config, context));
        rule.append(this.getVerifierRuleNameSufixTemplate(config, context));
        rule.append(this.getVerifierRuleWhenTemplate(config, context));
        rule.append(this.getVerifierFieldPatternPrefixTemplate(config, context));
        rule.append(this.getVerifierFieldPatternTemplate(config, context));
        rule.append(this.getVerifierFieldPatternSufixTemplate(config, context));
        rule.append(this.getVerifierRestrictionPatternPrefixTemplate(config, context));
        rule.append(this.getVerifierRestrictionPatternTemplate(config, context));
        rule.append(this.getVerifierRestrictionPatternSufixTemplate(config, context));
        rule.append(this.getVerifierRuleThenTemplate(config, context));
        rule.append(this.getVerifierActionPrefixTemplate(config, context));
        rule.append(this.getVerifierActionTemplate(config, context));
        rule.append(this.getVerifierActionSufixTemplate(config, context));
        rule.append(this.getVerifierRuleEndTemplate(config, context));
        rule.append(this.getVerifierRuleEndSufixTemplate(config, context));
        return rule.toString();
    }

    protected String createVerifierRuleTemplate(ConstraintConfiguration config, Map<String, Object> context, String ruleName, List<String> constraints, String message) {
        if (ruleName == null) {
            ruleName = "Constraint_rule";
        }
        ruleName = ruleName + "_" + this.ruleNum++;
        String rule = this.concatRule(config, context).replace("${ruleName}", ruleName);
        rule = rule.replace("${factType}", config.getFactType());
        rule = rule.replace("${fieldName}", config.getFieldName());
        StringBuilder constraintsTxt = new StringBuilder();
        if (constraints != null && !constraints.isEmpty()) {
            for (String c : constraints) {
                constraintsTxt.append(",\n");
                constraintsTxt.append(c);
            }
        }
        rule = rule.replace("${constraints}", constraintsTxt);
        rule = rule.replace("${message}", message == null || message.equals("") ? "Invalid Value" : message);
        return rule;
    }

    protected Object getMandatoryArgument(String key, ConstraintConfiguration conf) throws ArgumentNotSetException {
        if (!conf.containsArgument(key)) {
            throw new ArgumentNotSetException("The argument " + key + " doesn't exist.");
        }
        Object value = conf.getArgumentValue(key);
        if (value == null) {
            throw new ArgumentNotSetException("The argument " + key + " is null.");
        }
        return value;
    }

    @Override
    @Deprecated
    public ValidationResult validate(Object value, ConstraintConfiguration config) {
        ValidationResult result = new ValidationResult();
        result.setSuccess(true);
        return result;
    }

    protected Map<String, Object> createContext() {
        return new HashMap<String, Object>();
    }

    @Override
    public final String getVerifierRule(ConstraintConfiguration config) {
        return this.internalVerifierRule(config, this.createContext());
    }

    protected abstract String internalVerifierRule(ConstraintConfiguration var1, Map<String, Object> var2);

    @Override
    public String getConstraintName() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
    }

    protected String getVerifierActionTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        StringBuilder verifierActionTemplate = new StringBuilder();
        verifierActionTemplate.append(this.addResult(Severity.ERROR));
        return verifierActionTemplate.toString();
    }

    protected String addResult(Severity severity) {
        StringBuilder addString = new StringBuilder();
        addString.append("      result.add(new VerifierMessage(\n");
        addString.append("                        impactedRules,\n");
        if (severity.compareTo(Severity.ERROR) == 0) {
            addString.append("                        Severity.ERROR,\n");
        } else if (severity.compareTo(Severity.NOTE) == 0) {
            addString.append("                        Severity.NOTE,\n");
        } else if (severity.compareTo(Severity.WARNING) == 0) {
            addString.append("                        Severity.WARNING,\n");
        }
        addString.append("                        MessageType.NOT_SPECIFIED,\n");
        addString.append("                        $restriction,\n");
        addString.append("                        \"${message}\" ) );\n");
        return addString.toString();
    }

    protected String getVerifierActionPrefixTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        StringBuilder verifierActionPrefixTemplate = new StringBuilder();
        verifierActionPrefixTemplate.append("      Map<String,String> impactedRules = new HashMap<String,String>();\n").append("      impactedRules.put( $restriction.getPackagePath(), $restriction.getRuleName());\n");
        return verifierActionPrefixTemplate.toString();
    }

    protected String getVerifierActionSufixTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "";
    }

    protected String getVerifierFieldPatternTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        StringBuilder verifierFieldPatternTemplate = new StringBuilder();
        verifierFieldPatternTemplate.append("      $field :Field(\n");
        verifierFieldPatternTemplate.append("          objectTypeName == \"${factType}\",\n");
        verifierFieldPatternTemplate.append("          name == \"${fieldName}\"\n");
        verifierFieldPatternTemplate.append("      )\n");
        return verifierFieldPatternTemplate.toString();
    }

    protected String getVerifierFieldPatternPrefixTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "";
    }

    protected String getVerifierFieldPatternSufixTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "";
    }

    protected String getVerifierGlobalsTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "global VerifierReport result;\n";
    }

    protected String getVerifierGlobalsPrefixTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "";
    }

    protected String getVerifierGlobalsSufixTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "";
    }

    protected String getVerifierImportsTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        StringBuilder verifierImportsTemplate = new StringBuilder();
        verifierImportsTemplate.append("import org.drools.verifier.components.*;\n");
        verifierImportsTemplate.append("import java.util.Map;\n");
        verifierImportsTemplate.append("import java.util.HashMap;\n");
        verifierImportsTemplate.append("import org.drools.verifier.report.components.VerifierMessage;\n");
        verifierImportsTemplate.append("import org.drools.verifier.data.VerifierReport;\n");
        verifierImportsTemplate.append("import org.drools.verifier.report.components.Severity;\n");
        verifierImportsTemplate.append("import org.drools.verifier.report.components.MessageType;\n");
        return verifierImportsTemplate.toString();
    }

    protected String getVerifierImportsPrefixTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "";
    }

    protected String getVerifierImportsSufixTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "";
    }

    protected String getVerifierPackageTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "package org.drools.verifier.consequence\n";
    }

    protected String getVerifierPackagePrefixTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "";
    }

    protected String getVerifierPackageSufixTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "";
    }

    protected String getVerifierRestrictionPatternTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        StringBuilder verifierRestrictionPatternTemplate = new StringBuilder();
        verifierRestrictionPatternTemplate.append("      $restriction :");
        verifierRestrictionPatternTemplate.append(this.getFieldRestrictionClassName());
        verifierRestrictionPatternTemplate.append("      (\n");
        verifierRestrictionPatternTemplate.append("            fieldPath == $field.path\n");
        verifierRestrictionPatternTemplate.append("            ${constraints}\n");
        verifierRestrictionPatternTemplate.append("      )\n");
        return verifierRestrictionPatternTemplate.toString();
    }

    protected String getVerifierRestrictionPatternPrefixTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "";
    }

    protected String getVerifierRestrictionPatternSufixTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "";
    }

    protected String getVerifierRuleEndTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "end\n";
    }

    protected String getVerifierRuleEndSufixTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "";
    }

    protected String getVerifierRuleNameTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "rule \"${ruleName}\"\n";
    }

    protected String getVerifierRuleNamePrefixTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "";
    }

    protected String getVerifierRuleNameSufixTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "";
    }

    protected String getVerifierRuleThenTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "  then\n";
    }

    protected String getVerifierRuleWhenTemplate(ConstraintConfiguration config, Map<String, Object> context) {
        return "  when\n";
    }

    @Override
    public List<String> getArgumentKeys() {
        return new ArrayList<String>();
    }

    static {
        supportedOperators.add(Operator.EQUAL);
        supportedOperators.add(Operator.NOT_EQUAL);
        supportedOperators.add(Operator.GREATER);
        supportedOperators.add(Operator.GREATER_OR_EQUAL);
        supportedOperators.add(Operator.LESS);
        supportedOperators.add(Operator.LESS_OR_EQUAL);
    }
}

