/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factconstraints.server.predefined;

import java.util.Collection;
import org.drools.builder.ResourceType;
import org.drools.factconstraints.client.ConstraintConfiguration;
import org.drools.factconstraints.client.ValidationResult;
import org.drools.factconstraints.client.config.SimpleConstraintConfigurationImpl;
import org.drools.factconstraints.server.Constraint;
import org.drools.factconstraints.server.predefined.NotMatchesConstraint;
import org.drools.io.ResourceFactory;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierConfigurationImpl;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Severity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class NotMatchesConstraintTest {
    private ConstraintConfiguration conf;
    private Constraint cons;

    @Before
    public void setup() {
        this.conf = new SimpleConstraintConfigurationImpl();
        this.conf.setFactType("Person");
        this.conf.setFieldName("name");
        this.conf.setArgumentValue("matches", "^[A-Z].*$");
        this.cons = new NotMatchesConstraint();
        System.out.println("not matches rule: " + this.cons.getVerifierRule(this.conf));
    }

    @Test
    @Ignore
    public void testValidConstraint() {
        ValidationResult result = this.cons.validate((Object)"Bart", this.conf);
        Assert.assertTrue((boolean)result.isSuccess());
        result = this.cons.validate((Object)"", this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        result = this.cons.validate((Object)"bart", this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        result = this.cons.validate((Object)new Long("12"), this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        result = this.cons.validate((Object)12L, this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        result = this.cons.validate((Object)12.8, this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
    }

    @Test
    @Ignore
    public void testInvalidConstraint() {
        ValidationResult result = this.cons.validate(null, this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        System.out.println("Message: " + result.getMessage());
    }

    @Test
    public void testUsingVerifier() {
        String ruleToVerify = "";
        int fails = 0;
        ruleToVerify = String.valueOf(ruleToVerify) + "package org.drools.factconstraint.test\n\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "import org.drools.factconstraint.model.*\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"rule1\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       Person(name == \"John\")\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n\n";
        ++fails;
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"rule2\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       Person(name == '')\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"pepe\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "dialect \"mvel\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "    when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "        Person( name == 'pepe' )\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "    then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"rule3\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       Person(name == 'bart')\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"rule4\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       Person(name == '1bart')\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n";
        System.out.println(ruleToVerify);
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfigurationImpl vconf = new VerifierConfigurationImpl();
        vconf.getVerifyingResources().put(ResourceFactory.newByteArrayResource((byte[])this.cons.getVerifierRule(this.conf).getBytes()), ResourceType.DRL);
        Verifier verifier = vBuilder.newVerifier((VerifierConfiguration)vconf);
        verifier.addResourcesToVerify(ResourceFactory.newByteArrayResource((byte[])ruleToVerify.getBytes()), ResourceType.DRL);
        if (verifier.hasErrors()) {
            for (VerifierError error : verifier.getErrors()) {
                System.out.println(error.getMessage());
            }
            throw new RuntimeException("Error building verifier");
        }
        Assert.assertFalse((boolean)verifier.hasErrors());
        boolean noProblems = verifier.fireAnalysis();
        Assert.assertTrue((boolean)noProblems);
        VerifierReport result = verifier.getResult();
        Collection warnings = result.getBySeverity(Severity.ERROR);
        System.out.println(warnings);
        Assert.assertEquals((long)fails, (long)warnings.size());
        verifier.dispose();
    }
}

