/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factconstraints.server.predefined;

import java.util.Collection;
import org.drools.builder.ResourceType;
import org.drools.factconstraints.client.ConstraintConfiguration;
import org.drools.factconstraints.client.config.SimpleConstraintConfigurationImpl;
import org.drools.factconstraints.server.Constraint;
import org.drools.factconstraints.server.predefined.RangeConstraint;
import org.drools.io.ResourceFactory;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierConfigurationImpl;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Severity;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RangeConstraintMultipleOperatorsTest {
    private Verifier verifier;
    private Constraint cons;
    private ConstraintConfiguration conf;

    @Before
    public void setup() {
        this.cons = new RangeConstraint();
        this.conf = new SimpleConstraintConfigurationImpl();
        this.conf.setFactType("Person");
        this.conf.setFieldName("age");
        this.conf.setArgumentValue("Min.value", "0");
        this.conf.setArgumentValue("Max.value", "120");
        System.out.println("Validation Rule:\n" + this.cons.getVerifierRule(this.conf) + "\n\n");
    }

    @After
    public void dispose() {
        if (this.verifier != null) {
            this.verifier.dispose();
        }
    }

    @Test
    public void test1() {
        String rulesToVerify = "";
        int fail = 0;
        int warn = 0;
        rulesToVerify = String.valueOf(rulesToVerify) + "package org.drools.factconstraint.test\n\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "import org.drools.factconstraint.model.*\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "rule \"rule1\"\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   when\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       Person(age > 1, age < 100)\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   then\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "end\n\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "rule \"rule2\"\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   when\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       Person(age > -1,  age < 60)\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   then\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "end\n\n";
        ++warn;
        rulesToVerify = String.valueOf(rulesToVerify) + "rule \"rule3\"\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   when\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       Person(age > -1,  age < 150)\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   then\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "end\n\n";
        ++warn;
        rulesToVerify = String.valueOf(rulesToVerify) + "rule \"rule4\"\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   when\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       Person(age > 150,  age < -1)\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   then\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "end\n\n";
        ++fail;
        rulesToVerify = String.valueOf(rulesToVerify) + "rule \"rule5\"\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   when\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       Person(age > -10,  age < -1)\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   then\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "end\n\n";
        ++warn;
        rulesToVerify = String.valueOf(rulesToVerify) + "rule \"rule6\"\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   when\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       Person(age > 18,  age < 150)\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   then\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "end\n\n";
        ++warn;
        rulesToVerify = String.valueOf(rulesToVerify) + "rule \"rule7\"\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   when\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       Person(age > 18,  age < -1)\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   then\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "end\n\n";
        ++fail;
        rulesToVerify = String.valueOf(rulesToVerify) + "rule \"rule8\"\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   when\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       Person(age > 130,  age < 150)\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   then\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "end\n\n";
        ++warn;
        rulesToVerify = String.valueOf(rulesToVerify) + "rule \"rule9\"\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   when\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       Person(age > 130,  age < 18)\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   then\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "end\n\n";
        ++fail;
        VerifierReport result = this.verify(rulesToVerify);
        Collection errors = result.getBySeverity(Severity.ERROR);
        Collection warnings = result.getBySeverity(Severity.WARNING);
        System.out.println(warnings);
        System.out.println(errors);
        Assert.assertEquals((long)warn, (long)warnings.size());
        Assert.assertEquals((long)fail, (long)errors.size());
    }

    @Test
    public void test2() {
        String rulesToVerify = "";
        int fail = 0;
        int warn = 0;
        rulesToVerify = String.valueOf(rulesToVerify) + "package org.drools.factconstraint.test\n\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "import org.drools.factconstraint.model.*\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "rule \"rule1\"\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   when\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       Person(age >= 0, age <= 120)\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   then\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "end\n\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "rule \"rule2\"\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   when\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       Person(age >= 0, age <= 121)\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   then\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "end\n\n";
        ++warn;
        rulesToVerify = String.valueOf(rulesToVerify) + "rule \"rule3\"\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   when\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       Person(age >= 0, age <= 121.1)\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "   then\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "       System.out.println(\"Rule fired\");\n";
        rulesToVerify = String.valueOf(rulesToVerify) + "end\n\n";
        ++warn;
        VerifierReport result = this.verify(rulesToVerify);
        Collection errors = result.getBySeverity(Severity.ERROR);
        Collection warnings = result.getBySeverity(Severity.WARNING);
        System.out.println(warnings);
        System.out.println(errors);
        Assert.assertEquals((long)warn, (long)warnings.size());
        Assert.assertEquals((long)fail, (long)errors.size());
    }

    private VerifierReport verify(String rulesToVerify) {
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfigurationImpl conf = new VerifierConfigurationImpl();
        conf.getVerifyingResources().put(ResourceFactory.newByteArrayResource((byte[])this.cons.getVerifierRule(this.conf).getBytes()), ResourceType.DRL);
        this.verifier = vBuilder.newVerifier((VerifierConfiguration)conf);
        this.verifier.addResourcesToVerify(ResourceFactory.newByteArrayResource((byte[])rulesToVerify.getBytes()), ResourceType.DRL);
        if (this.verifier.hasErrors()) {
            for (VerifierError error : this.verifier.getErrors()) {
                System.out.println(error.getMessage());
            }
            throw new RuntimeException("Error building verifier");
        }
        Assert.assertFalse((boolean)this.verifier.hasErrors());
        boolean noProblems = this.verifier.fireAnalysis();
        Assert.assertTrue((boolean)noProblems);
        return this.verifier.getResult();
    }
}

