/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factconstraints.server.predefined;

import java.util.Collection;
import org.drools.builder.ResourceType;
import org.drools.factconstraints.client.ConstraintConfiguration;
import org.drools.factconstraints.client.ValidationResult;
import org.drools.factconstraints.client.config.SimpleConstraintConfigurationImpl;
import org.drools.factconstraints.server.Constraint;
import org.drools.factconstraints.server.predefined.RangeConstraint;
import org.drools.io.ResourceFactory;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierConfigurationImpl;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Severity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RangeConstraintTest {
    private Constraint cons;
    private ConstraintConfiguration conf;

    @Before
    public void setup() {
        this.cons = new RangeConstraint();
        this.conf = new SimpleConstraintConfigurationImpl();
        this.conf.setFactType("Person");
        this.conf.setFieldName("age");
    }

    public void testValidConstraint() {
        this.conf.setArgumentValue("Min.value", "-0.5");
        this.conf.setArgumentValue("Max.value", "100");
        ValidationResult result = this.cons.validate((Object)12, this.conf);
        Assert.assertTrue((boolean)result.isSuccess());
        result = this.cons.validate((Object)new Integer("12"), this.conf);
        Assert.assertTrue((boolean)result.isSuccess());
        result = this.cons.validate((Object)"12", this.conf);
        Assert.assertTrue((boolean)result.isSuccess());
        result = this.cons.validate((Object)0.6, this.conf);
        Assert.assertTrue((boolean)result.isSuccess());
        result = this.cons.validate((Object)new Float("-0.3"), this.conf);
        Assert.assertTrue((boolean)result.isSuccess());
        result = this.cons.validate((Object)"90.76", this.conf);
        Assert.assertTrue((boolean)result.isSuccess());
    }

    public void testInvalidConstraint() {
        this.conf.setArgumentValue("Min.value", "-0.5");
        this.conf.setArgumentValue("Max.value", "100");
        ValidationResult result = this.cons.validate(new Object(), this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        System.out.println("Message: " + result.getMessage());
        result = this.cons.validate(null, this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        System.out.println("Message: " + result.getMessage());
        result = this.cons.validate((Object)"", this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        System.out.println("Message: " + result.getMessage());
        result = this.cons.validate((Object)"ABC", this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        System.out.println("Message: " + result.getMessage());
        result = this.cons.validate((Object)new Long("-100"), this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        System.out.println("Message: " + result.getMessage());
        result = this.cons.validate((Object)-0.5, this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        System.out.println("Message: " + result.getMessage());
        result = this.cons.validate((Object)100, this.conf);
        Assert.assertFalse((boolean)result.isSuccess());
        System.out.println("Message: " + result.getMessage());
    }

    @Test
    public void testUsingVerifier() {
        this.conf.setArgumentValue("Min.value", "0");
        this.conf.setArgumentValue("Max.value", "120");
        System.out.println("Validation Rule:\n" + this.cons.getVerifierRule(this.conf) + "\n\n");
        SimpleConstraintConfigurationImpl salaryCons = new SimpleConstraintConfigurationImpl();
        salaryCons.setFactType("Person");
        salaryCons.setFieldName("salary");
        salaryCons.setArgumentValue("Min.value", "0");
        salaryCons.setArgumentValue("Max.value", "1000.6");
        System.out.println("Validation Rule:\n" + this.cons.getVerifierRule((ConstraintConfiguration)salaryCons) + "\n\n");
        String ruleToVerify = "";
        int fail = 0;
        ruleToVerify = String.valueOf(ruleToVerify) + "package org.drools.factconstraint.test\n\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "import org.drools.factconstraint.model.*\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"rule1\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       Person(age == 10)\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"rule2\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       Person(age == -5)\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n\n";
        ++fail;
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"rule3\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       Person(age == 100)\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"rule4\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       Person(salary == 100)\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"rule5\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       Person(salary == 89.67)\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"rule6\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       Person(salary == 1000.7)\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n";
        ++fail;
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"rule7\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       Person(salary == 1024)\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n";
        ++fail;
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"rule8\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       Person(age == 45, salary == 1000)\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"rule9\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       Person(age == 40, salary == 1011)\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n";
        ++fail;
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"rule10\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       Person(age == 43, salary == 1007)\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n";
        ++fail;
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"rule11\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       Person(age == 403, salary == 1008)\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n";
        fail += 2;
        ruleToVerify = String.valueOf(ruleToVerify) + "rule \"rule12\"\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   when\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       Person(age == 404, salary == -0.679)\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "   then\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = String.valueOf(ruleToVerify) + "end\n";
        fail += 2;
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfigurationImpl vconf = new VerifierConfigurationImpl();
        vconf.getVerifyingResources().put(ResourceFactory.newByteArrayResource((byte[])this.cons.getVerifierRule(this.conf).getBytes()), ResourceType.DRL);
        vconf.getVerifyingResources().put(ResourceFactory.newByteArrayResource((byte[])this.cons.getVerifierRule((ConstraintConfiguration)salaryCons).getBytes()), ResourceType.DRL);
        Verifier verifier = vBuilder.newVerifier((VerifierConfiguration)vconf);
        verifier.addResourcesToVerify(ResourceFactory.newByteArrayResource((byte[])ruleToVerify.getBytes()), ResourceType.DRL);
        if (verifier.hasErrors()) {
            for (VerifierError error : verifier.getErrors()) {
                System.out.println(error.getMessage());
            }
            throw new RuntimeException("Error building verifier");
        }
        Assert.assertFalse((boolean)verifier.hasErrors());
        boolean noProblems = verifier.fireAnalysis();
        Assert.assertTrue((boolean)noProblems);
        VerifierReport result = verifier.getResult();
        Collection warnings = result.getBySeverity(Severity.ERROR);
        System.out.println(warnings);
        Assert.assertEquals((long)fail, (long)warnings.size());
        verifier.dispose();
    }
}

