/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factconstraints.test.client.helper;

import java.util.LinkedList;
import org.drools.factconstraints.client.ConstraintConfiguration;
import org.drools.factconstraints.client.config.SimpleConstraintConfigurationImpl;
import org.drools.factconstraints.client.helper.ConstraintsContainer;
import org.junit.Assert;
import org.junit.Test;

public class ConstraintsConstrainerTest {
    @Test
    public void test() {
        LinkedList<SimpleConstraintConfigurationImpl> list = new LinkedList<SimpleConstraintConfigurationImpl>();
        SimpleConstraintConfigurationImpl conf = new SimpleConstraintConfigurationImpl();
        conf.setFactType("Person");
        conf.setFieldName("age");
        list.add(conf);
        ConstraintsContainer cc = new ConstraintsContainer(list);
        Assert.assertTrue((boolean)cc.hasConstraints("Person"));
        Assert.assertFalse((boolean)cc.hasConstraints("Person3"));
        Assert.assertEquals((long)1L, (long)cc.getConstraints("Person").size());
        conf = new SimpleConstraintConfigurationImpl();
        conf.setFactType("Person");
        conf.setFieldName("name");
        cc.addConstraint((ConstraintConfiguration)conf);
        Assert.assertEquals((long)2L, (long)cc.getConstraints("Person").size());
        Assert.assertEquals((long)1L, (long)cc.getConstraints("Person", "age").size());
        Assert.assertSame((Object)conf, cc.getConstraints("Person", "name").get(0));
        Assert.assertEquals((long)0L, (long)cc.getConstraints("Person", "toothCount").size());
        conf = new SimpleConstraintConfigurationImpl();
        conf.setFactType("Pet");
        conf.setFieldName("name");
        cc.addConstraint((ConstraintConfiguration)conf);
        Assert.assertEquals((long)1L, (long)cc.getConstraints("Pet").size());
        Assert.assertEquals((long)1L, (long)cc.getConstraints("Pet", "name").size());
    }

    @Test
    public void newConfig() {
        String[] stringArray = new String[]{"NotNull", "IntegerConstraint", "RangeConstraint", "NotMatches", "Matches"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String confName = stringArray[n2];
            ConstraintConfiguration conf1 = ConstraintsContainer.getEmptyConfiguration((String)confName);
            ConstraintConfiguration conf2 = ConstraintsContainer.getEmptyConfiguration((String)confName);
            Assert.assertFalse((boolean)conf1.equals(conf2));
            Assert.assertEquals((Object)conf1.getArgumentKeys(), (Object)conf2.getArgumentKeys());
            ++n2;
        }
    }
}

