/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factconstraints.server.factory;

import org.drools.factconstraints.client.ConstraintConfiguration;
import org.drools.factconstraints.server.Constraint;
import org.drools.factconstraints.server.predefined.IntegerConstraint;
import org.drools.factconstraints.server.predefined.MatchesConstraint;
import org.drools.factconstraints.server.predefined.NotMatchesConstraint;
import org.drools.factconstraints.server.predefined.NotNullConstraint;
import org.drools.factconstraints.server.predefined.RangeConstraint;

public class ConstraintsFactory {
    private static final ConstraintsFactory INSTANCE = new ConstraintsFactory();

    public static ConstraintsFactory getInstance() {
        return INSTANCE;
    }

    private ConstraintsFactory() {
    }

    public Constraint buildConstraint(ConstraintConfiguration config) {
        if ("NotNull".equals(config.getConstraintName())) {
            return new NotNullConstraint();
        }
        if ("IntegerConstraint".equals(config.getConstraintName())) {
            return new IntegerConstraint();
        }
        if ("RangeConstraint".equals(config.getConstraintName())) {
            return new RangeConstraint();
        }
        if ("NotMatches".equals(config.getConstraintName())) {
            return new NotMatchesConstraint();
        }
        if ("Matches".equals(config.getConstraintName())) {
            return new MatchesConstraint();
        }
        throw new IllegalArgumentException("Constraint unknown: " + config.getConstraintName());
    }

    public String getVerifierRule(ConstraintConfiguration config) {
        return this.buildConstraint(config).getVerifierRule(config);
    }
}

