/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.task;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.drools.grid.ExecutionNode;
import org.drools.grid.RemoteConnection;
import org.drools.grid.task.CommandBasedServicesWSHumanTaskHandler;
import org.drools.grid.task.HumanTaskService;
import org.drools.grid.task.TaskClientMessageHandlerImpl;
import org.drools.grid.task.responseHandlers.BlockingGetContentMessageResponseHandler;
import org.drools.grid.task.responseHandlers.BlockingGetTaskMessageResponseHandler;
import org.drools.grid.task.responseHandlers.BlockingTaskOperationMessageResponseHandler;
import org.drools.grid.task.responseHandlers.BlockingTaskSummaryMessageResponseHandler;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.WorkItemManager;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.task.AccessType;
import org.drools.task.Group;
import org.drools.task.Status;
import org.drools.task.Task;
import org.drools.task.User;
import org.drools.task.query.TaskSummary;
import org.drools.task.service.ContentData;
import org.drools.task.service.PermissionDeniedException;
import org.junit.Test;

public abstract class BaseTaskServiceTest {
    protected CommandBasedServicesWSHumanTaskHandler handler;
    protected HumanTaskService humanTaskClient;
    protected static final int DEFAULT_WAIT_TIME = 5000;
    protected static final int MANAGER_COMPLETION_WAIT_TIME = 5000;
    protected static final int MANAGER_ABORT_WAIT_TIME = 5000;
    protected Map<String, User> users;
    protected Map<String, Group> groups;
    protected ExecutionNode node;
    protected RemoteConnection connection = new RemoteConnection();

    @Test
    public void testTask() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryMessageResponseHandler responseHandler = new BlockingTaskSummaryMessageResponseHandler();
        this.humanTaskClient.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        List tasks = responseHandler.getResults();
        Assert.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((String)"TaskName", (String)task.getName());
        Assert.assertEquals((int)10, (int)task.getPriority());
        Assert.assertEquals((String)"Comment", (String)task.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        Assert.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        System.out.println("Starting task " + task.getId());
        BlockingTaskOperationMessageResponseHandler operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.start(task.getId(), "Darth Vader", (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started task " + task.getId());
        System.out.println("Completing task " + task.getId());
        operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.complete(task.getId(), "Darth Vader", null, (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(15000L);
        System.out.println("Completed task " + task.getId());
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
        Thread.sleep(500L);
    }

    @Test
    public void testTaskMultipleActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader, Dalai Lama");
        this.handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryMessageResponseHandler responseHandler = new BlockingTaskSummaryMessageResponseHandler();
        this.humanTaskClient.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        List tasks = responseHandler.getResults();
        Assert.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((String)"TaskName", (String)task.getName());
        Assert.assertEquals((int)10, (int)task.getPriority());
        Assert.assertEquals((String)"Comment", (String)task.getDescription());
        Assert.assertEquals((Object)Status.Ready, (Object)task.getStatus());
        System.out.println("Claiming task " + task.getId());
        BlockingTaskOperationMessageResponseHandler operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.claim(task.getId(), "Darth Vader", (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Claimed task " + task.getId());
        System.out.println("Starting task " + task.getId());
        operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.start(task.getId(), "Darth Vader", (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started task " + task.getId());
        System.out.println("Completing task " + task.getId());
        operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.complete(task.getId(), "Darth Vader", null, (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Completed task " + task.getId());
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
        Thread.sleep(500L);
    }

    @Test
    public void testTaskGroupActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("GroupId", (Object)"Crusaders");
        this.handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryMessageResponseHandler responseHandler = new BlockingTaskSummaryMessageResponseHandler();
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        this.humanTaskClient.getTasksAssignedAsPotentialOwner(null, groupIds, "en-UK", (TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        List tasks = responseHandler.getResults();
        Assert.assertEquals((int)1, (int)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        Assert.assertEquals((String)"TaskName", (String)taskSummary.getName());
        Assert.assertEquals((int)10, (int)taskSummary.getPriority());
        Assert.assertEquals((String)"Comment", (String)taskSummary.getDescription());
        Assert.assertEquals((Object)Status.Ready, (Object)taskSummary.getStatus());
        System.out.println("Claiming task " + taskSummary.getId());
        BlockingTaskOperationMessageResponseHandler operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.claim(taskSummary.getId(), "Darth Vader", (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        PermissionDeniedException denied = null;
        System.out.println("1");
        try {
            operationResponseHandler.waitTillDone(5000L);
            System.out.println("2");
        }
        catch (PermissionDeniedException e) {
            System.out.println("EXCEPTION: " + (Object)((Object)e));
            denied = e;
        }
        System.out.println("Claimed task " + taskSummary.getId());
        BlockingGetTaskMessageResponseHandler getTaskResponseHandler = new BlockingGetTaskMessageResponseHandler();
        this.humanTaskClient.getTask(taskSummary.getId(), (TaskClientMessageHandlerImpl.GetTaskMessageResponseHandler)getTaskResponseHandler);
        Task task = getTaskResponseHandler.getTask();
        Assert.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        Thread.sleep(500L);
    }

    @Test
    public void testTaskSingleAndGroupActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task One");
        workItem.setParameter("TaskName", (Object)"TaskNameOne");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("GroupId", (Object)"Crusaders");
        this.handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        workItem = new WorkItemImpl();
        workItem.setName("Human Task Two");
        workItem.setParameter("TaskName", (Object)"TaskNameTwo");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryMessageResponseHandler responseHandler = new BlockingTaskSummaryMessageResponseHandler();
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        this.humanTaskClient.getTasksAssignedAsPotentialOwner("Darth Vader", groupIds, "en-UK", (TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        List tasks = responseHandler.getResults();
        Assert.assertEquals((int)2, (int)tasks.size());
        Thread.sleep(500L);
    }

    @Test
    public void testTaskFail() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryMessageResponseHandler responseHandler = new BlockingTaskSummaryMessageResponseHandler();
        this.humanTaskClient.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        List tasks = responseHandler.getResults();
        Assert.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((String)"TaskName", (String)task.getName());
        Assert.assertEquals((int)10, (int)task.getPriority());
        Assert.assertEquals((String)"Comment", (String)task.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        Assert.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        System.out.println("Starting task " + task.getId());
        BlockingTaskOperationMessageResponseHandler operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.start(task.getId(), "Darth Vader", (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started task " + task.getId());
        System.out.println("Failing task " + task.getId());
        operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.fail(task.getId(), "Darth Vader", null, (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Failed task " + task.getId());
        Assert.assertTrue((boolean)manager.waitTillAborted(5000L));
        Thread.sleep(500L);
    }

    @Test
    public void testTaskSkip() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryMessageResponseHandler responseHandler = new BlockingTaskSummaryMessageResponseHandler();
        this.humanTaskClient.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        List tasks = responseHandler.getResults();
        Assert.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((String)"TaskName", (String)task.getName());
        Assert.assertEquals((int)10, (int)task.getPriority());
        Assert.assertEquals((String)"Comment", (String)task.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        Assert.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        System.out.println("Skipping task " + task.getId());
        BlockingTaskOperationMessageResponseHandler operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.skip(task.getId(), "Darth Vader", (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Skipped task " + task.getId());
        Assert.assertTrue((boolean)manager.waitTillAborted(5000L));
    }

    @Test
    public void testTaskAbortSkippable() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        this.handler.abortWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryMessageResponseHandler responseHandler = new BlockingTaskSummaryMessageResponseHandler();
        this.humanTaskClient.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        List tasks = responseHandler.getResults();
        Assert.assertEquals((int)0, (int)tasks.size());
    }

    @Test
    public void testTaskAbortNotSkippable() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("Skippable", (Object)"false");
        this.handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryMessageResponseHandler responseHandler = new BlockingTaskSummaryMessageResponseHandler();
        this.humanTaskClient.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        List tasks = responseHandler.getResults();
        Assert.assertEquals((int)1, (int)tasks.size());
        this.handler.abortWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        responseHandler = new BlockingTaskSummaryMessageResponseHandler();
        this.humanTaskClient.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler)responseHandler);
        tasks = responseHandler.getResults();
        Assert.assertEquals((int)1, (int)tasks.size());
    }

    @Test
    public void testTaskData() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("Content", (Object)"This is the content");
        this.handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryMessageResponseHandler responseHandler = new BlockingTaskSummaryMessageResponseHandler();
        this.humanTaskClient.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        List tasks = responseHandler.getResults();
        Assert.assertEquals((int)1, (int)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        Assert.assertEquals((String)"TaskName", (String)taskSummary.getName());
        Assert.assertEquals((int)10, (int)taskSummary.getPriority());
        Assert.assertEquals((String)"Comment", (String)taskSummary.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)taskSummary.getStatus());
        Assert.assertEquals((String)"Darth Vader", (String)taskSummary.getActualOwner().getId());
        BlockingGetTaskMessageResponseHandler getTaskResponseHandler = new BlockingGetTaskMessageResponseHandler();
        this.humanTaskClient.getTask(taskSummary.getId(), (TaskClientMessageHandlerImpl.GetTaskMessageResponseHandler)getTaskResponseHandler);
        Task task = getTaskResponseHandler.getTask();
        Assert.assertEquals((Object)AccessType.Inline, (Object)task.getTaskData().getDocumentAccessType());
        long contentId = task.getTaskData().getDocumentContentId();
        Assert.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentMessageResponseHandler getContentResponseHandler = new BlockingGetContentMessageResponseHandler();
        this.humanTaskClient.getContent(contentId, (TaskClientMessageHandlerImpl.GetContentMessageResponseHandler)getContentResponseHandler);
        ByteArrayInputStream bis = new ByteArrayInputStream(getContentResponseHandler.getContent().getContent());
        ObjectInputStream in = new ObjectInputStream(bis);
        Object data = in.readObject();
        in.close();
        Assert.assertEquals((Object)"This is the content", (Object)data);
        System.out.println("Starting task " + task.getId());
        BlockingTaskOperationMessageResponseHandler operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.start(task.getId().longValue(), "Darth Vader", (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started task " + task.getId());
        System.out.println("Completing task " + task.getId());
        operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        ContentData result = new ContentData();
        result.setAccessType(AccessType.Inline);
        result.setType("java.lang.String");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject("This is the result");
        out.close();
        result.setContent(bos.toByteArray());
        this.humanTaskClient.complete(task.getId().longValue(), "Darth Vader", result, (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Completed task " + task.getId());
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
        Map<String, Object> results = manager.getResults();
        Assert.assertNotNull(results);
        Assert.assertEquals((Object)"Darth Vader", (Object)results.get("ActorId"));
        Assert.assertEquals((Object)"This is the result", (Object)results.get("Result"));
    }

    @Test
    public void testOnAllSubTasksEndParentEndStrategy() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameParent");
        workItem.setParameter("Comment", (Object)"CommentParent");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("SubTaskStrategies", (Object)"OnAllSubTasksEndParentEnd");
        this.handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryMessageResponseHandler responseHandler = new BlockingTaskSummaryMessageResponseHandler();
        this.humanTaskClient.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        List tasks = responseHandler.getResults();
        Assert.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((String)"TaskNameParent", (String)task.getName());
        Assert.assertEquals((int)10, (int)task.getPriority());
        Assert.assertEquals((String)"CommentParent", (String)task.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        Assert.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameChild1");
        workItem.setParameter("Comment", (Object)"CommentChild1");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        workItem = new WorkItemImpl();
        workItem.setName("Human Task2");
        workItem.setParameter("TaskName", (Object)"TaskNameChild2");
        workItem.setParameter("Comment", (Object)"CommentChild2");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        System.out.println("Starting task " + task.getId());
        BlockingTaskOperationMessageResponseHandler operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.start(task.getId(), "Darth Vader", (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started task " + task.getId());
        BlockingGetTaskMessageResponseHandler getTaskResponseHandler = new BlockingGetTaskMessageResponseHandler();
        this.humanTaskClient.getTask(task.getId(), (TaskClientMessageHandlerImpl.GetTaskMessageResponseHandler)getTaskResponseHandler);
        Task parentTask = getTaskResponseHandler.getTask();
        Assert.assertEquals((Object)Status.InProgress, (Object)parentTask.getTaskData().getStatus());
        Assert.assertEquals((Object)this.users.get("darth"), (Object)parentTask.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskSummaryMessageResponseHandler();
        this.humanTaskClient.getSubTasksAssignedAsPotentialOwner(parentTask.getId().longValue(), "Darth Vader", "en-UK", (TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler)responseHandler);
        List subTasks = responseHandler.getResults();
        Assert.assertEquals((int)2, (int)subTasks.size());
        TaskSummary subTaskSummary1 = (TaskSummary)subTasks.get(0);
        TaskSummary subTaskSummary2 = (TaskSummary)subTasks.get(1);
        Assert.assertNotNull((Object)subTaskSummary1);
        Assert.assertNotNull((Object)subTaskSummary2);
        System.out.println("Starting sub task " + subTaskSummary1.getId());
        operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.start(subTaskSummary1.getId(), "Darth Vader", (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started sub task " + subTaskSummary1.getId());
        System.out.println("Starting sub task " + subTaskSummary2.getId());
        operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.start(subTaskSummary2.getId(), "Darth Vader", (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started sub task " + subTaskSummary2.getId());
        getTaskResponseHandler = new BlockingGetTaskMessageResponseHandler();
        this.humanTaskClient.getTask(subTaskSummary1.getId(), (TaskClientMessageHandlerImpl.GetTaskMessageResponseHandler)getTaskResponseHandler);
        Task subTask1 = getTaskResponseHandler.getTask();
        Assert.assertEquals((Object)Status.InProgress, (Object)subTask1.getTaskData().getStatus());
        Assert.assertEquals((Object)this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskMessageResponseHandler();
        this.humanTaskClient.getTask(subTaskSummary2.getId(), (TaskClientMessageHandlerImpl.GetTaskMessageResponseHandler)getTaskResponseHandler);
        Task subTask2 = getTaskResponseHandler.getTask();
        Assert.assertEquals((Object)Status.InProgress, (Object)subTask2.getTaskData().getStatus());
        Assert.assertEquals((Object)this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        System.out.println("Completing sub task " + subTask1.getId());
        operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.complete(subTask1.getId().longValue(), "Darth Vader", null, (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Completed sub task " + subTask1.getId());
        System.out.println("Completing sub task " + subTask2.getId());
        operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.complete(subTask2.getId().longValue(), "Darth Vader", null, (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Completed sub task " + subTask2.getId());
        getTaskResponseHandler = new BlockingGetTaskMessageResponseHandler();
        this.humanTaskClient.getTask(subTask1.getId().longValue(), (TaskClientMessageHandlerImpl.GetTaskMessageResponseHandler)getTaskResponseHandler);
        subTask1 = getTaskResponseHandler.getTask();
        Assert.assertEquals((Object)Status.Completed, (Object)subTask1.getTaskData().getStatus());
        Assert.assertEquals((Object)this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskMessageResponseHandler();
        this.humanTaskClient.getTask(subTask2.getId().longValue(), (TaskClientMessageHandlerImpl.GetTaskMessageResponseHandler)getTaskResponseHandler);
        subTask2 = getTaskResponseHandler.getTask();
        Assert.assertEquals((Object)Status.Completed, (Object)subTask2.getTaskData().getStatus());
        Assert.assertEquals((Object)this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskMessageResponseHandler();
        this.humanTaskClient.getTask(parentTask.getId().longValue(), (TaskClientMessageHandlerImpl.GetTaskMessageResponseHandler)getTaskResponseHandler);
        parentTask = getTaskResponseHandler.getTask();
        Assert.assertEquals((Object)Status.Completed, (Object)parentTask.getTaskData().getStatus());
        Assert.assertEquals((Object)this.users.get("darth"), (Object)parentTask.getTaskData().getActualOwner());
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    @Test
    public void testOnParentAbortAllSubTasksEndStrategy() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameParent");
        workItem.setParameter("Comment", (Object)"CommentParent");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("SubTaskStrategies", (Object)"OnParentAbortAllSubTasksEnd");
        this.handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryMessageResponseHandler responseHandler = new BlockingTaskSummaryMessageResponseHandler();
        this.humanTaskClient.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        List tasks = responseHandler.getResults();
        Assert.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((String)"TaskNameParent", (String)task.getName());
        Assert.assertEquals((int)10, (int)task.getPriority());
        Assert.assertEquals((String)"CommentParent", (String)task.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        Assert.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameChild1");
        workItem.setParameter("Comment", (Object)"CommentChild1");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        workItem = new WorkItemImpl();
        workItem.setName("Human Task2");
        workItem.setParameter("TaskName", (Object)"TaskNameChild2");
        workItem.setParameter("Comment", (Object)"CommentChild2");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.handler.executeWorkItem((org.drools.runtime.process.WorkItem)workItem, (org.drools.runtime.process.WorkItemManager)manager);
        Thread.sleep(500L);
        System.out.println("Starting task " + task.getId());
        BlockingTaskOperationMessageResponseHandler operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.start(task.getId(), "Darth Vader", (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started task " + task.getId());
        BlockingGetTaskMessageResponseHandler getTaskResponseHandler = new BlockingGetTaskMessageResponseHandler();
        this.humanTaskClient.getTask(task.getId(), (TaskClientMessageHandlerImpl.GetTaskMessageResponseHandler)getTaskResponseHandler);
        Task parentTask = getTaskResponseHandler.getTask();
        Assert.assertEquals((Object)Status.InProgress, (Object)parentTask.getTaskData().getStatus());
        Assert.assertEquals((Object)this.users.get("darth"), (Object)parentTask.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskSummaryMessageResponseHandler();
        this.humanTaskClient.getSubTasksAssignedAsPotentialOwner(parentTask.getId().longValue(), "Darth Vader", "en-UK", (TaskClientMessageHandlerImpl.TaskSummaryMessageResponseHandler)responseHandler);
        List subTasks = responseHandler.getResults();
        Assert.assertEquals((int)2, (int)subTasks.size());
        TaskSummary subTaskSummary1 = (TaskSummary)subTasks.get(0);
        TaskSummary subTaskSummary2 = (TaskSummary)subTasks.get(1);
        Assert.assertNotNull((Object)subTaskSummary1);
        Assert.assertNotNull((Object)subTaskSummary2);
        System.out.println("Starting sub task " + subTaskSummary1.getId());
        operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.start(subTaskSummary1.getId(), "Darth Vader", (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started sub task " + subTaskSummary1.getId());
        System.out.println("Starting sub task " + subTaskSummary2.getId());
        operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.start(subTaskSummary2.getId(), "Darth Vader", (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Started sub task " + subTaskSummary2.getId());
        getTaskResponseHandler = new BlockingGetTaskMessageResponseHandler();
        this.humanTaskClient.getTask(subTaskSummary1.getId(), (TaskClientMessageHandlerImpl.GetTaskMessageResponseHandler)getTaskResponseHandler);
        Task subTask1 = getTaskResponseHandler.getTask();
        Assert.assertEquals((Object)Status.InProgress, (Object)subTask1.getTaskData().getStatus());
        Assert.assertEquals((Object)this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskMessageResponseHandler();
        this.humanTaskClient.getTask(subTaskSummary2.getId(), (TaskClientMessageHandlerImpl.GetTaskMessageResponseHandler)getTaskResponseHandler);
        Task subTask2 = getTaskResponseHandler.getTask();
        Assert.assertEquals((Object)Status.InProgress, (Object)subTask2.getTaskData().getStatus());
        Assert.assertEquals((Object)this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        System.out.println("Completing parent task " + parentTask.getId());
        operationResponseHandler = new BlockingTaskOperationMessageResponseHandler();
        this.humanTaskClient.skip(parentTask.getId().longValue(), "Darth Vader", (TaskClientMessageHandlerImpl.TaskOperationMessageResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        System.out.println("Completed parent task " + parentTask.getId());
        getTaskResponseHandler = new BlockingGetTaskMessageResponseHandler();
        this.humanTaskClient.getTask(subTaskSummary1.getId(), (TaskClientMessageHandlerImpl.GetTaskMessageResponseHandler)getTaskResponseHandler);
        subTask1 = getTaskResponseHandler.getTask();
        Assert.assertEquals((Object)Status.Completed, (Object)subTask1.getTaskData().getStatus());
        Assert.assertEquals((Object)this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskMessageResponseHandler();
        this.humanTaskClient.getTask(subTaskSummary2.getId(), (TaskClientMessageHandlerImpl.GetTaskMessageResponseHandler)getTaskResponseHandler);
        subTask2 = getTaskResponseHandler.getTask();
        Assert.assertEquals((Object)Status.Completed, (Object)subTask2.getTaskData().getStatus());
        Assert.assertEquals((Object)this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestWorkItemManager
    implements WorkItemManager {
        private volatile boolean completed;
        private volatile boolean aborted;
        private volatile Map<String, Object> results;

        private TestWorkItemManager() {
        }

        public synchronized boolean waitTillCompleted(long time) {
            if (!this.isCompleted()) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isCompleted();
        }

        public synchronized boolean waitTillAborted(long time) {
            if (!this.isAborted()) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isAborted();
        }

        public void abortWorkItem(long id) {
            this.setAborted(true);
        }

        public synchronized boolean isAborted() {
            return this.aborted;
        }

        private synchronized void setAborted(boolean aborted) {
            this.aborted = aborted;
            this.notifyAll();
        }

        public void completeWorkItem(long id, Map<String, Object> results) {
            this.results = results;
            this.setCompleted(true);
        }

        private synchronized void setCompleted(boolean completed) {
            this.completed = completed;
            this.notifyAll();
        }

        public synchronized boolean isCompleted() {
            return this.completed;
        }

        public WorkItem getWorkItem(long id) {
            return null;
        }

        public Set<WorkItem> getWorkItems() {
            return null;
        }

        public Map<String, Object> getResults() {
            return this.results;
        }

        public void internalAbortWorkItem(long id) {
        }

        public void internalAddWorkItem(WorkItem workItem) {
        }

        public void internalExecuteWorkItem(WorkItem workItem) {
        }

        public void registerWorkItemHandler(String workItemName, org.drools.process.instance.WorkItemHandler handler) {
        }

        public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

